<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransParaRepInv.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransParaRepInv */
abstract class BaseALM_TransParaRepInvBV extends ALM_TransParaRepInvBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTrx */
    public function setIdTrx( $i_IdTrx, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTrx, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTrx ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTrx( $i_IdTrx );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumentoOriginal */
    public function setFechaDocumentoOriginal( $d_FechaDocumentoOriginal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumentoOriginal, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumentoOriginal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumentoOriginal( $d_FechaDocumentoOriginal );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumentoOriginal */
    public function setReferenciaTipoDocumentoOriginal( $s_ReferenciaTipoDocumentoOriginal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumentoOriginal, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumentoOriginal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumentoOriginal( $s_ReferenciaTipoDocumentoOriginal );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumentoOriginal */
    public function setReferenciaNumeroDocumentoOriginal( $s_ReferenciaNumeroDocumentoOriginal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumentoOriginal, "VARCHAR", 14, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumentoOriginal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumentoOriginal( $s_ReferenciaNumeroDocumentoOriginal );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo CantOriginal */
    public function setCantOriginal( $f_CantOriginal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantOriginal, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantOriginal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantOriginal( $f_CantOriginal );
        return true;
    }

    /* Valida y establece el valor del campo CantEvaluada */
    public function setCantEvaluada( $f_CantEvaluada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantEvaluada, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantEvaluada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantEvaluada( $f_CantEvaluada );
        return true;
    }

    /* Valida y establece el valor del campo CantSaldo */
    public function setCantSaldo( $f_CantSaldo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantSaldo, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantSaldo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantSaldo( $f_CantSaldo );
        return true;
    }

    /* Valida y establece el valor del campo StockFisico */
    public function setStockFisico( $f_StockFisico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockFisico, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockFisico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockFisico( $f_StockFisico );
        return true;
    }

    /* Valida y establece el valor del campo DiasCalculado */
    public function setDiasCalculado( $i_DiasCalculado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiasCalculado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DiasCalculado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiasCalculado( $i_DiasCalculado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTrx( $this->getIdTrx(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setFechaDocumentoOriginal( $this->getFechaDocumentoOriginal(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setReferenciaTipoDocumentoOriginal( $this->getReferenciaTipoDocumentoOriginal(), true );
        $this->setReferenciaNumeroDocumentoOriginal( $this->getReferenciaNumeroDocumentoOriginal(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setIdSecuencia( $this->getIdSecuencia(), true );
        $this->setCantOriginal( $this->getCantOriginal(), true );
        $this->setCantEvaluada( $this->getCantEvaluada(), true );
        $this->setCantSaldo( $this->getCantSaldo(), true );
        $this->setStockFisico( $this->getStockFisico(), true );
        $this->setDiasCalculado( $this->getDiasCalculado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>