<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_OrdenGuiaFactura.xml */
/* Generado: 2021-01-08 07:14:54 */

/* Validacion del contenido de los campos campos de la tabla ALM_OrdenGuiaFactura */
abstract class BaseALM_OrdenGuiaFacturaBV extends ALM_OrdenGuiaFacturaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOrdenGuia */
    public function setIdOrdenGuia( $i_IdOrdenGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenGuia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenGuia( $i_IdOrdenGuia );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenCompra */
    public function setIdOrdenCompra( $i_IdOrdenCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCompra, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCompra( $i_IdOrdenCompra );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo SerieGuia */
    public function setSerieGuia( $s_SerieGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieGuia, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo SerieGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieGuia( $s_SerieGuia );
        return true;
    }

    /* Valida y establece el valor del campo NumeroGuia */
    public function setNumeroGuia( $s_NumeroGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroGuia, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroGuia( $s_NumeroGuia );
        return true;
    }

    /* Valida y establece el valor del campo FechaGuia */
    public function setFechaGuia( $d_FechaGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaGuia, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaGuia( $d_FechaGuia );
        return true;
    }

    /* Valida y establece el valor del campo TipoDoc */
    public function setTipoDoc( $s_TipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDoc, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDoc( $s_TipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo SerieFactura */
    public function setSerieFactura( $s_SerieFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieFactura, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo SerieFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieFactura( $s_SerieFactura );
        return true;
    }

    /* Valida y establece el valor del campo NumeroFactura */
    public function setNumeroFactura( $s_NumeroFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroFactura, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroFactura( $s_NumeroFactura );
        return true;
    }

    /* Valida y establece el valor del campo FechaFactura */
    public function setFechaFactura( $d_FechaFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFactura, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFactura( $d_FechaFactura );
        return true;
    }

    /* Valida y establece el valor del campo MontoFacturaInafecto */
    public function setMontoFacturaInafecto( $f_MontoFacturaInafecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoFacturaInafecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoFacturaInafecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoFacturaInafecto( $f_MontoFacturaInafecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoFactura */
    public function setMontoFactura( $f_MontoFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoFactura, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoFactura( $f_MontoFactura );
        return true;
    }

    /* Valida y establece el valor del campo IGVFactura */
    public function setIGVFactura( $f_IGVFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_IGVFactura, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo IGVFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIGVFactura( $f_IGVFactura );
        return true;
    }

    /* Valida y establece el valor del campo TotalFactura */
    public function setTotalFactura( $f_TotalFactura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalFactura, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TotalFactura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalFactura( $f_TotalFactura );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenGuiaReferencia */
    public function setIdOrdenGuiaReferencia( $i_IdOrdenGuiaReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenGuiaReferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenGuiaReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenGuiaReferencia( $i_IdOrdenGuiaReferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumentoRef */
    public function setIdTipoDocumentoRef( $s_IdTipoDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumentoRef, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumentoRef( $s_IdTipoDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumentoRef */
    public function setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumentoRef, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumentoRef( $s_IdNumeroDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOrdenGuia( $this->getIdOrdenGuia(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdOrdenCompra( $this->getIdOrdenCompra(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setSerieGuia( $this->getSerieGuia(), true );
        $this->setNumeroGuia( $this->getNumeroGuia(), true );
        $this->setFechaGuia( $this->getFechaGuia(), true );
        $this->setTipoDoc( $this->getTipoDoc(), true );
        $this->setSerieFactura( $this->getSerieFactura(), true );
        $this->setNumeroFactura( $this->getNumeroFactura(), true );
        $this->setFechaFactura( $this->getFechaFactura(), true );
        $this->setMontoFacturaInafecto( $this->getMontoFacturaInafecto(), true );
        $this->setMontoFactura( $this->getMontoFactura(), true );
        $this->setIGVFactura( $this->getIGVFactura(), true );
        $this->setTotalFactura( $this->getTotalFactura(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setIdOrdenGuiaReferencia( $this->getIdOrdenGuiaReferencia(), true );
        $this->setIdTipoDocumentoRef( $this->getIdTipoDocumentoRef(), true );
        $this->setIdNumeroDocumentoRef( $this->getIdNumeroDocumentoRef(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>