<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Marca.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_Marca */
abstract class BaseALM_MarcaBV extends ALM_MarcaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdMarca */
    public function setIdMarca( $s_IdMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMarca, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMarca( $s_IdMarca );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLocal, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLocal( $s_DescripcionLocal );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo Persona */
    public function setPersona( $i_Persona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Persona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Persona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPersona( $i_Persona );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdMarca( $this->getIdMarca(), false );
        $this->setDescripcionLocal( $this->getDescripcionLocal(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setPersona( $this->getPersona(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>