<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemMast.xml */
/* Generado: 2021-05-18 05:19:50 */

/* Validacion del contenido de los campos campos de la tabla ALM_ItemMast */
abstract class BaseALM_ItemMastBV extends ALM_ItemMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdMarca */
    public function setIdMarca( $s_IdMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMarca, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMarca( $s_IdMarca );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionCompleta */
    public function setDescripcionCompleta( $s_DescripcionCompleta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionCompleta, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionCompleta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionCompleta( $s_DescripcionCompleta );
        return true;
    }
    
    /* Valida y establece el valor del campo UrlAmigable */
    public function setUrlAmigable( $s_UrlAmigable, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UrlAmigable, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo UrlAmigable ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUrlAmigable( $s_UrlAmigable );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDeParte */
    public function setNumeroDeParte( $s_NumeroDeParte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDeParte, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo NumeroDeParte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDeParte( $s_NumeroDeParte );
        return true;
    }

    /* Valida y establece el valor del campo CodigoInterno */
    public function setCodigoInterno( $s_CodigoInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoInterno, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo CodigoInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoInterno( $s_CodigoInterno );
        return true;
    }

    /* Valida y establece el valor del campo IdItemFiscal */
    public function setIdItemFiscal( $i_IdItemFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdItemFiscal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdItemFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemFiscal( $i_IdItemFiscal );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo UnidadCodigo */
    public function setUnidadCodigo( $s_UnidadCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadCodigo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo UnidadCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadCodigo( $s_UnidadCodigo );
        return true;
    }

    /* Valida y establece el valor del campo UnidadCompra */
    public function setUnidadCompra( $s_UnidadCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadCompra, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UnidadCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadCompra( $s_UnidadCompra );
        return true;
    }

    /* Valida y establece el valor del campo UnidadVenta */
    public function setUnidadVenta( $s_UnidadVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadVenta, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo UnidadVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadVenta( $s_UnidadVenta );
        return true;
    }

    /* Valida y establece el valor del campo UnidadAlmacenaje */
    public function setUnidadAlmacenaje( $s_UnidadAlmacenaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadAlmacenaje, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo UnidadAlmacenaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadAlmacenaje( $s_UnidadAlmacenaje );
        return true;
    }

    /* Valida y establece el valor del campo UnidadEmbalaje */
    public function setUnidadEmbalaje( $s_UnidadEmbalaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadEmbalaje, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo UnidadEmbalaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadEmbalaje( $s_UnidadEmbalaje );
        return true;
    }

    /* Valida y establece el valor del campo ClasificacionComercial */
    public function setClasificacionComercial( $s_ClasificacionComercial, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClasificacionComercial, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo ClasificacionComercial ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClasificacionComercial( $s_ClasificacionComercial );
        return true;
    }

    /* Valida y establece el valor del campo CodigoBarras */
    public function setCodigoBarras( $s_CodigoBarras, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoBarras, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo CodigoBarras ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoBarras( $s_CodigoBarras );
        return true;
    }

    /* Valida y establece el valor del campo CodigoBarrasFabricante */
    public function setCodigoBarrasFabricante( $s_CodigoBarrasFabricante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoBarrasFabricante, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo CodigoBarrasFabricante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoBarrasFabricante( $s_CodigoBarrasFabricante );
        return true;
    }

    /* Valida y establece el valor del campo CodigoBarras2 */
    public function setCodigoBarras2( $s_CodigoBarras2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoBarras2, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo CodigoBarras2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoBarras2( $s_CodigoBarras2 );
        return true;
    }

    /* Valida y establece el valor del campo MonedaCodigo */
    public function setMonedaCodigo( $s_MonedaCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaCodigo, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo MonedaCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaCodigo( $s_MonedaCodigo );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCosto */
    public function setPrecioCosto( $f_PrecioCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCosto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCosto( $f_PrecioCosto );
        return true;
    }

    /* Valida y establece el valor del campo PrecioVenta */
    public function setPrecioVenta( $f_PrecioVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioVenta, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioVenta( $f_PrecioVenta );
        return true;
    }

    /* Valida y establece el valor del campo UtilidadPorcentaje */
    public function setUtilidadPorcentaje( $f_UtilidadPorcentaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_UtilidadPorcentaje, "DECIMAL", 8, 2, false ) )
            {
                throw new Exception( "El campo UtilidadPorcentaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUtilidadPorcentaje( $f_UtilidadPorcentaje );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioLocal */
    public function setPrecioUnitarioLocal( $f_PrecioUnitarioLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioLocal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioLocal( $f_PrecioUnitarioLocal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioDolares */
    public function setPrecioUnitarioDolares( $f_PrecioUnitarioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioDolares( $f_PrecioUnitarioDolares );
        return true;
    }

    /* Valida y establece el valor del campo DisponibleVentaFlag */
    public function setDisponibleVentaFlag( $s_DisponibleVentaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DisponibleVentaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DisponibleVentaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDisponibleVentaFlag( $s_DisponibleVentaFlag );
        return true;
    }

    /* Valida y establece el valor del campo ManejoxLoteFlag */
    public function setManejoxLoteFlag( $s_ManejoxLoteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ManejoxLoteFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ManejoxLoteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setManejoxLoteFlag( $s_ManejoxLoteFlag );
        return true;
    }

    /* Valida y establece el valor del campo ManejoxSerieFlag */
    public function setManejoxSerieFlag( $s_ManejoxSerieFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ManejoxSerieFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ManejoxSerieFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setManejoxSerieFlag( $s_ManejoxSerieFlag );
        return true;
    }

    /* Valida y establece el valor del campo ManejoxUnidadFlag */
    public function setManejoxUnidadFlag( $s_ManejoxUnidadFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ManejoxUnidadFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ManejoxUnidadFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setManejoxUnidadFlag( $s_ManejoxUnidadFlag );
        return true;
    }

    /* Valida y establece el valor del campo NoAfectoImpuestoVentasFlag */
    public function setNoAfectoImpuestoVentasFlag( $s_NoAfectoImpuestoVentasFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NoAfectoImpuestoVentasFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo NoAfectoImpuestoVentasFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNoAfectoImpuestoVentasFlag( $s_NoAfectoImpuestoVentasFlag );
        return true;
    }

    /* Valida y establece el valor del campo DisponibleTransferenciaFlag */
    public function setDisponibleTransferenciaFlag( $s_DisponibleTransferenciaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DisponibleTransferenciaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DisponibleTransferenciaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDisponibleTransferenciaFlag( $s_DisponibleTransferenciaFlag );
        return true;
    }

    /* Valida y establece el valor del campo StockMinimo */
    public function setStockMinimo( $f_StockMinimo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMinimo, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockMinimo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMinimo( $f_StockMinimo );
        return true;
    }

    /* Valida y establece el valor del campo StockMaximo */
    public function setStockMaximo( $f_StockMaximo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMaximo, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockMaximo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMaximo( $f_StockMaximo );
        return true;
    }

    /* Valida y establece el valor del campo StockMinFlag */
    public function setStockMinFlag( $s_StockMinFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_StockMinFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo StockMinFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMinFlag( $s_StockMinFlag );
        return true;
    }

    /* Valida y establece el valor del campo LotedeVenta */
    public function setLotedeVenta( $i_LotedeVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_LotedeVenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo LotedeVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLotedeVenta( $i_LotedeVenta );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo NombreArchivo */
    public function setNombreArchivo( $s_NombreArchivo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreArchivo, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NombreArchivo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreArchivo( $s_NombreArchivo );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionURL */
    public function setUbicacionURL( $s_UbicacionURL, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionURL, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo UbicacionURL ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionURL( $s_UbicacionURL );
        return true;
    }

    /* Valida y establece el valor del campo UbicacionFisica */
    public function setUbicacionFisica( $s_UbicacionFisica, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbicacionFisica, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo UbicacionFisica ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbicacionFisica( $s_UbicacionFisica );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo IdLinea */
    public function setIdLinea( $i_IdLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLinea( $i_IdLinea );
        return true;
    }

    /* Valida y establece el valor del campo IdFamilia */
    public function setIdFamilia( $i_IdFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFamilia( $i_IdFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdSubFamilia */
    public function setIdSubFamilia( $i_IdSubFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSubFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSubFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubFamilia( $i_IdSubFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdProcedencia */
    public function setIdProcedencia( $s_IdProcedencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdProcedencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdProcedencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProcedencia( $s_IdProcedencia );
        return true;
    }

    /* Valida y establece el valor del campo TipoGarantiaId */
    public function setTipoGarantiaId( $s_TipoGarantiaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoGarantiaId, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo TipoGarantiaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoGarantiaId( $s_TipoGarantiaId );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoOperatividad */
    public function setIdTipoOperatividad( $s_IdTipoOperatividad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoOperatividad, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTipoOperatividad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoOperatividad( $s_IdTipoOperatividad );
        return true;
    }

    /* Valida y establece el valor del campo PesoGramos */
    public function setPesoGramos( $f_PesoGramos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoGramos, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoGramos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoGramos( $f_PesoGramos );
        return true;
    }

    /* Valida y establece el valor del campo AfectoPercepcionIGVFlag */
    public function setAfectoPercepcionIGVFlag( $s_AfectoPercepcionIGVFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AfectoPercepcionIGVFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AfectoPercepcionIGVFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoPercepcionIGVFlag( $s_AfectoPercepcionIGVFlag );
        return true;
    }

    /* Valida y establece el valor del campo AfectoDetraccionFlag */
    public function setAfectoDetraccionFlag( $s_AfectoDetraccionFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AfectoDetraccionFlag, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo AfectoDetraccionFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoDetraccionFlag( $s_AfectoDetraccionFlag );
        return true;
    }

    /* Valida y establece el valor del campo IdDetraccion */
    public function setIdDetraccion( $i_IdDetraccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDetraccion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDetraccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDetraccion( $i_IdDetraccion );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo CantidadUnidad */
    public function setCantidadUnidad( $f_CantidadUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadUnidad, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo CantidadUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadUnidad( $f_CantidadUnidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadUnidadCompra */
    public function setCantidadUnidadCompra( $f_CantidadUnidadCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadUnidadCompra, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo CantidadUnidadCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadUnidadCompra( $f_CantidadUnidadCompra );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLarga */
    public function setDescripcionLarga( $u_DescripcionLarga, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DescripcionLarga, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLarga ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLarga( $u_DescripcionLarga );
        return true;
    }

    /* Valida y establece el valor del campo EsInventariableFlag */
    public function setEsInventariableFlag( $s_EsInventariableFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsInventariableFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsInventariableFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsInventariableFlag( $s_EsInventariableFlag );
        return true;
    }

    /* Valida y establece el valor del campo FusionarLoteFlag */
    public function setFusionarLoteFlag( $s_FusionarLoteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FusionarLoteFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FusionarLoteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFusionarLoteFlag( $s_FusionarLoteFlag );
        return true;
    }

    /* Valida y establece el valor del campo EsServicioConDias */
    public function setEsServicioConDias( $s_EsServicioConDias, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsServicioConDias, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsServicioConDias ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsServicioConDias( $s_EsServicioConDias );
        return true;
    }

    /* Valida y establece el valor del campo UsarDisponibleStock */
    public function setUsarDisponibleStock( $s_UsarDisponibleStock, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsarDisponibleStock, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo UsarDisponibleStock ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsarDisponibleStock( $s_UsarDisponibleStock );
        return true;
    }

    /* Valida y establece el valor del campo UsarResevableStock */
    public function setUsarResevableStock( $s_UsarResevableStock, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsarResevableStock, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo UsarResevableStock ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsarResevableStock( $s_UsarResevableStock );
        return true;
    }

    /* Valida y establece el valor del campo EsParaVenta */
    public function setEsParaVenta( $s_EsParaVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsParaVenta, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsParaVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsParaVenta( $s_EsParaVenta );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoVenta */
    public function setIdRangoVenta( $i_IdRangoVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoVenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoVenta( $i_IdRangoVenta );
        return true;
    }

    /* Valida y establece el valor del campo EsParaAlquiler */
    public function setEsParaAlquiler( $s_EsParaAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsParaAlquiler, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsParaAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsParaAlquiler( $s_EsParaAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoAlquiler */
    public function setIdRangoAlquiler( $i_IdRangoAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoAlquiler, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoAlquiler( $i_IdRangoAlquiler );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdItem( $this->getIdItem(), false );
        $this->setIdMarca( $this->getIdMarca(), true );
        $this->setIdItemTipo( $this->getIdItemTipo(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setDescripcionCompleta( $this->getDescripcionCompleta(), true );
        $this->setUrlAmigable( $this->getUrlAmigable(), true );
        $this->setNumeroDeParte( $this->getNumeroDeParte(), true );
        $this->setCodigoInterno( $this->getCodigoInterno(), true );
        $this->setIdItemFiscal( $this->getIdItemFiscal(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setUnidadCodigo( $this->getUnidadCodigo(), true );
        $this->setUnidadCompra( $this->getUnidadCompra(), true );
        $this->setUnidadVenta( $this->getUnidadVenta(), true );
        $this->setUnidadAlmacenaje( $this->getUnidadAlmacenaje(), true );
        $this->setUnidadEmbalaje( $this->getUnidadEmbalaje(), true );
        $this->setClasificacionComercial( $this->getClasificacionComercial(), true );
        $this->setCodigoBarras( $this->getCodigoBarras(), true );
        $this->setCodigoBarrasFabricante( $this->getCodigoBarrasFabricante(), true );
        $this->setCodigoBarras2( $this->getCodigoBarras2(), true );
        $this->setMonedaCodigo( $this->getMonedaCodigo(), true );
        $this->setPrecioCosto( $this->getPrecioCosto(), true );
        $this->setPrecioVenta( $this->getPrecioVenta(), true );
        $this->setUtilidadPorcentaje( $this->getUtilidadPorcentaje(), true );
        $this->setPrecioUnitarioLocal( $this->getPrecioUnitarioLocal(), true );
        $this->setPrecioUnitarioDolares( $this->getPrecioUnitarioDolares(), true );
        $this->setDisponibleVentaFlag( $this->getDisponibleVentaFlag(), true );
        $this->setManejoxLoteFlag( $this->getManejoxLoteFlag(), true );
        $this->setManejoxSerieFlag( $this->getManejoxSerieFlag(), true );
        $this->setManejoxUnidadFlag( $this->getManejoxUnidadFlag(), true );
        $this->setNoAfectoImpuestoVentasFlag( $this->getNoAfectoImpuestoVentasFlag(), true );
        $this->setDisponibleTransferenciaFlag( $this->getDisponibleTransferenciaFlag(), true );
        $this->setStockMinimo( $this->getStockMinimo(), true );
        $this->setStockMaximo( $this->getStockMaximo(), true );
        $this->setStockMinFlag( $this->getStockMinFlag(), true );
        $this->setLotedeVenta( $this->getLotedeVenta(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setNombreArchivo( $this->getNombreArchivo(), true );
        $this->setUbicacionURL( $this->getUbicacionURL(), true );
        $this->setUbicacionFisica( $this->getUbicacionFisica(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setIdLinea( $this->getIdLinea(), true );
        $this->setIdFamilia( $this->getIdFamilia(), true );
        $this->setIdSubFamilia( $this->getIdSubFamilia(), true );
        $this->setIdProcedencia( $this->getIdProcedencia(), true );
        $this->setTipoGarantiaId( $this->getTipoGarantiaId(), true );
        $this->setIdTipoOperatividad( $this->getIdTipoOperatividad(), true );
        $this->setPesoGramos( $this->getPesoGramos(), true );
        $this->setAfectoPercepcionIGVFlag( $this->getAfectoPercepcionIGVFlag(), true );
        $this->setAfectoDetraccionFlag( $this->getAfectoDetraccionFlag(), true );
        $this->setIdDetraccion( $this->getIdDetraccion(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setCantidadUnidad( $this->getCantidadUnidad(), true );
        $this->setCantidadUnidadCompra( $this->getCantidadUnidadCompra(), true );
        $this->setDescripcionLarga( $this->getDescripcionLarga(), true );
        $this->setEsInventariableFlag( $this->getEsInventariableFlag(), true );
        $this->setFusionarLoteFlag( $this->getFusionarLoteFlag(), true );
        $this->setEsServicioConDias( $this->getEsServicioConDias(), true );
        $this->setUsarDisponibleStock( $this->getUsarDisponibleStock(), true );
        $this->setUsarResevableStock( $this->getUsarResevableStock(), true );
        $this->setEsParaVenta( $this->getEsParaVenta(), true );
        $this->setIdRangoVenta( $this->getIdRangoVenta(), true );
        $this->setEsParaAlquiler( $this->getEsParaAlquiler(), true );
        $this->setIdRangoAlquiler( $this->getIdRangoAlquiler(), true );
        return true;
    }
}
?>