<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemAlmacenStock.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Validacion del contenido de los campos campos de la tabla ALM_ItemAlmacenStock */
abstract class BaseALM_ItemAlmacenStockBV extends ALM_ItemAlmacenStockBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $s_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCondicion, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $s_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo LoteEquivalente */
    public function setLoteEquivalente( $s_LoteEquivalente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteEquivalente, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo LoteEquivalente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteEquivalente( $s_LoteEquivalente );
        return true;
    }

    /* Valida y establece el valor del campo Donante */
    public function setDonante( $i_Donante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Donante, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Donante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDonante( $i_Donante );
        return true;
    }

    /* Valida y establece el valor del campo FechaIngreso */
    public function setFechaIngreso( $d_FechaIngreso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaIngreso, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaIngreso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaIngreso( $d_FechaIngreso );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo StockIngreso */
    public function setStockIngreso( $f_StockIngreso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockIngreso, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockIngreso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockIngreso( $f_StockIngreso );
        return true;
    }

    /* Valida y establece el valor del campo StockActual */
    public function setStockActual( $f_StockActual, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockActual, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockActual ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockActual( $f_StockActual );
        return true;
    }

    /* Valida y establece el valor del campo StockComprometido */
    public function setStockComprometido( $f_StockComprometido, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockComprometido, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockComprometido ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockComprometido( $f_StockComprometido );
        return true;
    }

    /* Valida y establece el valor del campo StockActualDoble */
    public function setStockActualDoble( $f_StockActualDoble, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockActualDoble, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockActualDoble ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockActualDoble( $f_StockActualDoble );
        return true;
    }

    /* Valida y establece el valor del campo StockFisico */
    public function setStockFisico( $f_StockFisico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockFisico, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockFisico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockFisico( $f_StockFisico );
        return true;
    }

    /* Valida y establece el valor del campo StockReservado */
    public function setStockReservado( $f_StockReservado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockReservado, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockReservado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockReservado( $f_StockReservado );
        return true;
    }

    /* Valida y establece el valor del campo StockDisponible */
    public function setStockDisponible( $f_StockDisponible, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockDisponible, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo StockDisponible ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockDisponible( $f_StockDisponible );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioDolares */
    public function setPrecioUnitarioDolares( $f_PrecioUnitarioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioDolares( $f_PrecioUnitarioDolares );
        return true;
    }

    /* Valida y establece el valor del campo Prioridad */
    public function setPrioridad( $i_Prioridad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Prioridad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Prioridad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrioridad( $i_Prioridad );
        return true;
    }

    /* Valida y establece el valor del campo PrecioPromedioLocal */
    public function setPrecioPromedioLocal( $f_PrecioPromedioLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioPromedioLocal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioPromedioLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioPromedioLocal( $f_PrecioPromedioLocal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioPromedioDolares */
    public function setPrecioPromedioDolares( $f_PrecioPromedioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioPromedioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioPromedioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioPromedioDolares( $f_PrecioPromedioDolares );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoReferencia */
    public function setDocumentoReferencia( $s_DocumentoReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoReferencia, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo DocumentoReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoReferencia( $s_DocumentoReferencia );
        return true;
    }

    /* Valida y establece el valor del campo Observaciones */
    public function setObservaciones( $s_Observaciones, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Observaciones, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Observaciones ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservaciones( $s_Observaciones );
        return true;
    }

    /* Valida y establece el valor del campo ObservacionesCorrectivas */
    public function setObservacionesCorrectivas( $s_ObservacionesCorrectivas, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ObservacionesCorrectivas, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ObservacionesCorrectivas ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservacionesCorrectivas( $s_ObservacionesCorrectivas );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdItem( $this->getIdItem(), false );
        $this->setIdAlmacen( $this->getIdAlmacen(), false );
        $this->setIdCondicion( $this->getIdCondicion(), false );
        $this->setIdLote( $this->getIdLote(), false );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setLoteEquivalente( $this->getLoteEquivalente(), true );
        $this->setDonante( $this->getDonante(), true );
        $this->setFechaIngreso( $this->getFechaIngreso(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setStockIngreso( $this->getStockIngreso(), true );
        $this->setStockActual( $this->getStockActual(), true );
        $this->setStockComprometido( $this->getStockComprometido(), true );
        $this->setStockActualDoble( $this->getStockActualDoble(), true );
        $this->setStockFisico( $this->getStockFisico(), true );
        $this->setStockReservado( $this->getStockReservado(), true );
        $this->setStockDisponible( $this->getStockDisponible(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setPrecioUnitarioDolares( $this->getPrecioUnitarioDolares(), true );
        $this->setPrioridad( $this->getPrioridad(), true );
        $this->setPrecioPromedioLocal( $this->getPrecioPromedioLocal(), true );
        $this->setPrecioPromedioDolares( $this->getPrecioPromedioDolares(), true );
        $this->setDocumentoReferencia( $this->getDocumentoReferencia(), true );
        $this->setObservaciones( $this->getObservaciones(), true );
        $this->setObservacionesCorrectivas( $this->getObservacionesCorrectivas(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>