<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaDet.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_CajaChicaDet */
abstract class BaseALM_CajaChicaDetBV extends ALM_CajaChicaDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCajaDet */
    public function setIdCajaDet( $i_IdCajaDet, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCajaDet, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCajaDet ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCajaDet( $i_IdCajaDet );
        return true;
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocProv */
    public function setTipoDocProv( $s_TipoDocProv, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocProv, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDocProv ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocProv( $s_TipoDocProv );
        return true;
    }

    /* Valida y establece el valor del campo NumDocProv */
    public function setNumDocProv( $s_NumDocProv, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumDocProv, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumDocProv ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumDocProv( $s_NumDocProv );
        return true;
    }

    /* Valida y establece el valor del campo NomProv */
    public function setNomProv( $s_NomProv, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NomProv, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NomProv ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNomProv( $s_NomProv );
        return true;
    }

    /* Valida y establece el valor del campo EsInventariableFlag */
    public function setEsInventariableFlag( $s_EsInventariableFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsInventariableFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsInventariableFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsInventariableFlag( $s_EsInventariableFlag );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaIdTransaccion */
    public function setReferenciaIdTransaccion( $s_ReferenciaIdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaIdTransaccion, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaIdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaIdTransaccion( $s_ReferenciaIdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSerieDocumento */
    public function setReferenciaSerieDocumento( $s_ReferenciaSerieDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaSerieDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSerieDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSerieDocumento( $s_ReferenciaSerieDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotal */
    public function setMontoSubTotal( $f_MontoSubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotal( $f_MontoSubTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCajaDet( $this->getIdCajaDet(), false );
        $this->setIdCaja( $this->getIdCaja(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setTipoDocProv( $this->getTipoDocProv(), true );
        $this->setNumDocProv( $this->getNumDocProv(), true );
        $this->setNomProv( $this->getNomProv(), true );
        $this->setEsInventariableFlag( $this->getEsInventariableFlag(), true );
        $this->setReferenciaIdTransaccion( $this->getReferenciaIdTransaccion(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaSerieDocumento( $this->getReferenciaSerieDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setMontoSubTotal( $this->getMontoSubTotal(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>