<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaCab.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_CajaChicaCab */
abstract class BaseALM_CajaChicaCabBV extends ALM_CajaChicaCabBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCaja */
    public function setFechaCaja( $d_FechaCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCaja, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCaja( $d_FechaCaja );
        return true;
    }

    /* Valida y establece el valor del campo FechaCierreCaja */
    public function setFechaCierreCaja( $d_FechaCierreCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCierreCaja, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCierreCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCierreCaja( $d_FechaCierreCaja );
        return true;
    }

    /* Valida y establece el valor del campo MontoFondo */
    public function setMontoFondo( $f_MontoFondo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoFondo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoFondo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoFondo( $f_MontoFondo );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldoAnt */
    public function setMontoSaldoAnt( $f_MontoSaldoAnt, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldoAnt, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldoAnt ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldoAnt( $f_MontoSaldoAnt );
        return true;
    }

    /* Valida y establece el valor del campo MontoIngreso */
    public function setMontoIngreso( $f_MontoIngreso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIngreso, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIngreso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIngreso( $f_MontoIngreso );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldoAct */
    public function setMontoSaldoAct( $f_MontoSaldoAct, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldoAct, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldoAct ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldoAct( $f_MontoSaldoAct );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EnUsoFlag */
    public function setEnUsoFlag( $s_EnUsoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnUsoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EnUsoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnUsoFlag( $s_EnUsoFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCaja( $this->getIdCaja(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setFechaCaja( $this->getFechaCaja(), true );
        $this->setFechaCierreCaja( $this->getFechaCierreCaja(), true );
        $this->setMontoFondo( $this->getMontoFondo(), true );
        $this->setMontoSaldoAnt( $this->getMontoSaldoAnt(), true );
        $this->setMontoIngreso( $this->getMontoIngreso(), true );
        $this->setMontoSaldoAct( $this->getMontoSaldoAct(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEnUsoFlag( $this->getEnUsoFlag(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>