<?php
/* Autor...:  */
/* Esquema.: SR_LoteEscaneo.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Metodos de acceso a los campos de la tabla SR_LoteEscaneo */
abstract class BaseSR_LoteEscaneoBN
{
    /* Campos de la tabla */
    private $i_MovimientoDetalleId;    // MovimientoDetalleId: ( no definido )
    private $i_Secuencia;    // Secuencia: ( no definido )
    private $s_Lote;    // Lote: ( no definido )
    private $f_Cantidad;    // Cantidad: ( no definido )
    private $d_Fecha;    // Fecha: ( no definido )
    private $u_Comentario;    // Comentario: ( no definido )
    private $s_UsuarioRegistro;    // UsuarioRegistro: ( no definido )
    private $d_FechaRegistro;    // FechaRegistro: ( no definido )

    /* Establece el valor del campo MovimientoDetalleId */
    public function setMovimientoDetalleId( $i_MovimientoDetalleId )
    {
        $this->i_MovimientoDetalleId = $i_MovimientoDetalleId;
    }

    /* Obtiene el valor del campo MovimientoDetalleId */
    public function getMovimientoDetalleId()
    {
        return $this->i_MovimientoDetalleId;
    }

    /* Establece el valor del campo Secuencia */
    public function setSecuencia( $i_Secuencia )
    {
        $this->i_Secuencia = $i_Secuencia;
    }

    /* Obtiene el valor del campo Secuencia */
    public function getSecuencia()
    {
        return $this->i_Secuencia;
    }

    /* Establece el valor del campo Lote */
    public function setLote( $s_Lote )
    {
        $this->s_Lote = $s_Lote;
    }

    /* Obtiene el valor del campo Lote */
    public function getLote()
    {
        return $this->s_Lote;
    }

    /* Establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad )
    {
        $this->f_Cantidad = $f_Cantidad;
    }

    /* Obtiene el valor del campo Cantidad */
    public function getCantidad()
    {
        return $this->f_Cantidad;
    }

    /* Establece el valor del campo Fecha */
    public function setFecha( $d_Fecha )
    {
        $this->d_Fecha = $d_Fecha;
    }

    /* Obtiene el valor del campo Fecha */
    public function getFecha()
    {
        return $this->d_Fecha;
    }

    /* Establece el valor del campo Comentario */
    public function setComentario( $u_Comentario )
    {
        $this->u_Comentario = $u_Comentario;
    }

    /* Obtiene el valor del campo Comentario */
    public function getComentario()
    {
        return $this->u_Comentario;
    }

    /* Establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro )
    {
        $this->s_UsuarioRegistro = $s_UsuarioRegistro;
    }

    /* Obtiene el valor del campo UsuarioRegistro */
    public function getUsuarioRegistro()
    {
        return $this->s_UsuarioRegistro;
    }

    /* Establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro )
    {
        $this->d_FechaRegistro = $d_FechaRegistro;
    }

    /* Obtiene el valor del campo FechaRegistro */
    public function getFechaRegistro()
    {
        return $this->d_FechaRegistro;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'MovimientoDetalleId' => $this->getMovimientoDetalleId(),
            'Secuencia' => $this->getSecuencia(),
            'Lote' => $this->getLote(),
            'Cantidad' => $this->getCantidad(),
            'Fecha' => $this->getFecha(),
            'Comentario' => $this->getComentario(),
            'UsuarioRegistro' => $this->getUsuarioRegistro(),
            'FechaRegistro' => $this->getFechaRegistro(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto SR_LoteEscaneoBN desde un RecordSet */
    public static function retrieveByRs( $o_SR_LoteEscaneoRs )
    {
        $o_SR_LoteEscaneoBN = new SR_LoteEscaneoBN();
        $o_SR_LoteEscaneoBN->setMovimientoDetalleId( ( integer ) $o_SR_LoteEscaneoRs[ "MovimientoDetalleId" ] );
        $o_SR_LoteEscaneoBN->setSecuencia( ( integer ) $o_SR_LoteEscaneoRs[ "Secuencia" ] );
        $o_SR_LoteEscaneoBN->setLote( $o_SR_LoteEscaneoRs[ "Lote" ] );
        $o_SR_LoteEscaneoBN->setCantidad( ( float ) $o_SR_LoteEscaneoRs[ "Cantidad" ] );
        $o_SR_LoteEscaneoBN->setFecha( utilTimestamp::getTimestamp( $o_SR_LoteEscaneoRs[ "Fecha" ], "Y-m-d H:i:s" ) );
        $o_SR_LoteEscaneoBN->setComentario( $o_SR_LoteEscaneoRs[ "Comentario" ] );
        $o_SR_LoteEscaneoBN->setUsuarioRegistro( $o_SR_LoteEscaneoRs[ "UsuarioRegistro" ] );
        $o_SR_LoteEscaneoBN->setFechaRegistro( utilTimestamp::getTimestamp( $o_SR_LoteEscaneoRs[ "FechaRegistro" ], "Y-m-d H:i:s" ) );
        return $o_SR_LoteEscaneoBN;
    }
}
?>