<?php
/* Autor...:  */
/* Esquema.: MST_Talla.xml */
/* Generado: 2024-07-07 07:30:04 */

/* Metodos de acceso a los campos de la tabla MST_Talla */
abstract class BaseMST_TallaBN
{
    /* Campos de la tabla */
    private $i_IdTalla;    // IdTalla: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo IdTalla */
    public function setIdTalla( $i_IdTalla )
    {
        $this->i_IdTalla = $i_IdTalla;
    }

    /* Obtiene el valor del campo IdTalla */
    public function getIdTalla()
    {
        return $this->i_IdTalla;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdTalla' => $this->getIdTalla(),
            'Descripcion' => $this->getDescripcion(),
            'Estado' => $this->getEstado(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto MST_TallaBN desde un RecordSet */
    public static function retrieveByRs( $o_MST_TallaRs )
    {
        $o_MST_TallaBN = new MST_TallaBN();
        $o_MST_TallaBN->setIdTalla( ( integer ) $o_MST_TallaRs[ "IdTalla" ] );
        $o_MST_TallaBN->setDescripcion( $o_MST_TallaRs[ "Descripcion" ] );
        $o_MST_TallaBN->setEstado( $o_MST_TallaRs[ "Estado" ] );
        $o_MST_TallaBN->setUsuarioCreacion( $o_MST_TallaRs[ "UsuarioCreacion" ] );
        $o_MST_TallaBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_MST_TallaRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_MST_TallaBN->setUsuarioModificacion( $o_MST_TallaRs[ "UsuarioModificacion" ] );
        $o_MST_TallaBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_MST_TallaRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_MST_TallaBN;
    }
}
?>