<?php
/* Autor...:  */
/* Esquema.: MST_ItemProcedencia.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Metodos de acceso a los campos de la tabla MST_ItemProcedencia */
abstract class BaseMST_ItemProcedenciaBN
{
    /* Campos de la tabla */
    private $s_IdProcedencia;    // IdProcedencia: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )

    /* Establece el valor del campo IdProcedencia */
    public function setIdProcedencia( $s_IdProcedencia )
    {
        $this->s_IdProcedencia = $s_IdProcedencia;
    }

    /* Obtiene el valor del campo IdProcedencia */
    public function getIdProcedencia()
    {
        return $this->s_IdProcedencia;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdProcedencia' => $this->getIdProcedencia(),
            'Descripcion' => $this->getDescripcion(),
            'Estado' => $this->getEstado(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto MST_ItemProcedenciaBN desde un RecordSet */
    public static function retrieveByRs( $o_MST_ItemProcedenciaRs )
    {
        $o_MST_ItemProcedenciaBN = new MST_ItemProcedenciaBN();
        $o_MST_ItemProcedenciaBN->setIdProcedencia( $o_MST_ItemProcedenciaRs[ "IdProcedencia" ] );
        $o_MST_ItemProcedenciaBN->setDescripcion( $o_MST_ItemProcedenciaRs[ "Descripcion" ] );
        $o_MST_ItemProcedenciaBN->setEstado( $o_MST_ItemProcedenciaRs[ "Estado" ] );
        $o_MST_ItemProcedenciaBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_MST_ItemProcedenciaRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_MST_ItemProcedenciaBN->setUsuarioCreacion( $o_MST_ItemProcedenciaRs[ "UsuarioCreacion" ] );
        $o_MST_ItemProcedenciaBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_MST_ItemProcedenciaRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        $o_MST_ItemProcedenciaBN->setUsuarioModificacion( $o_MST_ItemProcedenciaRs[ "UsuarioModificacion" ] );
        return $o_MST_ItemProcedenciaBN;
    }
}
?>