<?php
/* Autor...:  */
/* Esquema.: GSS_Detraccion.xml */
/* Generado: 2021-10-09 18:38:22 */

/* Metodos de acceso a los campos de la tabla GSS_Detraccion */
abstract class BaseGSS_DetraccionBN
{
    /* Campos de la tabla */
    private $i_IdDetraccion;    // IdDetraccion: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $s_CodigoSunat;    // CodigoSunat: ( no definido )
    private $s_CodigoSunatPr;    // CodigoSunatPr: ( no definido )
    private $f_Porcentaje;    // Porcentaje: ( no definido )
    private $f_MontoMinimo;    // MontoMinimo: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FehaEliminacion;    // FehaEliminacion: ( no definido )
    private $s_UsuarioEliminacion;    // UsuarioEliminacion: ( no definido )

    /* Establece el valor del campo IdDetraccion */
    public function setIdDetraccion( $i_IdDetraccion )
    {
        $this->i_IdDetraccion = $i_IdDetraccion;
    }

    /* Obtiene el valor del campo IdDetraccion */
    public function getIdDetraccion()
    {
        return $this->i_IdDetraccion;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat )
    {
        $this->s_CodigoSunat = $s_CodigoSunat;
    }

    /* Obtiene el valor del campo CodigoSunat */
    public function getCodigoSunat()
    {
        return $this->s_CodigoSunat;
    }

    /* Establece el valor del campo CodigoSunatPr */
    public function setCodigoSunatPr( $s_CodigoSunatPr )
    {
        $this->s_CodigoSunatPr = $s_CodigoSunatPr;
    }

    /* Obtiene el valor del campo CodigoSunatPr */
    public function getCodigoSunatPr()
    {
        return $this->s_CodigoSunatPr;
    }

    /* Establece el valor del campo Porcentaje */
    public function setPorcentaje( $f_Porcentaje )
    {
        $this->f_Porcentaje = $f_Porcentaje;
    }

    /* Obtiene el valor del campo Porcentaje */
    public function getPorcentaje()
    {
        return $this->f_Porcentaje;
    }

    /* Establece el valor del campo MontoMinimo */
    public function setMontoMinimo( $f_MontoMinimo )
    {
        $this->f_MontoMinimo = $f_MontoMinimo;
    }

    /* Obtiene el valor del campo MontoMinimo */
    public function getMontoMinimo()
    {
        return $this->f_MontoMinimo;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FehaEliminacion */
    public function setFehaEliminacion( $d_FehaEliminacion )
    {
        $this->d_FehaEliminacion = $d_FehaEliminacion;
    }

    /* Obtiene el valor del campo FehaEliminacion */
    public function getFehaEliminacion()
    {
        return $this->d_FehaEliminacion;
    }

    /* Establece el valor del campo UsuarioEliminacion */
    public function setUsuarioEliminacion( $s_UsuarioEliminacion )
    {
        $this->s_UsuarioEliminacion = $s_UsuarioEliminacion;
    }

    /* Obtiene el valor del campo UsuarioEliminacion */
    public function getUsuarioEliminacion()
    {
        return $this->s_UsuarioEliminacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdDetraccion' => $this->getIdDetraccion(),
            'Descripcion' => $this->getDescripcion(),
            'CodigoSunat' => $this->getCodigoSunat(),
            'CodigoSunatPr' => $this->getCodigoSunatPr(),
            'Porcentaje' => $this->getPorcentaje(),
            'MontoMinimo' => $this->getMontoMinimo(),
            'Estado' => $this->getEstado(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FehaEliminacion' => $this->getFehaEliminacion(),
            'UsuarioEliminacion' => $this->getUsuarioEliminacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_DetraccionBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_DetraccionRs )
    {
        $o_GSS_DetraccionBN = new GSS_DetraccionBN();
        $o_GSS_DetraccionBN->setIdDetraccion( ( integer ) $o_GSS_DetraccionRs[ "IdDetraccion" ] );
        $o_GSS_DetraccionBN->setDescripcion( $o_GSS_DetraccionRs[ "Descripcion" ] );
        $o_GSS_DetraccionBN->setCodigoSunat( $o_GSS_DetraccionRs[ "CodigoSunat" ] );
        $o_GSS_DetraccionBN->setCodigoSunatPr( $o_GSS_DetraccionRs[ "CodigoSunatPr" ] );
        $o_GSS_DetraccionBN->setPorcentaje( ( float ) $o_GSS_DetraccionRs[ "Porcentaje" ] );
        $o_GSS_DetraccionBN->setMontoMinimo( ( float ) $o_GSS_DetraccionRs[ "MontoMinimo" ] );
        $o_GSS_DetraccionBN->setEstado( $o_GSS_DetraccionRs[ "Estado" ] );
        $o_GSS_DetraccionBN->setUsuarioCreacion( $o_GSS_DetraccionRs[ "UsuarioCreacion" ] );
        $o_GSS_DetraccionBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_DetraccionRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_DetraccionBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_DetraccionRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_DetraccionBN->setUsuarioModificacion( $o_GSS_DetraccionRs[ "UsuarioModificacion" ] );
        $o_GSS_DetraccionBN->setFehaEliminacion( utilTimestamp::getTimestamp( $o_GSS_DetraccionRs[ "FehaEliminacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_DetraccionBN->setUsuarioEliminacion( $o_GSS_DetraccionRs[ "UsuarioEliminacion" ] );
        return $o_GSS_DetraccionBN;
    }
}
?>