<?php

function getCorrelativo($compania, $tipoCorrelativo,$serie,$flagActualiza)
{
  $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
  $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk($compania,$tipoCorrelativo,$serie);
  
   try 
        {
			//Existe un correlativo para la llave asociada a una empresa especifica
			if(is_object($o_GSS_CorrelativoMastBN)){
				$correlativoActual = $o_GSS_CorrelativoMastBN->getCorrelativoNumero();
			}else{
				$o_GSS_CorrelativoMastBN = null;
				//Buscar para todas las empresas
				$compania = Constantes::COMPANIAS_TODAS;
				$o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk($compania,$tipoCorrelativo,$serie);	
							
			if(is_object(!$o_GSS_CorrelativoMastBN)){
				$correlativoActual = $o_GSS_CorrelativoMastBN->getCorrelativoNumero();
			}else{
				throw new Exception( "Debe crear en el mastro de correlativos un correlativo para ".$tipoCorrelativo." con serie ".$serie );
			}

			}
		}
		catch ( Exception $o_Exception )
		{
			throw new Exception( $o_Exception->getMessage() );
		}
	if($flagActualiza){
		$o_GSS_CoreelativoMastDP = new GSS_CorrelativoMastDP();
		$o_GSS_CoreelativoMastDP->setIdCompania((int)$compania);
		$o_GSS_CoreelativoMastDP->setTipoComprobante($tipoCorrelativo);
		$o_GSS_CoreelativoMastDP->setSerie($serie);
		$o_GSS_CoreelativoMastDP->setCorrelativoNumero($correlativoActual+1);
		$o_GSS_CoreelativoMastDP->update();
	}
		
	return $correlativoActual ;
  
}