<?php

function _replaceParams($params=''){
  $str = array("&", "=");
  $params = str_replace($str, "/", $params);
  return $params;
}

function _orderInternalUrl($internal_uri){
  $cadena = explode("/", $internal_uri);
  $string = "";
  foreach($cadena as $iKey => $sValue){
    $rs = fmod($iKey+1,2);
    $concat = "/";
    if($rs == 0){
      $concat = "/";
    }
    if(count($cadena)==$iKey+1){
      $concat = "";
    }
    $string .= $sValue.$concat;
  }
  return $string;
}

function link_to($name = '', $internal_uri = '', $options = array()){
  $internal_uri = _orderInternalUrl($internal_uri);
  $referer = $_SERVER['SCRIPT_NAME']."/".$internal_uri;
  $concatHref = '<a href="'.$referer.'">'.$name.'</a>';
  return $concatHref;
}

function buildUrl($internal_uri='', $params=''){
  $params = _replaceParams($params);
  $concatUrl = $_SERVER['SCRIPT_NAME'].'/'.$internal_uri.'/'.$params;
  return $concatUrl;
}

function buildUrlComplet($internal_uri='', $params=''){
  $a_tmp = explode('/', $_SERVER['SCRIPT_NAME']);
  foreach ($a_tmp as $iKey => $sValue){
    $bReturn = strpos($sValue, '.php');
    if ($bReturn !== false) {
      unset($a_tmp[$iKey]);
      break;
    }
  }  
  $tmp_url = implode('/', $a_tmp);
  $params = _replaceParams($params);
  $concatUrl = $tmp_url.'/'.$internal_uri.'/'.$params;
  return $concatUrl;
}