<?php
class iVentas
{
    public function registrarTipoCambio( $s_FechaSelect = null )
    {
        if( is_null( $s_FechaSelect ) )
        {
            $s_FechaHoy = date( "Y-m-d" );
        }
        else
        {
            $s_FechaHoy = $s_FechaSelect;
        }

        $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
        $o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPK( "EX", "LO", $s_FechaHoy, myUser::getUser()->getIdCompania() );

        if( !$o_GSS_TipoCambioBN )
        {
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AQUI SE RECUPERA DATA DEL WEBSERVICE POR EL TIPO DE CAMBIO
            //https://api.sunat.online/cambio/2021-05
            //https://api.sunat.online/cambio/2021-04-15
            $s_MesAnio = date( "m/Y" );
            $s_Anio    = date( "Y" );
            $s_Mes     = date( "m" );
            $o_iRestClient = new iRestClient();
            //$a_TipoCambio = $o_iRestClient->getJsonDecode( "http://consultardoc.ceatec.com.pe/tipo/cambio/mes/".$s_MesAnio );
            $a_TipoCambio = $o_iRestClient->getJsonDecode( "https://api.apis.net.pe/v1/tipo-cambio-sunat?year=$s_Anio&month=$s_Mes" );
            /*$a_TipoCambio[] = array( "fecha" => "2021-05-01", "compra" => "3.783", "venta" => "3.792" );
            $a_TipoCambio[] = array( "fecha" => "2021-05-04", "compra" => "3.783", "venta" => "3.792" );
            $a_TipoCambio[] = array( "fecha" => "2021-05-05", "compra" => "3.783", "venta" => "3.792" );*/
            
            foreach ( $a_TipoCambio as $a_Valores )
            {
                $a_DataTipo[$a_Valores['fecha']] = array( "compra" => floatval( $a_Valores['compra'] ), "venta" => floatval( $a_Valores['venta'] ) );
            }

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if( isset( $a_DataTipo[$s_FechaHoy] ) )
            {
                $i_TipoCambioPor      = $o_GSS_CompaniaBN->getPorTipoCambio();
                if( $i_TipoCambioPor )
                {
                    $f_TipoCambioPor      = ( $i_TipoCambioPor / 100 ) + 1;
                    $f_TipoCambioCobranza = round( $a_DataTipo[$s_FechaHoy]['venta'] * $f_TipoCambioPor, 3 );
                }
                else
                {
                    $f_TipoCambioCobranza = $a_DataTipo[$s_FechaHoy]['venta'];
                }
                
                $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();
                $o_GSS_TipoCambioDP->setIdMoneda( "EX" );
                $o_GSS_TipoCambioDP->setIdMonedaCambio( "LO" );
                $o_GSS_TipoCambioDP->setIdCompania( myUser::getUser()->getIdCompania() );
                $o_GSS_TipoCambioDP->setIdFechaCambio( $s_FechaHoy );
                $o_GSS_TipoCambioDP->setSunatCompra( $a_DataTipo[$s_FechaHoy]['compra'] );
                $o_GSS_TipoCambioDP->setSunatVenta( $a_DataTipo[$s_FechaHoy]['venta'] );
                $o_GSS_TipoCambioDP->setTipoCambioCobranza( $f_TipoCambioCobranza );
                $o_GSS_TipoCambioDP->setEstado( "A" );
                $o_GSS_TipoCambioDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_GSS_TipoCambioDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_GSS_TipoCambioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_GSS_TipoCambioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_GSS_TipoCambioDP->save();
            }
            else
            {
                $i_Anio     = date( "Y" );
                $i_Mes      = date( "m" );
                $i_Dia      = date( "d" );
                $s_FechaBus = "";
                
                $i_Dia  = $i_Dia - 1;
                if( $i_Dia == 0 )
                {
                    $i_Mes = ( $i_Mes - 1 );
                    $s_FechaAnt = UtilDate::getFechaFinMes( $i_Anio, $i_Mes );
                    $i_Dia = substr( $s_FechaAnt, -2 );
                    
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //AQUI SE RECUPERA DATA DEL WEBSERVICE POR EL TIPO DE CAMBIO
                    $s_MesAnio = $i_Mes."/".date( "Y" );
                    $o_iRestClient = new iRestClient();
                    $a_TipoCambio = $o_iRestClient->getJsonDecode( "http://consultardoc.ceatec.com.pe/tipo/cambio/mes/".$s_MesAnio );
                    
                    foreach ( $a_TipoCambio as $a_Valores )
                    {
                        $a_DataTipo[$a_Valores['fecha']] = array( "compra" => floatval( $a_Valores['compra'] ), "venta" => floatval( $a_Valores['venta'] ) );
                    }
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                }

                $b_Control = false;
                for ( $i=$i_Dia; $i>0; $i-- )
                {
                    $s_FechaBus = $i_Anio."-".str_pad( $i_Mes, 2, "0", STR_PAD_LEFT )."-".str_pad( $i, 2, "0", STR_PAD_LEFT );
                    if( isset( $a_DataTipo[$s_FechaBus] ) )
                    {
                        $b_Control = true;
                        //$a_DataSelect = $a_DataTipo[$s_FechaBus];
                        break;
                    }
                }

                if( !$b_Control )
                {
                    $i_Mes      = ( $i_Mes - 1 );
                    $s_FechaAnt = UtilDate::getFechaFinMes( $i_Anio, $i_Mes );
                    $i_Dia      = substr( $s_FechaAnt, -2 );
                    
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //AQUI SE RECUPERA DATA DEL WEBSERVICE POR EL TIPO DE CAMBIO
                    $s_MesAnio      = $i_Mes."/".date( "Y" );
                    $o_iRestClient  = new iRestClient();
                    $a_TipoCambio   = $o_iRestClient->getJsonDecode( "http://consultardoc.ceatec.com.pe/tipo/cambio/mes/".$s_MesAnio );
                    
                    foreach ( $a_TipoCambio as $a_Valores )
                    {
                        $a_DataTipo[$a_Valores['fecha']] = array( "compra" => floatval( $a_Valores['compra'] ), "venta" => floatval( $a_Valores['venta'] ) );
                    }
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    $b_Control = false;
                    for ( $i=$i_Dia; $i>0; $i-- )
                    {
                        $s_FechaBus = $i_Anio."-".str_pad( $i_Mes, 2, "0", STR_PAD_LEFT )."-".str_pad( $i, 2, "0", STR_PAD_LEFT );
                        if( isset( $a_DataTipo[$s_FechaBus] ) )
                        {
                            //pr( $s_FechaBus ); pr( $a_DataTipo[$s_FechaBus] );
                            $b_Control = true;
                            //$a_DataSelect = $a_DataTipo[$s_FechaBus];
                            break;
                        }
                    }
                }

                if( $b_Control )
                {
                    $i_TipoCambioPor  = $o_GSS_CompaniaBN->getPorTipoCambio();
                    if( $i_TipoCambioPor )
                    {
                        $f_TipoCambioPor      = ( $i_TipoCambioPor / 100 ) + 1;
                        $f_TipoCambioCobranza = round( $a_DataTipo[$s_FechaBus]['venta'] * $f_TipoCambioPor, 3 );
                    }
                    else
                    {
                        $f_TipoCambioCobranza = $a_DataTipo[$s_FechaBus]['venta'];
                    }
                    
                    $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();
                    $o_GSS_TipoCambioDP->setIdMoneda( "EX" );
                    $o_GSS_TipoCambioDP->setIdMonedaCambio( "LO" );
                    $o_GSS_TipoCambioDP->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_GSS_TipoCambioDP->setIdFechaCambio( $s_FechaHoy );
                    $o_GSS_TipoCambioDP->setSunatCompra( $a_DataTipo[$s_FechaBus]['compra'] );
                    $o_GSS_TipoCambioDP->setSunatVenta( $a_DataTipo[$s_FechaBus]['venta'] );
                    $o_GSS_TipoCambioDP->setTipoCambioCobranza( $f_TipoCambioCobranza );
                    $o_GSS_TipoCambioDP->setEstado( "A" );
                    $o_GSS_TipoCambioDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_GSS_TipoCambioDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_GSS_TipoCambioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_GSS_TipoCambioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_GSS_TipoCambioDP->save();
                    //pr( $o_GSS_TipoCambioDP );
                }
            }
        }
        else
        {
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );

            $i_TipoCambioPor  = $o_GSS_CompaniaBN->getPorTipoCambio();
            if( $i_TipoCambioPor )
            {
                $f_TipoCambioPor = ( $i_TipoCambioPor / 100 ) + 1;
                $f_TipoCambioCobranza = round( $o_GSS_TipoCambioBN->getSunatVenta() * $f_TipoCambioPor, 3 );
            }
            else
            {
                $f_TipoCambioCobranza = $o_GSS_TipoCambioBN->getSunatVenta();
            }

            $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();
            $o_GSS_TipoCambioDP->setIdMoneda( "EX" );
            $o_GSS_TipoCambioDP->setIdMonedaCambio( "LO" );
            $o_GSS_TipoCambioDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_GSS_TipoCambioDP->setIdFechaCambio( $s_FechaHoy );
            $o_GSS_TipoCambioDP->setTipoCambioCobranza( $f_TipoCambioCobranza );
            $o_GSS_TipoCambioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_GSS_TipoCambioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_GSS_TipoCambioDP->update();
            //pr( $o_GSS_TipoCambioDP );
        }
    }
}