<?php
class Ventas_model
{
    /**
     * @param $venta_id
     * @return array
     * @throws SQLException
     */
    public function query_cabecera( $venta_id )
    {
        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $venta_id );
        
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        $a_Data = array
        (
            "direccion_cliente_de_venta" => $o_VTA_FacturacionElectronicaBN->getClienteDireccion(),
            "numero_pedido" => "",
            "nota_venta" => "",
            "numero_guia" => "",
            "condicion_venta" => "",
            "operacion" => 1,
            "total_descuentos" => $o_VTA_FacturacionElectronicaBN->getMontoDescuento(),
            "operacion_id" => "",
            "respuesta_sunat_codigo" => "",
            "respuesta_sunat_descripcion" => "",
            "respuesta_anulacion_codigo" => "",
            "respuesta_anulacion_descripcion" => "",
            "estado_anulacion" => "",
            "venta_id" => $venta_id,
            "venta_anio" => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), "Y" ),
            "forma_pago_id" => $o_VTA_DocumentoBN->getObjectFormaPago()->getCodigoSunat(),
            "venta_relacionado_id" => "", //id del comprobante asociado a la nota de credito o nota de debito
            "tipo_ncredito_id" => "", //motivo
            "tipo_ndebito_id" => "", //motivo
            "serie" => $o_VTA_FacturacionElectronicaBN->getSerie(),
            "numero" => intval( $o_VTA_FacturacionElectronicaBN->getNumero() ),
            "porcentaje_igv" => ( $o_VTA_FacturacionElectronicaBN->getPorcentajeIGV() / 100 ),
            "fecha_emision_sf" => substr( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), 0, 10 ),
            "fecha_emision" => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), "d-m-Y" ),
            "hora_emision" => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), "H:i:s" ),
            "fecha_vencimiento" => $o_VTA_DocumentoBN->getFormaPagoCod()=="CRE" ? UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento(), "d-m-Y" ) : null,
            "fecha_vencimiento_sf" => $o_VTA_DocumentoBN->getFormaPagoCod()=="CRE" ? substr( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento(), 0, 10 ) : null,
            "tipo_de_cambio" => $o_VTA_FacturacionElectronicaBN->getTipoCambio(),
            "total_gravada" => $o_VTA_DocumentoBN->esGravadaConImpuesto() ? $o_VTA_FacturacionElectronicaBN->getSubTotal() : "",    //ES EL SUB-TOTAL
            "total_igv" => $o_VTA_FacturacionElectronicaBN->getImpuesto(),
            "total_gratuita" => "",
            "total_exportacion" => "",
            "total_exonerada" => "",
            "total_inafecta" => !$o_VTA_DocumentoBN->esGravadaConImpuesto() ? $o_VTA_FacturacionElectronicaBN->getSubTotal() : "",
            "total_bolsa" => "",
            "PrepaidAmount" => 0,   //ANTICIPOS
            "total_a_pagar" => $o_VTA_FacturacionElectronicaBN->getMontoTotal(),
            "estado_operacion" => $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" ? 1 : 0,
            "firma_sunat" => "",
            "orden_compra" => "",
            "notas notas" => "",
            "tipo_operacion" => "0101",
            "UBLVersionID" => "2.1",
            "CustomizationID" => "2.0",
            "moneda_id" => $o_VTA_DocumentoBN->getObjectMoneda()->getIdMoneda(),
            "moneda" => $o_VTA_DocumentoBN->getObjectMoneda()->getDescripcion(),
            "simbolo_moneda" => $o_VTA_DocumentoBN->getObjectMoneda()->getSigla(),
            "abrstandar" => $o_VTA_DocumentoBN->getObjectMoneda()->getCodigoFiscal(),
            "entidad_id" => $o_VTA_FacturacionElectronicaBN->getCodCliente(),
            "entidad" => $o_VTA_FacturacionElectronicaBN->getClienteNom(),
            "nombre_comercial" => "",
            "numero_documento" => $o_VTA_FacturacionElectronicaBN->getClienteDocNum(),
            "direccion_entidad" => $o_VTA_FacturacionElectronicaBN->getClienteDireccion(),
            "email_1_entidad" => $o_VTA_FacturacionElectronicaBN->getClienteEmail(),
            "email_2_entidad" => $o_VTA_FacturacionElectronicaBN->getClienteEmail1(),
            "telefono_fijo_1" => utilString::eliminar_espacios( $o_VTA_DocumentoBN->getObjectCliente()->getTelefono() ),
            "telefono_fijo_2" => "",
            "telefono_movil_1" => utilString::eliminar_espacios( $o_VTA_DocumentoBN->getObjectCliente()->getCelular() ),
            "telefono_movil_2" => "",
            "nombres" => $o_VTA_DocumentoBN->getObjectCliente()->getNombres(),
            "apellido_paterno" => $o_VTA_DocumentoBN->getObjectCliente()->getApellidoPaterno(),
            "apellido_materno" => $o_VTA_DocumentoBN->getObjectCliente()->getApellidoMaterno(),
            "dni" => $o_VTA_FacturacionElectronicaBN->getClienteDocNum(),
            "tipo_entidad_id" => $o_VTA_DocumentoBN->getObjectCliente()->getTipoDocumentoSunat(),
            "descripcion" => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "abreviatura_tipo_entidad" => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "tipo_entidad" => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "codigo_tipo_entidad" => $o_VTA_DocumentoBN->getObjectCliente()->getTipoDocumentoSunat(),
            "tipo_documento_id" => intval( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal() ),
            "abreviado" => $o_VTA_DocumentoBN->getObjectTipoDocumento()->getIdTipoDocumento(),
            "tipo_documento_codigo" => $o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal(),
            "tipo_documento" => $o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal(),
        );
        
        return $a_Data;
    }
}