<?php
use Peru\Sunat\RucFactory;
use Peru\Jne\DniFactory;

require ( 'plugins/webservices_api/peru-consult-master/vendor/autoload.php' );

//pr( getcwd() );

class iPersona
{
    protected $TipoDocumentoCliente;
    protected $NumeroDocumentoCliente;
    public function getTipoDocumentoCliente()
    {
        return $this->TipoDocumentoCliente;
    }

    public function getNumeroDocumentoCliente()
    {
        return $this->NumeroDocumentoCliente;
    }

    public function setTipoDocumentoCliente($TipoDocumentoCliente)
    {
        $this->TipoDocumentoCliente = $TipoDocumentoCliente;
    }

    public function setNumeroDocumentoCliente($NumeroDocumentoCliente)
    {
        $this->NumeroDocumentoCliente = $NumeroDocumentoCliente;
    }

    public function ConsultaDocumentoporServicioWeb()
    {
        $b_Control          = false;
        $b_ControlSeg       = true;
        $s_TipoDocuCliente  = $this->getTipoDocumentoCliente();
        $s_NumDocuCliente   = $this->getNumeroDocumentoCliente();
        $i_IdPersona        = "";

        //validaciones
        $i_CntCarac = strlen( $s_NumDocuCliente );
        if( !$s_TipoDocuCliente )
        {
            throw new Exception( "Se necesita el parametro Tipo de Documento." );
        }
        if( !$s_NumDocuCliente )
        {
            throw new Exception( "Se necesita el parametro Numero de Documento." );
        }
        if( $s_TipoDocuCliente == "DNI" )
        {
            if( $i_CntCarac <> 8 )
            {
                throw new Exception( "El Numero de Documento de Identidad es Incorrecto." );
            }
        }
        if( $s_TipoDocuCliente == "RUC" )
        {
            if( $i_CntCarac <> 11 )
            {
                throw new Exception( "El Registro Unico de Contribuyentes es Incorrecto." );
            }
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_Nombres = "";
        $s_ApellidoPaterno = "";
        $s_ApellidoMaterno = "";
        $s_NombreCompleto = "";
        $s_NombreComercial = "";
        $s_FechaActividad = "";
        $s_DireccionFiscal = "";
        $s_NivelInstruccion = "";
        $s_EstadoCivil = "";
        $s_TipoBrevete = "";
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //se busca por el metodo normal
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setTipoDocumento( $s_TipoDocuCliente );
        $o_MST_PersonaMastFN->setDocumento( $s_NumDocuCliente );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        if( $a_MST_PersonaMast )
        {
            $b_Control = true;
            $b_ControlSeg = false;
            $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
        }
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        //$o_MST_PersonaMastFN->setTipoDocumento( $s_TipoDocuCliente );
        $o_MST_PersonaMastFN->setDocumentoIdentidad( $s_NumDocuCliente );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        if( $a_MST_PersonaMast )
        {
            $b_Control = true;
            $b_ControlSeg = false;
            $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
        }
        
        if( $b_Control )
        {
            $i_IdPersona        = $o_MST_PersonaMastBN->getIdPersona();
            $s_Nombres          = $o_MST_PersonaMastBN->getNombres();
            $s_ApellidoPaterno  = $o_MST_PersonaMastBN->getApellidoPaterno();
            $s_ApellidoMaterno  = $o_MST_PersonaMastBN->getApellidoMaterno();
            $s_NombreCompleto   = $o_MST_PersonaMastBN->getNombreCompleto();
            $s_NombreComercial  = $o_MST_PersonaMastBN->getNombreComercial();
            $s_FechaActividad   = $o_MST_PersonaMastBN->getFechaNacimiento();
            $s_DireccionFiscal  = $o_MST_PersonaMastBN->getDireccion();
            $s_NivelInstruccion = $o_MST_PersonaMastBN->getNivelInstruccion();
            $s_EstadoCivil      = $o_MST_PersonaMastBN->getEstadoCivil();
            $s_TipoBrevete      = $o_MST_PersonaMastBN->getTipoBrevete();
            $s_TipoPersona      = $o_MST_PersonaMastBN->getTipoPersona();
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if( !$b_Control )
        {
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora si no lo encuentra, se busca en la RENIEC
            if( $s_TipoDocuCliente == "DNI" )
            {
                //-----------------------------------------------------------------------------------------------------------------------------
                //https://www.facturacionelectronica.us/consulta-dni.php
                //-----------------------------------------------------------------------------------------------------------------------------
                //http://api.ateneaperu.com/Home/ConsultarDni
                //-----------------------------------------------------------------------------------------------------------------------------
                //fuente: http://soporte.facturacionperu.pe/knowledgebase.php?article=58&rated=1
                //http://www.facturacionsunat.com/vfpsws/vfpsconsbsapi.php?dni=41288353&token=87290E49D50B519&format=json  -> devuelve en JSON
                //-----------------------------------------------------------------------------------------------------------------------------
                if( $b_ControlSeg )
                {
                    /*
                    $factory = new DniFactory();
                    $cs = $factory->create();
                    $person = $cs->get( $s_NumDocuCliente );
                    if( $person )
                    {
                        $s_TipoPersona      = "N";
                        $s_Nombres          = $person->nombres;
                        $s_ApellidoPaterno  = $person->apellidoPaterno;
                        $s_ApellidoMaterno  = $person->apellidoMaterno;
                        $s_FechaActividad   = date( "Y-m-d" );
                        $s_DireccionFiscal  = "";
                        $s_NivelInstruccion = "";
                        $s_EstadoCivil      = "";
                        $s_TipoBrevete      = "";

                        $s_NombreCompleto   = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                        $s_NombreComercial  = "";

                        $b_ControlSeg  = false;
                    }
                    */
                }
                
                if( $b_ControlSeg )
                {
                    /*$o_simple_html_dom_node = new simple_html_dom();
                    //$consulta = file_get_html( 'https://eldni.com/buscar-por-dni?dni='.$s_NumDocuCliente );
                    $consulta = file_get_html( 'https://eldni.com/pe/buscar-por-dni?dni='.$s_NumDocuCliente );
                    
                    $datosnombres = array();
                    
                    if( $consulta )
                    {
                        foreach(  $consulta->find( 'td' ) as $header )
                        {
                            $datosnombres[] = $header->plaintext;
                        }
                        //pr( "1:" ); pr( $datosnombres );
                        if( $datosnombres )
                        {
                            //se ecnontro el nombre desde la reniec
                            $s_TipoPersona      = "N";
                            $s_Nombres          = $datosnombres[1];
                            $s_ApellidoPaterno  = $datosnombres[2];
                            $s_ApellidoMaterno  = $datosnombres[3];
                            $s_FechaActividad   = date( "Y-m-d" );
                            $s_DireccionFiscal  = "";
                            $s_NivelInstruccion = "";
                            $s_EstadoCivil      = "";
                            $s_TipoBrevete      = "";
                            
                            $s_NombreCompleto   = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                            $s_NombreComercial  = "";
                            
                            $b_ControlSeg  = false;
                        }
                    }*/
                }
                
                if( $b_ControlSeg )
                {
                    /*$o_consulta_reniec = new consulta_reniec();
                    $o_consulta_reniec->setDNI( $s_NumDocuCliente );
                    $a_Result = $o_consulta_reniec->get_content();
                    //pr( "2:" ); pr( $a_Result );
                    if( $a_Result )
                    {
                        if( $a_Result["error"] )
                        {
                            throw new Exception( $a_Result["mensaje_error"] );
                        }
                        if( isset( $a_Result["dni"] ) )
                        {
                            $s_TipoPersona      = "N";
                            $s_Nombres          = $a_Result["nombres"];
                            $s_ApellidoPaterno  = $a_Result["ape_paterno"];
                            $s_ApellidoMaterno  = $a_Result["ape_materno"];
                            $s_FechaActividad   = strpos( $a_Result["feNacimiento"], "00" ) !== false ? UtilDate::convertDatexFormatSlash( $a_Result["feNacimiento"] ) : date( "Y-m-d" );
                            $s_DireccionFiscal  = $a_Result["domicilio"];
                            $s_NivelInstruccion = "";
                            $s_EstadoCivil      = "";
                            $s_TipoBrevete      = "";
                            
                            $s_NombreCompleto   = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                            $s_NombreComercial  = "";

                            $b_ControlSeg  = false;
                        }
                        else
                        {
                            throw new Exception( "No se puede recuperar datos de la RENIEC." );
                        }
                    }
                    else
                    {
                        throw new Exception( "No se puede recuperar datos de la RENIEC." );
                    }*/
                }

                //tercer componente
                if( $b_ControlSeg )
                {
                    //TOKEN DE MARCO:
                    //$s_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6Im1hc2NydXoxM0Bob3RtYWlsLmNvbSJ9.mNDdXUeDsTq7zlvdmkFUInQcXlC3qPTbEJIo4kfYi-w";
                    //$o_iRestClient = new iRestClient();
                    
                    //$a_Result = $o_iRestClient->getJsonDecode( "https://dniruc.apisperu.com/api/v1/dni/$s_NumDocuCliente?token=$s_Token" );
                    
                    //$s_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6IndpbGxqY2VAZ21haWwuY29tIn0.hT2x3lQmjmAnOtHBGfx4ZMRfRYZp7F9BMgUsT_5of8s";
                    $s_Token = "9a5969ba50b89914bbb2166f2e05eaaa149922956fb2aab68117f02e609f0f23";
                    $o_iRestClient = new iRestClient();
                    $url = "https://elitodontologico.com/ibp-admin/ws/ws_dniv2.php?dni=".$s_NumDocuCliente."&api_token=9a5969ba50b8883389914ba92166f2e05ea35149922956fb2aab687c7f02e609f0f23";
                    //$a_Result_r = $o_iRestClient->getJsonDecode( "https://my.apidev.pro/api/dni/$s_NumDocuCliente?api_token=$s_Token");
                    $a_Result_r = $o_iRestClient->getJsonDecode( $url);
                    

                    $a_Result           =  $a_Result_r["data"];   
                    //print_r($a_Result);
                    $s_TipoPersona      = "N";
                    $s_Nombres          = $a_Result["nombres"];
                    $s_ApellidoPaterno  = $a_Result["apellido_paterno"];//$a_Result["apellidoPaterno"];
                    $s_ApellidoMaterno  = $a_Result["apellido_materno"];//$a_Result["apellidoMaterno"];
                    
                    $s_FechaActividad   = date( "Y-m-d" );
                    $s_DireccionFiscal  = "";
                    $s_NivelInstruccion = "";
                    $s_EstadoCivil      = "";
                    $s_TipoBrevete      = "";

                    $s_NombreCompleto   = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                    $s_NombreComercial  = "";

                    $b_ControlSeg  = false;
                }

                //cuarto componente
                if( $b_ControlSeg )
                {
                    //TOKEN DE WILLY:
                    //$s_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6IndpbGxqY2VAZ21haWwuY29tIn0.hT2x3lQmjmAnOtHBGfx4ZMRfRYZp7F9BMgUsT_5of8s";
                    $s_Token = "9a5969ba50b89914bbb2166f2e05eaaa149922956fb2aab68117f02e609f0f23";
                    $o_iRestClient = new iRestClient();
                    //$a_Result = $o_iRestClient->getJsonDecode( "https://dniruc.apisperu.com/api/v1/dni/$s_NumDocuCliente?token=$s_Token" );
                    $a_Result_r = $o_iRestClient->getJsonDecode( "https://my.apidev.pro/api/dni/$s_NumDocuCliente?api_token=$s_Token");
                    print_r($a_Result_r);
                    $a_Result           =  $a_Result_r["data"];   
                    print_r($a_Result);
                    $s_TipoPersona      = "N";
                    $s_Nombres          = $a_Result["nombres"];
                    $s_ApellidoPaterno  = $a_Result["apellido_paterno"];//$a_Result["apellidoPaterno"];
                    $s_ApellidoMaterno  = $a_Result["apellido_materno"];//$a_Result["apellidoMaterno"];
                    $s_FechaActividad   = "";
                    $s_DireccionFiscal  = "";
                    $s_NivelInstruccion = "";
                    $s_EstadoCivil      = "";
                    $s_TipoBrevete      = "";

                    $s_NombreCompleto   = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                    $s_NombreComercial  = "";

                    $b_ControlSeg  = false;
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se busca a la SUNAT
            if( $s_TipoDocuCliente == "RUC" )
            {
                $b_ControlSeg  = true;
                $s_TipoPersona = "J";
                
                if( $b_ControlSeg )
                {
                    /*$factory = new RucFactory();
                    $cs = $factory->create();
                    $company = $cs->get( $s_NumDocuCliente );

                    if( $company )
                    {
                        $s_NombreCompleto   = $company->razonSocial;
                        $s_NombreComercial  = $company->nombreComercial;
                        $s_FechaActividad   = substr( $company->fechaInscripcion, 0, 10 );
                        $s_DireccionFiscal  = $company->direccion;
                        $s_NivelInstruccion = $company->condicion;
                        $s_EstadoCivil      = $company->estado;
                        $s_TipoBrevete      = "";
                        
                        $s_Nombres         = "";
                        $s_ApellidoPaterno = "";
                        $s_ApellidoMaterno = "";
                        
                        $b_ControlSeg  = false;
                    }*/
                }
                
                //primer componente
                if( $b_ControlSeg )
                {
                    /*$o_Sunat = new Sunat( true, true );
                    $s_Response = $o_Sunat->search( $s_NumDocuCliente, true ); //aqui si funciona, solo esta interpretando mal

                    if( $s_Response )
                    {
                        $a_Result = json_decode( $s_Response, true );
                        
                        if( $a_Result )
                        {
                            if( !isset( $a_Result['msg'] ) )
                            {
                                if( isset( $a_Result['result']['RUC'] ) )
                                {
                                    if( $a_Result["result"]['Estado'] != "ACTIVO" )
                                    {
                                        throw new Exception( "El Cliente con el RUC [$s_NumDocuCliente] tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                                    }
                                    $s_NombreCompleto   = $a_Result['result']['RazonSocial'];
                                    $s_NombreComercial  = $a_Result['result']['NombreComercial'];
                                    $s_FechaActividad   = UtilDate::convertDatexFormatSlash( $a_Result['result']['Inscripcion'] );
                                    $s_DireccionFiscal  = $a_Result['result']['Direccion'];
                                    $s_NivelInstruccion = $a_Result['result']['Condicion'];
                                    $s_EstadoCivil      = $a_Result['result']['Estado'];
                                    $s_TipoBrevete      = $a_Result['result']['Tipo'];
                                    
                                    $s_Nombres         = "";
                                    $s_ApellidoPaterno = "";
                                    $s_ApellidoMaterno = "";
                                    
                                    $b_ControlSeg  = false;
                                }
                            }
                        }
                    }*/
                }
                
                //segundo componente
                if( $b_ControlSeg )
                {
                    /*$o_consulta_sunat = new consulta_sunat();
                    $o_consulta_sunat->setRuc( $s_NumDocuCliente );
                    $a_Result = $o_consulta_sunat->get_content();

                    if( $a_Result )
                    {
                        if( !$a_Result["error"] )
                        {
                            if( $a_Result["contribuyente_estado"] != "ACTIVO" )
                            {
                                throw new Exception( "El Cliente tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                            }

                            $s_NombreCompleto   = $a_Result["razon_social"];
                            $s_NombreComercial  = $a_Result["nombre_comercial"];
                            $s_FechaActividad   = $a_Result["fecha_inscripcion"];
                            $s_DireccionFiscal  = $a_Result["domicilio_fiscal"];
                            $s_NivelInstruccion = $a_Result["contribuyente_condicion"];
                            $s_EstadoCivil      = $a_Result["contribuyente_estado"];
                            $s_TipoBrevete      = $a_Result["contribuyente_tipo"];

                            $s_Nombres         = "";
                            $s_ApellidoPaterno = "";
                            $s_ApellidoMaterno = "";

                            $b_ControlSeg  = false;
                        }
                    }*/
                }

                //tercer componente
                if( $b_ControlSeg )
                {
                    //TOKEN DE MARCO:
                    $s_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6Im1hc2NydXoxM0Bob3RtYWlsLmNvbSJ9.mNDdXUeDsTq7zlvdmkFUInQcXlC3qPTbEJIo4kfYi-w";
                    $o_iRestClient = new iRestClient();
                    $a_Result = $o_iRestClient->getJsonDecode( "https://dniruc.apisperu.com/api/v1/ruc/$s_NumDocuCliente?token=$s_Token" );

                    if( $a_Result["estado"] != "ACTIVO" )
                    {
                        throw new Exception( "El Cliente tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                    }

                    $s_NombreCompleto   = $a_Result["razonSocial"];
                    $s_NombreComercial  = $a_Result["nombreComercial"];
                    $s_FechaActividad   = $a_Result["fechaInscripcion"];
                    $s_DireccionFiscal  = $a_Result["direccion"];
                    $s_NivelInstruccion = $a_Result["condicion"];
                    $s_EstadoCivil      = $a_Result["estado"];
                    $s_TipoBrevete      = $a_Result["tipo"];

                    $s_Nombres         = "";
                    $s_ApellidoPaterno = "";
                    $s_ApellidoMaterno = "";

                    $b_ControlSeg  = false;
                }

                //CUARTO componente
                if( $b_ControlSeg )
                {
                    //TOKEN DE WILLY:
                    $s_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6IndpbGxqY2VAZ21haWwuY29tIn0.hT2x3lQmjmAnOtHBGfx4ZMRfRYZp7F9BMgUsT_5of8s";
                    $o_iRestClient = new iRestClient();
                    $a_Result = $o_iRestClient->getJsonDecode( "https://dniruc.apisperu.com/api/v1/ruc/$s_NumDocuCliente?token=$s_Token" );

                    if( $a_Result["estado"] != "ACTIVO" )
                    {
                        throw new Exception( "El Cliente tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                    }

                    $s_NombreCompleto   = $a_Result["razonSocial"];
                    $s_NombreComercial  = $a_Result["nombreComercial"];
                    $s_FechaActividad   = $a_Result["fechaInscripcion"];
                    $s_DireccionFiscal  = $a_Result["direccion"];
                    $s_NivelInstruccion = $a_Result["condicion"];
                    $s_EstadoCivil      = $a_Result["estado"];
                    $s_TipoBrevete      = $a_Result["tipo"];

                    $s_Nombres         = "";
                    $s_ApellidoPaterno = "";
                    $s_ApellidoMaterno = "";

                    $b_ControlSeg  = false;
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        }
        
        $a_Result = array();

        if( $b_ControlSeg )
        {
            throw new Exception( "No se encontro informacion en la SUNAT." );
        }

        $a_Result['ExisteCliente']    = $b_Control;
        $a_Result['IdPersona']        = $i_IdPersona;
        $a_Result['Nombres']          = $s_Nombres;
        $a_Result['ApellidoPaterno']  = $s_ApellidoPaterno;
        $a_Result['ApellidoMaterno']  = $s_ApellidoMaterno;
        $a_Result['NombreCompleto']   = $s_NombreCompleto;
        $a_Result['NombreComercial']  = $s_NombreComercial;
        $a_Result['FechaActividad']   = $s_FechaActividad;
        $a_Result['DireccionFiscal']  = $s_DireccionFiscal;
        $a_Result['NivelInstruccion'] = $s_NivelInstruccion;
        $a_Result['EstadoCivil']      = $s_EstadoCivil;
        $a_Result['TipoBrevete']      = $s_TipoBrevete;
        $a_Result['TipoPersona']      = $s_TipoPersona;

        return $a_Result;
    }
    
}