<?php
class utilGenerateId
{
    protected $IdCompania;
    protected $Tipocomprobante;
    protected $Serie;
    protected $o_CorrelativoMast;
    protected $NombreTabla;
    protected $IdTabla;
    protected $CampoPrfTabla;
    
    public function setIdCompania( $v )
    {
        $this->IdCompania = $v;
    }
    
    public function getIdCompania()
    {
        return $this->IdCompania;
    }
    
    public function setTipoCorrelativo( $v )
    {
        $this->Tipocomprobante = $v;
    }
    
    public function getTipoCorrelativo()
    {
        return $this->Tipocomprobante;
    }
    
    public function setSerie( $v )
    {
        $this->Serie = $v;
    }
    
    public function getSerie()
    {
        return $this->Serie;
    }
    
    /**
     * @return the $NombreTabla
     */
    public function getNombreTabla()
    {
        return $this->NombreTabla;
    }

    /**
     * @param field_type $NombreTabla
     */
    public function setNombreTabla($NombreTabla)
    {
        $this->NombreTabla = $NombreTabla;
    }

    /**
     * @return the $IdTabla
     */
    public function getIdTabla()
    {
        return $this->IdTabla;
    }

    /**
     * @param field_type $IdTabla
     */
    public function setIdTabla($IdTabla)
    {
        $this->IdTabla = $IdTabla;
    }

    /**
     * @return the $CampoPrfTabla
     */
    public function getCampoPrfTabla()
    {
        return $this->CampoPrfTabla;
    }

    /**
     * @param field_type $CampoPrfTabla
     */
    public function setCampoPrfTabla($CampoPrfTabla)
    {
        $this->CampoPrfTabla = $CampoPrfTabla;
    }

    /**
     * @return the $o_CorrelativoMast
     */
    public function getObjCorrelativoMast()
    {
        return $this->o_CorrelativoMast;
    }

    /**
     * @param Ambigous <unknown, NULL, GSS_CorrelativoMastBN> $o_CorrelativoMast
     */
    public function setObjCorrelativoMast($o_CorrelativoMast)
    {
        $this->o_CorrelativoMast = $o_CorrelativoMast;
    }

    private function generarCorrelativo()
    {
        $IdCompania      = $this->getIdCompania();
        $TipoCorrelativo = $this->getTipoCorrelativo();
        $Serie           = $this->getSerie();
        
        $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
        $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk( $IdCompania, $TipoCorrelativo, $Serie );
        
        $flagActualiza = false;
        try 
        {
            //Existe un correlativo para la llave asociada a una empresa especifica
            if( $o_GSS_CorrelativoMastBN )
            {
                $correlativoActual    = $o_GSS_CorrelativoMastBN->getCorrelativoNumero();
                $correlativoSiguiente = ( $correlativoActual + 1 );
                $flagActualiza = true;
            }
            else
            {
                $o_GSS_CorrelativoMastBN = null;
                //Buscar para todas las empresas
                $IdCompania = Constantes::COMPANIAS_TODAS;
                $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk( $IdCompania, $TipoCorrelativo, $Serie );	
            
                if( $o_GSS_CorrelativoMastBN )
                {
                    $correlativoActual    = $o_GSS_CorrelativoMastBN->getCorrelativoNumero();
                    $correlativoSiguiente = ( $correlativoActual + 1 );
                    $flagActualiza = true;
                }
                else
                {
                    throw new Exception( "Debe crear en el mastro de correlativos un correlativo para ".$TipoCorrelativo." con serie ".$Serie );
                }
            }
        }
        catch ( Exception $o_Exception )
        {
            throw new Exception( $o_Exception->getMessage() );
        }
        if( $flagActualiza )
        {
            $o_GSS_CoreelativoMastDP = new GSS_CorrelativoMastDP();
            $o_GSS_CoreelativoMastDP->setIdCompania( ( int ) $IdCompania );
            $o_GSS_CoreelativoMastDP->setIdTipoComprobante( $TipoCorrelativo );
            $o_GSS_CoreelativoMastDP->setIdSerie( $Serie );
            $o_GSS_CoreelativoMastDP->setCorrelativoNumero( $correlativoSiguiente );
            $o_GSS_CoreelativoMastDP->update();
        }
        return $correlativoSiguiente;
    }
    
    public function generateId()
    {
        $i_Id = ( int ) $this->generarCorrelativo();

        return $i_Id ;
    }
    
    public function generateStringId()
    {
        $i_Id = ( string ) $this->generarCorrelativo();
        return $i_Id ;
    }
    
    public function generateIdStringConcat()
        {
            try
            {
                    $sTableName = $this->getNombreTabla();
                    $s_ObjectTable = $sTableName."FN";
                    $s_IdRef = $this->getIdTabla();
                    $s_CampoPrf = "get".$this->getCampoPrfTabla();

                    $o_ObjectFN = new $s_ObjectTable();
                    $o_ObjectBN = $o_ObjectFN->selectByPk( $s_IdRef );
                    $s_RefPrefijo = $o_ObjectBN->$s_CampoPrf();

                    $this->setSerie( $s_RefPrefijo );

                    $IdCompania      = $this->getIdCompania();
                    $TipoCorrelativo = $this->getTipoCorrelativo();
                    $Serie           = $this->getSerie();

                    $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
                    $this->o_CorrelativoMast = $o_GSS_CorrelativoMastFN->selectByPk( $IdCompania, $TipoCorrelativo, $Serie );

                    $iId = $this->add();

                    $s_Id = $s_RefPrefijo.str_repeat( '0', strlen( $this->o_CorrelativoMast->getCorrelativoHasta() ) - strlen( $iId ) ).$iId;
            }
            catch ( Exception $o_Error )
            {
                    throw new Exception( $o_Error->getMessage() );
            }
            return $s_Id;
    }

    public function generateIntId()
    {
        try
        {
            $IdCompania      = $this->getIdCompania();
            $TipoCorrelativo = $this->getTipoCorrelativo();
            $Serie           = $this->getSerie();
            
            $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
            $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk( $IdCompania, $TipoCorrelativo, $Serie );
            if( $o_GSS_CorrelativoMastBN )
            {
                $this->o_CorrelativoMast = $o_GSS_CorrelativoMastBN;
                $i_Id = $this->add();
            }
            else
            {
                throw new Exception( 'No esta registrada en el correlativo de Ids.' );
            }
        }
        catch ( Exception $o_Error )
        {
            throw new Exception( $o_Error->getMessage() );
        }
        return $i_Id;
    }
    
    public function generateIdByExt()
    {
        try
        {
            $IdCompania      = $this->getIdCompania();
            $TipoCorrelativo = $this->getTipoCorrelativo();
            $Serie           = $this->getSerie();
            
            $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
            $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk( $IdCompania, $TipoCorrelativo, $Serie );
            if( $o_GSS_CorrelativoMastBN )
            {
                $this->o_CorrelativoMast = $o_GSS_CorrelativoMastBN;
                $i_Id = $this->add();
            }
            else
            {
                throw new Exception( 'No esta registrada en el correlativo de Ids.' );
            }
        }
        catch ( Exception $o_Error )
        {
            throw new Exception( $o_Error->getMessage() );
        }
        return $i_Id;
    }
    
    private function add()
    {
        $o_Resource = Conexion::getConexion();
        try 
        {
            $c_SQLQry = "UPDATE GSS_CorrelativoMast
                SET CorrelativoNumero=LAST_INSERT_ID( CorrelativoNumero+1 ),
                FechaModificacion=now()
                WHERE IdCompania='".$this->o_CorrelativoMast->getIdCompania()."' AND IdTipocomprobante='".$this->o_CorrelativoMast->getIdTipocomprobante()."' AND IdSerie='".$this->o_CorrelativoMast->getIdSerie()."' ;";
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $c_SQLQry );

            $c_SQLQry = "SELECT LAST_INSERT_ID() AS nId;";
            $statement = $o_Resource->prepareStatement( $c_SQLQry );
            $resultset = $statement->executeQuery();
            $resultset->next();
            $o_RsId = $resultset->getRow(); //devuele array
            
            //$o_Rs = mysql_query( $c_SQLQry, $o_Resource );
            //$o_RsId = mysql_fetch_object( $o_Rs );

            $i_Id = ( int ) $o_RsId['nId'];

            if( $i_Id > $this->o_CorrelativoMast->getCorrelativoHasta() )
            {
                throw new Exception( 'Desbordamiento numerico, se ha llegado al final del correlativo de la tabla.' );
            }
        }
        catch ( Exception $o_Exception )
        {
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return $i_Id;
    }
}