<?php
class UtilDate
{
    public static function diferenciaEntreFecha( $s_Fecha1, $s_Fecha2 )
    {

        $date1 = new DateTime( substr( $s_Fecha1, 0, 10 ) );
        $date2 = new DateTime( substr( $s_Fecha2, 0, 10 ) );
        $diff = $date1->diff( $date2 );
        // will output 2 days
        return $diff->days;
    }

    public static function getFormatDate( $s_Fecha, $s_Format )
    {
        $o_DateTime = new DateTime( $s_Fecha );
        $s_Return = $o_DateTime->format( $s_Format );
        return $s_Return;
    }
    
    public static function getFormatDateMes( $s_Fecha )
    {
        $o_DateTime = new DateTime( $s_Fecha );
        $s_Return = $o_DateTime->format( "m" );
        $s_MesDes = Constantes::$a_meses[$s_Return];
        return $s_MesDes;
    }
    
    /**
     * Formato a recibir: Y-m-d
     * @param unknown $s_Fecha
     */
    public static function sumarDias( $s_Fecha, $i_Dia )
    {
        $o_DateTime = new DateTime( $s_Fecha );
        $o_DateTime->modify( "+$i_Dia day" );
        return $o_DateTime->format( "Y-m-d" );
    }

    /**
     * Formato a recibir: Y-m-d
     * @param unknown $s_Fecha
     */
    public static function restarDias( $s_Fecha, $i_Dia )
    {
        $o_DateTime = new DateTime( $s_Fecha );
        $o_DateTime->modify( "-$i_Dia day" );
        return $o_DateTime->format( "Y-m-d" );
    }
    
    /**
     * Formato a recibir: d/m/y 
     *
     * @param String $s_Date
     * @return String $s_Date
     */
    public static function convertDatexFormatSlash( $s_Date )
    {
        $s_NewDate = "";
        if( $s_Date != "" )
        {
            $a_ArrayDate = explode( "/", $s_Date );
            $s_NewDate = date( "Y-m-d", mktime( 0,0,0, $a_ArrayDate[1], $a_ArrayDate[0], $a_ArrayDate[2] ) );
        }
        return $s_NewDate;
    }
    
    /**
     * Formato a recibir: d-m-y 
     *
     * @param String $s_Date
     * @return String $s_Date
     */
    public static function convertDatexFormatMenos( $s_Date )
    {
        $s_NewDate = "";
        if( $s_Date != "" )
        {
            $a_ArrayDate = explode( "-", $s_Date );
            $s_NewDate = date( "Y-m-d", mktime( 0,0,0, $a_ArrayDate[1], $a_ArrayDate[0], $a_ArrayDate[2] ) );
        }
        return $s_NewDate;
    }
    
    /**
     * Obtener la marca de tiempo Unix de una fecha
     *
     * @param unknown_type $s_Date
     * @return UnixTime
     */
    public static function convertDateTimeUnix( $s_Date )
    {
        $a_ArrayDate = explode( "/", $s_Date );
        $v_UnixTime = mktime( 0,0,0, $a_ArrayDate[1], $a_ArrayDate[2], $a_ArrayDate[0] );
        return $v_UnixTime;
    }
    
    public function convertDateSlash( $s_Date )
    {
        $s_NewDate = "";
        if( $s_Date != "" )
        {
            $a_ArrayDate = explode( "-", $s_Date );
            $s_NewDate = date( "d/m/Y", mktime( 0,0,0, $a_ArrayDate[1], $a_ArrayDate[2], $a_ArrayDate[0] ) );
        }
        return $s_NewDate;
    }
    
    public function convertDateMenos( $s_Date )
    {
        $s_NewDate = "";
        if( $s_Date != "" )
        {
            $a_ArrayDate = explode( "-", $s_Date );
            $s_NewDate = date( "d-m-Y", mktime( 0,0,0, $a_ArrayDate[1], $a_ArrayDate[2], $a_ArrayDate[0] ) );
        }
        return $s_NewDate;
    }
    
    public static function recuperarFechaMysql( $s_Date )
    {
        $s_Fecha = $s_Date;
        if( strpos( $s_Date, "/" ) !== false )
        {
            $s_Fecha = UtilDate::convertDatexFormatSlash( $s_Date );
        }
        if( strpos( $s_Date, "-" ) !== false )
        {
            $s_Fecha = UtilDate::convertDatexFormatMenos( $s_Date );
        }
        return $s_Fecha;
    }
    
    public static function getFechaFinMes( $elAnio, $elMes ) 
    {
        $s_Dia = date( "d",( mktime( 0, 0, 0, $elMes+1, 1, $elAnio ) -1 ) );
        $s_Fecha = $elAnio."-".$elMes."-".$s_Dia;
        return $s_Fecha;
    }
    
    /**
     * Formato establecido: yyyy-mm-dd
     */
    public static function validar_fecha( $s_Fecha )
    {
        $a_ArrayDate = explode( "-", $s_Fecha );
        if( count( $a_ArrayDate ) > 2 )
        {
            if ( !checkdate( $a_ArrayDate[1], $a_ArrayDate[2], $a_ArrayDate[0] ) )
            {
                return false;
            }
        }
        else 
        {
            return false;
        }
        return true;
    }
    
    public static function validarFecha1Mayor( $s_Fecha1, $s_Fecha2 )
    {
        $d_Fecha1 = strtotime( $s_Fecha1 );
        $d_Fecha2 = strtotime( $s_Fecha2 );
        if( $d_Fecha1 > $d_Fecha2 )
        {
            return true;
        }
        return false;
    }

    static function datetimeDiff( $dt1, $dt2 )
    {
        $t1 = strtotime($dt1);
        $t2 = strtotime($dt2);

        $dtd = new stdClass();
        $dtd->interval   = $t2 - $t1;
        //$dtd->total_sec  = abs($t2-$t1);
        $dtd->total_sec  = ($t2-$t1);
        $dtd->total_min  = floor($dtd->total_sec/60);
        $dtd->total_hour = floor($dtd->total_min/60);
        $dtd->total_day  = floor($dtd->total_hour/24);
        
        $dtd->day  = $dtd->total_day;
        $dtd->hour = $dtd->total_hour -($dtd->total_day*24);
        $dtd->min  = $dtd->total_min -($dtd->total_hour*60);
        $dtd->sec  = $dtd->total_sec -($dtd->total_min*60);
        return $dtd;
    }

    public static function sumar_hora( $i_Hora, $s_Fecha = null )
    {
        if( is_null( $s_Fecha ) )
        {
            $s_Fecha = date( "Y-m-d H:i:s" );
        }
        $date         = date( $s_Fecha ); 
        $newDate      = strtotime ( "+$i_Hora hour" , strtotime ( $date ) );
        $s_FechaFinal = date ( 'Y-m-j H:i:s' , $newDate ); 
        return $s_FechaFinal;
    }

    public static function sumar_minuto( $i_Minuto, $s_Fecha = null )
    {
        if( is_null( $s_Fecha ) )
        {
            $s_Fecha = date( "Y-m-d H:i:s" );
        }
        $date         = date( $s_Fecha ); 
        $newDate      = strtotime ( "+$i_Minuto minute" , strtotime ( $date ) );
        $s_FechaFinal = date ( 'Y-m-d H:i:s' , $newDate ); 
        return $s_FechaFinal;
    }
    
    public static function obtenerOrdenFechaVenc( $hr_a_sum = 4 )
    {
        //$date = new DateTime( $s_OrdenFecha );
        //$date->modify( '+4 hours' );
        //$date->modify('+10 minute');
        //$date->modify('-30 second');
        
        for ($i = 0; $i <= 4; $i++)
        {
            $horario[$i]['ini'] = 9;
            $horario[$i]['fin'] = 19;
        }
        
        $horario[5]['ini']  = 9;
        $horario[5]['fin']  = 14;
        
        $expHrs    = $hr_a_sum;
        
        $diaSem    = date("w");
        
        if( $diaSem == 6 )
        {
            $diaSem = 1;
        }
        
        $timeLimit = mktime($horario[$diaSem]['fin'],date("i"),date("s"),date("m"),date("d"),date("Y"));
        $timeNow   = mktime(date("H"),date("i"),date("s"),date("m"),date("d"),date("Y"));
        $currentHour  = date("H");
        
        if ($timeLimit > $timeNow)
        {
            if ((($timeLimit - $timeNow)/3600) < 4)
            {
                $timeDiffNextDay = $expHrs - (($timeLimit - $timeNow)/3600);
                if ($diaSem == 5)
                {
                    $diaSemx = $diaSem+2;
                    if ($diaSemx < 6)
                    {
                        $expHrsx = $horario[$diaSemx]['ini'];
                    }
                    else
                    {
                        $expHrsx = 0;
                    }
                    $expDate = date("Y-m-d H:i:s",mktime ($expHrsx + $timeDiffNextDay,date("i"),date("s"),date("m"),date("d")+1,date("Y")));
                }
                else
                {
                    $diaSemx = $diaSem+1;
                    if ($diaSemx < 6)
                    {
                        $expHrsx = $horario[$diaSemx]['ini'];
                    }
                    else
                    {
                        $expHrsx = 0;
                    }
                    $expDate = date("Y-m-d H:i:s",mktime ($expHrsx + $timeDiffNextDay,date("i"),date("s"),date("m"),date("d")+1,date("Y")));
                }
            }
            else
            {
                if ($currentHour < $horario[$diaSem]['ini'])
                {
                    $expDate = date("Y-m-d H:i:s",mktime ($horario[$diaSem]['ini'] + $expHrs,date("i"),date("s"),date("m"),date("d"),date("Y")));
                }
                else
                {
                    $expDate = date("Y-m-d H:i:s",mktime ($currentHour + $expHrs,date("i"),date("s"),date("m"),date("d"),date("Y")));
                }
            }
        }
        else
        {
            $diaSemx = $diaSem+1;
            if ($diaSemx < 6)
            {
                $expHrsx = $horario[$diaSemx]['ini'];
            }
            else
            {
                $expHrsx = 0;
            }
            $expDate = date("Y-m-d H:i:s",mktime ($expHrsx + $expHrs,date("i"),date("s"),date("m"),date("d")+1,date("Y")));
        }
        
        return $expDate;
    }
}