<?php
class Conexion
{
    private static $connectionMap = array();

    /**
    Link:
    https://www.google.com/search?ei=XoMKXrPyB9So5OUPkKSt4A0&q=propel+registerDriver&oq=propel+registerDriver&gs_l=psy-ab.3..0l10.4186927.4187900..4188027...0.1..0.193.1260.0j7......0....1j2..gws-wiz.......0i71j0i131j0i67j0i10.b37tOQsvFVs&ved=0ahUKEwizmYzYvt7mAhVUFLkGHRBSC9wQ4dUDCAs&uact=5
    
    https://github.com/halfer/propel-criteria-builder/blob/master/lib/symfony/vendor/creole/Creole.php
    https://github.com/halfer/propel-criteria-builder/blob/master/lib/symfony/vendor/propel/Propel.php
    https://hotexamples.com/examples/-/Creole/-/php-creole-class-examples.html

    https://github.com/halfer/propel-criteria-builder/blob/master/lib/symfony/vendor/creole/drivers/mysqli/MySQLiConnection.php
    */

    public static function getConexion2( $dsnName = 'default' )
    {
        $name = $dsnName;
        $o_MySQLConnection = isset( self::$connectionMap [$name] ) ? self::$connectionMap [$name] : null;
        if( $o_MySQLConnection === null )
        {
            
            $dsnInfo = isset( Constantes::$dsn [$name] ) ? Constantes::$dsn [$name] : null;
            // $dsn = isset(self::$configuration['datasources'][$name]['connection']) ? self::$configuration['datasources'][$name]['connection'] : null;
            if( $dsnInfo === null )
            {
                throw new SQLException( "No connection params set for " . $name );
            }
            /*
             * include_once 'creole/Creole.php';
             *
             * // if specified, use custom driver
             * if (isset(self::$configuration['datasources'][$name]['driver'])) {
             * Creole::registerDriver($dsn['phptype'], self::$configuration['datasources'][$name]['driver']);
             * }
             */
            try
            {
                // $con = Creole::getConnection($dsn);
                $o_MySQLConnection = new MySQLConnection();
                $o_MySQLConnection->connect( $dsnInfo );
            }
            catch( SQLException $e )
            {
                throw new Exception( $e );
            }
            self::$connectionMap [$name] = $o_MySQLConnection;
        }
        return $o_MySQLConnection;
    }

    public static function getConexion( $dsnName = 'default' )
    {
        try 
        {
            $dsninfo = isset( Constantes::$dsn[$dsnName] ) ? Constantes::$dsn[$dsnName] : null;

            if( $dsninfo === null )
            {
                throw new SQLException( "No se encontro parametros de conexion para el alias " . $dsnName );
            }

            $con = Creole::getConnection( $dsninfo );

            return $con;
        }
        catch ( SQLException $e ) 
        {
            throw new Exception( $e->getMessage() );
        }
    }

}
