<?php
class ActualizarDatosEmpleadoAction extends wtActions
{
    public function execute()
    {
        $content = trim( file_get_contents( "php://input" ) );
        $decoded = json_decode( $content, true );
        //pr( $decoded );
        $_POST   = $decoded;
        $j_datos = $_POST;
        $a_datos = $j_datos['datos'];

        $a_Result = array();

        try 
        {
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //validaciones
            if( !is_array( $a_datos ) )
            {
                throw new Exception( "El requerimiento no es funcional." );
            }

            if( !isset( $a_datos['metodo'] ) )
            {
                throw new Exception( "El requerimiento no tiene los parametros establecidos." );
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
            $o_MST_PersonaEmpleadoFN->addCondition( MST_PersonaEmpleadoFN::FlagEstadoAsistencia, "NOT IN", "('X')", false );
            $a_MST_PersonaEmpleado = $o_MST_PersonaEmpleadoFN->select();

            $a_empleados = array();
            foreach ( $a_MST_PersonaEmpleado as $o_MST_PersonaEmpleadoBN ) 
            {
                //pr( $o_MST_PersonaEmpleadoBN->toArray() );
                $i = $o_MST_PersonaEmpleadoBN->getIdPersona();
                $a_empleados[$i]['dni']              = $o_MST_PersonaEmpleadoBN->getNumeroDocumento();
                $a_empleados[$i]['nombres']          = $o_MST_PersonaEmpleadoBN->getEmpleadoNombres();
                $a_empleados[$i]['apellido_paterno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoPaterno() );
                $a_empleados[$i]['apellido_materno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoMaterno() );
                $a_empleados[$i]['estado']           = $o_MST_PersonaEmpleadoBN->getFlagEstadoAsistencia();
                $a_empleados[$i]['idsede']           = $o_MST_PersonaEmpleadoBN->getIdSede();
            }

            $a_Result['estado']    = 1;
            $a_Result['mensaje']   = "Exito";
            $a_Result["empleados"] = $a_empleados;
        } 
        catch ( Exception $e ) 
        {
            $a_Result['estado']    = 0;
            $a_Result['mensaje']   = $e->getMessage();
        }

        echo html_entity_decode( json_encode( $a_Result, JSON_FORCE_OBJECT ) );

        return ViewResponse::NONE;
    }
}