<?php
class RequestUbicacionAction extends wtActions 
{
    public function execute()
    {
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $a_Result   = array( "Result" => false, "error" => false );
        $b_Control  = true;

        try
        {
            switch ( $this->s_TipoProc )
            {
                case "getClienteInfoPoDocNum":
                    $con = Conexion::getConexion();
                    $con->begin();
                    try
                    {
                        $s_TipoDocuCliente = $this->getRequestParameter( 'TipoDocuCliente' );
                        $s_NumDocuCliente  = $this->getRequestParameter( 'NumDocuCliente' );

                        $o_iPersona = new iPersona();
                        $o_iPersona->setTipoDocumentoCliente( $s_TipoDocuCliente );
                        $o_iPersona->setNumeroDocumentoCliente( $s_NumDocuCliente );
                        $a_Result = $o_iPersona->ConsultaDocumentoporServicioWeb();
                        //pr( $a_Result ); exit;

                        $s_Nombres          = $a_Result['Nombres'];
                        $s_ApellidoPaterno  = $a_Result['ApellidoPaterno'];
                        $s_ApellidoMaterno  = $a_Result['ApellidoMaterno'];
                        $s_NombreCompleto   = $a_Result['NombreCompleto'];
                        $s_NombreComercial  = $a_Result['NombreComercial'];
                        $s_FechaActividad   = $a_Result['FechaActividad'];
                        $s_DireccionFiscal  = $a_Result['DireccionFiscal'];
                        $s_NivelInstruccion = $a_Result['NivelInstruccion'];
                        $s_EstadoCivil      = $a_Result['EstadoCivil'];
                        $s_TipoBrevete      = $a_Result['TipoBrevete'];
                        $s_TipoPersona      = $a_Result['TipoPersona'];
                        
                        

                        //NUEVA VALIDACION PARA SERMAQUI, VENDEDOR TIENE CLIENTES ASIGNADOS - 2021-09-30
                        /*if( $a_Result['ExisteCliente'] )
                        {
                            $o_MST_ClienteMastFN = new MST_ClienteMastFN();
                            $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $a_Result['IdPersona'] );
                            if( $o_MST_ClienteMastBN->getVendedorCod() != myUser::getUser()->getUserId() )
                            {
                                echo json_encode( array( "error" => false ) );
                                exit;
                            }
                        }*/

                        if( !$a_Result['ExisteCliente'] )
                        {
                            $PaisId          =  "9589";
                            $Nacionalidad    = "1";

                            if( $s_TipoPersona == "N" )
                            {
                                $s_NombreCompleto = $s_Nombres." ".$s_ApellidoPaterno." ".$s_ApellidoMaterno;
                            }

                            $o_MST_PaisFN = new MST_PaisFN();
                            $o_MST_PaisBN = $o_MST_PaisFN->selectByPK( $PaisId );

                            //ahora se registra el cliente
                            $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                            $o_MST_PersonaMastDP->setTipoPersona( $s_TipoPersona );
                            $o_MST_PersonaMastDP->setTipoDocumento( $s_TipoDocuCliente );
                            $o_MST_PersonaMastDP->setNombres( $s_Nombres );
                            $o_MST_PersonaMastDP->setApellidoPaterno( $s_ApellidoPaterno );
                            $o_MST_PersonaMastDP->setApellidoMaterno( $s_ApellidoMaterno );
                            $o_MST_PersonaMastDP->setNombreCompleto( $s_NombreCompleto );
                            $o_MST_PersonaMastDP->setNombreComercial( $s_NombreComercial );
                            $o_MST_PersonaMastDP->setDocumento( $s_NumDocuCliente );
                            $o_MST_PersonaMastDP->setFechaNacimiento( $s_FechaActividad );
                            $o_MST_PersonaMastDP->setSexo( " " );
                            $o_MST_PersonaMastDP->setNacionalidad( "1" );
                            $o_MST_PersonaMastDP->setEstadoCivil( $s_EstadoCivil );
                            $o_MST_PersonaMastDP->setNivelInstruccion( $s_NivelInstruccion );
                            $o_MST_PersonaMastDP->setTipoBrevete( $s_TipoBrevete );
                            $o_MST_PersonaMastDP->setEsCliente( "SI" );
                            $o_MST_PersonaMastDP->setEsProveedor( "NO" );
                            $o_MST_PersonaMastDP->setEsEmpleado( "NO" );
                            $o_MST_PersonaMastDP->setEsOtro( "NO" );
                            $o_MST_PersonaMastDP->setDireccion( $s_DireccionFiscal );
                            $o_MST_PersonaMastDP->setEstado( "A" );

                            $o_MST_PersonaMastDP->setPaisId( $o_MST_PaisBN->getId() );
                            $o_MST_PersonaMastDP->setPaisDesc( $o_MST_PaisBN->getNombre() );
                            $o_MST_PersonaMastDP->setNacionalidad( $Nacionalidad );
    
                            $i_Id = MST_PersonaMastFN::recuperarId();
                            $o_MST_PersonaMastDP->setIdPersona( ( int ) $i_Id );
                            $o_MST_PersonaMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                            $o_MST_PersonaMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_MST_PersonaMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            //pr( $o_MST_PersonaMastDP );
                            $b_Result = $o_MST_PersonaMastDP->save();
    
                            //se recuperar el Vendedor
                            $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarPersonaPorIdUsuario( myUser::getUser()->getUserId() );
                            if( is_array( $o_MST_PersonaMastBN ) )
                            {
                                throw new Exception( "8: El Usuario Vendedor tiene multiple Registro con el ID de Usuario [{myUser::getUser()->getUserId()}] Por favor Revisar." );
                            }
    
                            $DivisionId    = "1";
                            $NivelPrecioId = "1";
                            $cboVendedorId = $o_MST_PersonaMastBN->getIdPersona();
                            $CreditoHold   = "NO";
    
                            $o_MST_ClienteMastFN = new MST_ClienteMastFN();
                            $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $i_Id );
                            if( $o_MST_ClienteMastBN )
                            {
                                //pr( "upd" );
                                //SE ACTUALIZA
                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                $o_MST_ClienteMastDP->setCodCanal( $DivisionId );
                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                $o_MST_ClienteMastDP->setVendedorCod( myUser::getUser()->getUserId() );
                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId());
                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ));
                                $b_Result = $o_MST_ClienteMastDP->update();
                            }
                            else 
                            {
                                //pr( "ins" );
                                //SE INGRESA NUEVO REGISTRO
                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                $o_MST_ClienteMastDP->setCodCanal( $DivisionId );
                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                $o_MST_ClienteMastDP->setVendedorCod( myUser::getUser()->getUserId() );
                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                $o_MST_ClienteMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_MST_ClienteMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $b_Result = $o_MST_ClienteMastDP->save();
                            }
                            
                            $a_Result['IdPersona'] = $i_Id;
                        }
                        
                        $con->commit();
                    }
                    catch( Exception $o_Exception )
                    {
                        $con->rollback();
                        $a_Result                  = array();
                        $a_Result['error']         = true;
                        $a_Result['mensaje_error'] = $o_Exception->getMessage();
                    }
                break;
                case "recuperarTotales":
                    $b_Control  = false;

                    $o_FCO_AplicacionFN = new FCO_AplicacionFN();
                    //$o_FCO_AplicacionFN->setIdCaja( $s_IdCaja );
                    $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::Estado, 'IN', "( 'AP','AN')", false );
                    $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdCierre, 'IS', "NULL", false );
                    $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::TipoPagoNombre );
                    $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::IdMoneda );
                    $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::FechaAplicacion );
                    $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
                    $this->a_ResumnenCaja = array();
                    foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
                    {
                        $i_IdTipoPago = $o_FCO_AplicacionBN->getIdTipoPago();
                        $s_IdMoneda   = $o_FCO_AplicacionBN->getIdMoneda();
                        $s_Estado     = $o_FCO_AplicacionBN->getEstado();

                        if( !isset( $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda] ) )
                        {
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['MontoAplicado'] = 0;
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['CantTrx'] = 0;
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['CantTrxAnu'] = 0;
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['MontoAplicadoAnu'] = 0;
                        }

                        if( $s_Estado != "AN" )
                        {
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['MontoAplicado']  += $o_FCO_AplicacionBN->getMontoAplicado();
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['MonedaDes']      = $o_FCO_AplicacionBN->getMonedaDes();
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['TipoPagoNombre'] = $o_FCO_AplicacionBN->getTipoPagoNombre();
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['CantTrx']++;
                        }

                        if( $s_Estado == "AN" )
                        {
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['CantTrxAnu']++;
                            $this->a_ResumnenCaja[$i_IdTipoPago."_".$s_IdMoneda]['MontoAplicadoAnu']  += $o_FCO_AplicacionBN->getMontoAplicado();
                        }
                    }
                    //pr( $this->a_ResumnenCaja );
                    ViewResponse::getInstance()->setMethodAjax();
                break;
                case "buscarPrecio":
                    $s_IdItem = $this->getRequestParameter( 'id_item' );

                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem );
                    $a_Result['PrecioConIGV'] = $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();

                    //ahora buscamos la hora
                    $o_MST_ItemUbicacionFN = new MST_ItemUbicacionFN();
                    $o_MST_ItemUbicacionBN = $o_MST_ItemUbicacionFN->selectByPK( $s_IdItem );

                    if( !$o_MST_ItemUbicacionBN )
                    {
                        throw new Exception( "El Item no tiene asignacion de Ubicacion." );
                    }

                    $a_Result['HoraUbicacion'] = $o_MST_ItemUbicacionBN->getHoraHabitacion();

                break;
                case "getClienteInfo":
                    $i_IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );
                    $i_IdPersona       = $this->getRequestParameter( 'ClienteNumero' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

                    $s_NombreCompleto = $o_MST_PersonaMastBN->getNombreConcatenado();
                    $s_TipoDocumento  = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_Documento      = $o_MST_PersonaMastBN->getDocumento();

                    if( $o_MST_PersonaMastBN->getTipoDocumento() == "RUC" )
                    {
                        $s_NombreCompleto = $o_MST_PersonaMastBN->getNombreCompleto();
                    }
                    else 
                    {
                        $s_NombreCompleto = $o_MST_PersonaMastBN->getNombreConcatenado();
                    }

                    if( $this->getRequestParameter( 'IdTipoDocumento' ) )
                    {
                        if( $i_IdTipoDocumento == "FC" )
                        {
                            if( $o_MST_PersonaMastBN->getTipoPersona() == "N" && $o_MST_PersonaMastBN->getTipoDocumento() == "DNI" )
                            {
                                throw new Exception( "El Cliente esta como Persona Natural con DNI." );
                            }

                            $s_NombreCompleto = $o_MST_PersonaMastBN->getNombreCompleto();
                        }

                        if( $i_IdTipoDocumento == "BV" )
                        {
                            if( $o_MST_PersonaMastBN->getTipoPersona() == "N" && $o_MST_PersonaMastBN->getTipoDocumento() == "RUC" )
                            {
                                if( !$o_MST_PersonaMastBN->getDocumentoIdentidad() )
                                {
                                    throw new Exception( "El Cliente esta como Persona Natural con RUC, pero no se encuentra el Documento de Identidad." );
                                }

                                $s_TipoDocumento  = "DNI";
                                $s_Documento      = $o_MST_PersonaMastBN->getDocumentoIdentidad();
                            }
                        }
                    }

                    $a_Result['Nombre']            = $s_NombreCompleto;
                    $a_Result['TipoDocumento']     = $s_TipoDocumento;
                    $a_Result['Documento']         = $s_Documento;
                    $a_Result['DepartamentoDesc']  = $o_MST_PersonaMastBN->getDepartamentoDesc();
                    $a_Result['ProvinciaDesc']     = $o_MST_PersonaMastBN->getProvinciaDesc();
                    $a_Result['DistritoDesc']      = $o_MST_PersonaMastBN->getDistritoDesc();
                    $a_Result['IdUbigeo']          = $o_MST_PersonaMastBN->getDistrito();
                    $a_Result['Direccion']         = $o_MST_PersonaMastBN->getDireccion();
                    $a_Result['CanalCliente']      = $o_MST_PersonaMastBN->getCanalCliente();
                    $a_Result['IdVendedor']        = $o_MST_PersonaMastBN->getObjectCliente()->getVendedor();
                    $a_Result['CodVendedor']       = $o_MST_PersonaMastBN->getVendedorAsignado();
                break;
                case "Autocomplete":
                    $s_Termino = $this->getRequestParameter( 'term' );
                    $s_Metodo  = $this->getRequestParameter( 'metodo' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );

                    if( $this->getRequestParameter( 'metodo' ) )
                    {
                        $o_MST_PersonaMastFN->$s_Metodo( "SI" );
                    }
                    else
                    {
                        $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    }

                    //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->selectAutocompletePersonalizado( $s_Termino );
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_Result[] = array
                        (
                            "value"     => $o_MST_PersonaMastBN->getNombreCompletoLLeno(), 
                            "label"     => $o_MST_PersonaMastBN->getTipoDocumento()." - ".$o_MST_PersonaMastBN->getDocumento()." - ".$o_MST_PersonaMastBN->getNombreCompletoLLeno(), 
                            "id"        => $o_MST_PersonaMastBN->getIdPersona(),
                            "tipo_doc"  => $o_MST_PersonaMastBN->getTipoDocumento(),
                            "num_doc"   => $o_MST_PersonaMastBN->getDocumento()
                        );
                    }

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $o_MST_PersonaMastFN->setDocumentoIdentidad( 1 );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->selectAutocompletePersonalizado( $s_Termino );
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_Result[] = array
                        (
                            "value"     => $o_MST_PersonaMastBN->getNombreCompletoLLeno(), 
                            "label"     => "DNI - ".$o_MST_PersonaMastBN->getDocumentoIdentidad()." - ".$o_MST_PersonaMastBN->getNombreCompletoLLeno(), 
                            "id"        => $o_MST_PersonaMastBN->getIdPersona(),
                            "tipo_doc"  => "DNI",
                            "num_doc"   => $o_MST_PersonaMastBN->getDocumentoIdentidad()
                        );
                    }

                break;
                case "AutocompleteDoc":
                    $s_Termino = $this->getRequestParameter( 'term' );
                    $s_TipoDoc = $this->getRequestParameter( 'tipo_doc' );
                    $s_Metodo  = $this->getRequestParameter( 'metodo' );
                    
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );

                    if( $this->getRequestParameter( 'metodo' ) )
                    {
                        $o_MST_PersonaMastFN->$s_Metodo( "SI" );
                    }
                    else
                    {
                        $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    }

                    //$o_MST_PersonaMastFN->setTipoDocumento( $s_TipoDoc );
                    //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->selectAutocompletePorDocu( $s_Termino );
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_Result[] = array( "value" => $o_MST_PersonaMastBN->getDocumento(), "label" => $o_MST_PersonaMastBN->getDocumento()." - ".$o_MST_PersonaMastBN->getNombreCompletoLLeno(), "id" => $o_MST_PersonaMastBN->getIdPersona() );
                    }

                    $a_Result2 = array();
                    if( $s_TipoDoc != "RUC" )
                    {
                        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                        $o_MST_PersonaMastFN->setEstado( "A" );
                        $o_MST_PersonaMastFN->setEsCliente( "SI" );
                        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                        $a_MST_PersonaMast = $o_MST_PersonaMastFN->selectAutocompletePorDocumentoIdentidad( $s_Termino );
                        foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                        {
                            $a_Result2[] = array( "value" => $o_MST_PersonaMastBN->getDocumentoIdentidad(), "label" => $o_MST_PersonaMastBN->getDocumentoIdentidad()." - ".$o_MST_PersonaMastBN->getNombreCompletoLLeno(), "id" => $o_MST_PersonaMastBN->getIdPersona() );
                        }
                    }

                    $a_Result = array_merge( $a_Result, $a_Result2 );
                break;
                case "nuevo_comprobante":
                    $a_Result = $this->guardarNuevoComprobante();
                break;

                case "cerrar_ubicacion":

                    $s_IdUbicacion         = $this->getRequestParameter( 'idubicacion' );
                    $s_IdUbicacionClienteH = $this->getRequestParameter( 'idubicaclienteh' );
                    
                    $s_IdEstado            = $this->getRequestParameter( 'id_estado' );
                    $s_EstadoDesc          = MST_EstadosHabitacionMastFN::buscarDestalleEstado( $s_IdEstado );

                    //aqui se hace una validacion extra
                    //todos los comprobantes deberia de estar emitidos o anulados
                    $o_SRV_UbicacionClienteDetFN = new SRV_UbicacionClienteDetFN();
                    $o_SRV_UbicacionClienteDetFN->setIdUbicacion( $s_IdUbicacion );
                    $a_SRV_UbicacionClienteDet = $o_SRV_UbicacionClienteDetFN->select();
                    foreach ( $a_SRV_UbicacionClienteDet as $o_SRV_UbicacionClienteDetBN ) 
                    {
                        if( $o_SRV_UbicacionClienteDetBN->getEstado() == VTA_DocumentoBN::ESTADO_PREPARACION )
                        {
                            throw new Exception( "Actualmente tiene Transacciones en Estado PENDIENTE." );
                        }
                    }

                    $o_SRV_UbicacionClienteHDP = new SRV_UbicacionClienteHDP();
                    $o_SRV_UbicacionClienteHDP->setIdUbicacionClienteH( ( int ) $s_IdUbicacionClienteH );
                    $o_SRV_UbicacionClienteHDP->setEstado( SRV_UbicacionClienteHBN::ESTADO_TERMINADO );
                    $o_SRV_UbicacionClienteHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SRV_UbicacionClienteHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SRV_UbicacionClienteHDP->update();

                    //ahora se cambia el estado la ubicacion
                    $o_SRV_UbicacionEstadoDP = new SRV_UbicacionEstadoDP();
                    $o_SRV_UbicacionEstadoDP->setIdUbicacion( ( int ) $s_IdUbicacion );
                    $o_SRV_UbicacionEstadoDP->delete();

                    $o_SRV_UbicacionEstadoDP->setIdEstados( ( int ) $s_IdEstado );
                    $o_SRV_UbicacionEstadoDP->setEstadoNombre( $s_EstadoDesc );
                    $o_SRV_UbicacionEstadoDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_SRV_UbicacionEstadoDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_SRV_UbicacionEstadoDP->save();

                    //ahora se guarda el log
                    $i_IdLog = SRV_UbicacionEstadoLogDP::recuperarId();
                    $o_SRV_UbicacionEstadoLogDP = new SRV_UbicacionEstadoLogDP();
                    $o_SRV_UbicacionEstadoLogDP->setIdUbicacionEstLog( $i_IdLog );
                    $o_SRV_UbicacionEstadoLogDP->setIdUbicacion( ( int ) $s_IdUbicacion );
                    $o_SRV_UbicacionEstadoLogDP->setIdEstados( ( int ) $s_IdEstado );
                    $o_SRV_UbicacionEstadoLogDP->setEstadoNombre( $s_EstadoDesc );
                    $o_SRV_UbicacionEstadoLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_SRV_UbicacionEstadoLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_SRV_UbicacionEstadoLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SRV_UbicacionEstadoLogDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SRV_UbicacionEstadoLogDP->save();
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////

                break;

                case "cerrar_ubicacion_estado_proceso":
                    $s_IdUbicacion         = $this->getRequestParameter( 'idubicacion' );
                    $s_IdUbicacionClienteH = $this->getRequestParameter( 'idubicaclienteh' );

                    $con = Conexion::getConexion();
                    $con->begin();

                    try 
                    {

                        $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
                        $o_SRV_UbicacionClienteHBN = $o_SRV_UbicacionClienteHFN->selectByPK( $s_IdUbicacionClienteH );
                        if( !$o_SRV_UbicacionClienteHBN )
                        {
                            throw new Exception( "No se encontro la Ubicacion del Cliente." );
                        }

                        //aqui se hace una validacion extra
                        //todos los comprobantes deberia de estar emitidos o anulados
                        $o_SRV_UbicacionClienteDetFN = new SRV_UbicacionClienteDetFN();
                        $o_SRV_UbicacionClienteDetFN->setIdUbicacion( $s_IdUbicacion );
                        $a_SRV_UbicacionClienteDet = $o_SRV_UbicacionClienteDetFN->select();
                        foreach ( $a_SRV_UbicacionClienteDet as $o_SRV_UbicacionClienteDetBN ) 
                        {
                            if( $o_SRV_UbicacionClienteDetBN->getEstado() == VTA_DocumentoBN::ESTADO_PREPARACION )
                            {
                                throw new Exception( "Actualmente tiene Transacciones en Estado PENDIENTE." );
                            }
                        }

                        //ahora se valida si hay minutos extras - 2020-01-27
                        //siempre y cuando la fecha y hora actual es mayor a la salida
                        $s_FechaHoraSalida = UtilDate::sumar_minuto( $o_SRV_UbicacionClienteHBN->getToleranciaUbicacion(), $o_SRV_UbicacionClienteHBN->getFechaHoraSalida() );
                        $s_FechaHoraActual = date( "Y-m-d H:i:s" );
                        $i_MinutosExtras   = 0;
                        if( UtilDate::validarFecha1Mayor( $s_FechaHoraActual, $s_FechaHoraSalida ) )
                        {
                            //si se ingresa aqui, es que se tiene que generar un comprobante con minutos extras
                            //pr( $s_FechaHoraSalida );
                            //pr( $s_FechaHoraActual );
                            $o_stdClass = UtilDate::datetimeDiff( $s_FechaHoraSalida, $s_FechaHoraActual );
                            //pr( $o_stdClass->total_min );
                            //pr( UtilDate::sumar_minuto( $o_SRV_UbicacionClienteHBN->getToleranciaUbicacion(), $o_SRV_UbicacionClienteHBN->getFechaHoraSalida() ) );
                            $i_MinutosExtras = floatval( $o_stdClass->total_min );
                        }

                        //validamos el estado de proceso
                        $s_EstadoProceso = SRV_UbicacionClienteHBN::ESTADO_TERMINADO;
                        if( $o_SRV_UbicacionClienteHBN->getEstadoProceso() == SRV_UbicacionClienteHBN::ESTADO_TERMINADO )
                        {
                            $s_EstadoProceso = SRV_UbicacionClienteHBN::ESTADO_PENDIENTE;
                        }
                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        $f_MontoTotalNeto = 0;
                        if( $i_MinutosExtras )
                        {
                            //se genera comprobante por los minutos extras
                            $s_CodigoMinExtra = "04872";

                            /////////////////////////////////////////////////////////////////////////////////////
                            //una validacion de que no exista el item de minutos extras
                            $o_SRV_UbicacionClienteDetFN = new SRV_UbicacionClienteDetFN();
                            $o_SRV_UbicacionClienteDetFN->setIdUbicacionClienteH( $s_IdUbicacionClienteH );
                            $a_SRV_UbicacionClienteDet = $o_SRV_UbicacionClienteDetFN->select();

                            foreach ( $a_SRV_UbicacionClienteDet as $o_SRV_UbicacionClienteDetBN ) 
                            {
                                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_SRV_UbicacionClienteDetBN->getNumeroDocumento() );
                                $o_VTA_DocumentoDetalleFN->setItemCodigo( $s_CodigoMinExtra );
                                $o_VTA_DocumentoDetalleFN->addCondition( VTA_DocumentoDetalleFN::Estado, "IN", "('P','C')", false );
                                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                                if( $a_VTA_DocumentoDetalle )
                                {
                                    throw new Exception( "Actualmente se encuentra registrado los Minutos Extras." );
                                }
                            }
                            /////////////////////////////////////////////////////////////////////////////////////

                            //ahora buscamos el item por su descripcion
                            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_CodigoMinExtra );
                            $DescripcionCompleta = $o_ALM_ItemMastBN->getDescripcionCompleta();

                            //ahora se busca la ubicacion para concatenar las descripcion
                            $o_MST_UbicacionFN = new MST_UbicacionFN();
                            $o_MST_UbicacionBN = $o_MST_UbicacionFN->selectByPK( $s_IdUbicacion );
                            if( !$o_MST_UbicacionBN )
                            {
                                throw new Exception( "No se encontro la Ubicacion." );
                            }

                            $DescripcionCompleta .= " - ".$o_MST_UbicacionBN->getTipoUbicacionNombre()." ".$o_MST_UbicacionBN->getNombre();
                            //pr( $DescripcionCompleta );

                            //ahora calculamos el precio unitario
                            $f_PrecioTarifa  = $o_SRV_UbicacionClienteHBN->getPrecioTarifa();
                            $i_HoraUbicacion = $o_SRV_UbicacionClienteHBN->getHoraUbicacion();
                            $f_TarifaPorHora = round( $f_PrecioTarifa / $i_HoraUbicacion, 2 );
                            $f_TarifaPorMinu = round( $f_TarifaPorHora / 60, 2 );
                            $s_IdTipoPrecio  = "P";

                            //pr( "$f_TarifaPorHora = round( $f_PrecioTarifa / $i_HoraUbicacion, 2 );" );
                            //pr( "$f_TarifaPorMinu = round( $f_TarifaPorHora / 60, 2 );" );


                            ParameterWR::getInstance()->setVar( "tipo_documento", $o_SRV_UbicacionClienteHBN->getIdTipoDocumento() );
                            $a_Result = $this->guardarNuevoComprobante();
                            $s_ConcatIdComprobante = $a_Result['id_comprobante'];

                            $a_Ids = explode( "_", $s_ConcatIdComprobante );
                            $s_IdTipoDocumento = $a_Ids[0];
                            $s_IdCompania      = $a_Ids[1];
                            $s_NumeroDocumento = $a_Ids[2];

                            $a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
                            if( count( $a_ALM_AlmacenMast ) == 1 )
                            {
                                $s_IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
                            }
                            else
                            {
                                throw new Exception( "Se tiene que seleccionar un Almacen." );
                            }

                            //ahora se registra el detalle por el servicio
                            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                            $o_VTA_DocumentoDetalleBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                            //$o_VTA_DocumentoDetalleBN->setSecuencia( $Secuencia );
                            $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_CodigoMinExtra );
                            $o_VTA_DocumentoDetalleBN->setDescripcion( $DescripcionCompleta );
                            $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $s_IdAlmacen );
                            $o_VTA_DocumentoDetalleBN->setIdCompania( intval( $s_IdCompania ) );

                            /*$o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $s_IdTipoPrecio );
                            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_TarifaPorMinu );
                            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_TarifaPorMinu );
                            $o_VTA_DocumentoDetalleBN->setCambioPrecioFlag( true );*/

                            $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
                            $o_VTA_DocumentoDetalleBN->setCantidadPedida( $i_MinutosExtras );
                            $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $s_NumeroDocumento );
                            $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $s_IdTipoDocumento );
                            
                            //$o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitario );
                            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
                            $o_OrdenVentaDetalleBL->iniciarProceso( $o_VTA_DocumentoDetalleBN );

                            //pr( $o_VTA_DocumentoDetalleBN );

                            $o_VTA_DocumentoDetalleBN2 = new VTA_DocumentoDetalleBN();
                            $o_VTA_DocumentoDetalleBN2->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                            $o_VTA_DocumentoDetalleBN2->setItemCodigo( $s_CodigoMinExtra );
                            $o_VTA_DocumentoDetalleBN2->setIdCompania( ( int ) $s_IdCompania );
                            $o_VTA_DocumentoDetalleBN2->setIdTipoDocumento( $s_IdTipoDocumento );
                            $o_VTA_DocumentoDetalleBN2->setNumeroDocumento( $s_NumeroDocumento );
                            $o_VTA_DocumentoDetalleBN2->setCondicion( 1 );
                            $o_VTA_DocumentoDetalleBN2->setIdUnidad( 58 );
                            $o_VTA_DocumentoDetalleBN2->setIdTipoPrecio( $s_IdTipoPrecio );
                            $o_VTA_DocumentoDetalleBN2->setMontoIncImpuestoUnidad( $f_TarifaPorMinu );
                            $o_VTA_DocumentoDetalleBN2->setMontoIncImpuestoUnidadMN( $f_TarifaPorMinu );

                            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
                            $o_OrdenVentaDetalleBL->iniciarCambioPrecio( $o_VTA_DocumentoDetalleBN2 );

                            //pr( $o_VTA_DocumentoDetalleBN2 );
                            $f_MontoTotalNeto = $o_VTA_DocumentoDetalleBN2->getMontoTotalNeto();
                        }
                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        $o_SRV_UbicacionClienteHDP = new SRV_UbicacionClienteHDP();
                        $o_SRV_UbicacionClienteHDP->setIdUbicacionClienteH( ( int ) $s_IdUbicacionClienteH );
                        $o_SRV_UbicacionClienteHDP->setFechaHoraSalidaReal( $s_FechaHoraActual );
                        $o_SRV_UbicacionClienteHDP->setMinutosExtra( floatval( $i_MinutosExtras ) );
                        $o_SRV_UbicacionClienteHDP->setMinutosExtraMonto( $f_MontoTotalNeto );
                        $o_SRV_UbicacionClienteHDP->setEstadoProceso( $s_EstadoProceso );
                        $o_SRV_UbicacionClienteHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SRV_UbicacionClienteHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SRV_UbicacionClienteHDP->update();

                        $con->commit();
                    }
                    catch ( Exception $o_Exception )
                    {
                        $con->rollback();
                        throw new Exception( $o_Exception->getMessage() );
                    }

                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        if( $b_Control )
        {
            echo json_encode( $a_Result );
            return ViewResponse::NONE;
        }
    }

    public function guardarNuevoComprobante()
    {
        $con = Conexion::getConexion();
        $con->begin();

        try 
        {
            myUser::getUser()->validar_session();

            $s_IdUbicacion         = $this->getRequestParameter( 'idubicacion' );
            $s_IdUbicacionClienteH = $this->getRequestParameter( 'idubicaclienteh' );
            $s_IdTipoDocumento     = $this->getRequestParameter( 'tipo_documento' );

            $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
            $o_SRV_UbicacionClienteHBN = $o_SRV_UbicacionClienteHFN->selectByPK( $s_IdUbicacionClienteH );

            $i_IdUbicacionClienteH = $o_SRV_UbicacionClienteHBN->getIdUbicacionClienteH();

            $s_IdAlmacen  = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $i_IdCompania = myUser::getUser()->getIdBusiness();
            $i_IdSucursal = myUser::getUser()->getIdSucursal();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //$s_FechaEmision  = $o_SRV_UbicacionClienteHBN->getFechaHoraDocumento();
            $s_FechaEmision  = date( "Y-m-d H:i:s" );
            $s_NombreCliente = $o_SRV_UbicacionClienteHBN->getNombreCliente();

            $i_IdCliente       = $o_SRV_UbicacionClienteHBN->getIdCliente();
            $s_TipoDocCliente  = $o_SRV_UbicacionClienteHBN->getTipoDocCliente();
            $s_NumDocuCliente  = $o_SRV_UbicacionClienteHBN->getNumeroDocuCliente();
            //$s_IdTipoDocumento = $o_SRV_UbicacionClienteHBN->getIdTipoDocumento();
            //$s_DocumentoCod    = $o_SRV_UbicacionClienteHBN->getDocumentoCod();
            //$s_DocumentoSerie  = $o_SRV_UbicacionClienteHBN->getDocumentoSerie();
            //$s_DocumentoNumero = $o_SRV_UbicacionClienteHBN->getDocumentoNumero();

            $a_ParamComprobante = iComprobanteVenta::getSerieNumero( $s_IdTipoDocumento );

            $s_IdTipoDocumento = $a_ParamComprobante['IdTipoDocumento'];
            $s_DocumentoCod    = $a_ParamComprobante['TipoDocumentoCod'];
            $s_DocumentoSerie  = $a_ParamComprobante['Serie'];
            $s_DocumentoNumero = $a_ParamComprobante['Numero'];

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //PROCEDIMIENTO PARA CAJA - 2019-11-12
            /*$o_FCO_CajaFN = new FCO_CajaFN();
            $o_FCO_CajaFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_FCO_CajaFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_CajaFN->addCondition( "( SELECT COUNT(*) FROM FCO_CajaUsuario where IdUsuario='".myUser::getUser()->getUserId()."' and IdCaja=FCO_Caja.IdCaja )", ">=", 1 );
            $a_FCO_Caja = $o_FCO_CajaFN->select();
            $this->lst_caja = $a_FCO_Caja;*/
            //ahora validamos si ya esta en uso la caja
            $o_FCO_CajaUsuarioFN = new FCO_CajaUsuarioFN();
            $o_FCO_CajaUsuarioFN->setIdUsuario( myUser::getUser()->getUserId() );
            $o_FCO_CajaUsuarioFN->setEnUsoFlag( 1 );
            $a_FCO_CajaUsuario = $o_FCO_CajaUsuarioFN->select();
            $IdCajaSelect = "";
            if( $a_FCO_CajaUsuario )
            {
                //$this->b_ControlCaja  = false;
                $IdCajaSelect = $a_FCO_CajaUsuario[0]->getIdCaja();
                //$this->DesCajaSelect  = $a_FCO_CajaUsuario[0]->getObjectCaja()->getDescripcion();
            }
            //pr( $a_FCO_CajaUsuario );
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ParameterWR::getInstance()->setVar( "ClienteNumero", ( string ) $i_IdCliente );
            ParameterWR::getInstance()->setVar( "ClienteNombre", $o_SRV_UbicacionClienteHBN->getNombreCliente() );
            ParameterWR::getInstance()->setVar( "sDireccion", $o_SRV_UbicacionClienteHBN->getDireccionCliente() );
            ParameterWR::getInstance()->setVar( "IdTipoDocumento", $s_IdTipoDocumento );
            //ParameterWR::getInstance()->setVar( "IdTipoDocumento", $o_SRV_UbicacionClienteHBN->getIdTipoDocumento() );
            ParameterWR::getInstance()->setVar( "TipoDocumentoCod", $s_DocumentoCod );
            ParameterWR::getInstance()->setVar( "DocumentoSerie", $s_DocumentoSerie );
            ParameterWR::getInstance()->setVar( "DocumentoNumero", $s_DocumentoNumero );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se registra el comprobante cabecera
            ParameterWR::getInstance()->setVar( "IdVendedor", myUser::getUser()->getUserId() );
            ParameterWR::getInstance()->setVar( "TipoVenta", "MER" );
            ParameterWR::getInstance()->setVar( "s_TipoProc", "nvo" );
            ParameterWR::getInstance()->setVar( "MonedaDocumento", "LO" );
            ParameterWR::getInstance()->setVar( "MonedaCambioValor", 1 );
            ParameterWR::getInstance()->setVar( "FechaDocumento", $s_FechaEmision );
            ParameterWR::getInstance()->setVar( "ClienteNombre", $s_NombreCliente );
            ParameterWR::getInstance()->setVar( "ClienteTipoDoc", $s_TipoDocCliente );
            ParameterWR::getInstance()->setVar( "ClienteRUC", $s_NumDocuCliente );

            ParameterWR::getInstance()->setVar( "IdCaja", $IdCajaSelect );

            ob_start();
            $o_proActions = new proActions();
            $o_proActions->executeSaveAddEdit();
            $s_Json = ob_get_contents();
            ob_end_clean();

            $a_Json = json_decode( $s_Json, true );
            //pr( $a_Json );

            $s_ConcatIdComprobante = isset( $a_Json['id'] ) ? $a_Json['id'] : "0";
            $s_Estado              = isset( $a_Json['estado'] ) ? $a_Json['estado'] : "ERROR";
            $b_Error               = $a_Json['error'];

            if( $b_Error )
            {
                throw new Exception( $a_Json['mensaje_error'] );
            }

            $a_Ids = explode( "_", $s_ConcatIdComprobante );
            $s_IdTipoDocumento = $a_Ids[0];
            //$s_IdCompania      = $a_Ids[1];
            $s_NumeroDocumento = $a_Ids[2];

            ParameterWR::getInstance()->destroy();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se procede a realizar la relacion entre ubicacion y el medio de pago
            $o_SRV_UbicacionClienteDetDP = new SRV_UbicacionClienteDetDP();
            $o_SRV_UbicacionClienteDetDP->setIdUbicacionClienteH( $i_IdUbicacionClienteH );
            $o_SRV_UbicacionClienteDetDP->setIdUbicacion( ( int ) $s_IdUbicacion );
            $o_SRV_UbicacionClienteDetDP->setIdTipoDocumento( $s_IdTipoDocumento );
            $o_SRV_UbicacionClienteDetDP->setIdCompania( $i_IdCompania );
            $o_SRV_UbicacionClienteDetDP->setIdSucursal( $i_IdSucursal );
            $o_SRV_UbicacionClienteDetDP->setNumeroDocumento( $s_NumeroDocumento );
            $o_SRV_UbicacionClienteDetDP->setDocumentoCod( $s_DocumentoCod );
            $o_SRV_UbicacionClienteDetDP->setDocumentoSerie( $s_DocumentoSerie );
            $o_SRV_UbicacionClienteDetDP->setDocumentoNumero( $s_DocumentoNumero );
            $o_SRV_UbicacionClienteDetDP->setIdPersona( $i_IdCliente );
            $o_SRV_UbicacionClienteDetDP->setNombreCompleto( $s_NombreCliente );
            $o_SRV_UbicacionClienteDetDP->setEstado( $s_Estado );
            $o_SRV_UbicacionClienteDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteDetDP->save();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /*
            //ahora se registra el detalle por el servicio
            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
            $o_VTA_DocumentoDetalleBN->setIdSucursal( $i_IdSucursal );
            //$o_VTA_DocumentoDetalleBN->setSecuencia( $Secuencia );
            $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_ItemIdTarifa );
            $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $s_IdAlmacen );
            $o_VTA_DocumentoDetalleBN->setIdCompania( $i_IdCompania );
            //$o_VTA_DocumentoDetalleBN->setLote( $IdLote );
            //$o_VTA_DocumentoDetalleBN->setLoteAlias( $IdLote );
            $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
            $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
            $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $s_NumeroDocumento );
            $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $s_IdTipoDocumento );
            
            //$o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitario );
            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
            $o_OrdenVentaDetalleBL->iniciarProceso( $o_VTA_DocumentoDetalleBN );
            */
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se reserva la ubicacion
            /*
            $o_SRV_UbicacionEstadoDP = new SRV_UbicacionEstadoDP();
            $o_SRV_UbicacionEstadoDP->setIdUbicacion( ( int ) $s_IdUbicacion );
            $o_SRV_UbicacionEstadoDP->delete();
            */
            /*
            $o_SRV_UbicacionEstadoDP->setIdEstados( 3 );
            $o_SRV_UbicacionEstadoDP->setEstadoNombre( 'OCUPADO' );
            $o_SRV_UbicacionEstadoDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoDP->save();
            */

            //ahora se guarda el log
            /*
            $i_IdLog = SRV_UbicacionEstadoLogDP::recuperarId();
            $o_SRV_UbicacionEstadoLogDP = new SRV_UbicacionEstadoLogDP();
            $o_SRV_UbicacionEstadoLogDP->setIdUbicacionEstLog( $i_IdLog );
            $o_SRV_UbicacionEstadoLogDP->setIdUbicacion( ( int ) $s_IdUbicacion );
            $o_SRV_UbicacionEstadoLogDP->setIdEstados( 3 );
            $o_SRV_UbicacionEstadoLogDP->setEstadoNombre( 'OCUPADO' );
            $o_SRV_UbicacionEstadoLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionEstadoLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionEstadoLogDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoLogDP->save();
            */
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $con->commit();

            //$a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']          = false;
            $a_Rs['id_comprobante'] = $s_ConcatIdComprobante;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }

        return $a_Rs;
    }
}