<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class ptoActions extends wtActions
{
    public function executeIndex()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeVerSorteoPDF (  )
    {
        $s_Id    = $this->getRequestParameter( 'i_Id' );
        $s_vHtml = $this->getRequestParameter( 'vHtml' );

        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];

        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        (
            "o_GSS_CompaniaBN"       => $o_GSS_CompaniaBN,
            "o_VTA_DocumentoBN"      => $o_VTA_DocumentoBN
        );

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );

        //$dompdf->setPaper( 'A4', 'portrait' );

        //como se trata de ticket, se tiene que hacer una formula para calular el tamaño de la hoja por la cantidad de lineas impresa, la minimas es 15 po una sola linea

        $i_AnchoTicket = 215; //inicalmente
        $f_TotalLargo = 250;
        $customPaper = array( 0, 0, 218, $f_TotalLargo ); //215
        $dompdf->setPaper( $customPaper, 'portrait' );

        $dompdf->render();
        $dompdf->stream( 'Documento_1', array( "Attachment" => 0 ) );

        exit;
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->Titulo = "Lista - Orden de Venta";

        $o_CotizacionesBL = new CotizacionesBL();
        $o_CotizacionesBL->anularOrdenesExpirados();
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        set_header_utf8();

        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );

        $this->Titulo = "Nuevo Cotizaci&oacute;n";

        $this->error_mensaje = "";

        try
        {

            $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
            $o_GSS_UsuarioSucuDocumentoFN->setIdUsuario( myUser::getUser()->getUserId() );
            $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_GSS_UsuarioSucuDocumentoFN->addOrderBy( GSS_UsuarioSucuDocumentoFN::IdTipoDocumento );
            $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();
            $this->a_VTA_TipoDocumento = array();
            foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN ) 
            {
                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
                if( $o_GSS_SucursalDocumentoBN->getIdSucursal() != myUser::getUser()->getIdSucursal() )
                {
                    continue;
                }
                
                //AQUI SE INTERVIENE LA NOTA DE CREDITO:
                if( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() == "NC" )
                {
                    continue;
                }

                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
                if( $o_GSS_SucursalDocumentoBN->getEstado() != "A" )
                {
                    continue;
                }
                
                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() );
                if( $o_VTA_TipoDocumentoBN->getGenerarProvisionFlag() != "S" )
                {
                    continue;
                }
                $this->a_VTA_TipoDocumento[] = $o_VTA_TipoDocumentoBN;
            }

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            //$o_GSS_MonedaMastFN->setIdMoneda( "LO" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();

            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();

            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();

            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc();

            $this->o_VTA_OrdenBN = new VTA_OrdenBN();
            $this->o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $this->o_VTA_OrdenBN->setOrdenTipoId( 2 );
            $this->o_VTA_OrdenBN->setDiasAlquiler( 30 );
            $this->o_VTA_OrdenBN->setCondicionVenta( "CONADE" );

            //moneda por defecto, segun maestro de precios
            $IdCompania = myUser::getUser()->getIdBusiness();
            $IdSucursal = myUser::getUser()->getIdSucursal();

            $s_CodMoneda = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault( $IdCompania, $IdSucursal );

            $this->o_VTA_OrdenBN->setMonedaCod( $s_CodMoneda );
            $this->o_VTA_OrdenBN->setClienteDocCod( "RUC" );

            if( $this->s_TipoProc == "upd" )
            {
                $this->Titulo = "Editar Orden de Venta";

                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_Id );
            }

            //SERMAQUI TRABAJA CON CLIENTES ESPECIFICOS ASOCIADOS A LOS VENDEDORES, POR LO TANTO EL VENDEDOR TIENE Q SER UNICO - 2021-09-30
            $this->s_IdVendedor = myUser::getUser()->getUserId();

            //almacen
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
            //$o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
            $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'id' );
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $IdCompania         = myUser::getUser()->getIdBusiness();

            $o_GSS_CompaniaBN   = GSS_CompaniaFN::buscarCompania( $IdCompania );

            $OrdenTipoId                = 2;
            $ClienteNumero              = $o_GSS_CompaniaBN->getIdClientePorDef();

            $Comentario                 = "";
            $IdAlmacen                  = "";
            $AlmacenDespacho            = "";
            $IdVendedor                 = myUser::getUser()->getUserId();
            $FactRegla                  = "MER";
            $ValidezOrden               = "1";
            $PlazaEntregaOrden          = "1";
            $CondicionVenta             = null;
            $s_OrdenCompraRef           = null;
            $s_OrdenTipoComercialId     = 1;
            $s_OrdenTipoClasificacionId = 1;
            $s_DiasAlquiler             = null;
            $s_CondicionVentaId         = "008";
            $s_FormaPagoDesc            = "CONTADO";

            //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
            $o_MST_ValidezOfFN = new MST_ValidezOfFN();
            $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
            //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );

            $MonedaCod          = "LO";
            $MonedaCambioValor  = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            $IdProyecto         = null;
            $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_GSS_SucursalBN->getIdAlmacen() );

            //$a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( $o_ALM_AlmacenMastBN )
            {
                $IdAlmacen       = $o_ALM_AlmacenMastBN->getIdAlmacen();
                $AlmacenDespacho = $IdAlmacen;
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            if( !$o_MST_PersonaMastBN )
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
            }

            $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
            $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();
            $ClienteDireccion        = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
            $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
            $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();
            $ClienteNombre           = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
            $VendedorAsigna          = $o_MST_PersonaMastBN->getVendedorAsignado();
            $CanalCliente            = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente      = $o_MST_PersonaMastBN->getNivelPrecioCliente();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
            {
                $s_FechaSel = date( "Y-m-d" );

                $o_iVentas = new iVentas();
                $o_iVentas->registrarTipoCambio( $s_FechaSel );
            }

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenObs( $Comentario );
            $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
            $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );

            //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
            if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }

            $o_VTA_OrdenBN->setClienteId( ( int ) $ClienteNumero );
            $o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
            $o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
            $o_VTA_OrdenBN->setClienteNombre( $ClienteNombre );
            //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec1( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
            $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
            $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
            $o_VTA_OrdenBN->setFactPais( "PERU" );
            $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
            $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );

            $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
            $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
            $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
            $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
            $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );

            $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
            $o_VTA_OrdenBN->setIdProyecto( ( int ) $IdProyecto );

            //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
            $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
            $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );

            $o_VTA_OrdenBN->setOrdenTipoId( ( int ) $OrdenTipoId );
            $o_VTA_OrdenBN->setCondicionVentaId( $s_CondicionVentaId );
            $o_VTA_OrdenBN->setFormaPagoDesc( $s_FormaPagoDesc );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $o_VTA_OrdenBN->setOrdenTipoComercialId( intval( $s_OrdenTipoComercialId ) );

                $o_VTA_OrdenBN->setOrdenTipoClasificacionId( intval( $s_OrdenTipoClasificacionId ) );

                $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );

                $s_OrdenFecha = date( "Y-m-d H:i:s" );

                $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );
                $o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                $o_VTA_OrdenBN->setOrdenEstado( VTA_OrdenBN::ESTADO_ABIERTO );
                $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }
            else
            {
                //UPDATE
                $o_VTA_OrdenBN->setOrdenId( ( int ) $i_Id );

                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }

            $i_Id = $o_VTA_OrdenBN->getOrdenId();

            $con->commit();

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeDetailVta()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_OrdNum = $this->getRequestParameter( 'OrdNum' );
        $this->i_Id     = $this->getRequestParameter( 'i_Id' );
        $this->readonly = $this->getRequestParameter( 'readonly' );

        if( $this->getRequestParameter( 'OrdNum' ) )
        {
            $this->o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $this->s_OrdNum );
            $this->i_Id          = $this->o_VTA_OrdenBN->getOrdenId();
        }
        else
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->i_Id );
        }

        $this->s_OrdNum = $this->o_VTA_OrdenBN->getOrdenNum();

        $this->s_Titulo  = "Orden ".$this->s_OrdNum;
        $this->s_Titulo2 = "";

        if( $this->o_VTA_OrdenBN->getDocReferenciaId() )
        {
            $this->s_Titulo2 = $this->o_VTA_OrdenBN->getDocReferenciaNum()." | ".$this->o_VTA_OrdenBN->getCobranzaEstadoDesc();
        }

        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_OrdenBN->getMonedaCod() );

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_OrdenBN->getClienteId() );

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

        $i_IdProyecto = $this->o_VTA_OrdenBN->getIdProyecto();
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $this->o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $i_IdProyecto );

        //FORMA DE PAGO
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "O" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
        $o_FCO_CierreFN = new FCO_CierreFN();
        $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
        $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
        $a_FCO_Cierre = $o_FCO_CierreFN->select();
        $this->b_ControlCaja = false;
        if( count( $a_FCO_Cierre ) == 1 )
        {
            $o_FCO_CierreBN = $a_FCO_Cierre[0];
            $this->b_ControlCaja   = true;
            $this->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
            $this->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
            $this->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
            $this->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Logica para OPCIONES DE USUARIO
		$o_SEG_UsuarioOpcionesFN = new SEG_UsuarioOpcionesFN();
		$this->o_SEG_UsuarioOpcionesBN = $o_SEG_UsuarioOpcionesFN->selectByPK( myUser::getUser()->getUserId() );
    }

    public function executeAutocompleteProductos()
    {
        $s_Termino = $this->getRequestParameter( 'term' );

        $a_Result = array();

        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastFN->setEstado( ALM_ItemMastBN::ESTADO_ACTIVO );
        $a_ALM_ItemMast = $o_ALM_ItemMastFN->selectAutocomplet( $s_Termino );

        $s_UrlImagen = Constantes::ROOT_DIR_IMG;

        if( $a_ALM_ItemMast )
        {
            foreach( $a_ALM_ItemMast as $o_ALM_ItemMastBN )
            {
                $i_StockDisponibleTotal = $o_ALM_ItemMastBN->getStockDisponibleTotal();
                if( $i_StockDisponibleTotal > 0 )
                {
                    $s_ItemImagenUrl = $s_UrlImagen."img_no_disponible.jpg";
                    if ( file_exists( $o_ALM_ItemMastBN->getUbicacionFisica() ) )
                    {
                        if ( $o_ALM_ItemMastBN->getUbicacionURL() )
                        {
                            $s_ItemImagenUrl = $o_ALM_ItemMastBN->getUbicacionURL();
                        }
                    }
                    $a_Result[] = array
                    (
                        "value" => $o_ALM_ItemMastBN->getIdItem(),
                        "label" => '<table width="100%"><tr><td width="25%"><img src="'.$s_ItemImagenUrl.'" width="70" /></td><td width="25%">'.$o_ALM_ItemMastBN->getDescripcionCompleta().'</td><td width="25%">S/ '.number_format( $o_ALM_ItemMastBN->getPrecioConIGV(), 2 ).'</td><td width="25%">'.$o_ALM_ItemMastBN->getStockDisponibleTotal().'</td></tr></table>',
                        "id" => $o_ALM_ItemMastBN->getIdItem() 
                    );
                }
            }
        }

        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
	
	public function executeEditImpresionAutomatica()
    {
		$i_ValueChecked		= (int)$this->getRequestParameter( 'ValueChecked' );
		$a_Rs['error']    = false;
		//echo $i_ValueChecked;
		try
        {
            myUser::getUser()->validar_session();
			$o_SEG_UsuarioOpcionesDP = new SEG_UsuarioOpcionesDP();
			$o_SEG_UsuarioOpcionesDP->setIdUsuario( myUser::getUser()->getUserId() );
			$o_SEG_UsuarioOpcionesDP->setFlagImpresion( $i_ValueChecked );
			$o_SEG_UsuarioOpcionesDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
			$o_SEG_UsuarioOpcionesDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
			$o_SEG_UsuarioOpcionesDP->update();
		}
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
        //ViewResponse::getInstance()->setMethodAjax();
    }

}
