<?php 
/*
Contenido del Codigo QR : 
Número de RUC del emisor electrónico.
Tipo de comprobante de pago electrónico
Numeración conformada por serie y número correlativo.
Sumatoria IGV.
Importe total de la venta.
Fecha de emisión.
Tipo de documento del adquirente o usuario.
Número de documento del adquirente o usuario, de ser el caso.
Código Hash.
Valor de la Firma digital.
 */

function construir_cabecera( &$a_Data )
{
    $o_GSS_CompaniaBN  = $a_Data['o_GSS_CompaniaBN'];
    $o_VTA_DocumentoBN = $a_Data['o_VTA_DocumentoBN'];
    ?>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
            <tr>
                <td style="width: 30%">

                    <div style="">
                        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td style=""><img src="web/images/logo/<?=$o_GSS_CompaniaBN->getRuc()?>.jpg" style="width: <?=$o_GSS_CompaniaBN->getLogoFileAncho()?>px; height: <?=$o_GSS_CompaniaBN->getLogoFileAlto()?>px;" ></td>
                            </tr>
                            
                        </table>
                    </div>
                </td>
                <td style="width: 38%">
                    <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0" >
                        <tr>
                            <td style="font-size: 10px;" align="center">
                                <label><b><?=$o_GSS_CompaniaBN->getDireccionComun()?></b></label>
                            </td>
                        </tr>
                        <tr>
                            <td style="font-size: 10px;" align="center">
                                <label><?=$o_GSS_CompaniaBN->getDireccionAdicional()?></label>
                            </td>
                        </tr>
                    </table>
                </td>
                <td style="width: 30%;">

                    <div style=" vertical-align: top; background-color: #EDEDED; padding: 5px; 
                        border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px;
                        border: 1px solid #B9B5B5;
                        ">
                        <div style="text-align: center;"><label style="font-size: 18px; font-weight: bold;">RUC <?=$o_GSS_CompaniaBN->getRuc()?></label></div>
                        <div style="text-align: center;"><label style="font-size: 18px; font-weight: bold;"><?=strtoupper( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal() )?></label></div>
                        <div style="text-align: center;"> <label style="font-size: 18px; font-weight: bold;"><?=$o_VTA_DocumentoBN->getDocumentoSerieNumero()?></label> </div>
                        <!-- <div>
                            <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                                <tr>
                                    <td style="font-weight: bold; font-size: 10px; width: 40%; text-align: center;">EMISION</td>
                                    <td width="5px;" style="text-align: center;">:</td>
                                    <td style="font-size: 10px; width: 40%; text-align: center;"><?=substr($o_VTA_DocumentoBN->getFechaDocumento(),0,10)?></td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; font-size: 10px; text-align: center;">VENCIMIENTO</td>
                                    <td style="text-align: center;">:</td>
                                    <td style="font-size: 10px; text-align: center;"><?=substr($o_VTA_DocumentoBN->getFechaVencimiento(),0,10)?></td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; font-size: 10px; text-align: center;">MONEDA</td>
                                    <td style="text-align: center;">:</td>
                                    <td style="font-size: 10px; text-align: center;"><?=$o_VTA_DocumentoBN->getMonedaDocumento()=="LO"?"SOLES":"DOLARES"?></td>
                                </tr>
                            </table>
                        </div>-->
                    </div>

                </td>
            </tr>
        </table>

        <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                border: 1px solid #B9B5B5; padding: 5px; ">

            <table style="width: 99%;" border="0" cellpadding="0" cellspacing="0" align="center">
                <tr>
                    <td style="width: 8%; font-weight: bold;" align="left">CLIENTE</td> 
                    <td style="width: 28%;"><?=$o_VTA_DocumentoBN->getClienteNombre() ?></td>
                    <td style="width: 10%; font-weight: bold;" align="left">EMISION</td>
                    <td style="width: 15%;">&nbsp;<?=substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )?></td>
                    <td style="width: 10%; font-weight: bold;" align="left">VENCIMIENTO</td>
                    <td style="width: 10%;">&nbsp;<?=substr( $o_VTA_DocumentoBN->getFechaVencimiento(), 0, 10 )?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;" align="left"><?= $o_VTA_DocumentoBN->getClienteTipoDoc() ?></td>
                    <td><?=$o_VTA_DocumentoBN->getClienteRUC() ?></td>
                    <td style="font-weight: bold;" align="left">VENDEDOR</td>
                    <td><?= $o_VTA_DocumentoBN->getVendedor() ?></td>
                    <td style="font-weight: bold;" align="left">MONEDA</td>
                    <td>&nbsp;<?=$o_VTA_DocumentoBN->getMonedaDocumento()=="LO"?"SOLES":"DOLARES"?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;" align="left">DIRECCION</td>
                    <td colspan="3"><?=$o_VTA_DocumentoBN->getClienteDireccion()?> - <?=$o_VTA_DocumentoBN->getClienteReferencia()?></td>
                    <td style="font-weight: bold;" align="left">COTIZACIÓN</td>
                    <td>&nbsp;<?=$o_VTA_DocumentoBN->getDocumentoParentCod()?></td>
                </tr>
            </table>

        </div>
    <?php
}

function construir_pie( &$a_Data )
{
    $o_VTA_DocumentoBN  = $a_Data['o_VTA_DocumentoBN'];
    $a_CuentasBancarias = $a_Data['a_CuentasBancarias'];

    $s_QR_Image  = $a_Data['s_QR_Image'];
    $s_MedioPago = $a_Data['s_MedioPago'];

    $s_MontoEntero = explode( ".", number_format( $o_VTA_DocumentoBN->getMontoTotal(), 2, ".", "" ) );
                                
    $o_NumberToLetter   = new NumberToLetterConverter();
    $s_MontoTotalLetras = $o_NumberToLetter->to_word( $s_MontoEntero[0] );

    $s_MonedaDocumento  = $o_VTA_DocumentoBN->getMonedaDocumento();
    if( $s_MonedaDocumento == "LO" )
    {
        $s_MontoTotalLetras .= " CON ".$s_MontoEntero[1]." / 100 SOLES";
    }
    else
    {
        $s_MontoTotalLetras .= " CON ".$s_MontoEntero[1]." / 100 DOLARES AMERICANO";
    }
    ?>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
            <tr>
                <td colspan="2">
                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;">
                        <label> <b> IMPORTE EN LETRAS: </b> <?=$s_MontoTotalLetras?> </label><br>
                    </div>
                </td>
            </tr>

            <?php if( $o_VTA_DocumentoBN->getDetraccionTipoId() ){ ?>
            <tr>
                <td colspan="2">
                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;" align="center">
                        <label> <b> OPERACIÓN SUJETA AL SISTEMA DE PAGO DE OBLIGACIONES TRIBUTARIAS: </b> BANCO DE LA NACIÓN</label><br>
                    </div>
                </td>
            </tr>
            <?php } ?>

            <?php if( $o_VTA_DocumentoBN->getEsAgenteRetenedor() ){ ?>
                <tr>
                    <td colspan="2">
                        <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;" align="center">
                            <label> OPERACIÓN SUJETA A RETENCIÓN DEL I.G.V. TASA <?=number_format( $o_VTA_DocumentoBN->getRetencionPorcentaje(), 2 )?>% </label><br>
                        </div>
                    </td>
                </tr>
            <?php } ?>

            <tr>
                <td colspan="2">
                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;">
                        <div style="padding-top: 5px; padding-bottom: 5px;">
                            <table style="width: 100%;" border="0" cellpadding="1" cellspacing="0" >
                                <tr>
                                    <th align="center" width="25%"><u>Banco</u></th>
                                    <!-- <th align="center" width="25%"><u>Moneda</u></th> -->
                                    <th align="center" width="25%"><u>Nro Cuenta</u></th>
                                    <th align="center" width="25%"><u>CC Interbancario</u></th>
                                </tr>
                                <?php foreach( MST_CuentaBancariaFN::buscarCuentaVisible() as $o_MST_CuentaBancariaBN ){ ?>
                                <tr>
                                    <td align="center"><?=$o_MST_CuentaBancariaBN->getDescripcionCuenta()?></td>
                                    <td align="center"><?=$o_MST_CuentaBancariaBN->getNumeroCuenta()?></td>
                                    <td align="center"><?=$o_MST_CuentaBancariaBN->getNumeroCuentaCCI()?></td>
                                </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
            <tr>
                <td style="width: 87%; vertical-align: top;">
                    
                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;">
                        
                        <table style="width: 100%;" border="0" cellpadding="1" cellspacing="0" >
                            <tr>
                                <td align="right" width="30%"><label> <b> ORDEN DE COMPRA: </b>  </label></td>
                                <td> <?=$o_VTA_DocumentoBN->getOrdenCompraRef()?> </td>
                            </tr>
                            <tr>
                                <td align="right"><label> <b> GUÍA DE REMISIÓN REMITENTE: </b>  </label></td>
                                <td> <?=$o_VTA_DocumentoBN->getConcatGuiaRemision()?> </td>
                            </tr>
                            <tr>
                                <td align="right"><label> <b> CONDICION DE PAGO: </b> </label></td>
                                <td> <?=$o_VTA_DocumentoBN->getFormaPagoDes()?> </td>
                            </tr>
                            <tr>
                                <td align="right"><label> <b> CTA. DETRACCION: </b> </label></td>
                                <td> <?=MST_CuentaBancariaFN::buscarUnaCuentaDetraccion()->getNumeroCuenta()?> </td>
                            </tr>
                            <?php if( $s_MedioPago ){ ?>
                            <tr>
                                <td align="right"><label> <b> MEDIO DE PAGO: </b> </label></td>
                                <td> <?=$s_MedioPago?> </td>
                            </tr>
                            <?php } ?>
                            <?php if( $o_VTA_DocumentoBN->getComentario() ){ ?>
                            <tr>
                                <td align="right"><label> <b> OBSERVACIONES: </b> </label></td>
                                <td> <?=$o_VTA_DocumentoBN->getComentario()?> </td>
                            </tr>
                            <?php } ?>
                        </table>
                        
                    </div>

                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; margin-right: 2px;">

                        <label> Representación impresa de la <?=strtoupper( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal() )?>, visita <B>https://goldensoft.pse.pe/20538638090</B> </label><br>
                        <label> Emitido mediante un <B>PROVEEDOR Autorizado por la SUNAT</B> mediante Resolución de Intendencia <B>No. 034-005-0005315</B> </label><br>

                        <!-- <label><b>Resumen:</b> <?=$a_Data['s_CodigoHash']?> </label><br> -->
                
                    </div>

                </td>
                <td style="" valign="top">

                    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                        border: 1px solid #B9B5B5; padding: 5px; ">

                        <img src="web/images/temp/<?=$s_QR_Image?>" />
                
                    </div>

                </td>
            </tr>
        </table>
    <?php
}

function construir_cuerpo( &$a_Data, $ini, $fin, $s_vHtml )
{
    $o_VTA_DocumentoBN      = $a_Data['o_VTA_DocumentoBN'];
    $a_VTA_DocumentoDetalle = $a_Data['a_VTA_DocumentoDetalle'];
    ?>
        <?php if( $ini != 0 ){ ?> 
            <?php if( !$s_vHtml ){ ?>
                <div class="new-page"> 
            <?php } ?>
        <?php } ?>

        <?php if( !$s_vHtml ){ ?>
        <?=construir_cabecera( $a_Data )?>
        <?php } ?>

        <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                    border: 1px solid #B9B5B5; padding: 5px; ">

            <table style="width: 100%;" border="0" cellpadding="5" cellspacing="0" >
                <tr>
                    <!-- 1% -->
                    <td style="width: 5%; background-color: #EEEEEE; border-bottom: 1px solid ; border-left: 1px solid; border-top: 1px solid; border-color: #B9B5B5;
                            border-top-left-radius: 5px; border-bottom-left-radius: 5px;
                            " align="center">
                        <b>CODIGO</b>
                    </td>
                    <td style="width: 8%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;" align="center"><b>CNT</b></td>
                    <td style="width: 8%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;" align="center"><b>U.M</b></td>
                    <td style="width: 50%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;"><b>DESCRIPCION</b></td>
                    <td style="width: 10%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;" align="right"><b>P/U</b></td>
                    <td style="width: 10%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-right: 1px solid; border-color: #B9B5B5; 
                               border-bottom-right-radius: 5px; border-top-right-radius: 5px;" align="center">
                        <b>IMPORTE</b>
                    </td>
                </tr>
        
<?php if ( $a_VTA_DocumentoDetalle ){ ?>
    <?php for ( $i=$ini; $i < $fin; $i++) { ?>
        <?php if( isset( $a_VTA_DocumentoDetalle[$i] ) ){ ?>
        <?php
        $s_Background = $i%2==0 ? "" : "background-color: #F0F0F0;";
        $b_Control = $a_VTA_DocumentoDetalle[$i]->getTipoDetalle()==VTA_DocumentoDetalleBN::TIPO_DETALLE || $a_VTA_DocumentoDetalle[$i]->getTipoDetalle()==VTA_DocumentoDetalleBN::TIPO_DETALLE_SERVICIO ? true : false;
        ?>
            <tr style="<?=$s_Background?>">
                <td style="" align="center">
                    <?php if( $a_VTA_DocumentoDetalle[$i]->getTipoDetalle() == VTA_OrdenDetalleBN::TIPO_COMENTARIO ){ ?>
                        /C
                    <?php }else{ ?>
                        <?=$a_VTA_DocumentoDetalle[$i]->getItemCodigo() ?>
                    <?php } ?>
                </td>
                <td style="" align="center"><?=$b_Control?$a_VTA_DocumentoDetalle[$i]->getCantidadPedida():"" ?></td>
                <td style="" align="center"><?=$b_Control?$a_VTA_DocumentoDetalle[$i]->getObjectUnidad()->getDescripcionExtranjera():"" ?></td>
                <td style=""><?= $a_VTA_DocumentoDetalle[$i]->getDescripcion() ?></td>
                <td style="" align="right"><?=$b_Control?number_format( $a_VTA_DocumentoDetalle[$i]->getPrecioUnitario(), 2 ):"" ?></td>
                <td style="" align="right"><?=$b_Control?number_format( round( $a_VTA_DocumentoDetalle[$i]->getMontoSubTotal(), 2 ), 2 ):"" ?></td>
            </tr>
        <?php }else{ ?>
            <tr>
                <td style="" align="center">&nbsp;</td>
                <td style="" align="center">&nbsp;</td>
                <td style="" align="center">&nbsp;</td>
                <td style="">&nbsp;</td>
                <td style="" align="right">&nbsp;</td>
                <td style="" align="right">&nbsp;</td>
            </tr>
        <?php } ?>
    <?php } ?>
<?php } ?>
                <tr>
                    <td colspan="6">
                        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0" >
                            <tr>
                                <td width="20%" align="center">
                                    <b>ANTICIPOS <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                    <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoAnticipo() ), 2 )?></b>
                                </td>
                                <td width="20%" align="center">
                                    <b>DESCUENTO <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                    <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoDescuentos() ), 2 )?></b>
                                </td>
                                <td width="20%" align="center">
                                    <b>SUB TOTAL <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                    <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoSubTotal() ), 2 )?></b>
                                </td>
                                <td width="20%" align="center">
                                    <b>IGV <?=GSS_ParametroMastFN::getTextoIgvActual()?> <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                    <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoImpuestos() ), 2 )?></b>
                                </td>
                                <td width="20%" align="right">
                                    <b>TOTAL <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                    <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoTotal() ), 2 )?></b>
                                </td>
                            </tr>
                        </table>

                        <?php if( $o_VTA_DocumentoBN->getDetraccionTipoId() ){ ?>
                            <table style="width: 100%; margin-top: 5px;" border="0" cellpadding="0" cellspacing="0" >

                                <tr>
                                    <td width="20%" align="center">&nbsp;</td>
                                    <td width="20%" align="center">&nbsp;</td>
                                    <td width="20%" align="center">
                                        <b>DETRACCION </b>&nbsp;&nbsp;
                                        <b><?=round( ( $o_VTA_DocumentoBN->getDetraccionPorcentaje() ), 2 )?>%</b>
                                    </td>
                                    <td width="20%" align="center">
                                        <b>TOTAL DET <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                        <b><?=number_format( ( $o_VTA_DocumentoBN->getDetraccionTotal() ), 2 )?></b>
                                    </td>
                                    <td width="20%" align="right">
                                        <b>NETO A PAGAR <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                        <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoTotal() - $o_VTA_DocumentoBN->getDetraccionTotal() ), 2 )?></b>
                                    </td>
                                </tr>
                            </table>
                        <?php } ?>

                        <?php if( $o_VTA_DocumentoBN->getEsAgenteRetenedor() ){ ?>
                            <table style="width: 100%; margin-top: 5px;" border="0" cellpadding="0" cellspacing="0" >

                                <tr>
                                    <td width="20%" align="center">&nbsp;</td>
                                    <td width="20%" align="center">&nbsp;</td>
                                    <td width="20%" align="center">
                                        <b>RETENCION </b>&nbsp;&nbsp;
                                        <b><?=round( ( $o_VTA_DocumentoBN->getRetencionPorcentaje() ), 2 )?>%</b>
                                    </td>
                                    <td width="20%" align="center">
                                        <b>TOTAL RET <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                        <b><?=number_format( ( $o_VTA_DocumentoBN->getRetencionTotal() ), 2 )?></b>
                                    </td>
                                    <td width="20%" align="right">
                                        <b>NETO A PAGAR <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;
                                        <b><?=number_format( ( $o_VTA_DocumentoBN->getMontoTotal() - $o_VTA_DocumentoBN->getRetencionTotal() ), 2 )?></b>
                                    </td>
                                </tr>
                            </table>
                        <?php } ?>

                    </td>
                </tr>
                <!-- 
                <tr>
                    <td style="" colspan="3">&nbsp;</td>
                    <td style="" align="right" colspan="2"><b>DESCUENTO <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;</td>
                    <td style="" align="right"><b><?=number_format( ( $o_VTA_DocumentoBN->getMontoDescuentos() ), 2 )?></b></td>
                </tr>
                <tr>
                    <td style="" colspan="3">&nbsp;</td>
                    <td style="" align="right" colspan="2"><b>GRAVADA <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;</td>
                    <td style="" align="right"><b><?=number_format( ( $o_VTA_DocumentoBN->getMontoSubTotal() ), 2 )?></b></td>
                </tr>
                <tr>
                    <td style="" colspan="3">&nbsp;</td>
                    <td style="" align="right" colspan="2"><b>IGV <?=GSS_ParametroMastFN::getTextoIgvActual()?> <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;</td>
                    <td style="" align="right"><b><?=number_format( ( $o_VTA_DocumentoBN->getMontoImpuestos() ), 2 )?></b></td>
                </tr>
                <tr>
                    <td style="" colspan="3">&nbsp;</td>
                    <td style="" align="right" colspan="2"><b>TOTAL <?=GSS_MonedaMastFN::getSiglaxId( $o_VTA_DocumentoBN->getMonedaDocumento() )?></b>&nbsp;&nbsp;</td>
                    <td style="" align="right"><b><?=number_format( ( $o_VTA_DocumentoBN->getMontoTotal() ), 2 )?></b></td>
                </tr>
                -->
            </table>
        </div>

        <?php if( !$s_vHtml ){ ?>
        <?=construir_pie( $a_Data )?>
        <?php } ?>

        <?php if( $ini != 0 ){ ?> 
            <?php if( !$s_vHtml ){ ?>
                </div> 
            <?php } ?>
        <?php } ?>

    <?php
}
?>

<!-- https://ourcodeworld.com/articles/read/687/how-to-configure-a-header-and-footer-in-dompdf -->
<html>
    <head>
        <style type="text/css">
            @page 
            {
                size: A4 portrait;
                margin: 0cm 0cm;
            }

            header 
            {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 10px;
            }

            footer 
            {
                bottom: 0cm; 
                left: 0cm; 
                right: 0cm;
            }

            body 
            {
                margin : 0.5cm;
                /*margin-top: 1cm;*/
                font-family: Arial, Helvetica, sans-serif;
                font-size: 10px;
                /*margin-top: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
                margin-bottom: 0.5cm;*/
            }

            table
            {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 10px;
            }

            .new-page{ page-break-before: always; }
            
            #watermark 
            {
                position: fixed;
                opacity: 0.2;
                /** 
                    Establece una posición en la página para tu imagen
                    Esto debería centrarlo verticalmente
                **/
                bottom:   14cm;
                left:     6.5cm;

                /** Cambiar las dimensiones de la imagen **/
                width:    8cm;
                height:   8cm;

                /** Tu marca de agua debe estar detrás de cada contenido **/
                z-index:  -1000;
            }

        </style>
    </head>
    <!--<body style="page-break-before: always;">-->
    <body>
        <div id="watermark">
            <img src="web/images/logo/<?=$o_GSS_CompaniaBN->getRuc()?>_black.jpg" height="100%" width="100%" >
        </div>

        <?php
        $a_VTA_DocumentoDetalle = $a_Data['a_VTA_DocumentoDetalle'];

        $i_RowTot = 20;
        $i_Loop   = ceil( count( $a_VTA_DocumentoDetalle ) / $i_RowTot );

        $i_RowIni  = 0;
        $i_RowFin  = $i_RowTot;

        $j = 1;
        while ( $j <= $i_Loop ) 
        {
            if( $s_vHtml )
            {
                $i_RowFin = count( $a_VTA_DocumentoDetalle );
            }
            construir_cuerpo( $a_Data, $i_RowIni, $i_RowFin, $s_vHtml );

            $i_RowIni = $i_RowIni + $i_RowTot;
            $i_RowFin = $i_RowFin + $i_RowTot;
            
            $j++;

            if( $s_vHtml )
            {
                break;
            }
        }
        ?>

        <!--
        <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                border: 1px solid #B9B5B5; padding: 5px; ">

            

        </div>
        -->

    </body>
</html>