<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

require $sDirBase.'lib/vendor/php-jwt/JWT.php';
require $sDirBase.'lib/vendor/php-jwt/Key.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Dompdf\Dompdf;
use Dompdf\Options;

class proActions extends wtActions
{
    public static function setViewBtnPrint( $v ){ myUser::getUser()->setAttributeHolder( 'ViewBtnPrint', $v ); }
    public static function getViewBtnprint(){ return myUser::getUser()->getAttributeHolder( 'ViewBtnPrint' ); }
    
    public function executeIndex()
    {
        
    }
    
    public function executePrintPDF()
    {
        set_memory_max_time();
        
        $s_Id    = $this->getRequestParameter( 'i_Id' );
        $s_vHtml = $this->getRequestParameter( 'vHtml' );

        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];

        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );

        //aqui una validacion por el formato de impresion:
        if( !$s_vHtml )
        {
            switch ( $IdTipoDocumento ) 
            {
                case 'FC':
                    if( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() == "A5" )
                    {

                    }
                    if( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() == "TICKET" )
                    {
                        //redirect
                        $s_Dir = Constantes::ROOT_DIR_APP;
                        header( "Location:".$s_Dir."vta.php/pro/printPDF2/i_Id/".$s_Id );
                    }
                break;
                case "NV":
                case "BV":
                    if( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() == "A5" )
                    {

                    }
                    if( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() == "TICKET" )
                    {
                        //redirect
                        $s_Dir = Constantes::ROOT_DIR_APP;
                        header( "Location:".$s_Dir."vta.php/pro/printPDF2/i_Id/".$s_Id );
                    }
                break;
            }
        }

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        //$o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Descripcion );
        $o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Secuencia );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
        //pr( $a_VTA_DocumentoDetalle );
        /*$a_VTA_DocumentoDetalle = array();
        if( $a_Result )
        {
            $a_VTA_DocumentoDetalle = $a_Result;
        }*/
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();

        //AHORA SE MUESTRA EL MEDIO DE PAGO - 2021-09-20
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
        $o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_APLICADO );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        $s_MedioPago      = "";
        if( $a_FCO_Aplicacion )
        {
            foreach( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
            {
                $s_Descripcion = $o_FCO_AplicacionBN->getTipoPagoNombre();
                if( $o_FCO_AplicacionBN->getIdTipoPago() != 1 )
                {
                    $s_Descripcion .= " OP: ".$o_FCO_AplicacionBN->getReciboNumero();
                }

                $a_DataMedioPago[] = $s_Descripcion;
            }
            $s_MedioPago = implode( " | ", $a_DataMedioPago );
        }
        ///////////////////////////////////////////////////////////////////////////
        
        //ahora se crea el codigo QR
        $sDirBase     = dirname( __FILE__ ).'/../../../../../';
        $QR_BASEDIR   = $sDirBase.'plugins/phpqrcode/';

        include $QR_BASEDIR."qrlib.php";

        $PNG_TEMP_DIR = $sDirBase."web/images/temp/";
        //$PNG_TEMP_DIR = dirname( __FILE__ ).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //$PNG_WEB_DIR  = '/gestioncomercial/web/images/temp/';

        $errorCorrectionLevel = 'L';
        $matrixPointSize      = 2.5;
        $filename             = $PNG_TEMP_DIR.'test.jpg';
        $s_CodigoHash         = "";

        $data = "20448473962|01|F001|000427|51.66|338.74|30/08/2019|6|10457658708|CNw/Uft8s57/HS1HWw/y//MIJWZucDYUMdqOIuMx7po=|";
        $data = "20604033561 | 01 | F001 | 000003 | 3.81 | 25.00 | 08/12/2019 | 6 | 20523254473 | LsRvB/juGdOWcCQm43/7GWAkIbsz/G/bZqKjet9cxN8= |"; //del proveedor
        $data = $o_GSS_CompaniaBN->getRuc()." | ".$o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal()." | ".$o_VTA_DocumentoBN->getDocumentoSerie()." | ".
                $o_VTA_DocumentoBN->getDocumentoNumero()." | ".$o_VTA_DocumentoBN->getMontoImpuestos()." | ".$o_VTA_DocumentoBN->getMontoTotal()." | ".
                substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )." | ".MST_PersonaMastBN::$a_TipoDocumento[$o_VTA_DocumentoBN->getClienteTipoDoc()]." | ".
                $o_VTA_DocumentoBN->getClienteRUC()." | ";

        //se busca el codigo hash
        $o_VTA_FacturacionElectronicaBN = $o_VTA_DocumentoBN->getObjetFacturacionElectronica();
        if( $o_VTA_FacturacionElectronicaBN )
        {
            $s_CodigoHash = $o_VTA_FacturacionElectronicaBN->getCodigoHash();
            $data .= $s_CodigoHash." |";
        }

        QRcode::png( $data, $filename, $errorCorrectionLevel, $matrixPointSize, 1 );

        $s_QR_Image = basename( $filename );
        //echo '<img src="'.$s_QR_Image.'" /><hr/>';
        //////////////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"       => $o_GSS_CompaniaBN, 
            "o_VTA_DocumentoBN"      => $o_VTA_DocumentoBN, 
            "a_VTA_DocumentoDetalle" => $a_VTA_DocumentoDetalle,
            "s_QR_Image"             => $s_QR_Image,
            "s_CodigoHash"           => $s_CodigoHash,
            "a_CuentasBancarias"     => $a_CuentasBancarias,
            "s_MedioPago"            => $s_MedioPago
        );

        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        if( $s_vHtml )
        {
            pr( "<h2 style='background-color: #EEEEEE; padding:10px; font-weight: bold; font-size: 15px;'>COMPROBANTE: ".$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()."</h2>" );
            echo $html;         exit;
        }
        //echo $html;         exit;

        $options = new Options();
        //$options->set( 'isRemoteEnabled', false );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();

        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );

        $dompdf->stream( 'Documento_'.$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero(), array( "Attachment" => 0 ) );
        
        exit;
        //////////////////////////////////////////////////////////////////////////////////////
    }
	
	public function executePrintPDFFlask()
    {
		
        set_memory_max_time();
        
        $s_Id    = $this->getRequestParameter( 'i_Id' );
        $s_vHtml = $this->getRequestParameter( 'vHtml' );
        //$s_vHtml = '_BLANK';
		//echo "Prueba";
		//echo $s_Id;
        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
		
		//myUser::getUser()->validar_session();
		//echo "Prueba 1";
        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );

        $o_GSS_SucursalFN = new GSS_SucursalFN();
        #$o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( 1 ); ///////////////////////////////////////////////////////////////

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        //$o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Descripcion );
        $o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Secuencia );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();

        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        #$o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdCompania( 1 ); ///////////////////////////////////////////////////////////////
        $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $NumeroDocumento );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        $s_FormaPagoDesc = "";
        $a_DataFP = array();
        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
        {
            $a_DataFP[] = $o_FCO_AplicacionBN->getTipoPagoNombre();
        }
        $s_FormaPagoDesc = implode( ",", $a_DataFP );
        ///////////////////////////////////////////////////////////////////////////
        //ahora buscamos la referencia del documento en ubicacion cliente
        $b_CrtlUbicacion   = false;
        $s_NombreUbicacion = "";
        $s_CodigoItemUbica = "";
        $s_HoraInicioUbica = "";

        $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
        $o_SRV_UbicacionClienteHFN->setNumeroDocumentoRef( $NumeroDocumento );
        $a_SRV_UbicacionClienteH = $o_SRV_UbicacionClienteHFN->select();
        if( $a_SRV_UbicacionClienteH )
        {
            $b_CrtlUbicacion   = true;
            $s_NombreUbicacion = $a_SRV_UbicacionClienteH[0]->getObjectUbicacion()->getNombre();
            $s_CodigoItemUbica = $a_SRV_UbicacionClienteH[0]->getIdItemTarifa();
            $s_HoraInicioUbica = $a_SRV_UbicacionClienteH[0]->getFechaHoraDocumento();
        }
        ///////////////////////////////////////////////////////////////////////////

        
        //ahora se crea el codigo QR
        $sDirBase     = dirname( __FILE__ ).'/../../../../../';
        $QR_BASEDIR   = $sDirBase.'plugins/phpqrcode/';

        include $QR_BASEDIR."qrlib.php";

        $PNG_TEMP_DIR = $sDirBase."web/images/temp/";
        //$PNG_TEMP_DIR = dirname( __FILE__ ).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //$PNG_WEB_DIR  = '/gestioncomercial/web/images/temp/';

        $errorCorrectionLevel = 'L';
        $matrixPointSize      = 2;
        $filename             = $PNG_TEMP_DIR.'test.jpg';
        $s_CodigoHash         = "";

        $data = "20448473962|01|F001|000427|51.66|338.74|30/08/2019|6|10457658708|CNw/Uft8s57/HS1HWw/y//MIJWZucDYUMdqOIuMx7po=|";
        $data = "20604033561 | 01 | F001 | 000003 | 3.81 | 25.00 | 08/12/2019 | 6 | 20523254473 | LsRvB/juGdOWcCQm43/7GWAkIbsz/G/bZqKjet9cxN8= |"; //del proveedor
        $data = $o_GSS_CompaniaBN->getRuc()." | ".$o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal()." | ".$o_VTA_DocumentoBN->getDocumentoSerie()." | ".
                $o_VTA_DocumentoBN->getDocumentoNumero()." | ".$o_VTA_DocumentoBN->getMontoImpuestos()." | ".$o_VTA_DocumentoBN->getMontoTotal()." | ".
                substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )." | ".MST_PersonaMastBN::$a_TipoDocumento[$o_VTA_DocumentoBN->getClienteTipoDoc()]." | ".
                $o_VTA_DocumentoBN->getClienteRUC()." | ";

        //se busca el codigo hash
        $o_VTA_FacturacionElectronicaBN = $o_VTA_DocumentoBN->getObjetFacturacionElectronica();
        if( $o_VTA_FacturacionElectronicaBN )
        {
            $s_CodigoHash = $o_VTA_FacturacionElectronicaBN->getCodigoHash();
            $data .= $s_CodigoHash." |";
        }

        //pr( $data );
        QRcode::png( $data, $filename, $errorCorrectionLevel, $matrixPointSize, 2 );

        $s_QR_Image = basename( $filename );
        //echo '<img src="'.$s_QR_Image.'" /><hr/>';
        //////////////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"       => $o_GSS_CompaniaBN, 
            "o_VTA_DocumentoBN"      => $o_VTA_DocumentoBN, 
            "a_VTA_DocumentoDetalle" => $a_VTA_DocumentoDetalle,
            "s_QR_Image"             => $s_QR_Image
        );

        $i_Ln    = 0;
        $i_Largo = 15; // minimo por una linea

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );

        //$dompdf->setPaper( 'A4', 'portrait' );

        //como se trata de ticket, se tiene que hacer una formula para calular el tamaño de la hoja por la cantidad de lineas impresa, la minimas es 15 po una sola linea

        $i_AnchoTicket = 215; //inicalmente
        $f_TotalLargo = $i_Ln * $i_Largo;
        $customPaper = array( 0, 0, 218, $f_TotalLargo ); //215
        $dompdf->setPaper( $customPaper, 'portrait' );

        $dompdf->render();

        $dompdf->stream( 'Documento_1', array( "Attachment" => 0 ) );

        exit;
        //////////////////////////////////////////////////////////////////////////////////////
    }
	
	public function executePrintPDFToken()
    {
		$token = $this->getRequestParameter('token');
		//$token = $_GET['token'] ?? null;
		if (!$token) {
			echo "No tiene Permiso (falta token)";
			exit;
		}

		try {
			$decoded = JWT::decode($token, new Key("lym_printer_service", "HS256"));
		} catch (Exception $e) {
			echo "No tiene Permiso (token inválido)";
			exit;
		}
		
        set_memory_max_time();
        
        $s_Id    = $this->getRequestParameter( 'i_Id' );
        $s_vHtml = $this->getRequestParameter( 'vHtml' );
        //$s_vHtml = '_BLANK';

        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
		
		//myUser::getUser()->validar_session();
		//echo "Prueba 1";
        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );

        $o_GSS_SucursalFN = new GSS_SucursalFN();
        #$o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( 1 ); ///////////////////////////////////////////////////////////////

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        //$o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Descripcion );
        $o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Secuencia );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();

        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        #$o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdCompania( 1 ); ///////////////////////////////////////////////////////////////
        $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $NumeroDocumento );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        $s_FormaPagoDesc = "";
        $a_DataFP = array();
        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
        {
            $a_DataFP[] = $o_FCO_AplicacionBN->getTipoPagoNombre();
        }
        $s_FormaPagoDesc = implode( ",", $a_DataFP );
        ///////////////////////////////////////////////////////////////////////////
        //ahora buscamos la referencia del documento en ubicacion cliente
        $b_CrtlUbicacion   = false;
        $s_NombreUbicacion = "";
        $s_CodigoItemUbica = "";
        $s_HoraInicioUbica = "";

        $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
        $o_SRV_UbicacionClienteHFN->setNumeroDocumentoRef( $NumeroDocumento );
        $a_SRV_UbicacionClienteH = $o_SRV_UbicacionClienteHFN->select();
        if( $a_SRV_UbicacionClienteH )
        {
            $b_CrtlUbicacion   = true;
            $s_NombreUbicacion = $a_SRV_UbicacionClienteH[0]->getObjectUbicacion()->getNombre();
            $s_CodigoItemUbica = $a_SRV_UbicacionClienteH[0]->getIdItemTarifa();
            $s_HoraInicioUbica = $a_SRV_UbicacionClienteH[0]->getFechaHoraDocumento();
        }
        ///////////////////////////////////////////////////////////////////////////

        
        //ahora se crea el codigo QR
        $sDirBase     = dirname( __FILE__ ).'/../../../../../';
        $QR_BASEDIR   = $sDirBase.'plugins/phpqrcode/';

        include $QR_BASEDIR."qrlib.php";

        $PNG_TEMP_DIR = $sDirBase."web/images/temp/";
        //$PNG_TEMP_DIR = dirname( __FILE__ ).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //$PNG_WEB_DIR  = '/gestioncomercial/web/images/temp/';

        $errorCorrectionLevel = 'L';
        $matrixPointSize      = 2;
        $filename             = $PNG_TEMP_DIR.'test.jpg';
        $s_CodigoHash         = "";

        $data = "20448473962|01|F001|000427|51.66|338.74|30/08/2019|6|10457658708|CNw/Uft8s57/HS1HWw/y//MIJWZucDYUMdqOIuMx7po=|";
        $data = "20604033561 | 01 | F001 | 000003 | 3.81 | 25.00 | 08/12/2019 | 6 | 20523254473 | LsRvB/juGdOWcCQm43/7GWAkIbsz/G/bZqKjet9cxN8= |"; //del proveedor
        $data = $o_GSS_CompaniaBN->getRuc()." | ".$o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal()." | ".$o_VTA_DocumentoBN->getDocumentoSerie()." | ".
                $o_VTA_DocumentoBN->getDocumentoNumero()." | ".$o_VTA_DocumentoBN->getMontoImpuestos()." | ".$o_VTA_DocumentoBN->getMontoTotal()." | ".
                substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )." | ".MST_PersonaMastBN::$a_TipoDocumento[$o_VTA_DocumentoBN->getClienteTipoDoc()]." | ".
                $o_VTA_DocumentoBN->getClienteRUC()." | ";

        //se busca el codigo hash
        $o_VTA_FacturacionElectronicaBN = $o_VTA_DocumentoBN->getObjetFacturacionElectronica();
        if( $o_VTA_FacturacionElectronicaBN )
        {
            $s_CodigoHash = $o_VTA_FacturacionElectronicaBN->getCodigoHash();
            $data .= $s_CodigoHash." |";
        }

        //pr( $data );
        QRcode::png( $data, $filename, $errorCorrectionLevel, $matrixPointSize, 2 );

        $s_QR_Image = basename( $filename );
        //echo '<img src="'.$s_QR_Image.'" /><hr/>';
        //////////////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"       => $o_GSS_CompaniaBN, 
            "o_VTA_DocumentoBN"      => $o_VTA_DocumentoBN, 
            "a_VTA_DocumentoDetalle" => $a_VTA_DocumentoDetalle,
            "s_QR_Image"             => $s_QR_Image
        );

        $i_Ln    = 0;
        $i_Largo = 15; // minimo por una linea

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );

        //$dompdf->setPaper( 'A4', 'portrait' );

        //como se trata de ticket, se tiene que hacer una formula para calular el tamaño de la hoja por la cantidad de lineas impresa, la minimas es 15 po una sola linea

        $i_AnchoTicket = 215; //inicalmente
        $f_TotalLargo = $i_Ln * $i_Largo;
        $customPaper = array( 0, 0, 218, $f_TotalLargo ); //215
        $dompdf->setPaper( $customPaper, 'portrait' );

        $dompdf->render();

        $dompdf->stream( 'Documento_1', array( "Attachment" => 0 ) );

        exit;
        //////////////////////////////////////////////////////////////////////////////////////
    }

    public function executePrintPDF2()
    {
        set_memory_max_time();
        
        $s_Id    = $this->getRequestParameter( 'i_Id' );
        $s_vHtml = $this->getRequestParameter( 'vHtml' );

        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];

        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );

        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        //$o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Descripcion );
        $o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Secuencia );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
        //pr( $a_VTA_DocumentoDetalle );
        /*$a_VTA_DocumentoDetalle = array();
        if( $a_Result )
        {
            $a_VTA_DocumentoDetalle = $a_Result;
        }*/
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        /*$o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();*/
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $NumeroDocumento );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        $s_FormaPagoDesc = "";
        $a_DataFP = array();
        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
        {
            $a_DataFP[] = $o_FCO_AplicacionBN->getTipoPagoNombre();
        }
        $s_FormaPagoDesc = implode( ",", $a_DataFP );
        ///////////////////////////////////////////////////////////////////////////
        //ahora buscamos la referencia del documento en ubicacion cliente
        $b_CrtlUbicacion   = false;
        $s_NombreUbicacion = "";
        $s_CodigoItemUbica = "";
        $s_HoraInicioUbica = "";

        $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
        $o_SRV_UbicacionClienteHFN->setNumeroDocumentoRef( $NumeroDocumento );
        $a_SRV_UbicacionClienteH = $o_SRV_UbicacionClienteHFN->select();
        if( $a_SRV_UbicacionClienteH )
        {
            $b_CrtlUbicacion   = true;
            $s_NombreUbicacion = $a_SRV_UbicacionClienteH[0]->getObjectUbicacion()->getNombre();
            $s_CodigoItemUbica = $a_SRV_UbicacionClienteH[0]->getIdItemTarifa();
            $s_HoraInicioUbica = $a_SRV_UbicacionClienteH[0]->getFechaHoraDocumento();
        }
        ///////////////////////////////////////////////////////////////////////////

        
        //ahora se crea el codigo QR
        $sDirBase     = dirname( __FILE__ ).'/../../../../../';
        $QR_BASEDIR   = $sDirBase.'plugins/phpqrcode/';

        include $QR_BASEDIR."qrlib.php";

        $PNG_TEMP_DIR = $sDirBase."web/images/temp/";
        //$PNG_TEMP_DIR = dirname( __FILE__ ).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //$PNG_WEB_DIR  = '/gestioncomercial/web/images/temp/';

        $errorCorrectionLevel = 'L';
        $matrixPointSize      = 2;
        $filename             = $PNG_TEMP_DIR.'test.jpg';
        $s_CodigoHash         = "";

        $data = "20448473962|01|F001|000427|51.66|338.74|30/08/2019|6|10457658708|CNw/Uft8s57/HS1HWw/y//MIJWZucDYUMdqOIuMx7po=|";
        $data = "20604033561 | 01 | F001 | 000003 | 3.81 | 25.00 | 08/12/2019 | 6 | 20523254473 | LsRvB/juGdOWcCQm43/7GWAkIbsz/G/bZqKjet9cxN8= |"; //del proveedor
        $data = $o_GSS_CompaniaBN->getRuc()." | ".$o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal()." | ".$o_VTA_DocumentoBN->getDocumentoSerie()." | ".
                $o_VTA_DocumentoBN->getDocumentoNumero()." | ".$o_VTA_DocumentoBN->getMontoImpuestos()." | ".$o_VTA_DocumentoBN->getMontoTotal()." | ".
                substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )." | ".MST_PersonaMastBN::$a_TipoDocumento[$o_VTA_DocumentoBN->getClienteTipoDoc()]." | ".
                $o_VTA_DocumentoBN->getClienteRUC()." | ";

        //se busca el codigo hash
        $o_VTA_FacturacionElectronicaBN = $o_VTA_DocumentoBN->getObjetFacturacionElectronica();
        if( $o_VTA_FacturacionElectronicaBN )
        {
            $s_CodigoHash = $o_VTA_FacturacionElectronicaBN->getCodigoHash();
            $data .= $s_CodigoHash." |";
        }

        //pr( $data );
        QRcode::png( $data, $filename, $errorCorrectionLevel, $matrixPointSize, 2 );

        $s_QR_Image = basename( $filename );
        //echo '<img src="'.$s_QR_Image.'" /><hr/>';
        //////////////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"       => $o_GSS_CompaniaBN, 
            "o_VTA_DocumentoBN"      => $o_VTA_DocumentoBN, 
            "a_VTA_DocumentoDetalle" => $a_VTA_DocumentoDetalle,
            "s_QR_Image"             => $s_QR_Image
        );

        $i_Ln    = 0;
        $i_Largo = 15; // minimo por una linea

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );

        //$dompdf->setPaper( 'A4', 'portrait' );

        //como se trata de ticket, se tiene que hacer una formula para calular el tamaño de la hoja por la cantidad de lineas impresa, la minimas es 15 po una sola linea

        $i_AnchoTicket = 215; //inicalmente
        $f_TotalLargo = $i_Ln * $i_Largo;
        $customPaper = array( 0, 0, 218, $f_TotalLargo ); //215
        $dompdf->setPaper( $customPaper, 'portrait' );

        $dompdf->render();

        //For Footer
        //$canvas = $dompdf->get_canvas();
        //$footer = $canvas->open_object();
        //$font = "";
        //$font_metrics = $dompdf->getFontMetrics();
        //$font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        //$canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        //$canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        //$canvas->close_object();
        //$canvas->add_object( $footer, "all" );

        $dompdf->stream( 'Documento_1', array( "Attachment" => 0 ) );
        //$dompdf->clear();

        /*
        $dompdf = new Dompdf();
        $dompdf->loadHtml( "<p>HOLA MUNDO</p>" );
        $i_AnchoTicket = 215; //inicalmente
        $f_TotalLargo = 200;
        $customPaper = array( 0, 0, 218, $f_TotalLargo ); //215
        $dompdf->setPaper( $customPaper, 'portrait' );
        $dompdf->render();
        //$dompdf->stream( 'Documento_2', array( "Attachment" => 0 ) );
        echo $dompdf->output();
        */

        exit;
    }

    public function executeListValorizaciones()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_IdPersona  = $this->getRequestParameter( 'IdPersona' );
        $this->s_ClienteRUC = $this->getRequestParameter( 'ClienteRUC' );
    }

    public function executeGridValorizacion()
    {
        $s_IdPersona  = $this->getRequestParameter( 'IdPersona' );

        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new SR_DevolucionFacturacionFN() );
        $o_GridAction->addMethodDefault( SR_DevolucionFacturacionFN::IdProyecto, array( 'Condition' => 'IN', 'Value' => "( SELECT IdProyecto FROM VTA_PrsProyectos WHERE IdPersona=$s_IdPersona )" ) );
        $o_GridAction->addMethodDefault( SR_DevolucionFacturacionFN::Estado, array( 'Condition' => 'IN', 'Value' => "( 'P' )" ) );


        $o_GridAction->addRowsToShow( "DevolFactId", "IdProyecto", "TipoEstado", "EstadoDesc", "IdItem", "DescripcionItem", "FechaCorte", "SubTotal", "MontoIGV", "MontoTotal", "ProyectoDesc" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeListCotizacion()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_ClienteRUC = $this->getRequestParameter( 'ClienteRUC' );
    }
    
    public function executeGridCotizacion()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_OrdenFN() );
        
        $o_GridAction->addAssignFilter( "OrdenTipoId" );
        if( $this->getRequestParameter( 'CheckAnticipo' ) )
        {
            $o_GridAction->addMethodDefault( VTA_OrdenFN::OrdenEstado, array( 'Condition'=>'IN', 'Value'=>"('O','R')" ) );
        }
        else
        {
            $o_GridAction->addAssignFilter( "OrdenEstado" );
        }
        
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_OrdenFN::ClienteNombre, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteDocNum", VTA_OrdenFN::ClienteDocNum, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "OrdenNum", VTA_OrdenFN::OrdenNum, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "NumeroFactura", ALM_OrdenGuiaFacturaFN::NumeroFactura, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( VTA_OrdenFN::OrdenId, true );
        
        $o_GridAction->addRowsToShow( "OrdenId", "OrdenNum", "OrdenFecha", "ClienteNombre", "ClienteDocCod", "ClienteDocNum", "OrdenMonedaDesc", "OrdenNeto", "OrdenEstadoDesc" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_IdCompania = myUser::getUser()->getIdBusiness();
        
        $x = myUser::getUser()->getNameSucursal();
        
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->setDescripcionIngles( "PVTA" );
        $o_VTA_TipoDocumentoFN->setGenerarProvisionFlag( "S" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "" );
        $o_VTA_TipoDocumentoFN->setGenerarProvisionFlag( "S" );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        //$this->a_Estados  = VTA_DocumentoBN::getArrayEstados();
        $this->a_Estados    = array( VTA_DocumentoBN::ESTADO_CERRADO => VTA_DocumentoBN::getArrayEstados( VTA_DocumentoBN::ESTADO_CERRADO ), VTA_DocumentoBN::ESTADO_ANULADO => VTA_DocumentoBN::getArrayEstados( VTA_DocumentoBN::ESTADO_ANULADO ) );
        $this->a_EstadosCob = VTA_DocumentoBN::getArrayCobranzaEstados();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $this->a_ALM_AlmacenMast = array();

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        if( !$this->GlobalAccess )
        {
            $o_ALM_AlmacenMastFN->setIdCompania( $this->i_IdCompania );
        }        
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        if( $this->GlobalAccess )
        {
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        }
        
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();
        
        /*$o_VTA_VendedorFN = new VTA_VendedorFN();
        $o_VTA_VendedorFN->setEstado( "A" );
        $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
        $o_VTA_VendedorFN->addOrderBy( "(SELECT Nombres FROM MST_PersonaMast WHERE IdPersona=VTA_Vendedor.IdPersona)" );
        $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();*/
    }
    
    public function executeGrid()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = $this->buildGrid();
        
        $o_GridAction->addRowsToShow
        (
            "IdCompania","IdConcat", "IdTipoDocumento", "NumeroDocumento", "FechaDocumento", "ClienteNombre", "FechaVencimiento", "CantidadDiasVence",
            "MontoTotal", "Estado", "DocumentoSerieNumero", "FormaPagoDes", "EstadoDesc", "TipoDocumentoDesc", "DocumentoParentCod", "DocumentoParentId",
            "EsUltimoSerieNumero", "IdTipoDocumentoCustom", "TieneNotaCredito", "IdTipoDocumento", "ImpresionPendienteFlag", "MontoSaldo", "FormaPagoDes",
            "CobranzaEstadoDesc", "CobranzaEstado"
        );
        
        //$o_GridAction->addInnerJoin( new VTA_TipoDocumentoFN(), "IdTipoDocumento", "DescripcionLocal" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        set_header_utf8();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
     
        $this->error_mensaje = "";
        
        $this->s_Anticipo = $this->getRequestParameter( 'anticipo' );
        $this->s_OrdenNo  = $this->getRequestParameter( 'ordenno' );
        //$this->s_OrdenId = $this->getRequestParameter( 'ordenid' );

        try 
        {
            //TIPO DE DOCUMENTO [PUNO] [JULIACA]
            //aqui se cambia el metodo de recuperar los tipos de documentos, por el proceso de varias compañias y cajeros por sucursales
            //procedimiento para recuperar series asignado por usuario
            //ahora el procedimiento seria para recuperar el numero
            if( myUser::getUser()->getUserId() )
            {
                $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
                $o_GSS_UsuarioSucuDocumentoFN->setIdUsuario( myUser::getUser()->getUserId() );
                $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_GSS_UsuarioSucuDocumentoFN->addOrderBy( GSS_UsuarioSucuDocumentoFN::IdTipoDocumento );
                $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();
                foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN ) 
                {
                    //AQUI SE INTERVIENE LA NOTA DE CREDITO:
                    if( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() == "NC" )
                    {
                        continue;
                    }

                    $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                    $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
                    if( $o_GSS_SucursalDocumentoBN->getEstado() != "A" )
                    {
                        continue;
                    }
                    
                    $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                    $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() );
                    if( $o_VTA_TipoDocumentoBN->getGenerarProvisionFlag() != "S" )
                    {
                        continue;
                    }

                    $this->a_VTA_TipoDocumento[] = $o_VTA_TipoDocumentoBN;
                }
            }
            else
            {
                $this->a_VTA_TipoDocumento = array();
            }
            ///////////////////

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
            
            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();
            
            $this->s_Titulo = "Nuevo Documento de Venta";
            
            $this->o_VTA_DocumentoBN = new VTA_DocumentoBN();
            if( $this->s_TipoProc == "upd" )
            {
                $a_Ids = explode( "_", $this->i_Id );
                $IdTipoDocumento = $a_Ids[0];
                $IdCompania      = $a_Ids[1];
                $NumeroDocumento = $a_Ids[2];
                
                $this->s_Titulo = "Documento de Venta";
                
                $o_VTA_DocumentoFN = new VTA_DocumentoFN();
                $this->o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
            }

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            $this->o_VTA_DocumentoBN->b_ControlCaja = false;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $this->o_VTA_DocumentoBN->b_ControlCaja   = true;
                $this->o_VTA_DocumentoBN->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
                $this->o_VTA_DocumentoBN->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
                $this->o_VTA_DocumentoBN->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
                $this->o_VTA_DocumentoBN->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
            }
            /*
            //PROCEDIMIENTO PARA CAJA - 2019-11-12
            $o_FCO_CajaFN = new FCO_CajaFN();
            $o_FCO_CajaFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_FCO_CajaFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_CajaFN->addCondition( "( SELECT COUNT(*) FROM FCO_CajaUsuario where IdUsuario='".myUser::getUser()->getUserId()."' and IdCaja=FCO_Caja.IdCaja )", ">=", 1 );
            $a_FCO_Caja = $o_FCO_CajaFN->select();
            $this->o_VTA_DocumentoBN->lst_caja = $a_FCO_Caja;
            //ahora validamos si ya esta en uso la caja
            $o_FCO_CajaUsuarioFN = new FCO_CajaUsuarioFN();
            $o_FCO_CajaUsuarioFN->setIdUsuario( myUser::getUser()->getUserId() );
            $o_FCO_CajaUsuarioFN->setEnUsoFlag( 1 );
            $a_FCO_CajaUsuario = $o_FCO_CajaUsuarioFN->select();
            $this->o_VTA_DocumentoBN->b_ControlCaja = true;
            if( $a_FCO_CajaUsuario )
            {
                $this->o_VTA_DocumentoBN->b_ControlCaja  = false;
                $this->o_VTA_DocumentoBN->IdCajaSelect   = $a_FCO_CajaUsuario[0]->getIdCaja();
                $this->o_VTA_DocumentoBN->DesCajaSelect  = $a_FCO_CajaUsuario[0]->getObjectCaja()->getDescripcion();
            }
            //pr( $a_FCO_CajaUsuario );
            */
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = 1;
        
        $IdCompania         = myUser::getUser()->getIdBusiness();
        $ClienteNumero      = $this->getRequestParameter( 'ClienteNumero' );
        $ClienteNombre      = $this->getRequestParameter( 'ClienteNombre' );
        $sDireccion         = $this->getRequestParameter( 'sDireccion' );
        //$NumeroInterno    = $this->getRequestParameter( 'NumeroInterno' );
        $FechaDocumento     = $this->getRequestParameter( 'FechaDocumento' ); //
        $MonedaDocumento    = $this->getRequestParameter( 'MonedaDocumento' );
        $IdTipoDocumento    = $this->getRequestParameter( 'IdTipoDocumento' );
        $Comentario         = $this->getRequestParameter( 'Comentario' );
        $f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
        
        $TipoDocumentoCod   = $this->getRequestParameter( 'TipoDocumentoCod' );
        $DocumentoSerie     = $this->getRequestParameter( 'DocumentoSerie' );
        $DocumentoNumero    = $this->getRequestParameter( 'DocumentoNumero' );
        $NaceAnulado        = $this->getRequestParameter( 'NaceAnulado' );
        $FechaVencimiento   = $this->getRequestParameter( 'FechaVencimiento' );
        $TipoVenta          = $this->getRequestParameter( 'TipoVenta' );
        $IdProyecto         = $this->getRequestParameter( 'IdProyecto' );

        $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
        $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );

        $IdCaja             = $this->getRequestParameter( 'IdCajaSelect' );
        $IdTurno            = $this->getRequestParameter( 'IdTurnoSelect' );

        //$cboCanal           = $this->getRequestParameter( 'cboCanal' );
        try 
        {
            myUser::getUser()->validar_session();

            /*
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //recupero el id de caja y el turno
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            
            if( !$a_FCO_Cierre )
            {
                throw new Exception( "No se aperturo ninguna Caja." );
            }
            if( count( $a_FCO_Cierre ) > 1 )
            {
                throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
            }
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $IdCaja         = $o_FCO_CierreBN->getIdCaja();
                $IdTurno        = $o_FCO_CierreBN->getIdTurno();
                $CodVendedor    = $o_FCO_CierreBN->getCodVendedor();
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //VALIDACION POR EL CODIGO DE VENDEDOR
            //pr( "$CodVendedor != ".myUser::getUser()->getUserId() );
            //if( $CodVendedor != myUser::getUser()->getUserId() )
            if( $CodVendedor != $IdVendedor )
            {
                throw new Exception( "El Codigo de Cajero es diferente a la Apertura de Caja." );
            }
            */
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( !$IdCaja )
            {
                $IdCaja = 1;
                $IdTurno = 1;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            $a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( count( $a_ALM_AlmacenMast ) == 1 )
            {
                $IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            /*
            //VALIDACION POR EL TIPO DE CAMBIO
            if( !$f_TipoCambio )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }
            */
            //ahora la validacion va a ser diferente
           
            //VALIDACION EL PERIODO
            $s_Periodo = UtilDate::getFormatDate( $FechaDocumento, "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                //throw new Exception( "El Periodo se encuentra Cerrado." );
            }
            
            //se busca el cliente
            if( $ClienteNumero )
            {
                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
                if( !$o_MST_PersonaMastBN )
                {
                    throw new Exception( "El Nro Documento del Cliente ingresado no se encuentra registrado." );
                }
            }
            else
            {
                throw new Exception( "El Nro Documento del Cliente ingresado no se encuentra registrado." );
            }
            
            $ClienteRUC          = $o_MST_PersonaMastBN->getDocumento();
            //$ClienteRUC          = $this->getRequestParameter( 'ClienteRUC' );
            $ClienteTipoDoc      = $o_MST_PersonaMastBN->getTipoDocumento();
            //$ClienteTipoDoc      = $this->getRequestParameter( 'ClienteTipoDoc' );

            $ClienteDireccion    = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc = $o_MST_PersonaMastBN->getDistritoDesc();
            $UbigeoCod           = $o_MST_PersonaMastBN->getDistrito();
            $VendedorAsigna      = $o_MST_PersonaMastBN->getVendedorAsignado();
            $CanalCliente        = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente  = $o_MST_PersonaMastBN->getNivelPrecioCliente();

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            $o_VTA_DocumentoBN->setIdCaja( ( int ) $IdCaja );
            $o_VTA_DocumentoBN->setIdTurno( ( int ) $IdTurno );
            $o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );
            $o_VTA_DocumentoBN->setClienteNombre( $ClienteNombre );
            $o_VTA_DocumentoBN->setClienteTipoDoc( $ClienteTipoDoc );
            $o_VTA_DocumentoBN->setClienteRUC( $ClienteRUC );
            $o_VTA_DocumentoBN->setClienteDireccion( $ClienteDireccion );
            $o_VTA_DocumentoBN->setClienteReferencia( $ClienteDistritoDesc );
            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento." ".date( "H:i:s" ) );
            $o_VTA_DocumentoBN->setMonedaDocumento( $MonedaDocumento );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipoCambio );
            $o_VTA_DocumentoBN->setSucursal( ( string ) myUser::getUser()->getIdSucursal() );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setUbigeo( $UbigeoCod );
            $o_VTA_DocumentoBN->setIdFormaPago( "008" );
            if( $IdProyecto )
            {
                $o_VTA_DocumentoBN->setIdProyecto( ( int ) $IdProyecto );
            }

            $o_VTA_DocumentoBN->setCobranzaEstado( "PE" );

            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_VTA_DocumentoBN->setCanalVenta( $CanalCliente );

            $a_UbigeoDesc        = MST_UbigeoFN::getArrayDireccionCompleta( $UbigeoCod );
            $o_VTA_DocumentoBN->setDepartamento( $a_UbigeoDesc['Departamento'] );
            $o_VTA_DocumentoBN->setProvincia( $a_UbigeoDesc['Provincia'] );
            $o_VTA_DocumentoBN->setDistrito( $a_UbigeoDesc['Distrito'] );
            
            if( $s_TipoProc == "nvo" )
            {
                //INSERT
                $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            }
            else 
            {
                //UPDATE
                $i_Id = $this->getRequestParameter( 'i_Id' );
                
                $a_Ids = explode( "_", $i_Id );
                //$IdTipoDocumento = $a_Ids[0];
                //$IdCompania      = $a_Ids[1];
                $NumeroDocumento = $a_Ids[2];

                $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );
            }

            //un procedimiento mas, cuando nace anulado
            if( $NaceAnulado )
            {
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
                $TypeSub = 0;
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->iniciarDocumentoFactura( $o_VTA_DocumentoBN );

            //aqui se agrega el procedimiento de poner el estado de la caja en uso [2019-11-13]
            if( $this->getRequestParameter( 'IdCaja' ) )
            {
                $o_FCO_CajaUsuarioDP = new FCO_CajaUsuarioDP();
                $o_FCO_CajaUsuarioDP->setIdCaja( $IdCaja );
                $o_FCO_CajaUsuarioDP->setIdUsuario( myUser::getUser()->getUserId() );
                $o_FCO_CajaUsuarioDP->setEnUsoFlag( 1 );
                $o_FCO_CajaUsuarioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CajaUsuarioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_CajaUsuarioDP->update();
            }

            $i_Id = $o_VTA_DocumentoBN->getIdTipoDocumento()."_".$o_VTA_DocumentoBN->getIdCompania()."_".$o_VTA_DocumentoBN->getNumeroDocumento();

            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
            $a_Rs['estado']   = VTA_DocumentoBN::ESTADO_PREPARACION;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = utf8_encode ( $o_Exception->getMessage() );
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeClie()
    {
        $this->block = $this->getRequestParameter( 'block' );
    }
    
    public function executeClieGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_PersonaMastFN() );
    
        //ParameterWR::getInstance()->setVar( "IdCompania", $IdCompania );
    
        $o_GridAction->addMethodDefault( "EsCliente", "SI" );
        $o_GridAction->addMethodDefault( "Estado", "A" );
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
    
        $o_GridAction->addAssignFilter( "IdPersona" );
        //$o_GridAction->addAssignFilter( "IdCompania" );
        
        $o_GridAction->addAssignFilter( "Documento" );
        
        if( $this->getRequestParameter( 'TipoDocumento' ) != "DIVISION" )
        {
            $o_GridAction->addAssignFilter( "TipoDocumento" );
        }
    
        $s_TipoDocumento = $this->getRequestParameter( 'TipoDocumento' );
        /*
        if( $s_TipoDocumento == "RUC" )
        {
            $o_GridAction->addConditionFilter( "NombreCompleto", MST_PersonaMastFN::NombreCompleto, "LIKE", "%%s%" );
        }
        else 
        {
            $o_GridAction->addConditionFilter( "NombreCompleto", "CONCAT( Nombres,' ',ApellidoPaterno, ' ', ApellidoMaterno )", "LIKE", "%%s%" );
        }
        */
        $o_GridAction->addConditionFilter( "NombreCompleto", "( IF( Nombres='', NombreCompleto, CONCAT( ApellidoPaterno,' ',ApellidoMaterno, ' ', Nombres) ) )", "LIKE", "%%s%" );

        if( $s_TipoDocumento == "DIVISION" )
        {
            $o_GridAction->addConditionFilter( "cbo_division", "( SELECT CodCanal FROM MST_ClienteMast WHERE IdCliente=MST_PersonaMast.IdPersona )", "=" );
        }
    
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
    
        $o_GridAction->addOrderDefault( MST_PersonaMastFN::IdPersona, true );
    
        $o_GridAction->addRowsToShow( "IdPersona", "NombreCompletoLLeno", "TipoDocumento", "Documento", "TipoPersonaDesc" );
    
        //$o_GridAction->addInnerJoin( new ALM_ItemTipoFN(), "IdOrdenClasificacion", "DescripcionLocal" );
    
        $o_GridAction->setNumberRecordsShow( 15 );
    
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
    
        return ViewResponse::NONE;
    }

    public function executeListPromo()
    {
        $this->i_Id      = $this->getRequestParameter( 'i_Id' );
    }
    
    public function executeListServices()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block     = $this->getRequestParameter( 'block' );
        $this->type      = $this->getRequestParameter( 'type' );
        $this->IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        $this->i_Id      = $this->getRequestParameter( 'i_Id' );
        
        $this->moneda_cod  = $this->getRequestParameter( 'moneda_cod' );
        
        $this->module  = $this->getRequestParameter( 'module' ) ? $this->getRequestParameter( 'module' ) : "pro";
    }
    
    public function executeItemGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        
        $moneda_cod  = $this->getRequestParameter( 'moneda_cod' );
        
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        //ParameterWR::getInstance()->setVar( "IdCompania", $IdCompania );
        
        $o_GridAction->addMethodDefault( ALM_ItemMastFN::Estado, "A" );
        
        //$o_GridAction->addAssignFilter( "IdItem" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        $o_GridAction->addAssignFilter( "ConStock" );
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" );
        $o_GridAction->addAssignFilter( "IdMarca" );
        $o_GridAction->addAssignFilter( "IdColor" );
        $o_GridAction->addAssignFilter( "IdCatTalla" );
        $o_GridAction->addAssignFilter( "IdTalla" );

        $o_GridAction->addConditionFilter( "CodigoBarras", ALM_ItemMastFN::CodigoBarras, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "IdItem", ALM_ItemMastFN::IdItem, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );
        //$o_GridAction->addMethodDefault( "ALM_ItemMast.IdItemTipo", array( 'Condition'=>'<>', 'Value'=>"'02'", 'force'=>true ) );
        
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //cambios por los hoteles 2019-12-04
        //condicion especial para no mostrar los hoteles
        //solo se muestran todos los registros que se pueden registrar en transacciones
        //es parametro es para cuando se usa -> selectdos
        $o_GridAction->addMethodDefault( "ALM_ItemTipo.TransacciondelSistemaFlag", array( 'Condition'=>'=', 'Value'=>"1" ) ); 
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::DescripcionCompleta, true );
        $o_GridAction->addOrderDefault( "ALM_ItemAlmacenStock.FechaVencimiento", true );
        
        $o_GridAction->addRowsToShow( "IdItem", "CodigoBarras", "DescripcionCompleta" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->setControlArray( false );
        
        $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $IdAlmacen );
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ResultSelect    = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        /*
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );
        $f_ValorIGVMasUno = floatval( $o_GSS_ParametroMastBN->getNumero() ) + 1;
        */
        $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
        $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18

        //el tipo de cambio tiene q ser el documento generado
        $f_TipoCob      = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        //$f_TipoCob = 1; //por defecto ahora, ya q no es necesrio mostrar el precio | sermaqui | 2021-04-19
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_ObjClassBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ObjClassBN->setIdAlmacen( $IdAlmacen );
            $o_ObjClassBN->setIdSucursal( $s_IdSucursal );
            
            $PrecioFinal = 0;

            $a_Rs[] = array
            (
                "IdItem"              => utf8_encode( $o_ObjClassBN->getIdItem() ),
                "IdLote"              => $o_ObjClassBN->getIdLote(),
                "ConcatLoteFecV"      => $o_ObjClassBN->getConcatLoteFecV(),
                "DescripcionCompleta" => ( $o_ObjClassBN->getDescripcionCompleta() ),
                "Marca"               => $o_ObjClassBN->getIdMarca(),

                "Stock"               => $o_ObjClassBN->getStockDisponible(),
                //"PrecioxCaja"         => $PrecioFinal,
                //"PrecioxUni"          => $o_ObjClassBN->getUsoFraccionFlag() ? round( $PrecioFinal / $o_ObjClassBN->getDivisor(), 2 ) : "",

                "UniMedVentaDesc"     => $o_ObjClassBN->getUniMedVentaDesc(),
                "IdUniMedVenta"       => $o_ObjClassBN->getIdUniMedVenta(),
                //"CantUniMedVenta"     => round( $o_ObjClassBN->getCantUniMedVenta(), 2 ),

                //"CantidadxCaja"       => $o_ObjClassBN->getCantidadxCaja(),
                //"CantidadxUnidad"     => $o_ObjClassBN->getUsoFraccionFlag() ? number_format( $o_ObjClassBN->getCantidadxUnidad(), 2 ) : "",
                
                //"Divisor"             => $o_ObjClassBN->getDivisor(),
                "UnidadEquivalenteFlag" => $o_ObjClassBN->getUnidadEquivalenteFlag(),
                "UsoFraccionFlag"       => $o_ObjClassBN->getUsoFraccionFlag(),
                "EsUnidadMinimaFlag"    => $o_ObjClassBN->getEsUnidadMinimaFlag()
            );
        }
        
        $a_ResultJson['rows'] = $a_Rs;
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeFindItem()
    {
        $block    = $this->getRequestParameter( 'block' );
        $s_ItemId = $this->getRequestParameter( 's_ItemId' );
        $IdAlmacen     = $this->getRequestParameter( 'IdAlmacen' );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_ItemId );
        
        $a_ResultJson['result'] = 0;
        $a_ResultJson['IdItem'] = "";
        $a_ResultJson['DescripcionCompleta'] = "";
        $a_ResultJson['NoAfectoImpuestoVentasFlag'] = "";
        
        $f_StockActual = 0;
        if( $o_ALM_ItemMastBN )
        {
            /*$o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
            $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( myUser::getUser()->getIdBusiness(), $o_ALM_ItemMastBN->getIdItem(), $IdAlmacen, ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO , ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
            if( !$o_ALM_ItemAlmacenStockBN )
            {
                $f_StockActual = 0;
            }
            else
            {
                $f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockActual();
            }*/
            $a_ResultJson['result']              = 1;
            $a_ResultJson['IdItem']              = $o_ALM_ItemMastBN->getIdItem();
            $a_ResultJson['DescripcionCompleta'] = $o_ALM_ItemMastBN->getDescripcionCompleta();
            $a_ResultJson['ItemStock']           = $f_StockActual;
            $a_ResultJson['UnidadCompra']        = $o_ALM_ItemMastBN->getUnidadCompra();
            $a_ResultJson['UnidadVenta']        = $o_ALM_ItemMastBN->getUnidadVenta();
            if( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() == "N" || $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() == "0" || !$o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() )
            {
                $s_DescImpuesto = "N";
            }
            else 
            {
                $s_DescImpuesto = "S";
            }
            $a_ResultJson['NoAfectoImpuestoVentasFlag'] = $s_DescImpuesto;
            
            $a_ALM_ItemAlmacenStock = ALM_ItemAlmacenStockFN::recuperarLotes( myUser::getUser()->getIdBusiness(), $IdAlmacen, $s_ItemId );
            if( $a_ALM_ItemAlmacenStock )
            {
                $a_Lst = array();
                foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
                {
                    if( $o_ALM_ItemAlmacenStockBN->getStockActual() > 0 )
                    {
                        $a_Lst[] = array( "IdLote"=>$o_ALM_ItemAlmacenStockBN->getIdLote(), "FechaVencimiento"=>substr( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento(), 0, 10 ) );
                    }
                }
                $a_ResultJson['a_Lotes'] = $a_Lst;
            }
            
            //ahora se busca el precio
            $a_ResultJson['PrecioVenta'] = "0";
            $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
            $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal(), $s_ItemId, 1 );
            if( $o_MST_ListaPrecioDetalleBN )
            {
                $a_ResultJson['PrecioVenta'] = $o_MST_ListaPrecioDetalleBN->getPrecioVenta();
            }
        }
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeReporte()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
    
        $a_Ids = explode( "_", $i_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
    
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $this->o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
    
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        $this->a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
    }
    
    public function executeAnularDocumento()
    {
        $block    = $this->getRequestParameter( 'block' );
        $i_Id     = $this->getRequestParameter( 'i_Id' );

        $a_Rs['error']   = false;

        try 
        {
            myUser::getUser()->validar_session();

            $a_Ids = explode( "_", $i_Id );
            $IdTipoDocumento = $a_Ids[0];
            $IdCompania      = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
    
            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );

            $o_TMP_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $NumeroDocumento );

            $o_OrdenVentaBL = new OrdenVentaBL();
            if( $o_TMP_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_PREPARACION )
            {
                $o_OrdenVentaBL->AnularDocumentoEstadoPR( $o_VTA_DocumentoBN );
            }
            elseif ( $o_TMP_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_CERRADO ) 
            {
                //$o_OrdenVentaBL->AnularDocumento( $o_VTA_DocumentoBN );
            }
            else
            {
                throw new Exception( "No se encontro un estado definido para la cancelacion o anulacion del comprobante." );
            }

            /*
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            //$o_VTA_DocumentoBN->setAnulacionComentario( $s_AnulacionComentario );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
            $o_VTA_DocumentoBN->setImpresionPendienteFlag( "N" );
            $o_VTA_DocumentoBN->setFechaModificacion( date( "Y-m-d" ) );
            $o_VTA_DocumentoBN->setUsuarioModificacion( myUser::getUser()->getUserId() );

            $o_VTA_DocumentoDP = new VTA_DocumentoDP( $o_VTA_DocumentoBN );
            $b_Result = $o_VTA_DocumentoDP->update();
            
            if( $b_Result )
            {
                $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleDP->setEstado( VTA_DocumentoDetalleBN::ESTADO_ANULADO );
                $b_Result = $o_VTA_DocumentoDetalleDP->cambiarEstadoDetalles();

                //ahora se procede a quitar las reservas
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                foreach ( $a_VTA_DocumentoDetalle as $key => $o_VTA_DocumentoDetalleBN ) 
                {
                    $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
                    $o_OrdenVentaDetalleBL->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "D" );
                }
            }
            */
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo anular la orden.";
        }

        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }

    // es el proceso general que mueve transacciones, y registra en la bandeja de la Facturacion Electronica
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $s_AnulacionComentario = $this->getRequestParameter( 'AnulacionComentario' );
        try 
        {
            myUser::getUser()->validar_session();

            if( trim( $s_AnulacionComentario ) == "" )
            {
                throw new Exception( "Debe de ingresar comentario." );
            }
            $a_Ids = explode( "_", $i_Id );
            $IdTipoDocumento = $a_Ids[0];
            $IdCompania      = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
            $IdAlmacen       = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            
            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            $o_VTA_DocumentoBN->setAnulacionComentario( $s_AnulacionComentario );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
            $o_VTA_DocumentoBN->setImpresionPendienteFlag( "N" );
            $o_VTA_DocumentoBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_DocumentoBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            
            $o_OrdenVentaBL = new OrdenVentaBL();
            $b_Result = $o_OrdenVentaBL->AnularDocumento( $o_VTA_DocumentoBN );

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo anular la orden.";
        }
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeFacturarOrden()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        try 
        {
            myUser::getUser()->validar_session();
            
            $a_Ids = explode( "_", $i_Id );
            $IdTipoDocumento = $a_Ids[0];
            $IdCompania      = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
        
            //SE REALIZA UNA TRANSACCION DE SALIDA:
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );            
            
            $o_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            
            $o_OrdenVentaBL = new OrdenVentaBL();
            $b_Result = $o_OrdenVentaBL->cambiarOrdenFacturada( $o_VTA_DocumentoBN );
            //FIN TRANSACCION//////////////////////////////////////
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
            $a_Rs['mensaje_numero'] = $o_VTA_DocumentoBN->getNumeroError();
        }
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeView()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Orden de Venta";
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $this->o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        $o_VTA_DocumentoDetalleFN->addOrderBy( VTA_DocumentoDetalleFN::Secuencia );
        $a_Result = $o_VTA_DocumentoDetalleFN->select();
        $this->a_VTA_DocumentoDetalle = array();
        if( $a_Result )
        {
            $this->a_VTA_DocumentoDetalle = $a_Result;
        }
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();

        if( myUser::getUser()->getUserId() )
        {
            $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
            $o_GSS_UsuarioSucuDocumentoFN->setIdusuario( myUser::getUser()->getUserId() );
            $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();
            foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN ) 
            {
                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );

                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() );

                $this->a_VTA_TipoDocumento[] = $o_VTA_TipoDocumentoBN;
            }
        }
        else
        {
            pr( "Falta inicial Session." );
            $this->a_VTA_TipoDocumento = array();
        }
    }
    
    public function executeAddeditclie() 
    {
            set_header_utf8();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoFN->setTipo( "DEPT" );
        $this->a_DptMST_Ubigeo = $o_MST_UbigeoFN->select();
        
        $this->a_PrvMST_Ubigeo  = array();
        $this->a_DstMST_Ubigeo  = array();
        
        $this->s_Titulo = "Nuevo Persona";
        
        /************/
        
        $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        $o_MST_PersonaMastBN->setEstado('A');
        $this->o_MST_PersonaMastBN = $o_MST_PersonaMastBN;
        
        /*************/
        
        //$this->o_MST_PersonaMastBN = new MST_PersonaMastBN();
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Persona";
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->i_Id );
            if($o_MST_PersonaMastBN->getTipoPersona() == "N") $o_MST_PersonaMastBN->setNombreCompleto("");
            $this->o_MST_PersonaMastBN = $o_MST_PersonaMastBN;
                       
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoFN->setTipo( "PROV" );
            $o_MST_UbigeoFN->setPertenece( $this->o_MST_PersonaMastBN->getDepartamento() );
            $this->a_PrvMST_Ubigeo  = $o_MST_UbigeoFN->select();
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoFN->setTipo( "DIST" );
            $o_MST_UbigeoFN->setPertenece( $this->o_MST_PersonaMastBN->getProvincia() );
            $this->a_DstMST_Ubigeo  = $o_MST_UbigeoFN->select();
        }
    }
    
    public function executeTotales()
    {
    	//$E = $this->getRequestParameter( 'Estado' );
        //ParameterWR::getInstance()->setVarForce( "Estado", "" );
    	//$E2 = $this->getRequestParameter( 'Estado' );
    	
        $o_GridAction = $this->buildGrid();
        if( !$this->getRequestParameter( 'Estado' ) )
        {
        	//$o_GridAction->addMethodDefault( "Estado", VTA_DocumentoBN::ESTADO_CERRADO );
        }
        
        $o_GridAction->setMethodSelectCustom( "selectTotales" );
        $this->a_Row = $o_GridAction->initialize();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeExpexcel()
    {
        header( 'Content-Type: application/vnd.ms-excel' );
        header( 'Content-Disposition: attachment;filename="Documento_Venta.xls"' );
        header( 'Cache-Control: max-age=0' );

        $o_GridAction = $this->buildGrid();
        $o_GridAction->setNumberRecordsShow( 9999 );
        $o_GridAction->setControlArray( false );
        
        $o_GridAction->initialize();
        $this->a_VTA_Documento = $o_GridAction->getResultSelect();
        
        $o_GridAction->setMethodSelectCustom( "selectTotales" );
        $this->o_RowTotales = $o_GridAction->initialize();
        //pr( $this->o_RowTotales );
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeAnnulDoc()
    {
        $this->i_Id = $this->getRequestParameter( 'i_Id' );        
    }
    
    private function buildGrid()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_DocumentoFN() );
        
        if( $this->getRequestParameter( 'DocumentoNumeroPr' ) )
        {
            if( $this->getRequestParameter( 'IdTipoDocumento' ) != "OS" ) //se reutiliza el campo para buscar la orden de venta.
            {
                //$s_NumeroFact = str_pad( $this->getRequestParameter( 'DocumentoNumeroPr' ), 10, "0", STR_PAD_LEFT );
                $s_NumeroFact = $this->getRequestParameter( 'DocumentoNumeroPr' );
                
                ParameterWR::getInstance()->setVar( "DocumentoNumero", $s_NumeroFact );

                $o_GridAction->addConditionFilter( "DocumentoNumero", VTA_DocumentoFN::DocumentoNumero,     "LIKE", "%%s%" );
            }
        }

        $o_GridAction->addAssignFilter( "DocumentoSerie" );
        //$o_GridAction->addAssignFilter( "TipoVenta" );
        //$o_GridAction->addAssignFilter( "CanalVenta" );
        $o_GridAction->addAssignFilter( "FormaPagoCod" );
        $o_GridAction->addAssignFilter( "CobranzaEstado" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addAssignFilter( "Vendedor" );
        
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                //$o_GridAction->addMethodDefault( VTA_OrdenFN::UsuarioCreacion, array( 'Condition'=>'=', 'Value'=>"" ) );
                $o_GridAction->addMethodDefault( VTA_DocumentoFN::Vendedor, myUser::getUser()->getUserId() );
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /*
        if( !myUser::getUser()->hasGlobalAccess() )
        {
            if( !$this->getRequestParameter( 'IdAlmacenAdmin' ) )
            {
                //$IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
                //$o_GridAction->addMethodDefault( "IdAlmacen", $IdAlmacen );
            }
            $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        }
        
        if( $this->getRequestParameter( 'IdAlmacenAdmin' ) )
        {
            if( $this->getRequestParameter( 'IdAlmacenAdmin' ) != "" )
            {
                //$o_GridAction->addAssignFilter( "IdAlmacen" );
                $o_GridAction->addMethodDefault( "IdAlmacen", $this->getRequestParameter( 'IdAlmacenAdmin' ) );
            }
        }
        */
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        if( $this->getRequestParameter( 'IdTipoDocumento' ) == "OS" ) //si el combo se selecciono orden de venta.
        {
            //ParameterWR::getInstance()->setVar( "DocumentoParentCod", $this->getRequestParameter( 'DocumentoNumeroPr' ) );
            $o_GridAction->addConditionFilter( "NumeroComprobante", VTA_DocumentoFN::DocumentoParentCod, "LIKE", "%%s%" );

        }
        else
        {
            $o_GridAction->addAssignFilter( "IdTipoDocumento" );
            $o_GridAction->addConditionFilter( "NumeroComprobante", VTA_DocumentoFN::NumeroComprobante, "LIKE", "%%s%" );
        }
        
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_DocumentoFN::ClienteNombre,     "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", VTA_DocumentoFN::FechaDocumento,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", VTA_DocumentoFN::FechaDocumento,  "<=", '23:59:59' );

        $o_GridAction->addOrder( "FechaVencimiento", VTA_DocumentoFN::FechaVencimiento );
        $o_GridAction->addOrder( "CantidadDiasVence", "IF( CobranzaEstado='PE', ( DATEDIFF(NOW(), FechaVencimiento) ), -99999 )" );

        $o_GridAction->addOrderDefault( VTA_DocumentoFN::DocumentoNumero, false );
        
        return $o_GridAction; 
    }
}