<?php
class SaveCustomValorizAction extends wtActions
{
    public function execute()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = 1;

        $IdCompania         = myUser::getUser()->getIdBusiness();
        $ClienteNumero      = $this->getRequestParameter( 'ClienteNumero' );
        $ClienteNombre      = $this->getRequestParameter( 'ClienteNombre' );
        $sDireccion         = $this->getRequestParameter( 'sDireccion' );
        //$NumeroInterno    = $this->getRequestParameter( 'NumeroInterno' );
        $FechaDocumento     = $this->getRequestParameter( 'FechaDocumento' ); //
        $MonedaDocumento    = $this->getRequestParameter( 'MonedaDocumento' );
        $IdTipoDocumento    = $this->getRequestParameter( 'IdTipoDocumento' );
        $Comentario         = $this->getRequestParameter( 'Comentario' );
        $f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );

        $TipoDocumentoCod   = $this->getRequestParameter( 'TipoDocumentoCod' );
        $DocumentoSerie     = $this->getRequestParameter( 'DocumentoSerie' );
        $DocumentoNumero    = $this->getRequestParameter( 'DocumentoNumero' );
        $NaceAnulado        = $this->getRequestParameter( 'NaceAnulado' );
        $FechaVencimiento   = $this->getRequestParameter( 'FechaVencimiento' );
        $TipoVenta          = $this->getRequestParameter( 'TipoVenta' );
        $IdProyecto         = $this->getRequestParameter( 'IdProyecto' );

        $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
        $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );

        $IdCaja             = $this->getRequestParameter( 'IdCajaSelect' );
        $IdTurno            = $this->getRequestParameter( 'IdTurnoSelect' );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            if( !$IdCaja )
            {
                $IdCaja = 1;
                $IdTurno = 1;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            $a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( count( $a_ALM_AlmacenMast ) == 1 )
            {
                $IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //VALIDACION EL PERIODO
            $s_Periodo = UtilDate::getFormatDate( $FechaDocumento, "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                //throw new Exception( "El Periodo se encuentra Cerrado." );
            }

            //se busca el cliente
            if( $ClienteNumero )
            {
                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
                if( !$o_MST_PersonaMastBN )
                {
                    throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
                }
            }
            else
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
            }

            $ClienteRUC          = $o_MST_PersonaMastBN->getDocumento();
            //$ClienteRUC          = $this->getRequestParameter( 'ClienteRUC' );
            $ClienteTipoDoc      = $o_MST_PersonaMastBN->getTipoDocumento();
            //$ClienteTipoDoc      = $this->getRequestParameter( 'ClienteTipoDoc' );

            $ClienteDireccion    = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc = $o_MST_PersonaMastBN->getDistritoDesc();
            $UbigeoCod           = $o_MST_PersonaMastBN->getDistrito();
            $VendedorAsigna      = $o_MST_PersonaMastBN->getVendedorAsignado();
            $CanalCliente        = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente  = $o_MST_PersonaMastBN->getNivelPrecioCliente();

            $s_MonedaDocumento  = $this->getRequestParameter( 'MonedaDocumento' );
            $f_TipodeCambio     = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            $f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
            $f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
            $f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
            $f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            $o_VTA_DocumentoBN->setIdCaja( ( int ) $IdCaja );
            $o_VTA_DocumentoBN->setIdTurno( ( int ) $IdTurno );
            $o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );
            $o_VTA_DocumentoBN->setClienteNombre( $ClienteNombre );
            $o_VTA_DocumentoBN->setClienteTipoDoc( $ClienteTipoDoc );
            $o_VTA_DocumentoBN->setClienteRUC( $ClienteRUC );
            $o_VTA_DocumentoBN->setClienteDireccion( $ClienteDireccion );
            $o_VTA_DocumentoBN->setClienteReferencia( $ClienteDistritoDesc );
            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento." ".date( "H:i:s" ) );
            $o_VTA_DocumentoBN->setMonedaDocumento( $MonedaDocumento );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipoCambio );
            $o_VTA_DocumentoBN->setSucursal( ( string ) myUser::getUser()->getIdSucursal() );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setUbigeo( $UbigeoCod );
            $o_VTA_DocumentoBN->setIdFormaPago( "008" );
            if( $IdProyecto )
            {
                $o_VTA_DocumentoBN->setIdProyecto( ( int ) $IdProyecto );
            }

            $o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );

            $o_VTA_DocumentoBN->setMontoDescuentos( $f_Descuento );
            $o_VTA_DocumentoBN->setMontoDescuentosMN( $f_Descuento );
            $o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            $o_VTA_DocumentoBN->setMontoSubTotalMN( $f_MontoSubTotal );
            $o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            $o_VTA_DocumentoBN->setMontoImpuestoMN( $f_TotalImpuesto );
            $o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );
            $o_VTA_DocumentoBN->setMontoTotalMN( $f_MontoTotal );

            $o_VTA_DocumentoBN->setCobranzaEstado( "PE" );

            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_VTA_DocumentoBN->setCanalVenta( $CanalCliente );

            $a_UbigeoDesc        = MST_UbigeoFN::getArrayDireccionCompleta( $UbigeoCod );
            $o_VTA_DocumentoBN->setDepartamento( $a_UbigeoDesc['Departamento'] );
            $o_VTA_DocumentoBN->setProvincia( $a_UbigeoDesc['Provincia'] );
            $o_VTA_DocumentoBN->setDistrito( $a_UbigeoDesc['Distrito'] );

            if( $s_TipoProc == "nvo" )
            {
                //INSERT
                $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            }
            else
            {
                //UPDATE
                $i_Id = $this->getRequestParameter( 'i_Id' );

                $a_Ids = explode( "_", $i_Id );
                //$IdTipoDocumento = $a_Ids[0];
                //$IdCompania      = $a_Ids[1];
                $NumeroDocumento = $a_Ids[2];

                $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );
            }

            //un procedimiento mas, cuando nace anulado
            if( $NaceAnulado )
            {
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
                $TypeSub = 0;
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->iniciarDocumentoFactura( $o_VTA_DocumentoBN );

            //AHORA SE AGREGA LOS DETALLES EN ESTE CASO, SERVICIO POR VALORIZACION:
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $b_ControlDetalles = false;
            $s_DevolFactId = $this->getRequestParameter( 'DevolFactId' );

            $o_SR_DevolucionFacturacionFN = new SR_DevolucionFacturacionFN();
            $o_SR_DevolucionFacturacionBN = $o_SR_DevolucionFacturacionFN->selectByPK( $s_DevolFactId );

            $s_IdItem = $o_SR_DevolucionFacturacionBN->getIdItem();
            $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );

            $f_SubTotalDevol   = $o_SR_DevolucionFacturacionBN->getSubTotal();
            $f_MontoIGVDevol   = $o_SR_DevolucionFacturacionBN->getMontoIGV();
            $f_MontoTotalDevol = $o_SR_DevolucionFacturacionBN->getMontoTotal();

            $s_TipoEstado = $o_SR_DevolucionFacturacionBN->getTipoEstado();

            if( $s_TipoEstado == "RP" )
            {
                $f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
                $f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
                $f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
                $f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

                $f_SubTotalDevol   = $f_MontoSubTotal;
                $f_MontoIGVDevol   = $f_TotalImpuesto;
                $f_MontoTotalDevol = $f_MontoTotal;
                if( $f_Descuento > 0 )
                {
                    $f_SubTotalDevol = $f_SubTotalDevol + $f_Descuento;
                    $f_MontoIGVDevol = round( ( $f_SubTotalDevol * 0.18 ), 2 );
                    $f_MontoTotalDevol = $f_SubTotalDevol + $f_MontoIGVDevol;
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// VALIDACIONES:
            if( $f_Descuento > 0 )
            {
                $f_NvoSubTotal = $f_SubTotalDevol - $f_Descuento;

                $f_NvoMontoIGV = round( $f_NvoSubTotal * 0.18, 2 );
                $f_NvoMontoTotal = $f_NvoSubTotal + $f_NvoMontoIGV;

                if( $f_NvoSubTotal !=  $f_MontoSubTotal )
                {
                    throw new Exception( "Debe calcular bien el sub-total" );
                }
            }
            else
            {
                if( $f_SubTotalDevol != $f_MontoSubTotal )
                {
                    throw new Exception( "Debe calcular bien el sub-total" );
                }
            }

            if( $s_TipoEstado == "RE" )
            {
                $b_ControlDetalles = true;
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $a_DataDet = array();
            if( !$b_ControlDetalles )
            {
                $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );

                $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoBN->getIdTipoDocumento(), $o_VTA_DocumentoBN->getIdCompania(), $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Id );
                $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_OrdenDetalleBN::TIPO_PRODUCTO_SERVICIO );
                $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_ALM_ItemMastBN->getIdItem() );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( ( int ) $o_ALM_ItemMastBN->getUnidadVenta() );
                $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
                $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_ALM_ItemMastBN->getDescripcionCompleta() ) );
                $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta
                $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( 0 );
                $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( 0 );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );

                $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_SubTotalDevol );
                $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $f_SubTotalDevol );
                $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $f_MontoIGVDevol );
                $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_MontoIGVDevol );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_MontoTotalDevol );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_MontoTotalDevol );

                $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $f_SubTotalDevol );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $f_SubTotalDevol );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $f_MontoIGVDevol );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $f_MontoIGVDevol );
                $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $f_MontoTotalDevol );
                $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $f_MontoTotalDevol );

                $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                $o_VTA_DocumentoDetalleDP->save();
            }
            else
            {
                //aqui se registra varios detalles si es el estado por reposision
                $o_SR_DevolucionDetalleFN = new SR_DevolucionDetalleFN();
                $o_SR_DevolucionDetalleFN->setDevolFactId( $s_DevolFactId );
                $a_SR_DevolucionDetalle = $o_SR_DevolucionDetalleFN->select();
                if( $a_SR_DevolucionDetalle )
                {
                    foreach( $a_SR_DevolucionDetalle as $o_SR_DevolucionDetalleBN )
                    {
                        $s_IdItem = $o_SR_DevolucionDetalleBN->getIdItem();

                        $f_TotalDevol = round( $o_SR_DevolucionDetalleBN->getCantidadDevolucion() * $o_SR_DevolucionDetalleBN->getPrecioUnitVentaDevolucion(), 2 );

                        if( !isset( $a_DataDet[$s_IdItem]['Cant'] ) )
                        {
                            $a_DataDet[ $s_IdItem ][ 'Cant' ] = $o_SR_DevolucionDetalleBN->getCantidadDevolucion();
                            $a_DataDet[ $s_IdItem ][ 'Total' ] =  $f_TotalDevol;
                        }
                        else
                        {
                            $a_DataDet[ $s_IdItem ][ 'Cant' ] = $a_DataDet[ $s_IdItem ][ 'Cant' ] + $o_SR_DevolucionDetalleBN->getCantidadDevolucion();
                            $a_DataDet[ $s_IdItem ][ 'Total' ] =  $a_DataDet[ $s_IdItem ][ 'Total' ] + $f_TotalDevol;
                        }

                        $a_DataDet[ $s_IdItem ][ 'PrecioUnit' ] = $o_SR_DevolucionDetalleBN->getPrecioUnitVentaDevolucion();
                    }
                }
                else
                {
                    throw new Exception( "No se encontro pendientes de Facturacion para la Valorizacion. " );
                }

                $i_Cnt = 1;
                foreach( $a_DataDet as $s_IdItem => $a_Data )
                {
                    $f_MontoIncUniDet = round( $a_Data['PrecioUnit'] * 1.18, 2 );
                    $f_MontoUniUGVDet = $f_MontoIncUniDet - $a_Data['PrecioUnit'];

                    $f_TotalDetalle  = round( $a_Data['Total'] * 1.18, 2 );
                    $f_TotalImpuesto = $f_TotalDetalle - $a_Data['Total'];

                    if( count( $a_DataDet ) == $i_Cnt )
                    {

                    }

                    $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );

                    $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                    $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                    $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                    $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );

                    $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoBN->getIdTipoDocumento(), $o_VTA_DocumentoBN->getIdCompania(), $o_VTA_DocumentoBN->getNumeroDocumento() );
                    $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Id );
                    $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_IdItem );
                    $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                    $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                    $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                    $o_VTA_DocumentoDetalleBN->setIdUnidad( ( int ) $o_ALM_ItemMastBN->getUnidadVenta() );
                    $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
                    $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                    $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_ALM_ItemMastBN->getDescripcionCompleta() ) );
                    $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                    $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta
                    $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( 0 );
                    $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setCantidadPedida( $a_Data['Cant'] );

                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $a_Data['PrecioUnit'] );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $a_Data['PrecioUnit'] );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $f_MontoUniUGVDet );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_MontoUniUGVDet );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_MontoIncUniDet );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_MontoIncUniDet );

                    $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $a_Data['Total'] );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $a_Data['Total'] );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $f_TotalImpuesto );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $f_TotalImpuesto );
                    $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $f_TotalDetalle );
                    $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $f_TotalDetalle );

                    $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                    $o_VTA_DocumentoDetalleDP->save();

                    $i_Cnt++;
                }
            }
            //pr( $_REQUEST );  pr( $a_DataDet ); exit;

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// AHORA SE ACTUALIZA DEVOLUCION FACTURACION
            $o_SR_DevolucionFacturacionDP = new SR_DevolucionFacturacionDP();
            $o_SR_DevolucionFacturacionDP->setDevolFactId( ( int ) $s_DevolFactId );
            $o_SR_DevolucionFacturacionDP->setIdPersona( ( int ) $ClienteNumero );
            $o_SR_DevolucionFacturacionDP->setEstado( "F" );
            $o_SR_DevolucionFacturacionDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
            $o_SR_DevolucionFacturacionDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
            $o_SR_DevolucionFacturacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SR_DevolucionFacturacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SR_DevolucionFacturacionDP->update();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// AHORA SE CAMBIA EL ESTADO A FACTURADO
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_TMP_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_DocumentoBN->getIdTipoDocumento(), $IdCompania, $o_VTA_DocumentoBN->getNumeroDocumento() );

            $o_TMP_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->cambiarOrdenFacturada( $o_TMP_VTA_DocumentoBN );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $i_Id = $o_VTA_DocumentoBN->getIdTipoDocumento()."_".$o_VTA_DocumentoBN->getIdCompania()."_".$o_VTA_DocumentoBN->getNumeroDocumento();

            $a_Rs['error']     = false;
            $a_Rs['id']        = $i_Id;
            $a_Rs['id_concat'] = $o_VTA_DocumentoBN->getIdConcat();
            $a_Rs['estado']    = VTA_DocumentoBN::ESTADO_PREPARACION;

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = ( $o_Exception->getMessage() );
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;

    }
}
