<?php
class SaveBillingByOrderAction extends wtActions
{
    public function execute()
    {
        $a_Rs = array( "error" => false );

        try
        {
            $orden_id           = trim( $this->getRequestParameter( 'orden_id' ) );
            $txt_orden          = trim( $this->getRequestParameter( 'txt_orden' ) );

            $IdCompania         = myUser::getUser()->getIdBusiness();
            $ClienteNumero      = $this->getRequestParameter( 'ClienteNumero' );
            
            $FechaDocumento     = $this->getRequestParameter( 'FechaDocumento' ); //
            $IdTipoDocumento    = $this->getRequestParameter( 'IdTipoDocumento' );
            $Comentario         = addslashes( $this->getRequestParameter( 'Comentario' ) );
            //$f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            
            $TipoDocumentoCod   = $this->getRequestParameter( 'TipoDocumentoCod' );
            $DocumentoSerie     = $this->getRequestParameter( 'DocumentoSerie' );
            $DocumentoNumero    = $this->getRequestParameter( 'DocumentoNumero' );
            $NaceAnulado        = $this->getRequestParameter( 'NaceAnulado' );
            $FechaVencimiento   = $this->getRequestParameter( 'FechaVencimiento' );
            
            $TipoVenta          = $this->getRequestParameter( 'TipoVenta' );
            //$IdAlmacen          = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );            
            $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
            
            $s_MonedaDocumento  = $this->getRequestParameter( 'MonedaDocumento' );
            $f_TipodeCambio     = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            $f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
            $f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
            $f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
            $f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

            //PARAMETROS PARA LA DETRACCION
            $DetracconTipoId     = $this->getRequestParameter( 'DetracconTipoId' );
            $DetracconPorcentaje = $this->getRequestParameter( 'DetracconPorcentaje' );
            $DetracconMedPagoId  = $this->getRequestParameter( 'DetracconMedPagoId' );
            $DetracconTotal      = $this->getRequestParameter( 'DetracconTotal' );

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setDocumentoParentId( ( int ) $orden_id );
            $o_VTA_DocumentoBN->setDocumentoParentCod( $txt_orden );

            //SETEO PARA DETRACCIONES
            $o_VTA_DocumentoBN->setDetraccionTipoId( intval( $DetracconTipoId ) );
            $o_VTA_DocumentoBN->setDetraccionMedPagoId( intval( $DetracconMedPagoId ) );
            $o_VTA_DocumentoBN->setDetraccionPorcentaje( floatval( $DetracconPorcentaje ) );
            $o_VTA_DocumentoBN->setDetraccionTotal( floatval( $DetracconTotal ) );

            //PARAMETROS PARA RETENCION
            $RetencionTipoId        = $this->getRequestParameter( 'RetencionTipoId' );
            $RetencionBaseImponible = $this->getRequestParameter( 'RetencionBaseImponible' );
            $RetencionTotal         = $this->getRequestParameter( 'RetencionTotal' );

            //SETEO PARA RETENCION
            $o_VTA_DocumentoBN->setRetencionTipoId( intval( $RetencionTipoId ) );
            $o_VTA_DocumentoBN->setRetencionBaseImponible( floatval( $RetencionBaseImponible ) );
            $o_VTA_DocumentoBN->setRetencionTotal( floatval( $RetencionTotal ) );

            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            //$o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );
            
            $o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );
            $o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            $o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            $o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );

            $FechaDocumento   = date( "Y-m-d H:i:s" );
            $FechaVencimiento = $FechaDocumento;
            
            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            if( $NaceAnulado )
            {
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
                $o_VTA_DocumentoBN->setAnulacionComentario( $Comentario );
            }

            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->guardarDocumentoPorOrden( $o_VTA_DocumentoBN );

            $a_Rs['id_concat'] = $o_VTA_DocumentoBN->getIdConcat();
            $a_Rs['id_comprobante'] = $o_VTA_DocumentoBN->getNumeroDocumento();
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}