<?php
class ListfcoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->b_Control         = false;
        $this->b_Edicion         = true;
        $this->s_MensajeError    = "";
        $this->s_NumeroDocumento = $this->getRequestParameter( 'idnumdoc' );
        $s_TipoProc              = $this->getRequestParameter( 'tipoproc' );
        
        try
        {
            $this->o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->s_NumeroDocumento );
            if( $this->o_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_CERRADO )
            {
                $this->b_Edicion = false;
            }

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_DocumentoBN->getMonedaDocumento() );

            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_DocumentoBN->getClienteNumero() );

            //$i_IdPersona = intval( $this->o_VTA_DocumentoBN->getClienteNumero() );

            if( $this->getRequestParameter( 'control' ) )
            {
                myUser::getUser()->validar_session();
                
                switch ( $s_TipoProc ) 
                {
                    case 'del':
                        $i_IdDocRecibo  = intval( $this->getRequestParameter( 'iddocrecibo' ) );
                        $i_IdAplicacion = intval( $this->getRequestParameter( 'idaplicacion' ) );

                        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                        $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $i_IdDocRecibo );
                        if( !$o_FCO_DocReciboBN )
                        {
                            throw new Exception( "No se encontro el Recibo como Referencia para proceder a eliminar." );
                        }
                        if( $o_FCO_DocReciboBN->getFlujoEstado() != FCO_DocReciboBN::FLUESTADO_PENDIENTE )
                        {
                            throw new Exception( "El Recibo tiene un estado diferente, no se puede eliminar." );
                            //aqui se tiene que evaluar mas a detalle
                            //por ejemplo si tiene un estado aprobado, solo se tiene que separar la aplicacion, entonces ahi pasa por el recalculo de saldo
                        }

                        //ahroa revisamos la aplicacion
                        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
                        $o_FCO_AplicacionBN = $o_FCO_AplicacionFN->selectByPK( $i_IdAplicacion );
                        if( !$o_FCO_AplicacionBN )
                        {
                            throw new Exception( "No se encontro la Aplicacion como Referencia para proceder a eliminar." );
                        }
                        if( $o_FCO_AplicacionBN->getEstado() != FCO_Aplicacionbn::ESTADO_PENDINTE )
                        {
                            throw new Exception( "La Aplicacion tiene un estado diferente, no se puede eliminar." );
                            //aqui se tiene que evaluar mas a detalle
                            //por ejemplo si tiene un estado aprobado, solo se tiene que separar la aplicacion, entonces ahi pasa por el recalculo de saldo
                        }

                        $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                        $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_DocReciboDP->delete();

                        $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                        $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
                        $o_FCO_AplicacionDP->delete();

                    break;
                }
            }

            $o_FCO_DocReciboFN = new FCO_DocReciboFN();
            $o_FCO_DocReciboFN->setIdDocNumRef( $this->s_NumeroDocumento );
            $o_FCO_DocReciboFN->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO );
            $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::Saldo, '>', 0, false );
            $this->a_FCO_DocRecibo = $o_FCO_DocReciboFN->buscarRecibosPorDocRef();

            //$con->commit();

            $this->b_Control = true;
            
        }
        catch( Exception $o_Exception )
        {
            if( $this->getRequestParameter( 'control' ) )
            {
                //$con->rollback();
            }
            $this->s_MensajeError = $o_Exception->getMessage();
        }
        
    }
}