<?php
class GridPromoAction extends wtActions
{
    public function execute()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MKT_PromocionCabFN() );
        
        $o_GridAction->addAssignFilter( "IdItemTipo" );
        $o_GridAction->addConditionFilter( "DescripcionPromo", MKT_PromocionCabFN::DescripcionPromo, "LIKE", "%%s%" );

        $o_GridAction->addMethodDefault( MKT_PromocionCabFN::EstadoPromo, array( 'Condition' => '=', 'Value' => "'PU'" ) );
        $o_GridAction->addMethodDefault( "COALESCE(".MKT_PromocionCabFN::FechaInicio.",'".date("Y-m-d")."')", array( 'Condition' => '<=', 'Value'=> "'".date( "Y-m-d" )."'" ) );
        $o_GridAction->addMethodDefault( "COALESCE(".MKT_PromocionCabFN::FechaFin.",'".date("Y-m-d")."')",    array( 'Condition' => '>=', 'Value'=> "'".date( "Y-m-d" )."'" ) );
        
        //$o_GridAction->addOrder( "Estado", MST_UbicacionFN::Estado );
        
        $o_GridAction->addOrderDefault( MKT_PromocionCabFN::IdPromoCab, true );
        
        $o_GridAction->addRowsToShow( "IdPromoCab", "CodigoPromo", "DescripcionPromo", "FechaInicio", "FechaFin", "CantidadPromo", "PrecioConIGVPromo", "SaldoDisponible" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
}