<?php
class GenerateSunatCPEAction extends wtActions
{
    public function execute()
    {
        $a_Rs = array( "error" => false );

        $id_concat = $this->getRequestParameter( 'id_concat' );

        try
        {
            $a_Ids = explode( "_", $id_concat );
            $IdTipoDocumento = $a_Ids[0];
            $IdCompania      = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];

            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
            if( $o_VTA_DocumentoBN )
            {
                //pr( $o_VTA_DocumentoBN );
                $s_ClienteRUCDNI   = $o_VTA_DocumentoBN->getClienteRUC();
                $s_DocumentoSerie  = $o_VTA_DocumentoBN->getDocumentoSerie();
                $s_DocumentoNumero = $o_VTA_DocumentoBN->getDocumentoNumero();

                //$o_VTA_TipoDocumentoBN = $o_VTA_DocumentoBN->getObjectTipoDocumento();
                //$s_TipoComprobante = $o_VTA_TipoDocumentoBN->getCodigoFiscal();
                $s_TipoComprobante = $o_VTA_DocumentoBN->getCodigoFiscalxTipoDocumento();

                $s_NombreArchivo = $s_ClienteRUCDNI."-".$s_TipoComprobante."-".$s_DocumentoSerie."-".$s_DocumentoNumero;

                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //ahora se pasa a generar el documento .CAB
                $s_NombreArchivoCAB = $s_NombreArchivo.".cab";
                $nameFile           = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."data".DIRECTORY_SEPARATOR.$s_NombreArchivoCAB;
                $archivo            = fopen(  $nameFile, "w" );

                $s_Contenido = "0101|"; //tipo operacion -> TABLA 12: TIPO DE OPERACIÓN
                $s_Contenido .= substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )."|"; //fecha emision
                $s_Contenido .= substr( $o_VTA_DocumentoBN->getFechaDocumento(), 11, 8 )."|"; //hora emision
                $s_Contenido .= substr( $o_VTA_DocumentoBN->getFechaVencimiento(), 0, 10 )."|"; //fecha vencimiento
                $s_Contenido .= "0000|"; //codigo domicilio fiscal
                $s_Contenido .= GSS_ParametroMastFN::getValorPorTipo( "CPE_TIPO_DOC", $o_VTA_DocumentoBN->getClienteTipoDoc() )."|"; //tipo de documento de identidad
                $s_Contenido .= $o_VTA_DocumentoBN->getClienteRUC()."|"; //numero de documento identidad
                $s_Contenido .= $o_VTA_DocumentoBN->getClienteNombre()."|"; //apellidos y nombres o razon social
                $s_Contenido .= GSS_MonedaMastFN::getStaticCodigoFiscal( $o_VTA_DocumentoBN->getMonedaDocumento() )."|"; //tipo de moneda
                $s_Contenido .= $o_VTA_DocumentoBN->getMontoImpuestosDocumento()."|"; //sumatoria tributos
                $s_Contenido .= ( $o_VTA_DocumentoBN->getMontoAfectoDocumento() + $o_VTA_DocumentoBN->getMontoNoAfectoDocumento() )."|"; //total valor venta
                $s_Contenido .= $o_VTA_DocumentoBN->getMontoTotalDocumento()."|"; //total precio venta
                $s_Contenido .= "0|"; //total descuento
                $s_Contenido .= "0|"; //sumatoria otros cargos
                $s_Contenido .= "0|"; //total anticipo
                $s_Contenido .= $o_VTA_DocumentoBN->getMontoTotalDocumento()."|"; //importe total venta
                $s_Contenido .= "2.1|"; //version UBL
                $s_Contenido .= "2.0|\r\n"; //customization

                fwrite( $archivo, $s_Contenido );
                fclose( $archivo );
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //ahora se genera el documento .DET
                $s_NombreArchivoDET = $s_NombreArchivo.".det";
                $nameFile           = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."data".DIRECTORY_SEPARATOR.$s_NombreArchivoDET;
                $archivo            = fopen(  $nameFile, "w" );

                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN ) 
                {
                    $s_Contenido = "NIU|"; //Código de unidad de medida por ítem
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getCantidadPedida()."|"; //Cantidad de unidades por ítem
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getItemCodigo()."|";//Código de producto
                    $s_Contenido .= "-|";//Codigo producto SUNAT
                    $s_Contenido .= str_replace( "&", "Y", trim( utf8_decode( $o_VTA_DocumentoDetalleBN->getDescripcion() ) ) )."|";//Descripción detallada del servicio prestado, bien vendido o cedido en uso, indicando las características.
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getPrecionUnitarioDocumento()."|";//Valor Unitario (cac:InvoiceLine/cac:Price/cbc:PriceAmount)
                    //en si es una sumatoria con otros impuestos, pero como no tenemos, seguimos solo con el igv
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getImpuestoTotalDocumento()."|";//Sumatoria Tributos por item
                    //por ahora lo dejamos asi, hasta asignar por cada item el codigo de impuesto
                    $s_Contenido .= "1000|";//Tributo: Códigos de tipos de tributos IGV(1000 - 1016 - 9995 - 9996 - 9997 - 9998)
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getImpuestoTotalDocumento()."|";//Tributo: Monto de IGV por ítem, pero falta la suma de otros impuestos
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getPrecioSubTotalDocumento()."|";//Tributo: Base Imponible IGV por Item
                    $s_Contenido .= "IGV|";//Tributo: Nombre de tributo por item
                    $s_Contenido .= "VAT|";//Tributo: Código de tipo de tributo por Item
                    $s_Contenido .= "10|";//Tributo: Afectación al IGV por ítem
                    $s_Contenido .= "18|";//Tributo: Porcentaje de IGV

                    /*Tributo ISC (2000)*/
                    $s_Contenido .= "-|";//Tributo ISC: Códigos de tipos de tributos ISC
                    $s_Contenido .= "|";//Tributo ISC: Monto de ISC por ítem
                    $s_Contenido .= "|";//Tributo ISC: Base Imponible ISC por Item
                    $s_Contenido .= "|";//Tributo ISC: Nombre de tributo por item
                    $s_Contenido .= "|";//Tributo ISC: Código de tipo de tributo por Item
                    $s_Contenido .= "|";//Tributo ISC: Tipo de sistema ISC
                    $s_Contenido .= "|";//Tributo ISC: Porcentaje de ISC
                    /*Tributo Otro 9999*/
                    $s_Contenido .= "-|";//Tributo Otro: Códigos de tipos de tributos OTRO
                    $s_Contenido .= "|";//Tributo Otro: Monto de tributo OTRO por iItem
                    $s_Contenido .= "|";//Tributo Otro: Base Imponible de tributo OTRO por Item
                    $s_Contenido .= "|";//Tributo Otro:  Nombre de tributo OTRO por item
                    $s_Contenido .= "|";//Tributo Otro: Código de tipo de tributo OTRO por Item
                    $s_Contenido .= "|";//Tributo Otro: Porcentaje de tributo OTRO por Item

                    //Es el monto correspondiente al precio unitario facturado del bien vendido o servicio vendido. Este monto es la suma total que queda obligado a pagar el adquirente 
                    //o usuario por cada bien o servicio. Esto incluye los tributos (IGV, ISC y otros Tributos) y la deducción de descuentos por ítem.
                    $s_Contenido .= ($o_VTA_DocumentoDetalleBN->getPrecionUnitarioDocumento()*1.18)."|";//Precio de venta unitario(base+igv)
                    //Este elemento es el producto de la cantidad por el valor unitario ( Q x Valor Unitario) y la deducción de los descuentos aplicados a dicho ítem (de existir).  
                    //Este importe no incluye los tributos (IGV, ISC y otros Tributos), los descuentos globales o cargos.
                    $s_Contenido .= $o_VTA_DocumentoDetalleBN->getPrecioSubTotalDocumento()."|"; // round($value['subtotal']-$value['descuento'], 2)."|";//Valor de venta por Item
                    $s_Contenido .= "0.00|\r\n";//Valor REFERENCIAL unitario (gratuitos) 

                    fwrite( $archivo, $s_Contenido );
                }

                fclose( $archivo );
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //ahora se crea el archivo, tributos generales
                $s_NombreArchivoTRI = $s_NombreArchivo.".tri";
                $nameFile           = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."data".DIRECTORY_SEPARATOR.$s_NombreArchivoTRI;
                $archivo            = fopen(  $nameFile, "w" );

                //si tributo es igv
                if( $o_VTA_DocumentoBN->getMontoAfectoDocumento() > 0 )
                {
                    $s_Contenido = "1000|";//Identificador de tributo
                    $s_Contenido .= "IGV|";//Nombre de tributo
                    $s_Contenido .= "VAT|";//Código de tipo de tributo
                    $s_Contenido .= $o_VTA_DocumentoBN->getMontoAfectoDocumento()."|";//Base imponible
                    $s_Contenido .= round( $o_VTA_DocumentoBN->getMontoImpuestosDocumento(), 2 )."|\r\n";//Monto de Tirbuto por ítem
                    fwrite( $archivo, $s_Contenido );
                }

                //configurar mas adelante
                //si tributo es exonerada
                /*if( $comprobante['total_exonerada'] > 0 )
                {
                    $linea = "9997|";//Identificador de tributo
                    $linea .= "EXO|";//Nombre de tributo
                    $linea .= "VAT|";//Código de tipo de tributo
                    $linea .= "{$comprobante['total_exonerada']}|";//Base imponible
                    $linea .= "0|\r\n";//Monto de Tirbuto por ítem
                    fwrite( $archivo, $s_Contenido );
                }*/

                //si tributo es inafecto
                if( $o_VTA_DocumentoBN->getMontoNoAfectoDocumento() > 0 )
                {
                    $s_Contenido = "9998|";//Identificador de tributo
                    $s_Contenido .= "INA|";//Nombre de tributo
                    $s_Contenido .= "FRE|";//Código de tipo de tributo
                    $s_Contenido .= $o_VTA_DocumentoBN->getMontoNoAfectoDocumento()."|";//Base imponible
                    $s_Contenido .= "0|\r\n";//Monto de Tirbuto por ítem
                    fwrite( $archivo, $s_Contenido );
                }

                //configurar mas adelante
                //si tributo es gratuita/exportacion
                /*if( $comprobante['total_gratuita'] > 0 )
                {
                    $linea = "9996|";//Identificador de tributo
                    $linea .= "GRA|";//Nombre de tributo
                    $linea .= "FRE|";//Código de tipo de tributo
                    $linea .= "{$comprobante['total_gratuita']}|";//Base imponible
                    $linea .= "0|\r\n";//Monto de Tirbuto por ítem
                    fwrite( $archivo, $s_Contenido );
                }*/
                fclose( $archivo );
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //ahora DOCUMENTO LEYENDA
                $s_NombreArchivoLEY = $s_NombreArchivo.".ley";
                $nameFile           = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."data".DIRECTORY_SEPARATOR.$s_NombreArchivoLEY;
                $archivo            = fopen(  $nameFile, "w" );

                $a_MontoTotalDocumento = explode( ".", number_format( $o_VTA_DocumentoBN->getMontoTotalDocumento(), 2, ".", "" ) );

                $num = new Numletras();
                $s_Importe_letra = $num->num2letras( $a_MontoTotalDocumento[0], false, false );
                $s_MontoLetras = $s_Importe_letra.' con ' .$a_MontoTotalDocumento[1].'/100 '.GSS_MonedaMastFN::getDescripcionxId( $o_VTA_DocumentoBN->getMonedaDocumento() );

                $s_Contenido = "1000|";//Código de leyenda
                $s_Contenido .= "{$s_MontoLetras}|";//Descripción de leyenda    

                fwrite( $archivo, $s_Contenido );
                fclose( $archivo );
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                pr( $s_MontoLetras );
                
                

                pr( $s_Contenido );

                
                

            }
            else
            {
                throw new Exception( "No se encontro el Documento." );                
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}