<?php
class AsociarSerieAction extends wtActions
{
    public function execute()
    {
        $this->orden_id     = $this->getRequestParameter( 'orden_id' );
        $this->orden_no     = trim( $this->getRequestParameter( 'orden_no' ) );
        $b_Control          = $this->getRequestParameter( 'b_control' );
        $this->cbo_tipo_reg = $this->getRequestParameter( 'cbo_tipo_reg' );
        
        $this->s_MensajeError = "";
        
        try
        {
            myUser::getUser()->validar_session();
            
            //$IdCompania = myUser::getUser()->getIdBusiness();
            
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->orden_id );
            
            if( !$o_VTA_OrdenBN )
            {
                throw new Exception( "No se encontro la Orden de Venta." );
            }
            
            $a_VTA_OrdenDetalle = array();
            $s_MovimientoId     = "";
            $s_MovimientoDetIds = "";
            
            //se busca los detalles
            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $o_VTA_OrdenDetalleFN->setOrdenId( $this->orden_id );
            $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
            
            //ahora se busca el movimiento cabecera de la serie
            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoFN->setTipoMovimiento( "VTA" );
            $o_SR_MovimientoFN->setOperacion( "S" );
            $o_SR_MovimientoFN->setAlmacen( $o_VTA_OrdenBN->getAlmacenCod() );
            $o_SR_MovimientoFN->setReferenciaTipo( "OS" );
            $o_SR_MovimientoFN->setReferenciaNumero( trim( $this->orden_no ) );
            $o_SR_MovimientoFN->setReferenciaFecha( $o_VTA_OrdenBN->getOrdenFecha() );
            $o_SR_MovimientoFN->setEstado( "P" );
            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
            
            if( !$a_SR_Movimiento )
            {
                throw new Exception( "No se encontro el Movimiento de Serie Cabecera." );
            }

            $o_SR_MovimientoBN = $a_SR_Movimiento[0];
            $s_MovimientoId = $o_SR_MovimientoBN->getMovimientoId();

            //ahora se busca los ids de los detalles
            $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
            $o_SR_MovimientoDetalleFN->setMovimientoId( $s_MovimientoId );
            $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
            if( $a_SR_MovimientoDetalle )
            {
                $a_IdDet = array();
                foreach ( $a_SR_MovimientoDetalle as $o_SR_MovimientoDetalleBN )
                {
                    $a_IdDet[] = $o_SR_MovimientoDetalleBN->getMovimientoDetalleId();
                }
                $s_MovimientoDetIds = implode( ",", $a_IdDet );
            }

            if( $b_Control )
            {
                //identifico que procedimiento se requiere
                $tipo_proc = $this->getRequestParameter( 'tipo_proc' );
                
                //se procede en registrar la serie escaneada
                if( $tipo_proc == "registrar_serie" )
                {
                    $cbo_tipo_reg = $this->getRequestParameter( 'cbo_tipo_reg' );
                    
                    /*if( $cbo_tipo_reg == "S" ) //solo registro por serie
                    {*/
                        $txt_serie = trim( $this->getRequestParameter( 'txt_serie' ) );
                        
                        $a_Series = preg_split( "/[\s,]+/", $txt_serie );
                        
                        foreach ( $a_Series as $i_Key => $txt_serie )
                        {
                            if( $txt_serie )
                            {
                                if( $o_SR_MovimientoBN )
                                {
                                    //AQUI REGISTRO LA PRE - SERIE
                                    $o_SR_PreSerieBN = new SR_PreSerieBN();
                                    $o_SR_PreSerieBN->setMovimientoId( $s_MovimientoId );
                                    //$o_SR_PreSerieBN->setProductoId( $this->CodItem );
                                    $o_SR_PreSerieBN->setSerieNumero( $txt_serie );
                                    $o_SR_PreSerieBN->setOperacion( "S" );
                                    $o_SR_PreSerieBN->setAlmacen( $o_VTA_OrdenBN->getAlmacenCod() );
                                    $o_SR_PreSerieBN->setReferenciaTipo( "OS" );
                                    $o_SR_PreSerieBN->setReferenciaNumero( $this->orden_no );
                                    //$o_SR_PreSerieBN->setReferenciaCantidadLimite( $this->CanDeta ); //cantidad maxima de referencia
                                    
                                    $o_SerieDetalleBL = new SerieDetalleBL();
                                    $o_SerieDetalleBL->registrarPreSerie( $o_SR_PreSerieBN );
                                }
                            }
                        }
                    //}
                }
                if( $tipo_proc == "eliminar_serie" )
                {
                    $id_preserie_esc = $this->getRequestParameter( 'id_preserie' );
                    $cod_item = $this->getRequestParameter( 'cod_item' );
                    
                    $a_Ids = explode( "_", $id_preserie_esc );
                    $i_MovimientoDet = intval( $a_Ids[0] );
                    $i_IdPreSerie    = intval( $a_Ids[1] );
                    
                    $o_SR_PreSerieEscaneoBN = new SR_PreSerieEscaneoBN();
                    $o_SR_PreSerieEscaneoBN->setMovimientoId( $s_MovimientoId );
                    $o_SR_PreSerieEscaneoBN->setMovimientoDetalleId( $i_MovimientoDet );
                    $o_SR_PreSerieEscaneoBN->setSerieId( $i_IdPreSerie );
                    $o_SR_PreSerieEscaneoBN->setProductoId( $cod_item );
                    $o_SR_PreSerieEscaneoBN->setOperacion( "S" );
                    
                    $o_SerieDetalleBL = new SerieDetalleBL();
                    $o_SerieDetalleBL->eliminarPreSerieEscaneo( $o_SR_PreSerieEscaneoBN );
                }
                if( $tipo_proc == "eliminar_todo_serie" )
                {
                    $o_SR_PreSerieEscaneoBN = new SR_PreSerieEscaneoBN();
                    $o_SR_PreSerieEscaneoBN->setMovimientoId( $s_MovimientoId );
                    $o_SR_PreSerieEscaneoBN->setOperacion( "S" );
                    
                    $o_SerieDetalleBL = new SerieDetalleBL();
                    $o_SerieDetalleBL->eliminarPreSerieEscaneo( $o_SR_PreSerieEscaneoBN );
                }
            }
            
        }
        catch ( Exception $o_Exception )
        {
            $this->s_MensajeError = $o_Exception->getMessage();
        }
        
        $this->a_VTA_OrdenDetalle = $a_VTA_OrdenDetalle;

        //ahora se busca las series asociadas
        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
        $o_SR_PreSerieEscaneoFN->setReferenciaTipo( "OS" );
        $o_SR_PreSerieEscaneoFN->setReferenciaNumero( $this->orden_no );
        $o_SR_PreSerieEscaneoFN->addOrderBy( SR_PreSerieEscaneoFN::ProductoId );
        $o_SR_PreSerieEscaneoFN->addOrderBy( SR_PreSerieEscaneoFN::Fecha );
        //$o_SR_PreSerieEscaneoFN->addCondition( SR_PreSerieEscaneoFN::MovimientoDetalleId, "IN", "($s_MovimientoDetIds)", false );
        //$o_SR_PreSerieEscaneoFN->setProductoId( $this->CodItem );
        $this->a_SR_PreSerieEscaneo = $o_SR_PreSerieEscaneoFN->select();
        
    }
}