<?php
class AddeditfcoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->b_Control         = false;
        $this->s_MensajeError    = "";
        $this->s_NumeroDocumento = $this->getRequestParameter( 'idnumdoc' );
        $this->i_IdDocRecibo     = intval( $this->getRequestParameter( 'iddocrecibo' ) );
        $this->i_IdAplicacion    = intval( $this->getRequestParameter( 'idaplicacion' ) );

        $this->s_Fuente     = $this->getRequestParameter( 'fuente' );
        $this->s_TipoProc   = $this->getRequestParameter( 'tipoproc' );

        $this->IdMoneda     = $this->getRequestParameter( 'IdMoneda' );
        $this->IdTipoPago   = $this->getRequestParameter( 'IdTipoPago' );
        $this->Monto        = floatval( $this->getRequestParameter( 'Monto' ) );
        //$this->Monto        = ( 12/3.6 );
        $this->ReciboNumero = $this->getRequestParameter( 'ReciboNumero' );
        $this->ReciboFecha  = is_null( $this->getRequestParameter( 'ReciboFecha' ) ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'ReciboFecha' );

        //pr( bcadd( $this->Monto, 0, 16), false );
        try
        {
            $con = Conexion::getConexion();
            $con->begin();

            myUser::getUser()->validar_session();

            //para recuperar la moneda del sistema
            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $this->o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );

            //el tipo de cambio
            $this->f_TipoCob = GSS_TipoCambioFN::getStaticTipoCambioCobranza(); //EN EL FUTURO PODRIA SER EL TIPO DE CAMBIO GUARDADO EN LA ORDEN CABECERA
            //$this->f_TipoCon = GSS_TipoCambioFN::getStaticTipoCambioCompra(); //EN EL FUTURO PODRIA SER EL TIPO DE CAMBIO GUARDADO EN LA ORDEN CABECERA

            $f_MontoTotal = 0;

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //recupero el object por el documento de venta o otras clases
            $b_ControlOrden = false;
            $b_ControlDocu  = false;
            switch ( $this->s_Fuente ) 
            {
                case 'ORD':
                    $s_OrdenNum = $this->getRequestParameter( 'ord_num' );

                    $this->VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_OrdenNum );
                    $f_MontoTotal = $this->VTA_OrdenBN->getOrdenNeto();

                    //ahora recupero la moneda de la Orden de Venta
                    $this->s_DocMonedaCod = $this->VTA_OrdenBN->getMonedaCod();
                    
                    $i_IdPersona         = intval( $this->VTA_OrdenBN->getClienteId() );
                    $s_TipoDocCliente    = $this->VTA_OrdenBN->getClienteDocCod();
                    $s_NumTipoDocCliente = $this->VTA_OrdenBN->getClienteDocNum();
                    $s_NombreCliente     = $this->VTA_OrdenBN->getClienteNombre();
                    $s_CodVendedor       = $this->VTA_OrdenBN->getVendedorOrden();

                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //ahora recuperamos las aplicaciones relacionados y hacer la resta
                    $f_MontoAplicado = 0;
                    $o_FCO_OrdenReciboFN = new FCO_OrdenReciboFN();
                    $o_FCO_OrdenReciboFN->setOrdenId( $this->s_NumeroDocumento );
                    $a_FCO_OrdenRecibo = $o_FCO_OrdenReciboFN->select();
                    foreach ( $a_FCO_OrdenRecibo as $o_FCO_OrdenReciboBN ) 
                    {
                        if( $this->s_TipoProc == "edit" )
                        {
                            if( $o_FCO_OrdenReciboBN->getIdDocRecibo() == $this->i_IdDocRecibo )
                            {
                                continue;
                            }
                        }
                        if( $this->s_DocMonedaCod == "LO" )
                        {
                            //moneda nacional
                            $f_MontoAplicado = $o_FCO_OrdenReciboBN->getMontoOrdenMN() + $f_MontoAplicado;
                        }
                        else
                        {
                            //moneda extrangera
                            $f_MontoAplicado = $o_FCO_OrdenReciboBN->getMontoOrdenME() + $f_MontoAplicado;
                        }
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    $b_ControlOrden = true;
                break;
                default:
                    $this->o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->s_NumeroDocumento );
                    $f_MontoTotal = $this->o_VTA_DocumentoBN->getMontoTotal();

                    //ahora recupero la moneda de la Orden de Venta
                    $this->s_DocMonedaCod = $this->o_VTA_DocumentoBN->getMonedaDocumento();

                    $i_IdPersona         = intval( $this->o_VTA_DocumentoBN->getClienteNumero() );
                    $s_TipoDocCliente    = $this->o_VTA_DocumentoBN->getClienteTipoDoc();
                    $s_NumTipoDocCliente = $this->o_VTA_DocumentoBN->getClienteRUC();
                    $s_NombreCliente     = $this->o_VTA_DocumentoBN->getClienteNombre();
                    $s_CodVendedor       = $this->o_VTA_DocumentoBN->getVendedor();

                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //ahora recuperamos las aplicaciones relacionados y hacer la resta
                    $f_MontoAplicado = 0;
                    $o_FCO_AplicacionFN = new FCO_AplicacionFN();
                    $o_FCO_AplicacionFN->setIdDocNumRef( $this->s_NumeroDocumento );
                    $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
                    foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
                    {
                        if( $this->s_TipoProc == "edit" )
                        {
                            if( $o_FCO_AplicacionBN->getIdDocRecibo() == $this->i_IdDocRecibo )
                            {
                                continue;
                            }
                        }
                        $f_MontoAplicado = $o_FCO_AplicacionBN->getMontoAplicado() + $f_MontoAplicado;
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    $b_ControlDocu = true;
                break;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $this->f_MontoResta = $f_MontoTotal - $f_MontoAplicado;
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se recupera list para moneda
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();

            //el tipo de cambio del dia
            $this->f_TipodeCambio   = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$this->f_TipodeCambio )
            {
                throw new Exception( "El Tipo de Cambio no esta Registrado." );
            }

            //se recupera la moneda por defecto para el sistema
            $this->s_MonedaSistema  = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //procedimiento para la edicion del metodo de pago
            if( $this->i_IdDocRecibo && !$this->getRequestParameter( 'Control' ) && $this->s_TipoProc == "edit" )
            {
                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $this->i_IdDocRecibo );

                $this->IdTipoPago   = $o_FCO_DocReciboBN->getIdTipoPago();
                $this->Monto        = $o_FCO_DocReciboBN->getMonto();
                $this->f_MontoResta = $o_FCO_DocReciboBN->getMonto();
                $this->ReciboNumero = $o_FCO_DocReciboBN->getReciboNumero();
                $this->ReciboFecha  = substr( $o_FCO_DocReciboBN->getReciboFecha(), 0, 10 );

                $this->s_DocMonedaCod = $o_FCO_DocReciboBN->getIdMoneda();
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //procedimiento que se ejecuta por el submit
            if( $this->getRequestParameter( 'Control' ) )
            {
                //tipo de cambio 3.5
                if( $this->s_MonedaSistema == "EX" ) //moneda del sistema -> 10$
                {
                    if( $this->s_DocMonedaCod == "EX" ) //modeda de la orden de venta -> sigo viendo 10$
                    {
                        if( $this->IdMoneda == "LO" ) //se quiere pagar en soles, aqui ya se multiplico 35 soles
                        {
                            $f_MontoSoles = $this->Monto;
                            $f_MontoDolar = $this->Monto / $this->f_TipodeCambio; //regresr a su estado normal se divide
                        }
                        if( $this->IdMoneda == "EX" ) //se quiere pagar en dolares, no se hizo nada sigo viendo 10$
                        {
                            $f_MontoSoles = $this->Monto * $this->f_TipodeCambio; //se multiplica para pagar 35 soles
                            $f_MontoDolar = $this->Monto;
                        }
                    }
                    if( $this->s_DocMonedaCod == "LO" ) //moneda de la orden de venta, aqui se multiplica los items 35 soles
                    {
                        //todos los productos se convirtio a soles osea se multiplico
                        if( $this->IdMoneda == "LO" ) //se quiere pagar en soles
                        {
                            $f_MontoSoles = $this->Monto;
                            $f_MontoDolar = $this->Monto / $this->f_TipodeCambio; //lo divido para pagar 10$
                        }
                        if( $this->IdMoneda == "EX" ) //se quiere pagar en soles, se dividio para pagar 10$
                        {
                            $f_MontoSoles = $this->Monto * $this->f_TipodeCambio; //multiplico para pagar en soles 35
                            $f_MontoDolar = $this->Monto;
                        }
                    }
                }
                
                if( $this->s_MonedaSistema == "LO" ) //moneda del sistema 35 S/
                {
                    if( $this->s_DocMonedaCod == "EX" ) //moneda de la orden de venta -> Divido 10 $
                    {
                        if( $this->IdMoneda == "LO" ) //se quiere pagar en soles -> multiplico nuevamente para pagar 35 soles
                        {
                            $f_MontoSoles = $this->Monto; //aqui ya viene
                            $f_MontoDolar = $this->Monto / $this->f_TipodeCambio; //para pagar 10$
                        }
                        if( $this->IdMoneda == "EX" ) //sigo viendo 10$
                        {
                            $f_MontoSoles = $this->Monto * $this->f_TipodeCambio; //para pagar 35 soles
                            $f_MontoDolar = $this->Monto;
                        }
                    }
                    if( $this->s_DocMonedaCod == "LO" ) //modeda de la orden de venta -> sigo viendo 35 soles
                    {
                        //todos los productos se convirtio a soles osea se multiplico
                        if( $this->IdMoneda == "LO" ) //se quiere pagar en soles
                        {
                            $f_MontoSoles = $this->Monto;
                            $f_MontoDolar = $this->Monto / $this->f_TipodeCambio; //se paga 10 $
                        }
                        if( $this->IdMoneda == "EX" ) //se quiere pagar en soles, entonces divido para pagar 10 $
                        {
                            $f_MontoSoles = $this->Monto * $this->f_TipodeCambio; //se multiplica para pagar 35 soles
                            $f_MontoDolar = $this->Monto;
                        }
                    }
                }

                if( $this->Monto <= 0 )
                {
                    throw new Exception( "Debe de ingresar un monto valido." );
                }
                if( $this->s_DocMonedaCod == "LO" ) //segun la moneda de la orden - soles
                {
                    //moneda local
                    if( $f_MontoSoles > $this->f_MontoResta )
                    {
                        throw new Exception( "El monto ingresado, tiene que cubrir el total de la venta." );
                    }
                }
                else  //segun la moneda de la orden - dolares
                {
                    //moneda extrangera
                    if( $f_MontoDolar > $this->f_MontoResta )
                    {
                        throw new Exception( "El monto ingresado, tiene que cubrir el total de la venta." );
                    }
                }

                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //validacion por duplicidad de metodo de pago
                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                $o_FCO_DocReciboFN->setIdDocNumRef( $this->s_NumeroDocumento );
                $o_FCO_DocReciboFN->setFlujoEstado( "PE" );
                $o_FCO_DocReciboFN->setIdTipoPago( $this->IdTipoPago );
                $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::Saldo, '>', 0, false );
                if( $this->s_TipoProc == "edit" )
                {
                    $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::IdDocRecibo, 'NOT IN', '( '.$this->i_IdDocRecibo.' )', false );
                }
                //$o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::ReciboFecha, '>=', date( "Y-m-d" )." 00:00:00" );
                //$o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::ReciboFecha, '<=', date( "Y-m-d" )." 23:59:59" );
                if( $b_ControlOrden )
                {
                    $a_FCO_DocRecibo = $o_FCO_DocReciboFN->buscarOrdenRecibosPorDocRef();
                }
                if( $b_ControlDocu )
                {
                    $a_FCO_DocRecibo = $o_FCO_DocReciboFN->buscarRecibosPorDocRef();
                }
                if( count( $a_FCO_DocRecibo ) > 0 )
                {
                    throw new Exception( "Actualmente ya existe Metodo de Pago seleccionado, se le recomienda editar el Monto de Aplicacion." );
                }
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                

                $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
                $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $this->IdTipoPago );

                $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
                $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
                $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

                //submit
                if( $this->s_TipoProc == "nvo" )
                {
                    $i_IdDocRecibo = FCO_DocReciboDP::recuperarId();
                }
                else
                {
                    $i_IdDocRecibo = $this->i_IdDocRecibo;
                }

                //se recupera info de la moneda seleccionada
                $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
                $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->IdMoneda );

                $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
                $o_FCO_DocReciboDP->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
                $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
                
                $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
                $o_FCO_DocReciboDP->setTipoCambio( $this->f_TipodeCambio );
                
                $o_FCO_DocReciboDP->setMonto( $this->Monto );
                $o_FCO_DocReciboDP->setSaldo( $this->Monto );
                
                $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
                $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );

                if( $i_IdTipoPago == 1 )
                {
                    $this->ReciboNumero = ( string ) $i_IdDocRecibo;
                }
                $o_FCO_DocReciboDP->setReciboNumero( $this->ReciboNumero );

                if( $this->s_TipoProc == "nvo" )
                {
                    //se hace un insert
                    $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                    $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
                    $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
                    $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                    $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
                    $o_FCO_DocReciboDP->setReciboFecha( $this->ReciboFecha." ".date( "H:i:s" ) );
                    $o_FCO_DocReciboDP->setFlujoEstado( "PE" ); //PE NDIENTE - AP ROBADO - REC HAZADO
                    $o_FCO_DocReciboDP->setEstado( "AC" ); //AC TIVO - AN ULADO
                    $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_FCO_DocReciboDP->save();
                }
                else
                {
                    //se hace un update
                    $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                    $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_FCO_DocReciboDP->update();
                }

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //recupero el id de caja y el turno
                $o_FCO_CierreFN = new FCO_CierreFN();
                $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
                $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
                $a_FCO_Cierre = $o_FCO_CierreFN->select();
                if( !$a_FCO_Cierre )
                {
                    throw new Exception( "No se aperturo ninguna Caja." );
                }
                if( count( $a_FCO_Cierre ) > 1 )
                {
                    throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
                }
                if( count( $a_FCO_Cierre ) == 1 )
                {
                    $o_FCO_CierreBN = $a_FCO_Cierre[0];
                    $IdCaja  = $o_FCO_CierreBN->getIdCaja();
                    $IdTurno = $o_FCO_CierreBN->getIdTurno();
                }

                if( trim( $this->ReciboNumero ) == "" )
                {
                    throw new Exception( "El numero de Recibo no debe de estar vacio." );
                }
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                //ahora se hace el cambio para generar el recibo asociado a ordenes
                if( $b_ControlOrden )
                {
                    if( $this->s_TipoProc == "nvo" )
                    {
                        //insert
                        $o_FCO_OrdenReciboDP = new FCO_OrdenReciboDP();
                        $o_FCO_OrdenReciboDP->setOrdenId( $this->VTA_OrdenBN->getOrdenId() );
                        $o_FCO_OrdenReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_OrdenReciboDP->setOrdenNum( $this->VTA_OrdenBN->getOrdenNum() );
                        $o_FCO_OrdenReciboDP->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
                        $o_FCO_OrdenReciboDP->setTipoCambio( $this->f_TipodeCambio );
                        $o_FCO_OrdenReciboDP->setMontoOrden( $this->Monto );
                        $o_FCO_OrdenReciboDP->setMontoOrdenMN( $f_MontoSoles );
                        $o_FCO_OrdenReciboDP->setMontoOrdenME( $f_MontoDolar );
                        $o_FCO_OrdenReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_OrdenReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_FCO_OrdenReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_OrdenReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_FCO_OrdenReciboDP->save();
                    }
                    else
                    {
                        //update
                        $o_FCO_OrdenReciboDP = new FCO_OrdenReciboDP();
                        $o_FCO_OrdenReciboDP->setOrdenId( $this->VTA_OrdenBN->getOrdenId() );
                        $o_FCO_OrdenReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_OrdenReciboDP->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
                        $o_FCO_OrdenReciboDP->setTipoCambio( $this->f_TipodeCambio );
                        $o_FCO_OrdenReciboDP->setMontoOrden( $this->Monto );
                        $o_FCO_OrdenReciboDP->setMontoOrdenMN( $f_MontoSoles );
                        $o_FCO_OrdenReciboDP->setMontoOrdenME( $f_MontoDolar );
                        $o_FCO_OrdenReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_OrdenReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_FCO_OrdenReciboDP->update();
                    }
                }

                //si el recibo esta en un estado pendiente, se puede eliminar la aplicacion actual 
                //para insertar la aplicacion con los nuevos cambios
                if( $b_ControlDocu )
                {
                    if( $this->s_TipoProc == "nvo" )
                    {
                        //ahora se registra la aplicacion
                        $i_IdAplicacion = FCO_AplicacionDP::recuperarId();
                        $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                        $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
                        $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                        $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_FCO_AplicacionDP->setIdCaja( $IdCaja );
                        $o_FCO_AplicacionDP->setIdTurno( $IdTurno );
                        $o_FCO_AplicacionDP->setIdMoneda( "LO" );
                        $o_FCO_AplicacionDP->setMonedaDes( "SOLES" );

                        $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
                        $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
                        $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
                        $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO

                        $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
                        $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
                        $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                        $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );
                        
                        $o_FCO_AplicacionDP->setReciboNumero( $this->ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre

                        $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
                        //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante

                        $o_FCO_AplicacionDP->setIdDocNumRef( $this->o_VTA_DocumentoBN->getNumeroDocumento() );
                        $o_FCO_AplicacionDP->setCodDocRef( $this->o_VTA_DocumentoBN->getDocumentoCod() );
                        $o_FCO_AplicacionDP->setSerieNumeroDocRef( $this->o_VTA_DocumentoBN->getDocumentoSerieNumero() );
                        $o_FCO_AplicacionDP->setMontoTotalDocRef( $this->o_VTA_DocumentoBN->getMontoTotal() );
                        $o_FCO_AplicacionDP->setFechaDocRef( $this->o_VTA_DocumentoBN->getFechaDocumento() );
                        $o_FCO_AplicacionDP->setIdMonedaRef( $this->o_VTA_DocumentoBN->getMonedaDocumento() );
                        $o_FCO_AplicacionDP->setTipoCambioRef( $this->o_VTA_DocumentoBN->getTipodeCambio() );
                        $o_FCO_AplicacionDP->setCodVendedorRef( $this->o_VTA_DocumentoBN->getVendedor() );
                        $o_FCO_AplicacionDP->setIdAlmacenRef( $this->o_VTA_DocumentoBN->getIdAlmacen() );

                        $o_FCO_AplicacionDP->setTipoCambio( 1 ); //POR DEFECTO 1 POR SER EN SOLES
                        $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
                        $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setMontoAplicado( $this->Monto ); 
                        $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoSoles );
                        $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoDolar );
                        $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
                        $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_PENDINTE ); //PE NDIENTE - AP LICADO - AN ULADO
                        $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_FCO_AplicacionDP->save();
                    }
                    else
                    {
                        $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                        $o_FCO_AplicacionDP->setIdAplicacion( $this->i_IdAplicacion );
                        $o_FCO_AplicacionDP->getReciboNumero( $this->ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre
                        $o_FCO_AplicacionDP->setMontoAplicado( $this->Monto );
                        $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoSoles );
                        $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoDolar );
                        $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_FCO_AplicacionDP->update();
                    }
                }

                $con->commit();

                $this->b_Control = true;
            }
        }
        catch( Exception $o_Exception )
        {
            if( $this->getRequestParameter( 'Control' ) )
            {
                $con->rollback();
            }
            $this->s_MensajeError = $o_Exception->getMessage();
        }
    }
}