<?php
class cpeActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Facturacion Electonica";

        $this->a_Estados = VTA_FacturacionElectronicaBN::getArrayEstados();
        $this->a_EstadosWeb = VTA_DocumentoBN::getArrayEstados();
        unset( $this->a_EstadosWeb['PR'] );

        //TIPO DE DOCUMENTO
        $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
        $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_VTA_TipoDocumento = $o_GSS_SucursalDocumentoFN->recuperarTipoDocumento();
        //unset( $this->a_VTA_TipoDocumento[3] );
        ///////////////////
    }

    private function initialGridAction()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_FacturacionElectronicaFN() );

        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addAssignFilter( "EstadoWeb" );
        $o_GridAction->addAssignFilter( "Serie" );
        //$o_GridAction->addAssignFilter( "Numero" );
        $o_GridAction->addAssignFilter( "Tipo" );
        $o_GridAction->addAssignFilter( "AceptadaxSunat" );
        $o_GridAction->addAssignFilter( "AnuAceptadaPorSunat" );

        if( !myUser::getUser()->hasGlobalAccess() )
        {
            $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
            $o_GridAction->addAssignFilter( "IdCompania" );
        }
        else
        {
            $o_GridAction->addAssignFilter( "IdCompania" );
        }

        $o_GridAction->addConditionFilter( "FechaDocumento1", VTA_FacturacionElectronicaFN::FechaEmision,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", VTA_FacturacionElectronicaFN::FechaEmision,  "<=", '23:59:59' );

        $o_GridAction->addConditionFilter( "Numero", VTA_FacturacionElectronicaFN::Numero, "LIKE", "%%s%" );

        $o_GridAction->addOrderDefault( VTA_FacturacionElectronicaFN::FactElecId, false );

        return $o_GridAction;
    }

    public function executeGrid()
    {
        $o_GridAction = $this->initialGridAction();

        $o_GridAction->addRowsToShow
        ( 
            "FactElecId", "TipoComprobanteDesc", "SerieNumero", "FechaDocumentoRec", "ClienteNom", "MonedaDesc", "MontoTotal", "EstadoDesc", "EstadoWebDesc",
            "AceptadaxSunat", "PDFResult", "XMLResult", "CDRResult", "AnuAceptadaPorSunat", "IdCompania", "Tipo"
        );
    
        $o_GridAction->setNumberRecordsShow( 100 );
    
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson            = array();
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
}