<?php
class ProcAPISunatAction extends wtActions
{
    public $ventas_model;
    public $empresas_model;
    public $venta_detalles_model;
    public $cuotas_model;
    public $variables_diversas_model;

    /**
     * @var VTA_FacturacionElectronicaBN
     */
    public $o_VTA_FacturacionElectronicaBN;

    /**
     * @var VTA_DocumentoBN
     */
    public $o_VTA_DocumentoBN;

    public function __construct()
    {
        $this->ventas_model         = iSunatCPE::ventas_model();
        $this->empresas_model       = iSunatCPE::empresas_model();
        $this->venta_detalles_model = iSunatCPE::venta_detalles_model();
        $this->cuotas_model         = iSunatCPE::cuotas_model();
        $this->variables_diversas_model = iSunatCPE::variables_diversas_model();
    }

    public function execute()
    {
        $i_IdFact = null;
        if( $this->getRequestParameter( 'id' ) )
        {
            $i_IdFact = intval( $this->getRequestParameter( 'id' ) );
        }

        $this->externo          = $this->getRequestParameter( 'externo' );
        $this->recargarExterno  = false;

        $b_ControlAnulado = false;
        $this->mensaje_error = "";
        $this->o_VTA_FacturacionElectronicaBN = new VTA_FacturacionElectronicaBN();

        try
        {
            myUser::getUser()->validar_session();

            if( !$i_IdFact )
            {
                throw new Exception( "El Id de Comprobante es importante." );
            }

            //buscamos en la bandeja
            $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
            $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $i_IdFact );
            $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;

            //ahora buscamos el documento
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );
            $this->o_VTA_DocumentoBN = $o_VTA_DocumentoBN;

            $o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania( myUser::getUser()->getIdCompania() );

            //se pregunta si esta anulado, si es true, tiene un procedimiento diferente
            //pr( "if( {$o_VTA_DocumentoBN->getEstado()} == ".VTA_DocumentoBN::ESTADO_ANULADO." )" ); exit;
            if( $o_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_ANULADO )
            {
                //
            }

            if( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" )
            {

                if( !$o_VTA_FacturacionElectronicaBN->getCDRResult() )
                {
                    //para boletas no es muy importante, ademas es por lote, varias boletas
                    //puede estar en un cdr
                    //facturas es de uno a uno en cdr
                    if( $o_VTA_FacturacionElectronicaBN->getTipo() != "BV" )
                    {
                        $this->mensaje_error = "";
                        $this->findDocument( $o_VTA_FacturacionElectronicaBN );
                    }
                }
                $this->recargarExterno  = false;
                $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                return ViewResponse::SUCCESS;
            }

            if( $o_VTA_FacturacionElectronicaBN->getEnlace() && $o_VTA_FacturacionElectronicaBN->getCodigoHashQR() )
            {
                //en este procedimiento indica que ya se envio al proveedor y que falta preguntar si la sunat ua acepto
                $this->mensaje_error = "";
                $this->findDocument( $o_VTA_FacturacionElectronicaBN );
                $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                return ViewResponse::SUCCESS;
            }

            //http://localhost/monstruo6.0/index.php/ventas/enviar_sunat/286/20604051984-03-B001-10
            //AHORA PREGUNTAMOS SI YA SE ENCUENTA CREADO EL XML
            pr( $o_GSS_CompaniaBN->getRuc() );
            pr( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal() );
            pr( $o_VTA_FacturacionElectronicaBN->getSerie() );
            pr( intval( $o_VTA_FacturacionElectronicaBN->getNumero() ) );

            $venta_id = $i_IdFact;

            $nombre_archivo = $o_GSS_CompaniaBN->getRuc()."-".$o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal()."-".$o_VTA_FacturacionElectronicaBN->getSerie()."-".intval( $o_VTA_FacturacionElectronicaBN->getNumero() );
            //$ruta_zip = FCPATH."files/facturacion_electronica/FIRMA/".$nombre_archivo.".xml";
            $ruta_zip = SF_ROOT_DIR."/web/cpe/firma/".$nombre_archivo.".xml";
            //unlink( $ruta_zip );
            if( file_exists( $ruta_zip ) )
            {
                $empresa = $this->empresas_model->query_standar();
                $venta = $this->ventas_model->query_cabecera( $venta_id );
                $this->ws_sunat( $venta_id, $empresa, $nombre_archivo );
            }
            else
            {
                $rpta = $this->crear_xml( $venta_id );
                $this->firmar_xml( $rpta['nombre_archivo'].".xml", $rpta['modo'] );
                $this->ws_sunat( $rpta['venta_id'], $rpta['empresa'], $rpta['nombre_archivo'] );
            }

            

        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception );
            $this->mensaje_error = $o_Exception->getMessage();
        }
    }

    public function ws_sunat($venta_id, $empresa, $nombre_archivo)
    {
        //enviar a Sunat
        //cod_1: Select web Service: 1 factura, boletas --- 9 es para guias
        //cod_2: Entorno:  0 Beta, 1 Produccion
        //cod_3: ruc
        //cod_4: usuario secundario USU(segun seha beta o producción)
        //cod_5: usuario secundario PASSWORD(segun seha beta o producción)
        //cod_6: Accion:   1 enviar documento a Sunat --  2 enviar a anular  --  3 enviar ticket
        //cod_7: serie de documento
        //cod_8: numero ticket
        $user_sec_usu = ($empresa['modo'] == 1) ? $empresa['usu_secundario_produccion_user'] : $empresa['usu_secundario_prueba_user'];
        $user_sec_pass = ($empresa['modo'] == 1) ? $empresa['usu_secundario_produccion_password'] : $empresa['usu_secundario_prueba_passoword'];
        //$url = base_url()."ws_sunat/index.php?numero_documento=".$nombre_archivo."&cod_1=1&cod_2=".$empresa['modo']."&cod_3=".$empresa['ruc']."&cod_4=".$user_sec_usu."&cod_5=".$user_sec_pass."&cod_6=1";
        $url = base_url()."services/ws_sunat/index.php?numero_documento=".$nombre_archivo."&cod_1=1&cod_2=".$empresa['modo']."&cod_3=".$empresa['ruc']."&cod_4=".$user_sec_usu."&cod_5=".$user_sec_pass."&cod_6=1";
        //echo $url; exit;

        $data = file_get_contents( $url );
        $info = json_decode( $data, TRUE );

        $info['enlace']     = "$url";
        $info['sunat_note'] = "$nombre_archivo";

        pr( $data );
        pr( $info );

        $respuesta_codigo = '';
        $respuesta_mensaje = '';
        if( $info['error_existe'] == 0 )
        {
            $respuesta_sunat = $this->leerRespuestaSunat( $nombre_archivo.".xml" );
            pr( $respuesta_sunat );
            if( $respuesta_sunat != null )
            {
                /*$this->ventas_model->modificar($venta_id, $respuesta_sunat);
                if($respuesta_sunat['respuesta_sunat_codigo'] == '0')
                    $this->ventas_model->modificar($venta_id, array('estado_operacion' => 1));*/
                $info['sunat_soap_error']       = "";
                $info['aceptada_por_sunat']     = "SI";
                $info['sunat_responsecode']     = $respuesta_sunat['respuesta_sunat_codigo'];
                $info['sunat_description']      = $respuesta_sunat['respuesta_sunat_descripcion'];
                $info['enlace_del_pdf']         = base_url()."vta.php/pro/printPDF/i_Id/".$this->o_VTA_DocumentoBN->getIdConcat();
                $info['enlace_del_xml']         = base_url()."web/cpe/firma/".$nombre_archivo.".xml";
                //$info['enlace_del_cdr']       = base_url()."web/cpe/firma/R-".$nombre_archivo.".zip";
                $info['enlace_del_cdr']         = base_url()."services/ws_sunat/R-".$nombre_archivo.".xml";
                $info['codigo_hash']            = $respuesta_sunat['respuesta_sunat_hash'];
                $info['cadena_para_codigo_qr']  = $this->o_VTA_DocumentoBN->getCodigoQR()."|".$info['codigo_hash']."|";

                $this->updateDocument( $info, $this->o_VTA_FacturacionElectronicaBN );
            }
            else
            {
                //algun error
                $info['error_existe'] = 1;
                $info['error_mensaje'] = "Se encontro un problema.";

                $this->updateDocument( $info, $o_VTA_FacturacionElectronicaBN );
            }
            //var_dump($respuesta_sunat);
            $respuesta_mensaje = ($respuesta_sunat != null) ? $respuesta_sunat['respuesta_sunat_descripcion']: '';
            $respuesta_codigo = ($respuesta_sunat != null) ? $respuesta_sunat['respuesta_sunat_codigo']: '';
        }
        else
        {
            $info['error_existe'] = 1;

            //algun error o respuesta con error
            $this->updateDocument( $info, $o_VTA_FacturacionElectronicaBN );
        }

        $jsondata = array(
            'success'       =>  true,
            'codigo'        =>  $respuesta_codigo,
            'error_existe'  =>  $info['error_existe'],
            'message'       =>  $respuesta_mensaje.$info['error_mensaje']
        );


        //echo json_encode($jsondata, JSON_UNESCAPED_UNICODE);
    }

    private function updateDocument( $a_respuesta, $o_VTA_FacturacionElectronicaBN )
    {
        $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
        $o_VTA_FacturacionElectronicaDP->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
        $o_VTA_FacturacionElectronicaDP->setEstado( "E" );

        if( $a_respuesta['error_existe'] )
        {
            $o_VTA_FacturacionElectronicaDP->setEstado( "X" );
            $o_VTA_FacturacionElectronicaDP->setErrors( addslashes( $a_respuesta['error_mensaje'] ) );
            $o_VTA_FacturacionElectronicaDP->setCodigoError("" );
            $o_VTA_FacturacionElectronicaDP->setAceptadaxSunat( "NO" );
            $this->mensaje_error = "[ ".addslashes( $a_respuesta['error_mensaje'] )." ]";
        }
        else
        {
            $o_VTA_FacturacionElectronicaDP->setErrors( "" );
            $o_VTA_FacturacionElectronicaDP->setCodigoError( "" );
            $o_VTA_FacturacionElectronicaDP->setCodigoErrorDesc( "" );
            $o_VTA_FacturacionElectronicaDP->setEnlace( $a_respuesta['enlace'] );
            $o_VTA_FacturacionElectronicaDP->setAceptadaxSunat( $a_respuesta['aceptada_por_sunat'] ? "SI" : "NO" );
            $o_VTA_FacturacionElectronicaDP->setSunatDescripcion( addslashes( $a_respuesta['sunat_description'] ) );
            $o_VTA_FacturacionElectronicaDP->setSunatNote( addslashes( $a_respuesta['sunat_note'] ) );
            $o_VTA_FacturacionElectronicaDP->setSunatResponseCode( is_null( $a_respuesta['sunat_responsecode'] ) ? "" : $a_respuesta['sunat_responsecode'] );
            $o_VTA_FacturacionElectronicaDP->setSunatSoapError( is_null( $a_respuesta['sunat_soap_error'] ) ? "" : $a_respuesta['sunat_soap_error'] );
            $o_VTA_FacturacionElectronicaDP->setPDFResult( $a_respuesta['enlace_del_pdf'] );
            $o_VTA_FacturacionElectronicaDP->setXMLResult( $a_respuesta['enlace_del_xml'] );
            $o_VTA_FacturacionElectronicaDP->setCDRResult( $a_respuesta['enlace_del_cdr'] );
            $o_VTA_FacturacionElectronicaDP->setCodigoHashQR( $a_respuesta['cadena_para_codigo_qr'] );
            $o_VTA_FacturacionElectronicaDP->setCodigoHash( $a_respuesta['codigo_hash'] );
        }

        $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_FacturacionElectronicaDP->update();

        return true;
    }

    public function leerRespuestaSunat($nombre_archivo)
    {
        //$nombre = FCPATH."ws_sunat/R-".$nombre_archivo;
        $nombre = SF_ROOT_DIR."/services/ws_sunat/R-".$nombre_archivo;
        $resultado = array();
        if( file_exists( $nombre ) )
        {
            $library = new SimpleXMLElement( $nombre, null, true );

            $ns = $library->getDocNamespaces();
            $ext1 = $library->children($ns['cac']);
            $ext2 = $ext1->DocumentResponse;
            $ext3 = $ext2->children($ns['cac']);
            $ext4 = $ext3->children($ns['cbc']);

            $respuesta_sunat_codigo = trim($ext4->ResponseCode);
            $respuesta_sunat_descripcion = trim($ext4->Description);

            $ns = $library->getDocNamespaces();
            $ext1 = $library->children($ns['ext']);
            $ext2 = $ext1->UBLExtensions;
            $ext3 = $ext2->UBLExtension;
            $ext4 = $ext3->ExtensionContent;
            $ext5 = $ext4->children();
            $ext6 = $ext5->Signature;
            $ext7 = $ext6->SignedInfo;
            $ext8 = $ext7->Reference;
            $ext9 = $ext8->DigestValue;

            $resultado = array(
                'respuesta_sunat_hash' => trim( ( string ) $ext9 ),
                'respuesta_sunat_codigo' => $respuesta_sunat_codigo,
                'respuesta_sunat_descripcion' => $respuesta_sunat_descripcion
            );
        }
        return $resultado;
    }

    public function firmar_xml( $name_file, $entorno, $baja = '' )
    {
        //$carpeta_baja = ($baja != '') ? 'BAJA/':'';
        $carpeta_baja = ($baja != '') ? 'baja/':'';
        //$carpeta = "files/facturacion_electronica/$carpeta_baja";
        $carpeta = "web/cpe/$carpeta_baja";
        $dir = base_url().$carpeta."xml/".$name_file;
        $xmlstr = file_get_contents( $dir );

        $domDocument = new \DOMDocument();
        $domDocument->loadXML( $xmlstr );
        $factura  = new Factura();
        $xml = $factura->firmar( $domDocument, '', $entorno );
        $content = $xml->saveXML();
        file_put_contents($carpeta."firma/".$name_file, $content );
    }

    public function crear_xml( $venta_id )
    {
        $venta = $this->ventas_model->query_cabecera( $venta_id );
        $empresa = $this->empresas_model->query_standar();
        //pr( $empresa ); exit;
        $anticipos = array();
        /*if($venta['venta_id'] != null && $venta['venta_id'] != ''){
            $anticipos = $this->venta_anticipos_model->select_anticipo_ventas(3, array('ventas.serie serie, ventas.numero numero, ventas.total_a_pagar total_a_pagar, ventas.id'), array('venta_anticipos.venta_id' => $venta['venta_id']));
        }*/
        
        $empresa = $this->empresas_model->query_standar();
        $detalle = $this->venta_detalles_model->query_detalle( $venta_id );
        $cuotas  = $this->cuotas_model->select(3, '', array('venta_id' => $venta_id), ' ORDER BY id DESC');

        $venta_relacionado = '';
        $motivo_nc = '';
        $motivo_nd = '';

        if(( ($venta['tipo_documento_id'] == 7) || ($venta['tipo_documento_id'] == 8) ) && ($venta['venta_relacionado_id'] != null)){
            $venta_relacionado = $this->ventas_model->venta_documento($venta['venta_relacionado_id']);
            
            if($venta['tipo_documento_id'] == 7){
                $motivo_nc = $this->tipo_ncreditos_model->select(2,'',array('id' => $venta['tipo_ncredito_id']));
            }            
            if($venta['tipo_documento_id'] == 8){
                $motivo_nd = $this->tipo_ndebitos_model->select(2,'',array('id' => $venta['tipo_ndebito_id']));
            }            
        }
        
        $xml = $this->desarrollo_xml( $empresa, $venta, $detalle, $venta_relacionado, $motivo_nc, $motivo_nd, $cuotas, $anticipos );

        $nombre_archivo = $empresa['ruc'].'-'.$venta['tipo_documento_codigo'].'-'.$venta['serie'].'-'.$venta['numero'];
        //$nombre = FCPATH."files/facturacion_electronica/XML/".$nombre_archivo.".xml";
        $nombre = SF_ROOT_DIR."/web/cpe/xml/".$nombre_archivo.".xml";
        
        //si existe lo elimino
        if (file_exists($nombre)) {
           unlink($nombre);
        }
        
        $archivo = fopen($nombre, "w+");
        fwrite($archivo, utf8_decode($xml));
        fclose($archivo);        
        
        return array(
            'nombre_archivo'=> $nombre_archivo, 
            'modo'          => $empresa['modo'],
            'venta_id'      => $venta_id,
            'empresa'       => $empresa
        );
    }

    public function desarrollo_xml( $empresa, $venta, $detalles, $venta_relacionado, $motivo_nc, $motivo_nd, $cuotas, $anticipos = array() )
    {
        $num = new Numletras();
        $totalVenta = explode(".",  $venta['total_a_pagar']);
        $totalLetras = $num->num2letras($totalVenta[0]);
        $venta['total_letras'] = $totalLetras.' con '.$totalVenta[1].'/100 '.$venta['moneda'];

        $linea_inicio   = '';
        $linea_fin   = '';
        $tag_total_pago = '';
        $dato_nc = '';
        switch ($venta['tipo_documento_id']) {
            case '1':
                $linea_inicio   = '<Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">';
                $linea_fin   = 'Invoice';
                $InvoiceTypeCode = '<cbc:InvoiceTypeCode listID="' . $venta['tipo_operacion'] . '" listAgencyName="PE:SUNAT" listName="Tipo de Documento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01" name="Tipo de Operacion" listSchemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51">' . $venta['tipo_documento_codigo'] . '</cbc:InvoiceTypeCode>';
                $tag_total_pago = 'LegalMonetaryTotal';
            break;

            case '3':
                $linea_inicio   = '<Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">';
                $linea_fin   = 'Invoice';
                $InvoiceTypeCode = '<cbc:InvoiceTypeCode listID="' . $venta['tipo_operacion'] . '" listAgencyName="PE:SUNAT" listName="Tipo de Documento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01" name="Tipo de Operacion" listSchemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51">' . $venta['tipo_documento_codigo'] . '</cbc:InvoiceTypeCode>';
                $tag_total_pago = 'LegalMonetaryTotal';
            break;

            case '7':
                $linea_inicio   = '<CreditNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2">';
                $linea_fin   = 'CreditNote';
                $InvoiceTypeCode = '';

                $dato_nc = '<cac:DiscrepancyResponse>
                <cbc:ReferenceID>'.$venta_relacionado['serie'].'-'.$venta_relacionado['numero'].'</cbc:ReferenceID>
                <cbc:ResponseCode>'.$motivo_nc['codigo'].'</cbc:ResponseCode>
                <cbc:Description>'.$motivo_nc['tipo_ncredito'].'</cbc:Description>
            </cac:DiscrepancyResponse>
            <cac:BillingReference>
                <cac:InvoiceDocumentReference>
                    <cbc:ID>'.$venta_relacionado['serie'].'-'.$venta_relacionado['numero'].'</cbc:ID>
                    <cbc:DocumentTypeCode>'.$venta_relacionado['codigo'].'</cbc:DocumentTypeCode>
                </cac:InvoiceDocumentReference>
            </cac:BillingReference>';
                $tag_total_pago = 'LegalMonetaryTotal';
            break;

            case '8':
                $linea_inicio   = '<DebitNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:DebitNote-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">';
                $linea_fin   = 'DebitNote';
                $InvoiceTypeCode = '';
                $dato_nc = '<cac:DiscrepancyResponse>
                <cbc:ReferenceID>'.$venta_relacionado['serie'].'-'.$venta_relacionado['numero'].'</cbc:ReferenceID>
                <cbc:ResponseCode>'.$motivo_nd['codigo'].'</cbc:ResponseCode>
                <cbc:Description>'.$motivo_nd['tipo_ndebito'].'</cbc:Description>
            </cac:DiscrepancyResponse>
            <cac:BillingReference>
                <cac:InvoiceDocumentReference>
                    <cbc:ID>'.$venta_relacionado['serie'].'-'.$venta_relacionado['numero'].'</cbc:ID>
                    <cbc:DocumentTypeCode>'.$venta_relacionado['codigo'].'</cbc:DocumentTypeCode>
                </cac:InvoiceDocumentReference>
            </cac:BillingReference>';
                $tag_total_pago = 'RequestedMonetaryTotal';
            break;
        }

        $xml =  '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'.$linea_inicio.'<ext:UBLExtensions>
                        <ext:UBLExtension>
                            <ext:ExtensionContent></ext:ExtensionContent>
                        </ext:UBLExtension>
                    </ext:UBLExtensions>
                    <cbc:UBLVersionID>'.$venta['UBLVersionID'].'</cbc:UBLVersionID>
                    <cbc:CustomizationID>'.$venta['CustomizationID'].'</cbc:CustomizationID>
                    <cbc:ID>'.$venta['serie'].'-'.$venta['numero'].'</cbc:ID>
                    <cbc:IssueDate>'.$venta['fecha_emision_sf'].'</cbc:IssueDate>
                    <cbc:IssueTime>'.$venta['hora_emision'].'</cbc:IssueTime>';
        if(($venta['fecha_vencimiento'] != null) && (($venta['tipo_documento_id'] == 1) || ($venta['tipo_documento_id'] == 3))) {
            $xml .= '<cbc:DueDate>' . $venta['fecha_vencimiento_sf'] . '</cbc:DueDate>';
        };
        $xml .= $InvoiceTypeCode.'<cbc:Note languageLocaleID="1000">'.$venta['total_letras'].'</cbc:Note>
                <cbc:DocumentCurrencyCode listID="ISO 4217 Alpha" listName="Currency" listAgencyName="United Nations Economic Commission for Europe">'.$venta['abrstandar'].'</cbc:DocumentCurrencyCode>'.$dato_nc;

        //--Para anticipos INICIO--
        $ij = 1;
        foreach ($anticipos as $value_anticipos){
            //codigo documento relacionado (Catalogo 12 Sunat)
            if(substr($value_anticipos['serie'], 0, 1) == 'F'){
                $codigo_documento_relacionado = '02';
            }elseif(substr($value_anticipos['serie'], 0, 1) == 'B'){
                $codigo_documento_relacionado = '03';
            }
            $xml .= '<cac:AdditionalDocumentReference>
                    <cbc:ID schemeID="01">'.$value_anticipos['serie'].'-'.$value_anticipos['numero'].'</cbc:ID>
                    <cbc:DocumentTypeCode listAgencyName="PE:SUNAT" listName="Documento Relacionado" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo12">'.$codigo_documento_relacionado.'</cbc:DocumentTypeCode>
                    <cbc:DocumentType>ANTICIPO</cbc:DocumentType>
                    <cbc:DocumentStatusCode listAgencyName="PE:SUNAT" listName="Anticipo">'.$ij.'</cbc:DocumentStatusCode>
                    <cac:IssuerParty>
                            <cac:PartyIdentification>
                                    <cbc:ID schemeAgencyName="PE:SUNAT" schemeID="'.$venta['codigo_tipo_entidad'].'" schemeName="Documento de Identidad" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$venta['numero_documento'].'</cbc:ID>
                            </cac:PartyIdentification>
                    </cac:IssuerParty>
                </cac:AdditionalDocumentReference>';
            $ij ++;
        }
        //--Para anticipos FIN--

        /////--Orden de compra  -- INICIO
        if(($venta['orden_compra'] != null) && (($venta['tipo_documento_id'] == 1) || ($venta['tipo_documento_id'] == 3))) {
            $xml .= '<cac:OrderReference>
                            <cbc:ID>'.$venta['orden_compra'].'</cbc:ID>
                            </cac:OrderReference>';
        };
        /////--Orden de compra  -- FIN

        $xml .= '<cac:Signature>
                            <cbc:ID>'.$empresa['ruc'].'</cbc:ID>
                            <cac:SignatoryParty>
                                <cac:PartyIdentification>
                                    <cbc:ID>'.$empresa['ruc'].'</cbc:ID>
                                </cac:PartyIdentification>
                                <cac:PartyName>
                                    <cbc:Name><![CDATA['.$empresa['empresa'].']]></cbc:Name>
                                </cac:PartyName>
                            </cac:SignatoryParty>
                            <cac:DigitalSignatureAttachment>
                                <cac:ExternalReference>
                                    <cbc:URI>'.$empresa['ruc'].'</cbc:URI>
                                </cac:ExternalReference>
                            </cac:DigitalSignatureAttachment>
                        </cac:Signature>                        
                        <cac:AccountingSupplierParty>
                            <cac:Party>
                                <cac:PartyIdentification>
                                    <cbc:ID schemeID="6">'.$empresa['ruc'].'</cbc:ID>
                                </cac:PartyIdentification>
                                <cac:PartyName>
                                    <cbc:Name><![CDATA['.$empresa['nombre_comercial'].']]></cbc:Name>                                    
                                </cac:PartyName>
                                <cac:PartyLegalEntity>
                                    <cbc:RegistrationName><![CDATA['.$empresa['empresa'].']]></cbc:RegistrationName>
                                    <cac:RegistrationAddress>
                                        <cbc:ID schemeName="Ubigeos" schemeAgencyName="PE:INEI">'.$empresa['ubigeo'].'</cbc:ID>
                                        <cbc:AddressTypeCode listAgencyName="PE:SUNAT" listName="Establecimientos anexos">0000</cbc:AddressTypeCode>
                                        <cbc:CityName>'.$empresa['provincia'].'</cbc:CityName>
                                        <cbc:CountrySubentity>'.$empresa['departamento'].'</cbc:CountrySubentity>
                                        <cbc:District>'.$empresa['distrito'].'</cbc:District>
                                        <cac:AddressLine>
                                            <cbc:Line>'.$empresa['domicilio_fiscal'].'</cbc:Line>
                                        </cac:AddressLine>
                                        <cac:Country>
                                            <cbc:IdentificationCode listID="ISO 3166-1" listAgencyName="United Nations Economic Commission for Europe" listName="Country">PE</cbc:IdentificationCode>
                                        </cac:Country>
                                    </cac:RegistrationAddress>
                                </cac:PartyLegalEntity>
                            </cac:Party>
                        </cac:AccountingSupplierParty>                        
                        <cac:AccountingCustomerParty>
                            <cac:Party>
                                <cac:PartyIdentification>
                                    <cbc:ID schemeID="'.$venta['codigo_tipo_entidad'].'" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$venta['numero_documento'].'</cbc:ID>
                                </cac:PartyIdentification>
                                <cac:PartyLegalEntity>
                                    <cbc:RegistrationName><![CDATA['.$venta['entidad'].']]></cbc:RegistrationName>
                                </cac:PartyLegalEntity>
                            </cac:Party>
                        </cac:AccountingCustomerParty>';

        //--Para anticipos INICIO--
        $ij = 1;
        foreach ($anticipos as $value_anticipos){
            $xml .= '<cac:PrepaidPayment>
                            <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Anticipo">'.$ij.'</cbc:ID>
                            <cbc:PaidAmount currencyID="'.$venta['abrstandar'].'">'.$value_anticipos['total_a_pagar'].'</cbc:PaidAmount>
                        </cac:PrepaidPayment>';
        }
        //--Para anticipos FIN--

        /////////////Forma de pago  --  INICIO
        if(count($anticipos) == 0){
            if(($venta['forma_pago_id'] == 1) && ($venta['tipo_documento_id'] == '1') || ($venta['tipo_documento_id'] == '3')){
                $xml .= '<cac:PaymentTerms>
                            <cbc:ID>FormaPago</cbc:ID>
                            <cbc:PaymentMeansID>Contado</cbc:PaymentMeansID>
                        </cac:PaymentTerms>';
            }
            if(($venta['forma_pago_id'] == 2) && ($venta['tipo_documento_id'] == '1') || ($venta['tipo_documento_id'] == '3')){
                $xml .= '<cac:PaymentTerms>
                            <cbc:ID>FormaPago</cbc:ID>
                            <cbc:PaymentMeansID>Credito</cbc:PaymentMeansID>
                            <cbc:Amount currencyID="'.$venta['abrstandar'].'">' . number_format($venta['total_a_pagar'], 2, '.', '') . '</cbc:Amount>
                        </cac:PaymentTerms>';

                $contar_cuota = 1;
                foreach($cuotas as $value_cuotas){
                    $xml .= '<cac:PaymentTerms>
                                    <cbc:ID>FormaPago</cbc:ID>
                                    <cbc:PaymentMeansID>Cuota00'.$contar_cuota.'</cbc:PaymentMeansID>
                                    <cbc:Amount currencyID="'.$venta['abrstandar'].'">' . number_format($value_cuotas['monto'], 2, '.', '') . '</cbc:Amount>
                                    <cbc:PaymentDueDate>' . $value_cuotas['fecha_cuota'] . '</cbc:PaymentDueDate>
                                </cac:PaymentTerms>';
                    $contar_cuota ++;
                }
            }
        }
        /////////////Forma de pago  --  FIN

        //////////////Descuentos Globales  -- INICIO
        if( ($venta['total_descuentos'] != null) && ($venta['total_descuentos'] > 0)){
            $codigo_cargos = ( $venta['total_igv'] > 0 ) ? '02' : '03';
            $xml .= '<cac:AllowanceCharge>
                <cbc:ChargeIndicator>false</cbc:ChargeIndicator>
                <cbc:AllowanceChargeReasonCode listAgencyName="PE:SUNAT" listName="Cargo/descuento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo53">'.$codigo_cargos.'</cbc:AllowanceChargeReasonCode>
                <cbc:MultiplierFactorNumeric>' . number_format(( $venta['total_descuentos'] / ($venta['total_gravada'] + $venta['total_descuentos'])), 5,'.', ''). '</cbc:MultiplierFactorNumeric>
                <cbc:Amount currencyID="'.$venta['abrstandar'].'">' . $venta['total_descuentos'] . '</cbc:Amount>
                <cbc:BaseAmount currencyID="'.$venta['abrstandar'].'">' . number_format(($venta['total_gravada'] + $venta['total_descuentos']), 2,'.', ''). '</cbc:BaseAmount>
            </cac:AllowanceCharge>';
        }
        //////////////Descuentos Globales -- FIN

        //////////////Descuentos ITEM  -- INICIO
        $suma_descuento_lineal = 0;
        $tipo_igv_id_item = 1;//suponemos q por defecto será con IGV. igual luego se reemplazará en el caso tenga descuento por Item
        foreach ($detalles as $datos_descuento){
            $suma_descuento_lineal += $datos_descuento['descuento'];
            $tipo_igv_id_item = $datos_descuento['tipo_igv_id'];
        }

        if($suma_descuento_lineal > 0){
            $codigo_cargos = ($tipo_igv_id_item == 1) ? '00' : '01';
            $xml .= '<cac:AllowanceCharge>
                    <cbc:ChargeIndicator>false</cbc:ChargeIndicator>
                    <cbc:AllowanceChargeReasonCode listAgencyName="PE:SUNAT" listName="Cargo/descuento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo53">'.$codigo_cargos.'</cbc:AllowanceChargeReasonCode>
                    <cbc:MultiplierFactorNumeric>' . number_format(( $suma_descuento_lineal / ($venta['total_gravada'] + $suma_descuento_lineal)), 5,'.', ''). '</cbc:MultiplierFactorNumeric>
                    <cbc:Amount currencyID="'.$venta['abrstandar'].'">' . $suma_descuento_lineal . '</cbc:Amount>
                    <cbc:BaseAmount currencyID="'.$venta['abrstandar'].'">' . number_format(($venta['total_gravada'] + $suma_descuento_lineal), 2,'.', ''). '</cbc:BaseAmount>
                </cac:AllowanceCharge>';
        }
        //////////////Descuentos ITEM -- FIN

        $total_igv = ($venta['total_igv'] != null) ? $venta['total_igv'] : 0.0;
        $xml .=  '<cac:TaxTotal>
                            <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">'. $total_igv .'</cbc:TaxAmount>';
        if($venta['total_gravada'] != null){
            $xml .=  '<cac:TaxSubtotal>
                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_gravada'] . '</cbc:TaxableAmount>
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">' . $total_igv . '</cbc:TaxAmount>
                                <cac:TaxCategory>
                                    <cac:TaxScheme>
                                        <cbc:ID schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">1000</cbc:ID>
                                        <cbc:Name>IGV</cbc:Name>
                                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        if($venta['total_exportacion'] != null){
            $xml .=  '<cac:TaxSubtotal>
                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_exportacion'] . '</cbc:TaxableAmount>
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">0.00</cbc:TaxAmount>
                                <cac:TaxCategory>
                                    <cac:TaxScheme>
                                        <cbc:ID schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">9995</cbc:ID>
                                        <cbc:Name>EXP</cbc:Name>
                                        <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        if($venta['total_gratuita'] != null){
            $xml .=  '<cac:TaxSubtotal>
                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_gratuita'] . '</cbc:TaxableAmount>
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">0.00</cbc:TaxAmount>
                                <cac:TaxCategory>
                                    <cac:TaxScheme>
                                        <cbc:ID schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">9996</cbc:ID>
                                        <cbc:Name>GRA</cbc:Name>
                                        <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        if($venta['total_exonerada'] != null){
            $xml .=  '<cac:TaxSubtotal>
                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_exonerada'] . '</cbc:TaxableAmount>
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">0.00</cbc:TaxAmount>
                                <cac:TaxCategory>
                                    <cac:TaxScheme>
                                        <cbc:ID schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">9997</cbc:ID>
                                        <cbc:Name>EXO</cbc:Name>
                                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        if($venta['total_inafecta'] != null){
            $xml .=  '<cac:TaxSubtotal>
                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_inafecta'] . '</cbc:TaxableAmount>
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">0.00</cbc:TaxAmount>
                                <cac:TaxCategory>
                                    <cac:TaxScheme>
                                        <cbc:ID schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">9998</cbc:ID>
                                        <cbc:Name>INA</cbc:Name>
                                        <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        if($venta['total_bolsa'] != null){
            $xml .=  '<cac:TaxSubtotal>              
                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">' . $venta['total_bolsa'] . '</cbc:TaxAmount>
                                <cac:TaxCategory>       				  
                                    <cac:TaxScheme>
                                        <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Codigo de tributos" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">7152</cbc:ID>
                                        <!-- ICBPER: Nombre de ICBPER -->
                                        <cbc:Name>ICBPER</cbc:Name>
                                        <!-- ICBPER: Codigo Internacional de ICBPER -->
                                        <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>
                                    </cac:TaxScheme>
                                </cac:TaxCategory>
                            </cac:TaxSubtotal>';
        };
        $total_gravada      = ($venta['total_gravada'] == null)     ? 0 : $venta['total_gravada'];
        $total_exportacion  = ($venta['total_exportacion'] == null) ? 0 : $venta['total_exportacion'];
        $total_exonerada    = ($venta['total_exonerada'] == null)   ? 0 : $venta['total_exonerada'];
        $total_inafecta     = ($venta['total_inafecta'] == null)    ? 0 : $venta['total_inafecta'];
        $xml .=  '</cac:TaxTotal>';

        $xml .=  '<cac:'.$tag_total_pago.'>                                
                            <cbc:LineExtensionAmount currencyID="'.$venta['abrstandar'].'">' . number_format(($total_gravada + $total_exportacion + $total_exonerada + $total_inafecta), 2, '.', '') . '</cbc:LineExtensionAmount>
                            <cbc:TaxInclusiveAmount currencyID="'.$venta['abrstandar'].'">' . number_format($venta['total_a_pagar'], 2, '.', '') . '</cbc:TaxInclusiveAmount>
                            <cbc:AllowanceTotalAmount currencyID="'.$venta['abrstandar'].'">'.number_format($suma_descuento_lineal, 2, '.', '').'</cbc:AllowanceTotalAmount>
                            <cbc:ChargeTotalAmount currencyID="'.$venta['abrstandar'].'">0.00</cbc:ChargeTotalAmount>
                            <cbc:PrepaidAmount currencyID="'.$venta['abrstandar'].'">' . number_format($venta['PrepaidAmount'], 2, '.', '') . '</cbc:PrepaidAmount>
                            <cbc:PayableAmount currencyID="'.$venta['abrstandar'].'">' . number_format($venta['total_a_pagar'], 2, '.', ''). '</cbc:PayableAmount>
                        </cac:'.$tag_total_pago.'>';
        $i = 1;
        $percent = $venta['porcentaje_igv'];
        foreach($detalles as $value){
            $icbper = ($value['impuesto_bolsa'] != null) ? $value['impuesto_bolsa'] : 00.00;
            $priceAmount = $this->variables_diversas_model->priceAmount($value['precio_base'], $value['codigo_de_tributo'], $percent, $icbper, $value['descuento']);
            $PriceTypeCode = ($value['codigo_de_tributo'] == 9996) ? '02' : '01';
            $taxAmount = $this->variables_diversas_model->taxAmount($value['cantidad'], $value['precio_base'], $value['codigo_de_tributo'], $percent, $value['descuento']);
            $price_priceAmount = $this->variables_diversas_model->price_priceAmount($value['precio_base'], $value['codigo_de_tributo'], $value['descuento']);
            //sale del catalgo16
            //PriceAmount precio unitario (precio base x (1 + IGV)) + impuesto por 1 bolsa. (en caso no se pague IGV sera 1 + 0).

            $linea = '';
            $cantidad = '';
            switch ($venta['tipo_documento_id']) {
                case '1':
                    $linea      = 'InvoiceLine';
                    $cantidad   = 'InvoicedQuantity';
                break;

                case '3':
                    $linea      = 'InvoiceLine';
                    $cantidad   = 'InvoicedQuantity';
                break;

                case '7':
                    $linea      = 'CreditNoteLine';
                    $cantidad   = 'CreditedQuantity';
                break;

                case '8':
                    $linea      = 'DebitNoteLine';
                    $cantidad   = 'DebitedQuantity';
                break;
            }

            $xml .= '<cac:'.$linea.'>
                                    <cbc:ID>'.$i.'</cbc:ID>
                                    <cbc:'.$cantidad.' unitCode="NIU">'. number_format($value['cantidad'], 2, '.', '') .'</cbc:'.$cantidad.'>
                                    <cbc:LineExtensionAmount currencyID="'.$venta['abrstandar'].'">'. number_format($value['cantidad'] * ($value['precio_base'] - $value['descuento']), 2, '.', '').'</cbc:LineExtensionAmount>
                                    <cac:PricingReference>
                                        <cac:AlternativeConditionPrice>
                                            <cbc:PriceAmount currencyID="'.$venta['abrstandar'].'">' . abs(number_format($priceAmount, 6, '.', '')) .'</cbc:PriceAmount>
                                            <cbc:PriceTypeCode listName="Tipo de Precio" listAgencyName="PE:SUNAT" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo16">' . $PriceTypeCode . '</cbc:PriceTypeCode>
                                        </cac:AlternativeConditionPrice>
                                    </cac:PricingReference>';

            if($value['descuento'] != ''){
                //chekar catalogo 53
                $codigo_cargos = ($value['tipo_igv_id'] == 1) ? '00' : '01';
                $xml .= '<cac:AllowanceCharge>
                                            <cbc:ChargeIndicator>false</cbc:ChargeIndicator>
                                            <cbc:AllowanceChargeReasonCode listAgencyName="PE:SUNAT" listName="Cargo/descuento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo53">'.$codigo_cargos.'</cbc:AllowanceChargeReasonCode>
                                            <cbc:MultiplierFactorNumeric>' . number_format(( $value['descuento'] / ($value['precio_base'])), 5,'.', ''). '</cbc:MultiplierFactorNumeric>
                                            <cbc:Amount currencyID="'.$venta['abrstandar'].'">'.$value['descuento'].'</cbc:Amount>
                                            <cbc:BaseAmount currencyID="'.$venta['abrstandar'].'">'. number_format($value['precio_base'], 2) .'</cbc:BaseAmount>
                                        </cac:AllowanceCharge>';
            }

            $xml .=     '<cac:TaxTotal>
                                            <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">'. number_format(($taxAmount + $icbper * $value['cantidad']), 2, '.', '') .'</cbc:TaxAmount>                                                
                                            <cac:TaxSubtotal>
                                                <cbc:TaxableAmount currencyID="'.$venta['abrstandar'].'">' . number_format(($value['precio_base'] - $value['descuento']) * $value['cantidad'] ,2, '.', '') . '</cbc:TaxableAmount>
                                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">'. number_format($taxAmount, 2, '.', '') .'</cbc:TaxAmount>
                                                <cac:TaxCategory>
                                                    <cbc:Percent>'. $percent * 100 .'</cbc:Percent>
                                                    <cbc:TaxExemptionReasonCode>'.$value['tipo_igv_codigo'].'</cbc:TaxExemptionReasonCode>
                                                    <cac:TaxScheme>
                                                        <cbc:ID>'.$value['codigo_de_tributo'].'</cbc:ID>                                                    
                                                        <cbc:Name>'.$value['nombre_tributo'].'</cbc:Name>                                                    
                                                        <cbc:TaxTypeCode>'.$value['codigo_internacional'].'</cbc:TaxTypeCode>
                                                    </cac:TaxScheme>
                                                </cac:TaxCategory>
                                            </cac:TaxSubtotal>';
            if($value['impuesto_bolsa'] != null){
                $xml .= '<cac:TaxSubtotal>
                                                <cbc:TaxAmount currencyID="'.$venta['abrstandar'].'">' . $icbper * $value['cantidad'] . '</cbc:TaxAmount>
                                                <cbc:BaseUnitMeasure unitCode="NIU">' . number_format($value['cantidad'], 0, '','') . '</cbc:BaseUnitMeasure>
                                                <cac:TaxCategory>
                                                    <cbc:PerUnitAmount currencyID="'.$venta['abrstandar'].'">' . $icbper . '</cbc:PerUnitAmount>
                                                    <cac:TaxScheme>
                                                        <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Codigo de tributos" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">7152</cbc:ID>
                                                        <cbc:Name>ICBPER</cbc:Name>
                                                        <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>	
                                                    </cac:TaxScheme>
                                                </cac:TaxCategory>
                                            </cac:TaxSubtotal>';
            }
            $xml .=     '</cac:TaxTotal>                                    
                                        <cac:Item>                                    
                                            <cbc:Description><![CDATA['.$value['producto'].']]></cbc:Description>
                                            <cac:SellersItemIdentification>
                                                <cbc:ID>'.$value['codigo_producto'].'</cbc:ID>
                                            </cac:SellersItemIdentification>
                                            <cac:CommodityClassification>                                        
                                                <cbc:ItemClassificationCode>'.$value['codigo_sunat'].'</cbc:ItemClassificationCode>
                                            </cac:CommodityClassification>
                                        </cac:Item>
                                        <cac:Price>
                                            <cbc:PriceAmount currencyID="'.$venta['abrstandar'].'">' . abs($price_priceAmount) . '</cbc:PriceAmount>
                                        </cac:Price>
                                </cac:'.$linea.'>
                                ';
            $i++;
        }
        $xml .=  '</'.$linea_fin.'>';
        return $xml;
    }


}