<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<script>
asignarIdPrecio = function( id_precio )
{
    $( "#IdTipoPrecio" ).val( id_precio );
    ejecutarGuardar();
}

ejecutarGuardar = function()
{
	blockContent( "content_frm" );
    
    var strFormSerialize = $( 'form' ).serialize();
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'cot/changePrice' ) ?>", 
        strFormSerialize,
        function( o_json )
        {
        	unBlockContent( "content_frm" );
            console.log( o_json );
            
            if( o_json.error )
            {
            	showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                return false;
            }
            parent.executeFindDetail();
            parent.ocultarModal( 'exampleModalScrollable' );
            if ( typeof parent.calcularMontoFinal === 'function' )
            {
                parent.calcularMontoFinal(); // Llama a la función si existe
            }
        } 
    );
}
</script>

<script>
calcularMontos = function( conIGV )
{
    id_precio_venta_igv = "txt_precio";
    id_precio_venta     = "valor_unit";
    id_monto_igv        = "monto_igv";

    if( conIGV )
    {
    	if( $( "#" + id_precio_venta_igv ).val() == "" )
    	{
            return false;
    	}
        
        var precio_venta_igv = parseFloat( $( "#" + id_precio_venta_igv ).val() );
    	if( "<?=$AfectoIGV?>" == "Y" )
        {
            var precio_venta = redondear( ( precio_venta_igv / 1.18 ), 2 );
            var monto_igv    = redondear( precio_venta_igv - precio_venta, 2 );
        }
    	else
        {
            var precio_venta = precio_venta_igv;
            var monto_igv    = 0;
        }

        $( "#" + id_precio_venta ).val( precio_venta );
        $( "#" + id_monto_igv ).val( monto_igv );
    }
    else
    {
    	if( $( "#" + id_precio_venta ).val() == "" )
    	{
            return false;
    	}
        
        var precio_venta = parseFloat( $( "#" + id_precio_venta ).val() );
        if( "<?=$AfectoIGV?>" == "Y" )
        {
            var precio_venta_igv = redondear( precio_venta * 1.18, 2 );
            var monto_igv        = redondear( precio_venta_igv - precio_venta, 2 );
        }
        else
        {
            var precio_venta_igv = precio_venta;
            var monto_igv        = 0;
        }

        $( "#" + id_precio_venta_igv ).val( precio_venta_igv );
        $( "#" + id_monto_igv ).val( monto_igv );
    }
}
</script>

<div id="content_frm">
    <form id="form1" name="form1" method="POST" onsubmit="return false;"  enctype="multipart/form-data">
        <input type="hidden" name="id" id="id" value="<?=$i_Id?>"/>
        <input type="hidden" name="id_item" id="id_item" value="<?=$s_IdItem?>"/>
        <input type="hidden" name="secuencia" id="secuencia" value="<?=$s_Secuencia?>"/>
        <input type="hidden" name="tipo_precio" id="IdTipoPrecio" value=""/>
    
        <div id="resultContent" style=""></div>
        <div id="content_alert" style=""></div>

        <div class="container">
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    C&oacute;digo
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <?=$o_ALM_ItemMastBN->getIdItem()?>
                </div>
            </div>
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    Descripci&oacute;n
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <?=$o_ALM_ItemMastBN->getDescripcionCompleta()?>
                </div>
            </div>
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    <label class="text-white" for="contrasenia">Contrase&ntilde;a</label>
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <input type="password" class="form-control text-center" name="contrasenia" id="contrasenia" onblur="" onfocus="this.select();">
                </div>
            </div>
        </div>
        <div class="dropdown-divider"></div>
        <div class="form-row mx-0">
        
            <div class="col-md-10 mb-1">
                <div class="card">
                    <div class="form-row mx-0">
                        <div class="col-md-4 mt-1 mb-1">
                            <label class="col-form-label" for="valor_unit">Valor Sin IGV</label>
                            <input type="text" class="form-control" name="valor_unit" id="valor_unit" onblur="calcularMontos( false )" onfocus="this.select();" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetallePrecioUnidad()?>">
                        </div>
                        <div class="col-md-4 mt-1 mb-1">
                            <label class="col-form-label" for="monto_igv">IGV</label>
                            <input type="text" class="form-control" name="monto_igv" id="monto_igv" placeholder="" readonly="readonly" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetalleImpuestoUnidad()?>">
                        </div>
                        <div class="col-md-4 mt-1 mb-1">
                            <label class="col-form-label" for="txt_precio">Total</label>
                            <input type="text" class="form-control" name="txt_precio" id="txt_precio" onblur="calcularMontos( true )" onfocus="this.select();" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getPrecioUnidadIncImpuesto()?>">
                        </div>
                    </div>
                </div>
                
                
            </div>
            
            <div class="col-md-2 mb-1">
                <button type="button" class="btn btn-primary btn-sm btn-block" onclick="asignarIdPrecio('P');">GUARDAR</button>
            </div>
        </div>
        <div class="dropdown-divider"></div>
        <table class="table table-sm table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th scope="col" style="text-align: center;">Nivel</th>
                    <!-- <th scope="col" style="text-align: center;">Margen %</th> -->
                    <th scope="col" style="text-align: center;">Precio Sin IGV</th>
                    <th scope="col" style="text-align: center;">Precio Con IGV</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ( $a_MST_ListaPrecioDetalle as $i_Key => $o_MST_ListaPrecioDetalleBN ){ ?>
                <?php
                $s_IdTipoPrecio = $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio();
                $f_Porcentaje   = $o_MST_ListaPrecioDetalleBN->getPorcentajeUtilidad();
                if( !$f_Porcentaje )
                {
                    if( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() > 0 )
                    {
                        $f_Porcentaje = round( ( 100 * ( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() - $o_MST_ListaPrecioDetalleBN->getPrecioCosto() ) / $o_MST_ListaPrecioDetalleBN->getPrecioVenta() ), 2 );
                    }
                    else
                    {
                        $f_Porcentaje = 0;
                    }
                }
                if( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() )
                {
                    $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                    $o_MST_RangoDetalleBN = $o_MST_RangoDetalleFN->selectByPK( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() );
                    if( $o_MST_RangoDetalleBN )
                    {
                        $s_IdTipoPrecio = $o_MST_RangoDetalleBN->getMinimo()." - ".$o_MST_RangoDetalleBN->getMaximo();
                    }
                }
                ?>
                <tr ondblclick="asignarIdPrecio('<?=$o_MST_ListaPrecioDetalleBN->getIdTipoPrecio()?>');">
                    <td align="center" ><label class="labelData"><?=$s_IdTipoPrecio?></label></td>
                    <!-- <td align="center" ><label class="labelData"><?=$f_Porcentaje?>%</label></td> -->
                    <td align="center" >
                        <?php
                        echo GSS_MonedaMastFN::getSiglaxId( $o_VTA_OrdenBN->getMonedaCod() )."&nbsp;";
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() / $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                        }
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() * $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta(), 2 );
                            }
                        }
                        ?>
                    </td>
                    <td align="center" >
                        <?php
                        echo GSS_MonedaMastFN::getSiglaxId( $o_VTA_OrdenBN->getMonedaCod() )."&nbsp;";
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() / $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                        }
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() * $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV(), 2 );
                            }
                        }
                        ?>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
    </form>
</div>