<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class cotActions extends wtActions
{
    public function executePrint2PDF()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_VTA_OrdenBN->getCiaCod() );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();
        
        $host_name = "localhost";
        if( $_SERVER['HTTP_HOST'] != "localhost" )
        {
            $host_name = $_SERVER['HTTP_HOST'];
        }
        
        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        (
                "o_GSS_CompaniaBN"   => $o_GSS_CompaniaBN,
                "o_VTA_OrdenBN"      => $o_VTA_OrdenBN,
                "a_VTA_OrdenDetalle" => $a_VTA_OrdenDetalle,
                "a_CuentasBancarias" => $a_CuentasBancarias
        );
        $s_vHtml = 0;
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Venta_'.$o_VTA_OrdenBN->getOrdenNum(), array( "Attachment" => 0 ) );
        
        exit;
    }
    
    public function executePrintPDF()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );

        ///////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_VTA_OrdenBN->getCiaCod() );

        ///////////////////////////////////////////////////////////////////////////
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();
        
        $host_name = "localhost";
        if( $_SERVER['HTTP_HOST'] != "localhost" )
        {
            $host_name = $_SERVER['HTTP_HOST'];
        }

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"   => $o_GSS_CompaniaBN, 
            "o_VTA_OrdenBN"      => $o_VTA_OrdenBN, 
            "a_VTA_OrdenDetalle" => $a_VTA_OrdenDetalle,
            "a_CuentasBancarias" => $a_CuentasBancarias
        );
        $s_vHtml = 0;
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Venta_'.$o_VTA_OrdenBN->getOrdenNum(), array( "Attachment" => 0 ) );
        
        exit;
        //////////////////////////////////////////////////////////////////////////////////////
        
        //ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeListProyectos()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_IdPersona = $this->getRequestParameter( 'IdPersona' );
        
        if( $this->getRequestParameter( 'IdPersona' ) )
        {
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $this->o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->s_IdPersona );
        }
        else
        {
            $this->o_MST_PersonaMastBN = new MST_PersonaMastBN();
        }
    }
    
    public function executeGridProyectos()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_PrsProyectosFN() );
        
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "ClienteNroDocu", VTA_PrsProyectosFN::ClienteNroDocu, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_PrsProyectosFN::ClienteNombre, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "OrdenNum", VTA_OrdenFN::OrdenNum, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "NumeroFactura", ALM_OrdenGuiaFacturaFN::NumeroFactura, "LIKE", "%%s%" );
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
                {
                    $o_GridAction->addMethodDefault( "( SELECT VendedorCod FROM MST_ClienteMast WHERE MST_ClienteMast.IdCliente=VTA_PrsProyectos.IdPersona )", array( 'Condition'=>'=', 'Value' => "'".myUser::getUser()->getUserId()."'" ) );
                }
            }
        }

        //
        
        $o_GridAction->addOrderDefault( VTA_PrsProyectosFN::IdProyecto, true );
        
        $o_GridAction->addRowsToShow( "IdProyecto", "NombreProyecto", "Contacto", "TipoDocumento", "NroDocumento", "Direccion", "ClienteNombre", "ClienteNroDocu", "IdPersona" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Lista - Cotizaci&oacute;n";

        $o_CotizacionesBL = new CotizacionesBL();
        $o_CotizacionesBL->anularOrdenesExpirados();
    }

    public function executeGrid()
    {
        $o_GridAction = $this->buildGrid();
        
        $o_GridAction->addOrderDefault( VTA_OrdenFN::OrdenNum, false );

        $o_GridAction->addRowsToShow
        ( 
            "OrdenId", "OrdenNum", "OrdenFecha", "AlmacenCod", "ClienteNombre", "OrdenMonedaDesc", "OrdenNeto", "OrdenEstadoDesc", "UsuarioCreacion", "VendedorOrden", "TipoOrdenComercialDesc", "TipoClasificacionDesc", "OrdenEstado", "OrdenTotalaPagar",
            "AdminComentario", "FormaPagoDesc", "DocReferenciaId", "CobranzaEstadoDesc"
        );
    
        $o_GridAction->setNumberRecordsShow( 100 );
    
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson            = array();
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        set_header_utf8();
        
        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        
        $this->Titulo = "Nuevo Cotizaci&oacute;n";

        $this->error_mensaje = "";

        try 
        {
        
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            //$o_GSS_MonedaMastFN->setIdMoneda( "LO" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
            
            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();
            
            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc();

            $this->o_VTA_OrdenBN = new VTA_OrdenBN();
            $this->o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $this->o_VTA_OrdenBN->setOrdenTipoId( 2 );
            $this->o_VTA_OrdenBN->setDiasAlquiler( 30 );
            $this->o_VTA_OrdenBN->setCondicionVenta( "CONADE" );
            
            //moneda por defecto, segun maestro de precios
            $IdCompania = myUser::getUser()->getIdBusiness();
            $IdSucursal = myUser::getUser()->getIdSucursal();
            
            $s_CodMoneda = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault( $IdCompania, $IdSucursal );

            $this->o_VTA_OrdenBN->setMonedaCod( $s_CodMoneda );
            $this->o_VTA_OrdenBN->setClienteDocCod( "RUC" );

            if( $this->s_TipoProc == "upd" )
            {
                $this->Titulo = "Editar Cotizaci&oacute;n";

                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_Id );
            }

            $this->s_IdVendedor = null; //por defecto
            //SERMAQUI TRABAJA CON CLIENTES ESPECIFICOS ASOCIADOS A LOS VENDEDORES, POR LO TANTO EL VENDEDOR TIENE Q SER UNICO - 2021-09-30
            $this->s_IdVendedor = myUser::getUser()->getUserId();

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
            /*$o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            $this->b_ControlCaja = false;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $this->b_ControlCaja   = true;
                $this->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
                $this->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
                $this->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
                $this->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
            }*/
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //almacen
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
            //$o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
            $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
            
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
        
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'id' );
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        
        $IdCompania         = myUser::getUser()->getIdBusiness();
        
        $TipoDocCliente     = $this->getRequestParameter( 'TipoDocCliente' );
        $NumDocuCliente     = $this->getRequestParameter( 'NumDocuCliente' );
        $OrdenTipoId        = $this->getRequestParameter( 'OrdenTipoId' );
        $ClienteNumero      = trim( $this->getRequestParameter( 'ClienteNumero' ) );
        $ClienteNombre      = trim( $this->getRequestParameter( 'NombreCliente' ) );
        
        $Comentario         = trim( $this->getRequestParameter( 'Comentario' ) );
        $DireccionCliente   = trim( $this->getRequestParameter( 'DireccionCliente' ) );
        //$f_TipoCambio       = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        $f_TipoCambio       = $this->getRequestParameter( 'MonedaCambioValor' );
        
        $IdAlmacen          = $this->getRequestParameter( 'AlmacenCod' );
        $AlmacenDespacho    = $this->getRequestParameter( 'AlmacenDespacho' );
        
        $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
        $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );
        
        $FactRegla          = $this->getRequestParameter( 'FactRegla' );

        $ValidezOrden       = $this->getRequestParameter( 'ValidezOrden' );
        $PlazaEntregaOrden  = $this->getRequestParameter( 'PlazaEntregaOrden' );
        $CondicionVenta     = $this->getRequestParameter( 'CondicionVenta' );
        $s_OrdenCompraRef   = $this->getRequestParameter( 'OrdenCompraRef' );
        
        $s_OrdenTipoComercialId     = $this->getRequestParameter( 'OrdenTipoComercialId' );
        $s_OrdenTipoClasificacionId = $this->getRequestParameter( 'OrdenTipoClasificacionId' );
        $s_DiasAlquiler             = $this->getRequestParameter( 'DiasAlquiler' );

        //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
        $o_MST_ValidezOfFN = new MST_ValidezOfFN();
        $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
        $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
        //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );
        
        $MonedaCod          = $this->getRequestParameter( 'MonedaCod' );
        $MonedaCambioValor  = $this->getRequestParameter( 'MonedaCambioValor' );
        
        $IdProyecto  = $this->getRequestParameter( 'IdProyecto' );
        
        $a_Rs = array();
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //recupero el id de caja y el turno
            /*$o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( !$a_FCO_Cierre )
            {
                throw new Exception( "No se aperturo ninguna Caja." );
            }
            if( count( $a_FCO_Cierre ) > 1 )
            {
                throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
            }
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $IdCaja      = $o_FCO_CierreBN->getIdCaja();
                $IdTurno     = $o_FCO_CierreBN->getIdTurno();
                $CodVendedor = $o_FCO_CierreBN->getCodVendedor();
            }*/
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //VALIDACION POR EL CODIGO DE VENDEDOR
            /*if( $CodVendedor != $IdVendedor )
            {
                throw new Exception( "El Codigo de Cajero es diferente a la Apertura de Caja." );
            }*/
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            /*$a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( count( $a_ALM_AlmacenMast ) == 1 )
            {
                $IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }*/
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //VALIDACION POR EL TIPO DE CAMBIO
            //if( !$f_TipoCambio ){ throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." ); }
            //ahora la validacion que si es soles va 1
            /*if( $MonedaCod == "LO" )
            {
                $MonedaCambioValor = 1;
            }*/

            //INFO DE LA SUCURSAL
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            if( !$o_MST_PersonaMastBN )
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
            }

            if( $o_MST_PersonaMastBN->getTipoPersona() == MST_PersonaMastBN::PERSONA_NATURAL )
            {
                if( $o_MST_PersonaMastBN->getDireccion() != $DireccionCliente )
                {
                    //se actualiza la direccion
                    $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                    $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                    $o_MST_PersonaMastDP->setDireccion( $DireccionCliente );
                    $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    //$o_MST_PersonaMastDP->update();
                }
            }
            
            $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
            $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();
            $ClienteDireccion        = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
            $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
            $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();
            if( strpos( $NumDocuCliente, "0000" ) === false )
            {
                $ClienteNombre = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
            }
            else
            {
                $NumDocuCliente = "00000000";
            }
            $VendedorAsigna     = $o_MST_PersonaMastBN->getVendedorAsignado();
            //$CanalCliente       = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente = $o_MST_PersonaMastBN->getNivelPrecioCliente();
            
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenObs( $Comentario );

            $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
            $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );

            //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
            if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }

            $o_VTA_OrdenBN->setClienteId( ( int ) $ClienteNumero );
            $o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
            $o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
            $o_VTA_OrdenBN->setClienteNombre( $ClienteNombre );
            //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec1( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
            $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
            $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
            $o_VTA_OrdenBN->setFactPais( "PERU" );
            $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
            $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );

            $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
            $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
            $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
            $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
            $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );
            
            $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
            $o_VTA_OrdenBN->setIdProyecto( ( int ) $IdProyecto );

            //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
            $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
            $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
            
            $o_VTA_OrdenBN->setOrdenTipoId( ( int ) $OrdenTipoId );
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $o_VTA_OrdenBN->setOrdenTipoComercialId( intval( $s_OrdenTipoComercialId ) );
                
                $o_VTA_OrdenBN->setOrdenTipoClasificacionId( intval( $s_OrdenTipoClasificacionId ) );
                
                $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );

                //$o_VTA_OrdenBN->setIdCaja( $IdCaja );
                //$o_VTA_OrdenBN->setIdTurno( $IdTurno );
                
                $s_OrdenFecha = date( "Y-m-d H:i:s" );
                
                $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                
                $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );

                $o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                if( $this->getRequestParameter( 'IdVendedor' ) )
                {
                    $o_VTA_OrdenBN->setVendedorOrden( $this->getRequestParameter( 'IdVendedor' ) );
                }

                //$o_VTA_OrdenBN->setPrecioNivel(  );
                $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                
                //$o_VTA_OrdenBN->setContactoMedio(  );
                //$o_VTA_OrdenBN->setContactoNombre(  );
                
                //$o_VTA_OrdenBN->setDocReferenciaTipo(  );
                //$o_VTA_OrdenBN->setDocReferenciaNum(  );
                //$o_VTA_OrdenBN->setDocReferenciaFecha(  );
                
                //$o_VTA_OrdenBN->setOrdenImpuestoFlag(  );
                
                $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                
                $o_VTA_OrdenBN->setOrdenEstado( "O" );
                
                $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                //pr( $o_VTA_OrdenBN ); exit;
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }
            else
            {
                //UPDATE
                $o_VTA_OrdenBN->setOrdenId( ( int ) $i_Id );
                
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }
            
            $i_Id = $o_VTA_OrdenBN->getOrdenId();
            
            $con->commit();
            
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDetailVta()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_OrdNum = $this->getRequestParameter( 'OrdNum' );
        $this->i_Id     = $this->getRequestParameter( 'i_Id' );
        $this->readonly = $this->getRequestParameter( 'readonly' );
        
        $this->s_Titulo = "Cotizaci&oacute;n";
        
        if( $this->getRequestParameter( 'OrdNum' ) )
        {
            $this->o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $this->s_OrdNum );
            $this->i_Id          = $this->o_VTA_OrdenBN->getOrdenId();
        }
        else
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->i_Id );
        }
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_OrdenBN->getMonedaCod() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_OrdenBN->getClienteId() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

        $i_IdProyecto = $this->o_VTA_OrdenBN->getIdProyecto();
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $this->o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $i_IdProyecto );
        
        //FORMA DE PAGO
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "O" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();
    }
    
    public function executeFindDetailVta()
    {
        $i_Id         = $this->getRequestParameter( 'i_Id' );
        $this->noedit = $this->getRequestParameter( 'noedit' );

        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $this->a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();

        $this->b_MostrarMargen = myUser::getUser()->getObjectCompania()->getMostrarMargenVenta();
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            $this->b_MostrarMargen = false;
        }

        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeDeleteDetailVta()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $a_Rs = array();
        
        $a_Rs['error'] = false;
        
        try
        {
            $a_Ids = explode( "_", $i_Id );
            $i_OrdenId         = $a_Ids[0];
            $i_OrdenDetalleNum = $a_Ids[1];
            
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_OrdenId );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( ( int ) $i_OrdenDetalleNum );
            
            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->eliminarLinea( $o_VTA_OrdenDetalleBN );
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
            //$a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeCambiarEstadoOrden()
    {
        $i_Id     = ( int ) $this->getRequestParameter( 'id' );
        $s_Estado = $this->getRequestParameter( 'estado' );
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";
        
        try
        {
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );
            $o_VTA_OrdenBN->setOrdenEstado( $s_Estado );
            if( $s_Estado == VTA_OrdenBN::ESTADO_ANULADO )
            {
                $s_MotivoAnulacion = $this->getRequestParameter( 'motivo_anulacion' );
                $o_VTA_OrdenBN->setAnulacionComentario( $s_MotivoAnulacion );
            }
            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->cambiarEstadoOrdenVenta( $o_VTA_OrdenBN );
            
            //cuando el estado es aprobado se activa el producto final
            foreach ( $o_VTA_OrdenBN->getArrayDetalles() as $o_VTA_OrdenDetalleBN )
            {
                if( $o_VTA_OrdenDetalleBN->getItemTipo() == VTA_OrdenDetalleBN::TIPO_PRODUCTO_FINAL )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_OrdenDetalleBN->getItemCod() );
                    if( $o_ALM_ItemMastBN )
                    {
                        $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                        $o_ALM_ItemMastDP->setIdItem( $o_VTA_OrdenDetalleBN->getItemCod() );
                        
                        if( $s_Estado == VTA_OrdenBN::ESTADO_CERRADO )
                        {
                            $o_ALM_ItemMastDP->setEstado( ALM_ItemMastBN::ESTADO_ACTIVO );
                        }
                        if( $s_Estado != VTA_OrdenBN::ESTADO_CERRADO )
                        {
                            $o_ALM_ItemMastDP->setEstado( ALM_ItemMastBN::ESTADO_INACTIVO );
                        }
                        
                        $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_ALM_ItemMastDP->update();
                    }
                    else 
                    {
                        throw new Exception( "No se encontro el Producto Final." );
                    }
                }
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeListPrecio()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_IdItem    = $this->getRequestParameter( 'id_item' );
        $this->i_Id        = $this->getRequestParameter( 'id' );
        $this->s_Secuencia = $this->getRequestParameter( 'secuencia' );
        
        try
        {
            myUser::getUser()->validar_session();
            
            $this->b_Error = false;
            
            if( !myUser::getUser()->getIdSucursal() )
            {
                throw new Exception( "Se tiene que seleccionar Sucursal." );
            }
            
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->i_Id );

            //$o_MST_RangoFN = new MST_RangoFN();
            //$this->o_MST_RangoBN = $o_MST_RangoFN->selectByPK( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() );


            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $this->o_VTA_DocumentoDetalleBN = $o_VTA_OrdenDetalleFN->selectByPK( $this->i_Id, $this->s_Secuencia );
            
            //$s_OrdenTipoCod = $this->o_VTA_OrdenBN->getOrdenTipoObject()->getOrdenTipoCod();
            
            $this->f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->s_IdItem );

            $this->AfectoIGV = "Y";
            if( !$this->o_ALM_ItemMastBN->EsAfectoaIGV() )
            {
                $this->AfectoIGV = "N";
            }

            if( $this->o_VTA_OrdenBN->esExoneradodeIGV() )
            {
                $this->AfectoIGV = "N";
            }
            
            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraFN->setIdTipoLista( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() );
            $o_MST_ListaPrecioCabeceraFN->addOrderBy( MST_ListaPrecioCabeceraFN::IdTipoLista );
            $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
            $this->o_MST_ListaPrecioCabeceraBN = null;
            if( $a_MST_ListaPrecioCabecera )
            {
                $this->o_MST_ListaPrecioCabeceraBN = $a_MST_ListaPrecioCabecera[0];
            }
            else
            {
                throw new Exception( "El cabecera de precios no existe." );
            }

            //$this->o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            
            $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
            $o_MST_ListaPrecioDetalleFN->setIdListaPreciCab( $this->o_MST_ListaPrecioCabeceraBN->getIdListaPreciCab() );
            $o_MST_ListaPrecioDetalleFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_MST_ListaPrecioDetalleFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_MST_ListaPrecioDetalleFN->setIdRango( $this->o_ALM_ItemMastBN->getIdRangoVenta() );
            $o_MST_ListaPrecioDetalleFN->setIdItem( $this->s_IdItem );
            $o_MST_ListaPrecioDetalleFN->setEstado( "A" );
            $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::IdRangoDetalle );
            $this->a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
            //$this->a_MST_ListaPrecioDetalle = array();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
            exit;
        }
    }
    
    public function executeChangePrice()
    {
        $s_IdItem       = $this->getRequestParameter( 'id_item' );
        $s_Contrasenia  = trim( $this->getRequestParameter( 'contrasenia' ) );
        $i_Id           = intval( $this->getRequestParameter( 'id' ) );
        $s_Secuencia    = intval( $this->getRequestParameter( 'secuencia' ) );
        $s_IdTipoPrecio = $this->getRequestParameter( 'tipo_precio' );
        $f_PrecioPersa  = floatval( $this->getRequestParameter( 'txt_precio' ) );
        
        $a_Rs = array();
        
        try
        {
            myUser::getUser()->validar_session();
            
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $i_Id );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $s_Secuencia );
            $o_VTA_OrdenDetalleBN->setItemCod( $s_IdItem );
            $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( $s_IdTipoPrecio );
            $o_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $f_PrecioPersa );
            $o_VTA_OrdenDetalleBN->setContrasenia( $s_Contrasenia );
            //$o_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $f_PrecioPersa );

            //SE PENSO QUE SE PUEDE AGREGAR BAJAR EL PRECIO POR EL PORCENTAJE QUE SE LE ASIGNA AL VENDEDOR
            //LA MISMA LOGICA QUE EL DESCUENTO EN GLOBAL, CON LA CONTRASEÑA DEL UN ADMINISTRADOR

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->iniciarCambioPrecio( $o_VTA_OrdenDetalleBN );
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeTotalesMaster()
    {
        try 
        {
            myUser::getUser()->validar_session();
            
            $o_GridAction = $this->buildGrid();
            
            $o_GridAction->setMethodSelectCustom( "selectTotales" );
            $o_Row = $o_GridAction->initialize();

            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            if( !$o_MST_ListaPrecioCabeceraBN )
            {
                $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
            }
            
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {
                $this->f_SumaOrdenAfecto   = $o_Row['SumaOrdenAfectoMN'];
                $this->f_SumaOrdenInafecto = $o_Row['SumaOrdenInafectoMN'];
                $this->f_SumaOrdenImpuesto = $o_Row['SumaOrdenImpuestoMN'];
                $this->f_SumaOrdenNeto     = $o_Row['SumaOrdenNetoMN'];
            }
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
            {
                $this->f_SumaOrdenAfecto   = $o_Row['SumaOrdenAfecto'];
                $this->f_SumaOrdenInafecto = $o_Row['SumaOrdenInafecto'];
                $this->f_SumaOrdenImpuesto = $o_Row['SumaOrdenImpuesto'];
                $this->f_SumaOrdenNeto     = $o_Row['SumaOrdenNeto'];
            }
            
            $this->s_MonedaPrf = GSS_MonedaMastFN::getSiglaxId( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() );
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
        
        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeConvertirOrdenEstandar()
    {
        $i_Id     = ( int ) $this->getRequestParameter( 'id' );

        $a_Rs = array();
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";

        $con = Conexion::getConexion();
        $con->begin();

        try
        {
            myUser::getUser()->validar_session();

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );

            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->convertirOrdenEstandar( $o_VTA_OrdenBN );
            
            $a_Rs['id_orden']  = $o_VTA_OrdenBN->getOrdenId();
            $a_Rs['num_orden'] = $o_VTA_OrdenBN->getOrdenNum();

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeCopiarOrdenVenta()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        $i_DiasAlquiler = ( int ) $this->getRequestParameter( 'dias_alquiler' );

        $a_Rs = array();
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";

        try
        {
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );
            $o_VTA_OrdenBN->setDiasAlquiler( $i_DiasAlquiler );

            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->copiarOrdenVenta( $o_VTA_OrdenBN );

            $i_IdFinal = $o_VTA_OrdenBN->getOrdenId();
            
            //pr( "Id Final -> $i_IdFinal || Padre -> ".$o_VTA_OrdenBN->getOrdenPadre() );

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_IdFinal;
        }
        catch( Exception $e )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $e->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    private function buildGrid()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_OrdenFN() );
        
        $o_GridAction->addAssignFilter( "OrdenTipoId" );
        $o_GridAction->addAssignFilter( "OrdenEstado" );
        //$o_GridAction->addAssignFilter( "OrdenNum" );
        $o_GridAction->addAssignFilter( "ClienteDocNum" );
        $o_GridAction->addAssignFilter( "VendedorOrden" );
        $o_GridAction->addAssignFilter( "OrdenTipoComercialId" );
        $o_GridAction->addAssignFilter( "OrdenTipoClasificacionId" );
        
        $o_GridAction->addConditionFilter( "OrdenNum", VTA_OrdenFN::OrdenNum, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_OrdenFN::ClienteNombre, "LIKE", "%%s%" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", VTA_OrdenFN::OrdenFecha,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", VTA_OrdenFN::OrdenFecha,  "<=", '23:59:59' );

        $o_GridAction->addMethodDefault( "CiaCod", myUser::getUser()->getIdBusiness() );

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                //$o_GridAction->addMethodDefault( VTA_OrdenFN::UsuarioCreacion, array( 'Condition'=>'=', 'Value'=>"" ) );
                $o_GridAction->addMethodDefault( VTA_OrdenFN::UsuarioCreacion, myUser::getUser()->getUserId() );
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        if( $this->getRequestParameter( 'CobranzaEstado' ) )
        {
            $s_EstadoCob = $this->getRequestParameter( 'CobranzaEstado' );
            $o_GridAction->addMethodDefault( "( SELECT CobranzaEstado FROM VTA_Documento WHERE DocumentoParentId=VTA_Orden.OrdenId )", array( 'Condition'=>'=', 'Value'=>"'$s_EstadoCob'" ) );
        }

        if( $this->getRequestParameter( 'CodItem' ) )
        {
            $s_Cod = $this->getRequestParameter( 'CodItem' );
            ParameterWR::getInstance()->setVar( "CodItem", 1 );
            $o_GridAction->addConditionFilter( "CodItem", "( SELECT count(*) FROM VTA_OrdenDetalle where OrdenId=VTA_Orden.OrdenId and ItemCod in ('$s_Cod') )", ">=", "%s" );
        }
        
        return $o_GridAction; 
    }
}