<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class ValorizadoPDFAction extends wtActions
{
    public function execute()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_VTA_OrdenBN->getCiaCod() );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();
        
        $host_name = "localhost";
        if( $_SERVER['HTTP_HOST'] != "localhost" )
        {
            $host_name = $_SERVER['HTTP_HOST'];
        }
        
        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        (
                "o_GSS_CompaniaBN"   => $o_GSS_CompaniaBN,
                "o_VTA_OrdenBN"      => $o_VTA_OrdenBN,
                "a_VTA_OrdenDetalle" => $a_VTA_OrdenDetalle,
                "a_CuentasBancarias" => $a_CuentasBancarias
        );
        $s_vHtml = 0;
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html;         exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Venta_'.$o_VTA_OrdenBN->getOrdenNum(), array( "Attachment" => 0 ) );
        
        exit;
    }
}