<?php
class RequestOrdenAction extends wtActions
{
    public function execute()
    {
        $s_FormaPagoId = $this->getRequestParameter( 'FormaPagoId' );
        $s_OrdenId     = $this->getRequestParameter( 'OrdenId' );
        $s_TipoProc    = $this->getRequestParameter( 'TipoProc' );
        
        $a_lst       = array( "Result" => false, "error" => false );

        try
        {
            switch ( $s_TipoProc )
            {
                case "buscatTotalaPagar":

                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_OrdenId );
                    if( !$o_VTA_OrdenBN )
                    {
                        throw new Exception( "La Orden no existe." );
                    }

                    $f_TotalaPagar = $o_VTA_OrdenBN->getOrdenTotalaPagar() ? $o_VTA_OrdenBN->getOrdenTotalaPagar() : 0;
                    $a_lst['totalapagar'] = $f_TotalaPagar;
                    $a_lst['error']  = false;

                break;
                case "actualizarTipoDocumento":

                    $s_ValorId  = $this->getRequestParameter( 'ValorId' );

                    $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                    $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $s_ValorId );
                    $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
                    if( !$a_GSS_SucursalDocumento )
                    {
                        throw new Exception( "El Tipo de Documento no existe." );
                    }

                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_OrdenId );
                    if( !$o_VTA_OrdenBN )
                    {
                        throw new Exception( "La Orden no existe." );
                    }

                    $o_VTA_OrdenDP = new VTA_OrdenDP();
                    $o_VTA_OrdenDP->setOrdenId( ( int ) $s_OrdenId );
                    $o_VTA_OrdenDP->setReferenciaTipoDocId( $a_GSS_SucursalDocumento[0]->getIdTipoDocumento() );
                    $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $b_Result = $o_VTA_OrdenDP->update();

                    $a_lst['result'] = $b_Result;
                    $a_lst['error']  = false;

                break;
                case "actualizarFechaAlquiler":
                    
                    $s_FechaInicioAlquiler  = $this->getRequestParameter( 'FechaInicioAlquiler' );
                    
                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_OrdenId );
                    
                    //$s_FechaFinAlquiler = UtilDate::obtenerOrdenFechaVenc( ( $o_VTA_OrdenBN->getDiasAlquiler() * 24 ) );
                    $s_FechaFinAlquiler = UtilDate::sumarDias( $s_FechaInicioAlquiler, ( $o_VTA_OrdenBN->getDiasAlquiler() - 1 ) );
                    
                    
                    if( !$this->getRequestParameter( 'NoUpdate' ) )
                    {
                        $o_VTA_OrdenDP = new VTA_OrdenDP();
                        $o_VTA_OrdenDP->setOrdenId( ( int ) $s_OrdenId );
                        $o_VTA_OrdenDP->setFechaInicioAlq( $s_FechaInicioAlquiler );
                        $o_VTA_OrdenDP->setFechaFinAlq( $s_FechaFinAlquiler );
                        $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_VTA_OrdenDP->update();
                    }
                    else
                    {
                        $b_Result = 1;
                    }
                    
                    $a_lst['FechaInicioAlquiler'] = $s_FechaInicioAlquiler;
                    $a_lst['FechaFinAlquiler']    = $s_FechaFinAlquiler;
                    
                    $a_lst['result'] = $b_Result;
                    $a_lst['error']  = false;
                    
                break;
                case "buscarPrecioEncofrado":
                    
                    $s_IdOrden      = $this->getRequestParameter( 'IdOrden' );
                    $s_IdSubFamilia = $this->getRequestParameter( 'IdSubFamilia' );
                    $f_Altura       = floatval( $this->getRequestParameter( 'Altura' ) );
                    
                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_IdOrden );

                    $o_MST_ClaseSubFamiliaBN = null;
                    if( $s_IdSubFamilia )
                    {
                        $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                        $o_MST_ClaseSubFamiliaBN = $o_MST_ClaseSubFamiliaFN->selectByPK( $s_IdSubFamilia );
                    }

                    if( $o_MST_ClaseSubFamiliaBN )
                    {
                        
                        if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == 1 ) //para venta
                        {
                            if( $o_MST_ClaseSubFamiliaBN->getEsParaVenta() == "NO" )
                            {
                                throw new Exception( "La Sub Familia no tiene Precio para Venta" );
                            }
                            $i_IdRango = $o_MST_ClaseSubFamiliaBN->getIdRangoVenta();
                        }
                        if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == 2 ) //para alquiler
                        {
                            if( $o_MST_ClaseSubFamiliaBN->getEsParaAlquiler() == "NO" )
                            {
                                throw new Exception( "La Sub Familia no tiene Precio para Alquiler" );
                            }
                            $i_IdRango = $o_MST_ClaseSubFamiliaBN->getIdRangoAlquiler();
                        }
                        
                        $o_TMP_MST_RangoDetalleBN = null;
                        $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                        $o_MST_RangoDetalleFN->setIdRango( $i_IdRango );
                        $a_MST_RangoDetalle = $o_MST_RangoDetalleFN->select();
                        if( !$a_MST_RangoDetalle )
                        {
                            throw new Exception( "No tiene registros de Rango Detalle por Precios." );
                        }
                        
                        foreach ( $a_MST_RangoDetalle as $o_MST_RangoDetalleBN )
                        {
                            if( $f_Altura >= $o_MST_RangoDetalleBN->getMinimo() && $f_Altura <= $o_MST_RangoDetalleBN->getMaximo() )
                            {
                                $o_TMP_MST_RangoDetalleBN = $o_MST_RangoDetalleBN;
                                break;
                            }
                        }

                        if( $o_TMP_MST_RangoDetalleBN )
                        {
                            $o_MST_ListaPrecioSubFamDetFN = new MST_ListaPrecioSubFamDetFN();
                            $o_MST_ListaPrecioSubFamDetFN->setIdRangoDetalle( $o_TMP_MST_RangoDetalleBN->getIdRangoDetalle() );
                            $o_MST_ListaPrecioSubFamDetFN->setIdSubFamilia( $s_IdSubFamilia );
                            $o_MST_ListaPrecioSubFamDetFN->setIdRango( $i_IdRango );
                            $o_MST_ListaPrecioSubFamDetFN->setIdTipoLista( $o_VTA_OrdenBN->getOrdenTipoComercialId() );

                            $a_MST_ListaPrecioSubFamDet = $o_MST_ListaPrecioSubFamDetFN->select();
                            
                            if( $a_MST_ListaPrecioSubFamDet )
                            {
                                if( count( $a_MST_ListaPrecioSubFamDet ) > 1 )
                                {
                                    throw new Exception( "Se encontro varios Precios." );
                                }
                                $a_lst = $a_MST_ListaPrecioSubFamDet[0]->toArray();
                            }
                            else
                            {
                                throw new Exception( "No se encontro Lista de Precio Sub Familia." );
                            }
                        }
                        else
                        {
                            throw new Exception( "No se encontro el Rango por la Altura ingresada." );
                        }
                    }
                    
                break;
                case "actualizarFormaPago":

                    $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
                    $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $s_FormaPagoId );
                    if( !$o_VTA_FormaPagoBN )
                    {
                        throw new Exception( "El Medio de Pago no existe." );
                    }

                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_OrdenId );
                    if( !$o_VTA_OrdenBN )
                    {
                        throw new Exception( "La Orden no existe." );
                    }

                    $o_VTA_OrdenDP = new VTA_OrdenDP();
                    $o_VTA_OrdenDP->setOrdenId( ( int ) $s_OrdenId );
                    //$o_VTA_OrdenDP->setContactoNombre( $s_FormaPagoId );
                    $o_VTA_OrdenDP->setCondicionVentaId( $s_FormaPagoId );
                    $o_VTA_OrdenDP->setFormaPagoDesc( $o_VTA_FormaPagoBN->getDescripcionLocal() );
                    $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $b_Result = $o_VTA_OrdenDP->update();
                    
                    $a_lst['result'] = $b_Result;
                    $a_lst['error']  = false;

                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_lst['error']         = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
}