<?php
class ProdFinalAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $s_Id          = $this->getRequestParameter( 'i_Id' );
        $s_IdAlmacen   = $this->getRequestParameter( 'IdAlmacen' );
        $s_IdProdFinal = $this->getRequestParameter( 'idprod' );
        $this->s_Tipo  = $this->getRequestParameter( 'tipo' );
        
        $this->s_Titulo  = "Registrar Producto Final";
        $this->s_Mensaje = "";
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_Id );
        
        $this->o_VTA_ProductoFinalBN = new VTA_ProductoFinalBN();
        
        if( $s_IdProdFinal )
        {
            $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
            $this->o_VTA_ProductoFinalBN = $o_VTA_ProductoFinalFN->selectByPK( $s_IdProdFinal );
        }
        
        $this->f_SumaTotalAlq = 0;
        if( $s_IdProdFinal )
        {
            $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
            $o_VTA_ProductoFinalDetFN->setOrdenId( $s_Id );
            $o_VTA_ProductoFinalDetFN->setProFinalId( $s_IdProdFinal );
            $a_VTA_ProductoFinalDet = $o_VTA_ProductoFinalDetFN->select();
            foreach ( $a_VTA_ProductoFinalDet as $o_VTA_ProductoFinalDetBN )
            {
                $this->f_SumaTotalAlq = $this->f_SumaTotalAlq + $o_VTA_ProductoFinalDetBN->getTotalConIGVAlq();
            }
        }
        
        $this->b_Control = false;
        
        if( $this->getRequestParameter( 'Control' ) )
        {
            //aqui se realiza el proceso
            $s_Altura       = $this->getRequestParameter( 'Altura' );
            $s_Cantidad     = $this->getRequestParameter( 'Cantidad' );
            $s_PrecioUnit   = $this->getRequestParameter( 'valor_unit' ); //valor sin igv
            $s_ImpuestoUnit = $this->getRequestParameter( 'monto_igv' ); //igv
            $s_TotalUnit    = $this->getRequestParameter( 'txt_precio' ); //valor con igv
            $s_DsctoTipoCod = $this->getRequestParameter( 'DsctoTipoCod' ); //codigo descuento
            //$s_DsctoCod     = $this->getRequestParameter( 'DsctoCod' ); //porcentaje descuento
            $s_DsctoCod     = "";
            
            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////
            
            //para recuperar la moneda del sistema
            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            
            if( !$o_MST_ListaPrecioCabeceraBN )
            {
                $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
            }
            //////////////////////////////////////////////////////////////////////////////////////////
            $b_ControlImpuesto = $this->o_VTA_OrdenBN->esGravadaConImpuesto();
            $s_OrdenMonedaCod  = $this->o_VTA_OrdenBN->getMonedaCod();
            //////////////////////////////////////////////////////////////////////////////////////////
            
            if( $b_ControlImpuesto )
            {
                $f_MontoSubTotal         = round( floatval( $s_PrecioUnit ) * floatval( $s_Cantidad ), 2 );
                $f_MontoSubTotalImpuesto = round( $f_MontoSubTotal * $f_ValorIGV, 2 );
                $f_MontoTotalNeto        = $f_MontoSubTotal + $f_MontoSubTotalImpuesto;

                /*$f_MontoTotalNeto        = floatval( $s_TotalUnit ) * floatval( $s_Cantidad );
                $f_MontoSubTotal         = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
                $f_MontoSubTotalImpuesto = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );*/
            }
            else
            {
                $s_TotalUnit             = $s_PrecioUnit;
                $s_ImpuestoUnit          = 0;
                $f_MontoTotalNeto        = round( floatval( $s_PrecioUnit ) * floatval( $s_Cantidad ), 2 );
                $f_MontoSubTotal         = $f_MontoTotalNeto;
                $f_MontoSubTotalImpuesto = 0;
            }
            
            $f_MontoDscto       = 0;
            $f_BaseImponible    = $f_MontoSubTotal;
            $f_ImpuestoConDscto = $f_MontoSubTotalImpuesto;
            $f_TotalaPagar      = $f_MontoTotalNeto;
            /*
            if( $s_DsctoCod )
            {
                $f_DsctoMulti       = ( floatval( $s_DsctoCod ) / 100 );
                $f_MontoDscto       = round( $f_MontoSubTotal * $f_DsctoMulti, 2 );
                $f_BaseImponible    = $f_MontoSubTotal - $f_MontoDscto;
                $f_ImpuestoConDscto = round( $f_BaseImponible * $f_ValorIGV, 2 );
                $f_TotalaPagar      = $f_BaseImponible + $f_ImpuestoConDscto;
            }
            else
            {
                $s_DsctoTipoCod = "";
            }
            */
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            $s_IdLinea      = $this->getRequestParameter( 'IdLinea' );
            $s_IdFamilia    = $this->getRequestParameter( 'IdFamilia' );
            $s_IdSubFamilia = $this->getRequestParameter( 'IdSubFamilia' );
            $i_IdUnidad     = $this->getRequestParameter( 'IdUnidad' );

            $s_DetalleDescripcion = $this->getRequestParameter( 'DetalleDescripcion' );

            $con = Conexion::getConexion();
            $con->begin();
            
            try
            {
                myUser::getUser()->validar_session();
                
                if( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() == 2 ) //alquiler, es de tipo servicio
                {
                    $s_IdItemTipo = "02";
                }
                else
                {
                    $s_IdItemTipo = "01"; //para venta, es mercaderia
                }

                /*$i_IdUnidad = 58;
                if( $this->s_Tipo == "1" ) //ENCOFRADO
                {
                    $i_IdUnidad = 65;
                }*/
                
                if( !$s_IdProdFinal )
                {
                    //nuevo producto
                    $s_IdItem = ALM_ItemMastFN::recuperarId();
                    $s_CodigoInterno = ALM_ItemMastDP::recuperarCodigoInterno();
                    
                    $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                    $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                    $o_ALM_ItemMastDP->setCodigoInterno( ( string ) $s_CodigoInterno );
                    $o_ALM_ItemMastDP->setIdMarca( "1" );
                    $o_ALM_ItemMastDP->setIdLinea( ( int ) $s_IdLinea );
                    $o_ALM_ItemMastDP->setIdFamilia( ( int ) $s_IdFamilia );
                    $o_ALM_ItemMastDP->setIdSubFamilia( ( int ) $s_IdSubFamilia );
                    $o_ALM_ItemMastDP->setIdItemTipo( $s_IdItemTipo ); //01 - MERCADERIA //02 - SERVICIOS
                    $o_ALM_ItemMastDP->setDescripcionCompleta( $s_DetalleDescripcion );
                    $o_ALM_ItemMastDP->setUnidadCompra( ( string ) $i_IdUnidad ); //unidad
                    $o_ALM_ItemMastDP->setUnidadVenta( ( string ) $i_IdUnidad ); //unidad
                    $o_ALM_ItemMastDP->setPrecioCosto( 0 );
                    $o_ALM_ItemMastDP->setPrecioUnitarioLocal( 0 );
                    $o_ALM_ItemMastDP->setPrecioUnitarioDolares( 0 );
                    $o_ALM_ItemMastDP->setEstado( "I" );
                    $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_ItemMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_ItemMastDP->setNoAfectoImpuestoVentasFlag( "N" );
                    
                    if( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() == 2 ) //alquiler
                    {
                        $o_ALM_ItemMastDP->setEsInventariableFlag( "N" );
                        $o_ALM_ItemMastDP->setUsarDisponibleStock( "N" );
                        $o_ALM_ItemMastDP->setUsarResevableStock( "N" );
                    }
                    else
                    {
                        $o_ALM_ItemMastDP->setEsInventariableFlag( "S" );
                        $o_ALM_ItemMastDP->setUsarDisponibleStock( "S" );
                        $o_ALM_ItemMastDP->setUsarResevableStock( "S" );
                    }
                    
                    $o_ALM_ItemMastDP->setFusionarLoteFlag( "N" );
                    $o_ALM_ItemMastDP->setEsServicioConDias( "N" );
                    
                    $o_ALM_ItemMastDP->setTipoGarantiaId( "18" );
                    //$o_ALM_ItemMastDP->setUsarReservableStock( "N" );
                    $o_ALM_ItemMastDP->save();
                }
                else
                {
                    //update
                    $s_IdItem = $this->o_VTA_ProductoFinalBN->getIdItem();
                    
                    $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                    $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                    $o_ALM_ItemMastDP->setIdItemTipo( $s_IdItemTipo ); //01 - MERCADERIA //02 - SERVICIOS
                    $o_ALM_ItemMastDP->setIdLinea( ( int ) $s_IdLinea );
                    $o_ALM_ItemMastDP->setIdFamilia( ( int ) $s_IdFamilia );
                    $o_ALM_ItemMastDP->setIdSubFamilia( ( int ) $s_IdSubFamilia );
                    $o_ALM_ItemMastDP->setPrecioCosto( 0 );
                    $o_ALM_ItemMastDP->setPrecioUnitarioLocal( 0 );
                    $o_ALM_ItemMastDP->setPrecioUnitarioDolares( 0 );
                    $o_ALM_ItemMastDP->setDescripcionCompleta( trim( $s_DetalleDescripcion ) );
                    $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_ItemMastDP->update();
                }
                
                $o_VTA_ProductoFinalDP = new VTA_ProductoFinalDP();
                $o_VTA_ProductoFinalDP->setIdLinea( ( int ) $s_IdLinea );
                $o_VTA_ProductoFinalDP->setIdFamilia( ( int ) $s_IdFamilia );
                $o_VTA_ProductoFinalDP->setIdSubFamilia( ( int ) $s_IdSubFamilia );
                $o_VTA_ProductoFinalDP->setDetalleDescripcion( trim( $s_DetalleDescripcion ) );
                $o_VTA_ProductoFinalDP->setIdUnidad( ( int ) $i_IdUnidad );
                $o_VTA_ProductoFinalDP->setIdItemTipo( $s_IdItemTipo );
                
                $o_VTA_ProductoFinalDP->setAltura( floatval( $s_Altura ) );
                $o_VTA_ProductoFinalDP->setCantidad( floatval( $s_Cantidad ) );
                $o_VTA_ProductoFinalDP->setPrecioUnitario( floatval( $s_PrecioUnit ) );
                $o_VTA_ProductoFinalDP->setImpuestoUnitario( floatval( $s_ImpuestoUnit ) );
                $o_VTA_ProductoFinalDP->setPrecioUnitarioConIGV( floatval( $s_TotalUnit ) );
                $o_VTA_ProductoFinalDP->setSubTotalSinIGV( $f_MontoSubTotal );
                $o_VTA_ProductoFinalDP->setImpuestoSubTotal( $f_MontoSubTotalImpuesto );
                $o_VTA_ProductoFinalDP->setPrecioTotalConIGV( $f_MontoTotalNeto );

                $o_VTA_ProductoFinalDP->setDsctoTipoCod( $s_DsctoTipoCod );
                $o_VTA_ProductoFinalDP->setDsctoCod( $s_DsctoCod );
                $o_VTA_ProductoFinalDP->setDsctoTotal( $f_MontoDscto );
                $o_VTA_ProductoFinalDP->setBaseImponible( $f_BaseImponible );
                $o_VTA_ProductoFinalDP->setImpuestoConDscto( $f_ImpuestoConDscto );
                $o_VTA_ProductoFinalDP->setTotalaPagar( $f_TotalaPagar );

                if( !$s_IdProdFinal )
                {
                    //nuevo:
                    $i_IdProdFin = VTA_ProductoFinalDP::recuperarId();
                    $s_Secuencia = VTA_ProductoFinalDP::recuperarSecuencia( $s_Id );
                    
                    $o_VTA_ProductoFinalDP->setProFinalId( $i_IdProdFin );
                    $o_VTA_ProductoFinalDP->setIdAlmacen( $s_IdAlmacen );
                    $o_VTA_ProductoFinalDP->setOrdenId( ( int ) $s_Id );
                    $o_VTA_ProductoFinalDP->setIdAlmacen( $s_IdAlmacen );
                    $o_VTA_ProductoFinalDP->setItemTipoClase( ( int ) $this->s_Tipo );
                    $o_VTA_ProductoFinalDP->setSecuencia( $s_Secuencia );
                    $o_VTA_ProductoFinalDP->setIdItem( $s_IdItem );
                    $o_VTA_ProductoFinalDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDP->save();
                }
                else
                {
                    //update
                    $o_VTA_ProductoFinalDP->setProFinalId( ( int ) $s_IdProdFinal );
                    $o_VTA_ProductoFinalDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDP->update();
                }
                
                VTA_OrdenDP::actualizarCabaceraMontos2( ( int ) $s_Id );
                
                $this->b_Control = true;
                
                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                $con->rollback();
                $this->s_Mensaje = $o_Exception->getMessage();
            }
        }
    }
}