<?php
class CerrarCajaAction extends wtActions
{
    public function execute()
    {
        $s_IdCaja     = $this->getRequestParameter( 'id_caja' );
        $s_IdVendedor = $this->getRequestParameter( 'id_vendedor' );

        $a_Result = array( "Result" => false, "error" => false );

        $con = Conexion::getConexion();
        $con->begin();

        try
        {
            myUser::getUser()->validar_session();

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se recupera la caja aperturada - que por ahora solo es una caja
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( !$a_FCO_Cierre )
            {
                pr( "No se aperturo ninguna Caja." );
                exit;
            }
            $this->b_ControlCaja = false;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
            }
            else
            {
                pr( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
                exit;
            }
            
            $i_IdCierre     = $o_FCO_CierreBN->getIdCierre();
            $s_IdCaja       = $o_FCO_CierreBN->getIdCaja(); //solo hay una caja, por lo tanto es por defecto
            $s_IdVendedor   = $o_FCO_CierreBN->getCodVendedor();
            $i_IdTurno      = $o_FCO_CierreBN->getIdTurno();

            $s_FechaCreaCierre = $o_FCO_CierreBN->getFechaCreacion();
            
            $s_FechaCierre  = date( "Y-m-d H:i:s" );
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se genera el cierre
            //pero ahora se cambia el precedimiento, el registro ya existe con un estado abierto, se tiene que cambiar a cerrado - 2020-02-03
            //$i_IdCierre = FCO_CierreDP::recuperarId();

            $o_FCO_CierreDP = new FCO_CierreDP();
            $o_FCO_CierreDP->setIdCierre( $i_IdCierre );
            $o_FCO_CierreDP->setFechaCierre( $s_FechaCierre );
            $o_FCO_CierreDP->setTotalSoles( 0 );
            $o_FCO_CierreDP->setTotalDolares( 0 );
            $o_FCO_CierreDP->setEstado( FCO_CierreBN::ESTADO_CERRADO );
            $o_FCO_CierreDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_CierreDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_CierreDP->update();
            usleep( 500000 );
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //actualizamos el id_caja en documentos
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoFN->setIdCaja( $s_IdCaja );
            $o_VTA_DocumentoFN->setIdTurno( $i_IdTurno );
            if( $s_IdVendedor )
            {
                //$o_VTA_DocumentoFN->setVendedor( $s_IdVendedor );
            }
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, 'IN', "( 'CE','AN')", false );
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdCierre, 'IS', "NULL", false );
            $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoCod );
            $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoSerie );
            $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoNumero );
            $a_VTA_Documento = $o_VTA_DocumentoFN->select();
            $f_MontoTotalSoles = 0;
            foreach ( $a_VTA_Documento as $o_VTA_DocumentoBN ) 
            {
                if( $o_VTA_DocumentoBN->getEstado() == "CE" )
                {
                    $f_MontoTotalSoles = $o_VTA_DocumentoBN->getMontoTotal() + $f_MontoTotalSoles;
                }
            }
            if( $f_MontoTotalSoles <= 0 )
            {
                //throw new Exception( "No se encontro data para cierre." );
            }
            
            $o_VTA_DocumentoDP = new VTA_DocumentoDP();
            $o_VTA_DocumentoDP->setIdCaja( intval( $s_IdCaja ) );
            $o_VTA_DocumentoDP->setIdTurno( $i_IdTurno );
            $o_VTA_DocumentoDP->setIdCierre( $i_IdCierre ); //este valor se utiliza para actualizar
            if( $s_IdVendedor )
            {
                //$o_VTA_DocumentoDP->setVendedor( $s_IdVendedor );
            }
            $o_VTA_DocumentoDP->actualizarIdCierre();


            //aqui se agrega un procedimiento para las aplicaciones asociados se actualice con el id de cierre
            foreach ( $a_VTA_Documento as $o_VTA_DocumentoBN ) 
            {
                if( $o_VTA_DocumentoBN->getEstado() != "CE" )
                {
                    continue;
                }
                if( $o_VTA_DocumentoBN->getIdTipoDocumento() == "NC" )
                {
                    continue;
                }
                $a_FCO_Aplicacion = FCO_AplicacionFN::buscarPorIdReferenciaDoc( $o_VTA_DocumentoBN->getNumeroDocumento() );
                if( !$a_FCO_Aplicacion )
                {
                    throw new Exception( "No se encontro aplicacion[es] asociado[s] [".$o_VTA_DocumentoBN->getDocumentoParentCod()."] [".$o_VTA_DocumentoBN->getDocumentoSerieNumero()."] [".$o_VTA_DocumentoBN->getNumeroDocumento()."] ." );
                }

                foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
                {
                    if( UtilDate::validarFecha1Mayor( $o_FCO_AplicacionBN->getFechaAplicacion(), $s_FechaCierre ) )
                    {
                        //pr( "Mayor" );
                        //pr( $o_FCO_AplicacionBN );
                        $s_IdAplicacion = $o_FCO_AplicacionBN->getIdAplicacion();
                        $s_FechaAplica  = $o_FCO_AplicacionBN->getFechaAplicacion();
                        $s_Comprobante  = "(".$o_FCO_AplicacionBN->getIdDocNumRef().")".$o_FCO_AplicacionBN->getCodDocRef()."-".$o_FCO_AplicacionBN->getSerieNumeroDocRef();
                        
                        $o_PHPMailer = new PHPMailer();
                        $o_PHPMailer->Mailer   = 'smtp';
                        $o_PHPMailer->Host     ='127.0.0.1';
                        $o_PHPMailer->From     = "willjce@gmail.com";
                        $o_PHPMailer->FromName = "Sistema Sermaqui";
                        $o_PHPMailer->Subject  = "[Advertencia][FechaAplicacion]";
                        $o_PHPMailer->Body     = "IdAplicacion [$s_IdAplicacion] | Fecha Aplicacion [$s_FechaAplica] | Fecha Cierre [$s_FechaCierre] | Comprobante [$s_Comprobante]";
                        $o_PHPMailer->AddAddress( "msotomayor@dataexe.com" );
                        $o_PHPMailer->AddCC( "willjce@gmail.com" );
                        $send = $o_PHPMailer->Send();
                    }
                    $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                    $o_FCO_AplicacionDP->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
                    $o_FCO_AplicacionDP->setIdCierre( $i_IdCierre ); //este valor se utiliza para actualizar
                    $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_FCO_AplicacionDP->update();
                }
            }
            usleep( 500 );
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AQUI SE BUSCA APLICACIONES PENDIENTES - 2020-11-19
            $o_FCO_AplicacionFN = new FCO_AplicacionFN();
            $o_FCO_AplicacionFN->setEstado( "PE" );
            $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdCierre, 'IS', "NULL", false );
            $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::FechaCreacion, '>=', $s_FechaCreaCierre );
            $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
            if( $a_FCO_Aplicacion )
            {
                $a_Msg = array();
                foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
                {
                    $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );
                    if( $o_VTA_DocumentoBN->getEstado() == "CA" )
                    {
                        continue;
                    }
                    $a_Msg[] = $o_FCO_AplicacionBN->getCodDocRef()."-".$o_FCO_AplicacionBN->getSerieNumeroDocRef();
                }
                if( $a_Msg )
                {
                    throw new Exception( "Los siguientes Comprobantes, necesitan ser Facturados: ".implode( " | ", $a_Msg ) );
                }
            }
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora cerramos las aplicaciones
            $o_FCO_AplicacionDP = new FCO_AplicacionDP();
            $o_FCO_AplicacionDP->setIdCaja( intval( $s_IdCaja ) );
            $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
            $o_FCO_AplicacionDP->setIdCierre( $i_IdCierre ); //este valor se utiliza para actualizar
            if( $s_IdVendedor )
            {
                //$o_FCO_AplicacionDP->setCodVendedorRef( $s_IdVendedor );
            }
            $o_FCO_AplicacionDP->actualizarIdCierre();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora deja de usar la caja
            $o_FCO_CajaUsuarioDP = new FCO_CajaUsuarioDP();
            $o_FCO_CajaUsuarioDP->setIdCaja( intval( $s_IdCaja ) );
            $o_FCO_CajaUsuarioDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_FCO_CajaUsuarioDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            if( $s_IdVendedor )
            {
                $o_FCO_CajaUsuarioDP->setIdUsuario( $s_IdVendedor );
            }
            else
            {
                $o_FCO_CajaUsuarioDP->setIdUsuario( myUser::getUser()->getUserId() );
            }
            $o_FCO_CajaUsuarioDP->setEnUsoFlag( 0 );
            $o_FCO_CajaUsuarioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_CajaUsuarioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_CajaUsuarioDP->update();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se actualiza los demas campos
            $o_FCO_CierreDP = new FCO_CierreDP();
            $o_FCO_CierreDP->setIdCierre( $i_IdCierre );
            $o_FCO_CierreDP->setTotalSoles( $f_MontoTotalSoles );
            $o_FCO_CierreDP->setTotalDolares( $f_MontoTotalSoles );
            $o_FCO_CierreDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_CierreDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_CierreDP->update();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //AQUI SE VA APROVECHA EN HACER UN PROCEDIMIENTO PARA TOMAR UNA FOTO AL STOCK FISICO POR DIA - 20200813
            $o_ALM_ItemStockDetHisDP = new ALM_ItemStockDetHisDP();
            $o_ALM_ItemStockDetHisDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_ALM_ItemStockDetHisDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_ALM_ItemStockDetHisDP->setIdFecha( substr( $s_FechaCreaCierre, 0, 10 ) );
            $o_ALM_ItemStockDetHisDP->deleteCompPeriodo();
            $o_ALM_ItemStockDetHisDP->realizarFotoStockFisico();

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
}