<?php
class AddeditReciboAction extends wtActions
{
    public function execute()
    {
        //$i_IdDocRecibo    = intval( $this->getRequestParameter( 'IdDocRecibo' ) );
        $s_TipoProcRec    = $this->getRequestParameter( 'TipoProcRec' );
        $s_TipoProcApli   = $this->getRequestParameter( 'TipoProcApli' );
        $i_IdPersona      = intval( $this->getRequestParameter( 'IdPersona' ) );
        $s_IdMonedaDocRef = $this->getRequestParameter( 'IdMonedaDocRef' );
        $f_MontoTotalRef  = floatval( $this->getRequestParameter( 'MontoTotalRef' ) );
        $s_IdMoneda       = $this->getRequestParameter( 'IdMoneda' ); //moneda del recibo
        $s_IdTipoPago     = $this->getRequestParameter( 'IdTipoPago' );
        $i_IdBanco        = intval( $this->getRequestParameter( 'IdBanco' ) );
        $i_IdCuenta       = intval( $this->getRequestParameter( 'IdCuenta' ) );
        $i_TerminoPago    = intval( $this->getRequestParameter( 'TerminoPago' ) );
        $f_Monto          = floatval( $this->getRequestParameter( 'Monto' ) );
        $s_ReciboNumero   = $this->getRequestParameter( 'ReciboNumero' );
        $s_ReciboFecha    = !$this->getRequestParameter( 'ReciboFecha' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'ReciboFecha' );
        $s_FechaVenc      = !$this->getRequestParameter( 'FechaVencimiento' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaVencimiento' );
        $i_TerminoPago    = intval( $this->getRequestParameter( 'TerminoPago' ) );

        $RegistrarITF     = $this->getRequestParameter( "RegistrarITF" );

        $s_DocMonedaCod  = $s_IdMonedaDocRef; //moneda del documento factura o boleta

        //pr( $_REQUEST ); exit;

        try
        {
            myUser::getUser()->validar_session();
            
            $con = Conexion::getConexion();
            $con->begin();
            
            //se recupera la moneda por defecto para el sistema
            $s_MonedaSistema  = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            
            //el tipo de cambio del dia
            $f_TipodeCambio   = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$f_TipodeCambio )
            {
                throw new Exception( "El Tipo de Cambio no esta Registrado." );
            }
            
            //se recupera info de la moneda del recibo
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $s_IdMoneda );
            
            //los datos de tipo de pago
            $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
            $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $s_IdTipoPago );
            
            $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
            $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
            $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();
            
            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );
            
            $s_NumTipoDocCliente = $o_MST_PersonaMastBN->getDocumento();
            $s_TipoDocCliente    = $o_MST_PersonaMastBN->getTipoDocumento();
            $s_NombreCliente     = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
            
            if( $s_MonedaSistema == "LO" ) //moneda del sistema -> 10$
            {
                if( $s_DocMonedaCod == $s_IdMoneda )
                {
                    if( $s_DocMonedaCod == "LO" )
                    {
                        $f_MontoSoles = $f_Monto;
                        $f_MontoDolar = round( $f_Monto / $f_TipodeCambio, 2 ); //por q no tengo el calculo en dolares
                    }
                    if( $s_DocMonedaCod == "EX" )
                    {
                        $f_MontoSoles = round( $f_Monto * $f_TipodeCambio, 2 );
                        $f_MontoDolar = $f_Monto;
                    }
                }
                else
                {
                    if( $s_DocMonedaCod == "LO" && $s_IdMoneda == "EX" )
                    {
                        $f_MontoSoles = $f_MontoTotalRef;
                        $f_MontoDolar = $f_Monto;
                    }
                    if( $s_DocMonedaCod == "EX" && $s_IdMoneda == "LO" )
                    {
                        $f_MontoSoles = $f_Monto;
                        $f_MontoDolar = $f_MontoTotalRef;
                    }
                }
            }

            $s_Descripcion = "COBRO POR FACTURA";

            $f_SaldoMonto      = $f_Monto;
            $f_SaldoMontoSoles = $f_MontoSoles;
            $f_SaldoMontoDolar = $f_MontoDolar;
            
            $o_FCO_DocReciboDP = new FCO_DocReciboDP();
            
            if( $s_TipoProcRec == "nvo" )
            {
                //ahora se busca el numero de cuenta
                $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );
                
                //se hace un insert
                //en el caso de una cobranza nueva
                $i_IdDocRecibo = FCO_DocReciboDP::recuperarId();
                
                $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                
                if( $i_IdTipoPago == 1 )
                {
                    $s_ReciboNumero = ( string ) $i_IdDocRecibo;
                }
                $o_FCO_DocReciboDP->setReciboNumero( $s_ReciboNumero );
                $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
                $o_FCO_DocReciboDP->setIdMoneda( $s_IdMoneda );
                $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
                $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
                $o_FCO_DocReciboDP->setIdCuenta( $i_IdCuenta );
                $o_FCO_DocReciboDP->setNumeroCuenta( $o_MST_CuentaBancariaBN->getNumeroCuenta() );
                $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
                $o_FCO_DocReciboDP->setTipoCambio( $f_TipodeCambio );
                $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
                $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
                $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
                $o_FCO_DocReciboDP->setDescripcion( $s_Descripcion );
                $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );
                $o_FCO_DocReciboDP->setTerminoPago( $i_TerminoPago );
                $o_FCO_DocReciboDP->setFechaVencimiento( $s_FechaVenc );
                //$o_FCO_DocReciboDP->setFlujoEstado( "PE" ); //PE NDIENTE - AP ROBADO - REC HAZADO
                $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO ); //PE NDIENTE - AP ROBADO - REC HAZADO
                $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
                $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
                $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO ); //AC TIVO - AN ULADO
                $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_PENDIENTE );
                
                $o_FCO_DocReciboDP->setMonto( $f_Monto );
                $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
                $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
                $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
                $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
                $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );
                
                $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                //pr( $o_FCO_DocReciboDP );
                $o_FCO_DocReciboDP->save();
            }
            else
            {
                //aqui se puede agregar los casos de recibos existentes
                
                //busco recibo para actualizar saldos
                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $i_IdDocRecibo );
                
                $f_Monto           = $o_FCO_DocReciboBN->getMonto();
                $f_SaldoMonto      = $o_FCO_DocReciboBN->getSaldo();
                $f_MontoSoles      = $o_FCO_DocReciboBN->getMontoMN();
                $f_SaldoMontoSoles = $o_FCO_DocReciboBN->getSaldoMN();
                $f_MontoDolar      = $o_FCO_DocReciboBN->getMontoME();
                $f_SaldoMontoDolar = $o_FCO_DocReciboBN->getSaldoME();
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //recupero el id de caja y el turno

            $i_IdCaja  = FCO_CajaUsuarioFN::getCajaId( myUser::getUser()->getUserId(), myUser::getUser()->getIdCompania(), myUser::getUser()->getIdSucursal() );
            $i_IdTurno = null;

            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_FCO_CierreFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( !$a_FCO_Cierre )
            {
                //throw new Exception( "No se aperturo ninguna Caja." );
            }
            if( count( $a_FCO_Cierre ) > 1 )
            {
                //throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
            }
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $i_IdCaja  = $o_FCO_CierreBN->getIdCaja();
                $i_IdTurno = $o_FCO_CierreBN->getIdTurno();
            }

            if( !$i_IdCaja )
            {
                throw new Exception( "El Usuario actual no tiene asignado una Caja." );
            }

            if( trim( $s_ReciboNumero ) == "" )
            {
                throw new Exception( "El numero de Recibo no debe de estar vacio." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( $s_TipoProcApli == "registrar" )
            {
                //se hace validaciones adicionales
                if( $f_SaldoMonto <= 0 )
                {
                    throw new Exception( "No se puede hacer la Cobranza por no tener saldo suficiente." );
                }

                //AHORA SE HACE LAS APLICACIONES
                $a_IdNumeroDocumento = $this->getRequestParameter( 'iddoc' );
                $a_MontoAplicacion   = $this->getRequestParameter( 'monto' ); //MONTO A APLICAR
                foreach ( $a_IdNumeroDocumento as $i_Key => $s_IdNumeroDocumento )
                {
                    $f_MontoAplicar = floatval( $a_MontoAplicacion[$i_Key] ); //la moneda del monto a aplicar es segun el combo de moneda a buscar comprobantes, factura o boleta
                    if( $f_MontoAplicar > 0 )
                    {
                        //busco comprobante para actualizar saldos
                        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $s_IdNumeroDocumento ); //SE RECUPERA EL COMPROBANTE DEL CLIENTE

                        if( $s_MonedaSistema == "LO" ) //moneda del sistema
                        {
                            $f_DocumentoPagado   = $o_VTA_DocumentoBN->getMontoPagado();
                            $f_DocumentoPagadoMN = $o_VTA_DocumentoBN->getMontoPagadoMN();

                            $f_DocumentoSaldo    = $o_VTA_DocumentoBN->getMontoSaldo();
                            $f_DocumentoSaldoMN  = $o_VTA_DocumentoBN->getMontoSaldoMN();

                            //informacion del comprobante
                            if( $s_DocMonedaCod == "LO" )
                            {
                                $f_DocumentoSaldoME  = round( $o_VTA_DocumentoBN->getMontoSaldoMN() / $o_VTA_DocumentoBN->getTipodeCambio(), 2 );

                                $f_MontoAplicarMN = $f_MontoAplicar;
                                $f_MontoAplicarME = round( $f_MontoAplicar / $f_TipodeCambio, 2 );
                            }
                            if( $s_DocMonedaCod == "EX" )
                            {
                                $f_DocumentoSaldoME  = $f_DocumentoSaldo;

                                $f_MontoAplicarMN = round( $f_MontoAplicar * $f_TipodeCambio, 2 );
                                $f_MontoAplicarME = $f_MontoAplicar;
                            }

                            //saldo y cobrado para el comprobante
                            $f_NvoDocuSaldo    = round( $f_DocumentoSaldo - $f_MontoAplicar, 2 );           // 0
                            $f_NvoDocuSaldoMN  = round( $f_DocumentoSaldoMN - $f_MontoAplicarMN, 2 );
                            $f_NvoDocuSaldoME  = round( $f_DocumentoSaldoME - $f_MontoAplicarME, 2 );
                            $f_NvoDocuPagado   = round( $f_DocumentoPagado + $f_MontoAplicar, 2 );      //AQUI SE ACUMULA LO PAGADO
                            $f_NvoDocuPagadoMN = round( $f_DocumentoPagadoMN + $f_MontoAplicarMN, 2 );

                            //se convierte el monto a aplicar en la moneda del recibo
                            if( $s_DocMonedaCod == "LO" && $s_IdMoneda == "EX" )
                            {
                                $f_MontoAplicar = round( $f_MontoAplicar / $f_TipodeCambio, 2 );
                            }
                            if( $s_DocMonedaCod == "EX" && $s_IdMoneda == "LO" )
                            {
                                $f_MontoAplicar = round( $f_MontoAplicar * $f_TipodeCambio, 2 );
                            }

                            //ahora saldo para el recibo
                            $f_SaldoMonto      = round( $f_SaldoMonto - $f_MontoAplicar, 2 );       //AQUI SE CALCULA EL SALDO DEL RECIBO
                            $f_SaldoMontoSoles = round( $f_SaldoMontoSoles - $f_MontoAplicarMN, 2 );
                            $f_SaldoMontoDolar = round( $f_SaldoMontoDolar - $f_MontoAplicarME, 2 );
                        }
                        if( $s_MonedaSistema == "EX" ) //moneda del sistema, aun no se ha implementado
                        {

                        }

                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //ahora se guarda la aplicacion
                        $i_IdAplicacion = FCO_AplicacionDP::recuperarId();

                        $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                        $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
                        $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                        $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_FCO_AplicacionDP->setIdCaja( $i_IdCaja );
                        $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
                        $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
                        $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
                        $o_FCO_AplicacionDP->setIdMoneda( $s_IdMoneda );
                        $o_FCO_AplicacionDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );

                        $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
                        $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
                        $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
                        $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO
                        $o_FCO_AplicacionDP->setDescripcion( $s_Descripcion );

                        $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
                        $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
                        $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                        $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );

                        $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre

                        $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
                        //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante

                        $o_FCO_AplicacionDP->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
                        $o_FCO_AplicacionDP->setCodDocRef( $o_VTA_DocumentoBN->getDocumentoCod() );
                        $o_FCO_AplicacionDP->setSerieNumeroDocRef( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
                        $o_FCO_AplicacionDP->setMontoTotalDocRef( $o_VTA_DocumentoBN->getMontoTotal() );
                        $o_FCO_AplicacionDP->setSaldoDocRef( $f_NvoDocuSaldo );
                        $o_FCO_AplicacionDP->setFechaDocRef( $o_VTA_DocumentoBN->getFechaDocumento() );
                        $o_FCO_AplicacionDP->setFechaDocVenRef( $o_VTA_DocumentoBN->getFechaVencimiento() );
                        $o_FCO_AplicacionDP->setIdMonedaRef( $o_VTA_DocumentoBN->getMonedaDocumento() );
                        $o_FCO_AplicacionDP->setTipoCambioRef( $o_VTA_DocumentoBN->getTipodeCambio() );
                        $o_FCO_AplicacionDP->setCodVendedorRef( $o_VTA_DocumentoBN->getVendedor() );
                        $o_FCO_AplicacionDP->setIdAlmacenRef( $o_VTA_DocumentoBN->getIdAlmacen() );

                        $o_FCO_AplicacionDP->setTipoCambio( $f_TipodeCambio ); //POR DEFECTO 1 POR SER EN SOLES
                        $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
                        $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setMontoAplicado( $f_MontoAplicar );
                        $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoAplicarMN );
                        $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoAplicarME );
                        $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
                        $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_APLICADO ); //PE NDIENTE - AP LICADO - AN ULADO
                        $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        //pr( $o_FCO_AplicacionDP );
                        $o_FCO_AplicacionDP->save();
                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //ahora se actualiza los saldos del comprobante
                        $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                        $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                        $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                        $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                        $o_VTA_DocumentoDP->setMontoPagado( $f_NvoDocuPagado );
                        $o_VTA_DocumentoDP->setMontoPagadoMN( $f_NvoDocuPagadoMN );
                        $o_VTA_DocumentoDP->setMontoSaldo( $f_NvoDocuSaldo );
                        $o_VTA_DocumentoDP->setMontoSaldoMN( $f_NvoDocuSaldoMN );
                        if( $o_VTA_DocumentoBN->getMontoTotal() == $f_NvoDocuPagado || $o_VTA_DocumentoBN->getMontoPagadoMN() == $f_NvoDocuPagadoMN )
                        {
                            $o_VTA_DocumentoDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
                            $o_VTA_DocumentoDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
                            $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                        }
                        $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        //pr( $o_VTA_DocumentoDP );
                        $o_VTA_DocumentoDP->update();

                        if( $o_VTA_DocumentoBN->getMontoTotal() == $f_NvoDocuPagado || $o_VTA_DocumentoBN->getMontoPagadoMN() == $f_NvoDocuPagadoMN )
                        {
                            //PROCEDIMIENTO NUEVO - 2022-02-15
                            //SI SE HACE LA COBRANZA Y TIENE REFERENCIA POR SERVICIO TECNICO POR DIAGNOSTICO:
                            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                            $o_STE_ServicioTecnicoFN->setDiagnosticoComprobanteId( $o_VTA_DocumentoBN->getNumeroDocumento() );
                            $a_STE_ServicioTecnico = $o_STE_ServicioTecnicoFN->select();
                            if( $a_STE_ServicioTecnico )
                            {
                                $o_STE_ServicioTecnicoBN = $a_STE_ServicioTecnico[0];

                                $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                                $o_STE_ServicioTecnicoDP->setIdServicio( $o_STE_ServicioTecnicoBN->getIdServicio() );
                                $o_STE_ServicioTecnicoDP->setDiagnosticoCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                                $o_STE_ServicioTecnicoDP->setDiagnosticoCobranzaFecha( date( "Y-m-d H:i:s" ) );
                                $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                                $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                                $o_STE_ServicioTecnicoDP->update();
                            }

                            //SI SE HACE LA COBRANZA Y TIENE REFERENCIA POR SERVICIO TECNICO POR REPARACION:
                            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                            $o_STE_ServicioTecnicoFN->setReparacionComprobanteId( $o_VTA_DocumentoBN->getNumeroDocumento() );
                            $a_STE_ServicioTecnico = $o_STE_ServicioTecnicoFN->select();
                            if( $a_STE_ServicioTecnico )
                            {
                                $o_STE_ServicioTecnicoBN = $a_STE_ServicioTecnico[0];

                                $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                                $o_STE_ServicioTecnicoDP->setIdServicio( $o_STE_ServicioTecnicoBN->getIdServicio() );
                                $o_STE_ServicioTecnicoDP->setReparacionCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                                $o_STE_ServicioTecnicoDP->setReparacionCobranzaFecha( date( "Y-m-d H:i:s" ) );
                                $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                                $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                                $o_STE_ServicioTecnicoDP->update();
                            }
                        }
                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //ahora se actualiza el saldo del recibo
                        $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                        $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
                        $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
                        $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );
                        if( $f_SaldoMontoSoles == 0 || $f_SaldoMontoDolar == 0 )
                        {
                            $o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
                            $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_COBRADO );
                        }
                        $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        //pr( $o_FCO_DocReciboDP );
                        $o_FCO_DocReciboDP->update();
                        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    }
                }
            }

            if( $RegistrarITF )
            {
                $this->generarImpuestoITF( $i_IdDocRecibo );
            }

            $a_Result['IdDocRecibo'] = $i_IdDocRecibo;
            $a_Result['error'] = false;
            //exit;
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }

    public function generarImpuestoITF( $i_ParantIdDocRecibo )
    {
        //$i_IdDocRecibo    = intval( $this->getRequestParameter( 'IdDocRecibo' ) );
        $s_TipoProcRec    = $this->getRequestParameter( 'TipoProcRec' );
        $s_TipoProcApli   = $this->getRequestParameter( 'TipoProcApli' );
        $i_IdPersona      = intval( $this->getRequestParameter( 'IdPersona' ) );
        $s_IdMonedaDocRef = $this->getRequestParameter( 'IdMonedaDocRef' );
        $f_MontoTotalRef  = floatval( $this->getRequestParameter( 'MontoTotalRef' ) );
        $s_IdMoneda       = $this->getRequestParameter( 'IdMoneda' ); //moneda del recibo
        $s_IdTipoPago     = $this->getRequestParameter( 'IdTipoPago' );
        $i_IdBanco        = intval( $this->getRequestParameter( 'IdBanco' ) );
        $i_IdCuenta       = intval( $this->getRequestParameter( 'IdCuenta' ) );
        $i_TerminoPago    = intval( $this->getRequestParameter( 'TerminoPago' ) );
        $f_Monto          = floatval( $this->getRequestParameter( 'MontoTotalITF' ) );
        $s_ReciboNumero   = $this->getRequestParameter( 'ReciboNumero' );
        $s_ReciboFecha    = !$this->getRequestParameter( 'ReciboFecha' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'ReciboFecha' );
        $s_FechaVenc      = !$this->getRequestParameter( 'FechaVencimiento' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaVencimiento' );
        $i_TerminoPago    = intval( $this->getRequestParameter( 'TerminoPago' ) );
        $f_TipodeCambio   = floatval( $this->getRequestParameter( "TipoCambio" ) );
        $s_Descripcion    = "IMPUESTO ITF";

        $s_ParentCod    = "CC";

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //los datos de tipo de pago
        $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
        $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $s_IdTipoPago );

        $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
        $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
        $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $s_IdMoneda );

        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
        $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );

        //se busca el cliente
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

        $s_NumTipoDocCliente = $o_MST_PersonaMastBN->getDocumento();
        $s_TipoDocCliente    = $o_MST_PersonaMastBN->getTipoDocumento();
        $s_NombreCliente     = $o_MST_PersonaMastBN->getNombreCompletoLLeno();

        $f_SaldoMonto       = 0;
        $f_MontoSoles       = $f_Monto;
        $f_SaldoMontoSoles  = 0;
        $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );
        $f_SaldoMontoDolar  = 0;

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //se hace un insert
        //en el caso de una cobranza nueva
        $i_IdDocRecibo = CP_DocReciboDP::recuperarId();

        $o_FCO_DocReciboDP = new CP_DocReciboDP();
        $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
        $o_FCO_DocReciboDP->setReciboNumero( ( string ) $i_IdDocRecibo );
        $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_FCO_DocReciboDP->setParentId( $i_ParantIdDocRecibo );
        $o_FCO_DocReciboDP->setParentCod( $s_ParentCod );
        $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago ); //el tipo va a depender
        $o_FCO_DocReciboDP->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
        $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
        $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
        $o_FCO_DocReciboDP->setIdCuenta( $o_MST_CuentaBancariaBN->getIdCuenta() );
        $o_FCO_DocReciboDP->setNumeroCuenta( $o_MST_CuentaBancariaBN->getNumeroCuenta() );
        $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
        $o_FCO_DocReciboDP->setTipoCambio( $f_TipodeCambio );
        $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
        $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
        $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
        $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
        $o_FCO_DocReciboDP->setDescripcion( $s_Descripcion );
        $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );
        $o_FCO_DocReciboDP->setTerminoPago( $i_TerminoPago );
        //$o_FCO_DocReciboDP->setFechaVencimiento( $s_FechaVenc );
        $o_FCO_DocReciboDP->setFlujoEstado( "AP" ); //PE NDIENTE - AP ROBADO - REC HAZADO
        $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO ); //PE NDIENTE - AP ROBADO - REC HAZADO
        $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
        $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
        $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO ); //AC TIVO - AN ULADO
        $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_COBRADO );
        $o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );

        $o_FCO_DocReciboDP->setMonto( $f_Monto );
        $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
        $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
        $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
        $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
        $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );

        $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

        $o_FCO_DocReciboDP->save();
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //POR AHORA PARA PAGOS A PROVEEDORES PARA MI NO ES NECESARIO ID_CAJA, ID_TURNO
        $i_IdCaja  = FCO_CajaUsuarioFN::getCajaId( myUser::getUser()->getUserId(), myUser::getUser()->getIdCompania(), myUser::getUser()->getIdSucursal() );
        $i_IdTurno = null;

        if( !$i_IdCaja )
        {
            throw new Exception( "El Usuario actual no tiene asignado una Caja." );
        }

        $o_VTA_DocumentoBN = new CP_ObligacionesBN();
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //ahora se guarda la aplicacion
        $i_IdAplicacion = FCO_AplicacionDP::recuperarId();

        $o_FCO_AplicacionDP = new CP_AplicacionDP();
        $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
        $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_FCO_AplicacionDP->setIdCaja( $i_IdCaja );
        $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
        $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
        $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
        $o_FCO_AplicacionDP->setIdMoneda( $s_IdMoneda );
        $o_FCO_AplicacionDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );

        $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
        $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
        $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
        $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO
        $o_FCO_AplicacionDP->setDescripcion( $s_Descripcion );

        $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
        $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
        $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
        $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );

        $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre

        $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
        //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante

        $o_FCO_AplicacionDP->setIdDocNumRef( ( string ) $o_VTA_DocumentoBN->getObligacionesId() ); //ID DE LA FACTURA
        $o_FCO_AplicacionDP->setCodDocRef( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getTipoDocumentoCod() );
        $o_FCO_AplicacionDP->setSerieNumeroDocRef( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
        $o_FCO_AplicacionDP->setMontoTotalDocRef( $o_VTA_DocumentoBN->getMontoTotal() );
        $o_FCO_AplicacionDP->setSaldoDocRef( 0 );
        $o_FCO_AplicacionDP->setFechaDocRef( $o_VTA_DocumentoBN->getFechaEmision() );
        $o_FCO_AplicacionDP->setFechaDocVenRef( $o_VTA_DocumentoBN->getFechaVencimiento() );
        $o_FCO_AplicacionDP->setIdMonedaRef( $o_VTA_DocumentoBN->getIdMoneda() );
        $o_FCO_AplicacionDP->setTipoCambioRef( $o_VTA_DocumentoBN->getTipoCambio() );
        $o_FCO_AplicacionDP->setCodVendedorRef( myUser::getUser()->getUserId() );

        $o_FCO_AplicacionDP->setTipoCambio( $f_TipodeCambio ); //POR DEFECTO 1 POR SER EN SOLES
        $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
        $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
        $o_FCO_AplicacionDP->setMontoAplicado( $f_Monto );
        $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoSoles );
        $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoDolar );
        $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
        $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_APLICADO ); //PE NDIENTE - AP LICADO - AN ULADO
        $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        //pr( $o_FCO_AplicacionDP ); exit;
        $o_FCO_AplicacionDP->save();
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    }
}
