<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">Asistencia</h4>
        </div>
        <div class="col mb-1 text-right">
            <!--<div class="btn-group">-->
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Opciones
                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);" onclick="exportarExcel();">Exportar Excel</a>
                </div>
            <!--</div>-->
        </div>
    </div>
</div>

<script type="text/javascript">
changeIcon = function( elm, name )
{
    var elms    = $( elm ).find( "svg" );
    var elm_sel = elms.first();
    if( $( "#" + name ).is( ":visible" ) )
    {
        $( elm_sel ).removeClass( "fa-angle-down" );
        $( elm_sel ).addClass( "fa-angle-right" );
    }
    else
    {
        $( elm_sel ).removeClass( "fa-angle-right" );
        $( elm_sel ).addClass( "fa-angle-down" );
    }
}
</script>

<div id="accordion" class="mb-2">
    <div class="card">
        <div class="card-header">
            <a data-toggle="collapse" href="#collapseThree" aria-expanded="true" aria-controls="collapse1" 
                class="text-info" onclick="changeIcon( this,'collapseThree' );" id="cotent_a_collapse" 
                >
                <h5 class="mb-0"> Filtro <i class="fas fa-angle-right pull-right"></i></h5>
            </a>
        </div>
        <div id="collapseThree" class="collapse" data-parent="#accordion">
            <div class="card-body pb-1">
                <form class="" name="form1" id="form1" method="POST" action="">
                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="TipoDocumento">Tipo Documento</label>
                            <select class="form-control" name="TipoDocumento" id="TipoDocumento" >
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( MST_PersonaMastBN::getArrayTipoDocumento() as $s_Key => $s_Value ) { ?>
                                <option value="<?=$s_Key?>"> <?=$s_Key?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="NumeroDocumento">Nro Documento</label>
                            <input type="text" class="form-control" name="NumeroDocumento" id="NumeroDocumento" placeholder="">
                        </div>
                        <div class="col-md-4 mb-1 ">
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento1">Fecha Inicio</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento1" name="FechaDocumento1" placeholder="Fecha Desde" value="<?=date( "Y-m-d" )?>">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento1" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-5:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento2">Fecha Fin</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento2" name="FechaDocumento2" placeholder="Fecha Hasta">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento2" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-5:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="IdRegistro">Marcacion Registro</label>
                            <select class="form-control" name="IdRegistro" id="IdRegistro">
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( PLA_MarcacionRegistroFN::selectActivos() as $o_PLA_MarcacionRegistroBN ) { ?>
                                <option value="<?=$o_PLA_MarcacionRegistroBN->getIdRegistro()?>"> <?=$o_PLA_MarcacionRegistroBN->getDescripcion()?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="IdTipo">Marcacion Tipo</label>
                            <select class="form-control" name="IdTipo" id="IdTipo">
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( PLA_MarcacionTipoFN::selectActivos( "IN" ) as $o_PLA_MarcacionTipoBN ) { ?>
                                <option value="<?=$o_PLA_MarcacionTipoBN->getIdTipo()?>"> <?=$o_PLA_MarcacionTipoBN->getDescripcion()?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-1">
                            
                        </div>
                    </div>
                    <div class="text-center mt-2">
                        <button class="btn btn-primary text-center" type="button" onclick="findControl();">Buscar</button>
                        <a data-toggle="collapse" href="#collapseThree" class="text-info" onclick="changeIcon( $('#cotent_a_collapse')[0],'collapseThree');" style="background: none;">
                            Contraer <i class="fas fa-angle-up"></i>
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include_partial( "grid" ); ?>

<script>
$( document ).bind
(
    'keyup', 
    function( e ) 
    {
        if( e.which === 13 ) //ENTER
        {
            findControl();
        }
        if( e.which === 107 || e.which === 27 ) //tecla +  || ESC
        {
            $( "#cotent_a_collapse" ).trigger( "click" );
        }
    }
);
setTimeout( "findControl();", 500 );
</script>
