<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">Reporte de Ventas Diarias</h4>
        </div>
    </div>
</div>

<script type="text/javascript">
changeIcon = function( elm, name )
{
    var elms    = $( elm ).find( "svg" );
    var elm_sel = elms.first();
    if( $( "#" + name ).is( ":visible" ) )
    {
        $( elm_sel ).removeClass( "fa-angle-down" );
        $( elm_sel ).addClass( "fa-angle-right" );
    }
    else
    {
        $( elm_sel ).removeClass( "fa-angle-right" );
        $( elm_sel ).addClass( "fa-angle-down" );
    }
}

cambiarFiltroPorTipo = function()
{
    pr( $( "#filtroTipo" ).val() );
    if( $( "#filtroTipo" ).val() == "A" )
    {
        $( "#IdTurno" ).val( "" );
        $( "#IdTurno" ).prop( "disabled", true );

        $( "#IdAlmacen" ).prop( "disabled", false );
        $( "#IdAlmacen" ).val( "ALM00002" );

        $( "#content_turno" ).hide();
        $( "#content_almacen" ).show();
    }
    if( $( "#filtroTipo" ).val() == "T" )
    {
        $( "#IdAlmacen" ).val( "" );
        $( "#IdAlmacen" ).prop( "disabled", true );

        $( "#IdTurno" ).prop( "disabled", false );
        $( "#IdTurno" ).val( "1" );

        $( "#content_almacen" ).hide();
        $( "#content_turno" ).show();
    }
}
</script>

<div id="accordion" class="mb-2">
    <div class="card">
        <div class="card-header">
            <a data-toggle="collapse" href="#collapseThree" aria-expanded="true" aria-controls="collapse1" 
                class="text-info" onclick="changeIcon(this,'collapseThree');" id="cotent_a_collapse" 
                >
                <h5 class="mb-0"> Filtro <i class="fas fa-angle-right pull-right"></i></h5>
            </a>
        </div>
        <div id="collapseThree" class="collapse show" data-parent="#accordion">
            <div class="card-body pb-1">
                <form class="" name="form1" id="form1" method="POST" action="">
                    <input type="hidden" name="IdCompania" value="<?=myUser::getUser()->getIdBusiness()?>">

                    <input type="hidden" name="IdItem" value="">
                    <input type="hidden" name="IdItemTipo" value="">
                    <input type="hidden" name="IdTipoUbicacion" value="">

                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="filtroTipo">POR</label>
                            <select class="form-control" name="filtroTipo" id="filtroTipo" onchange="cambiarFiltroPorTipo();">
                                <option value="T"> TURNO </option>
                                <option value="A"> ALMACEN </option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-1" id="content_turno">
                            <label class="col-form-label" for="IdTurno">TURNO</label>
                            <select class="form-control" name="IdTurno" id="IdTurno">
                                <!--<option value=""> - TODOS - </option>-->
                                <?php foreach ( MST_TurnoFN::selectActivos() as $o_MST_TurnoBN ) { ?>
                                <option value="<?=$o_MST_TurnoBN->getIdTurno()?>"> <?=$o_MST_TurnoBN->getDescripcion()?> </option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="col-md-4 mb-1" id="content_almacen" style="display: none;">
                            <label class="col-form-label" for="IdAlmacen">ALMACEN</label>
                            <select class="form-control" name="IdAlmacen" id="IdAlmacen">
                                <!--<option value=""> - TODOS - </option>-->
                                <?php foreach ( ALM_AlmacenMastFN::recuperarAlmacenParaVentas() as $s_Key => $o_ALM_AlmacenMastBN ){ ?>
                                <option value="<?=$o_ALM_AlmacenMastBN->getIdAlmacen()?>" ><?=$o_ALM_AlmacenMastBN->getDescripcionLocal()?> </option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="IdVendedor">VENDEDOR</label>
                            <select class="form-control" name="IdVendedor" id="IdVendedor">
                                <option value=""> - TODOS - </option>
                                <?php foreach ( VTA_VendedorFN::select_all() as $a_Vendedor ) { ?>
                                <option value="<?=$a_Vendedor['IdUsuario']?>" > <?=$a_Vendedor['NombreCompleto']?> </option>
                                <?php } ?>
                            </select>
                        </div>

                    </div>

                    <div class="form-row mx-0">

                        <div class="col-md-4 mb-1 ">
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento1">FECHA DESDE</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento1" name="FechaDocumento1" placeholder="Fecha Desde" value="<?=date( "Y-m-d" )?>">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento1" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-5:+0", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento2">FECHA HASTA</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento2" name="FechaDocumento2" placeholder="Fecha Hasta" value="<?=date( "Y-m-d" )?>">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento2" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-5:+0", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="IdTipoPago">FORMA DE PAGO</label>
                            <select class="form-control" name="IdTipoPago" id="IdTipoPago" required="">
                                <option value=""> - TODOS - </option>
                                <?php foreach ( FCO_TipoPagoFN::selectActivos() as $o_FCO_TipoPagoBN) { ?>
                                <option value="<?=$o_FCO_TipoPagoBN->getIdTipoPago()?>" > <?=$o_FCO_TipoPagoBN->getNombre()?> </option>
                                <?php } ?>
                                
                            </select>
                        </div>
                    </div>

                    <div class="text-center mt-2">
                        <button class="btn btn-primary text-center" type="button" onclick="findControl(1);">Buscar</button>
                        <button class="btn btn-primary text-center" type="button" onclick="findControl(2);">Buscar Print</button>
                        <a data-toggle="collapse" href="#collapseThree" class="text-info" onclick="changeIcon( $('#cotent_a_collapse')[0],'collapseThree');" style="background: none;">
                            Contraer <i class="fas fa-angle-up"></i>
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
findControl = function( tipo )
{
    pr( "ingresa" );
    var params = $( 'form' ).serialize();
    if( tipo == 2 )
    {
        params += "&no_ajax=1"
        window.open( '<?=buildUrl( 'rep/rsVentasDiaria' ) ?>' + '?' + params, '_BLANK' );
        return false;
    }
    blockContent( 'content_result' );
    executeAjaxUpdater
    ( 
        'content_result', 
        "<?php echo buildUrl( 'rep/rsVentasDiaria' ) ?>", 
        params, 
        function( response )
        {
            //unBlockContent( 'content_buttons' );
        } 
    );
}
</script>

<div class="" style="margin-top: 10px;" id="content_result">
</div>