<?php if( !$Excel ){ ?>
<style type="text/css">
    fieldset
    {
        border: 1px solid #ddd !important;
        margin: 0;
        xmin-width: 0;
        padding: 10px;
        position: relative;
        border-radius:4px;
        background-color:#f5f5f5;
        padding-left:10px!important;
    }

    legend
    {
        font-size:14px;
        font-weight:bold;
        margin-bottom: 0px;
        width: 35%;
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 5px 5px 5px 10px;
        background-color: #ffffff;
    }
</style>
<?php } ?>

<?php ob_start(); ?>
<fieldset class="">
    <legend class="w-auto">Documentos</legend>
    <div class="table-responsive">
        <table class="table  table-bordered table-hover">
            <thead class="table-primary">
            <tr>
                <th scope="col" class="text-center">Nro</th>
                <th scope="col" class="text-center">Tipo Documento</th>
                <th scope="col" class="text-center">Documento</th>
                <th scope="col" class="text-center">Fecha</th>
                <th scope="col" class="text-center">Monto sin IGV</th>
                <th scope="col" class="text-center">Margen</th>
                <th scope="col" class="text-center">Margen %</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $f_SumaCostoAlmacenTotal = 0;
            $f_SumaTotalMargen = 0;
            $f_SumaTotal       = 0;
            ?>
            <?php foreach ( $a_VTA_Documento as $i_Key => $o_VTA_DocumentoBN ) { ?>
                <?php
                $f_SumaCostoAlmacen     = 0;
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
                $s_Moneda = $o_VTA_DocumentoBN->getMonedaDocumento();
                $f_TipoCambio = $o_VTA_DocumentoBN->getTipodeCambio();
                foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                {
                    $f_CostoUnitVenta = $o_VTA_DocumentoDetalleBN->getCostoUnitarioMN(); //SE RECUPERA EL COSTO EN MONEDA NACIONAL

                    if( $f_CostoUnitVenta > $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() )
                    {
                        $f_Resta = $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() - $o_VTA_DocumentoDetalleBN->getCostoUnitarioMN();

                        //pr( "Se encontro margen negativo: [$f_Resta = {$o_VTA_DocumentoDetalleBN->getCostoUnitarioMN()} - {$o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN()}] [{$o_VTA_DocumentoBN->getNumeroComprobante()}][{$o_VTA_DocumentoBN->getNumeroDocumento()}][{$o_VTA_DocumentoDetalleBN->getItemCodigo()}]" );

                        $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                        $f_CostoUnitVenta = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                        if( $f_CostoUnitVenta > $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() )
                        {
                            $f_CostoUnitVenta = ( $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() - 0.01 );
                        }
                    }

                    $f_SumaCostoAlmacen = $f_SumaCostoAlmacen + ( $f_CostoUnitVenta * $o_VTA_DocumentoDetalleBN->getCantidadPedida() );
                }

                $f_TotalUtil = 0;
                if( $f_SumaCostoAlmacen )
                {
                    $f_SumaCostoAlmacenTotal = $f_SumaCostoAlmacenTotal + $f_SumaCostoAlmacen;
                    $f_TotalUtil = utilMath::fnround( ( ( $o_VTA_DocumentoBN->getMontoSubTotalMN() - $f_SumaCostoAlmacen ) / $o_VTA_DocumentoBN->getMontoSubTotalMN() ) * 100, 2 );
                }
                $f_Margen = round( $o_VTA_DocumentoBN->getMontoSubTotalMN() - $f_SumaCostoAlmacen, 2 );
                $f_SumaTotalMargen = round( $f_SumaTotalMargen + $f_Margen, 2 );

                $f_SumaTotal = $f_SumaTotal + $o_VTA_DocumentoBN->getMontoSubTotalMN();
                ?>
                <tr>
                    <td class="text-center"><?=$i_Key+1?></td>
                    <td class="text-center"><?=$o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal()?></td>
                    <td class="text-center" style="cursor: pointer; color: blue; text-decoration: underline;" onclick="mostrarDocumentoReferencia('<?=$o_VTA_DocumentoBN->getNumeroDocumento()?>');"><?=$o_VTA_DocumentoBN->getNumeroComprobante()?></td>
                    <td class="text-center"><?=substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )?></td>
                    <td class="text-center"><?=number_format( $o_VTA_DocumentoBN->getMontoSubTotal(), 2 )?></td>
                    <td class="text-center"><?=number_format( $f_Margen, 2 )?></td>
                    <td class="text-center"><?=number_format( $f_TotalUtil, 2 )?>%</td>
                </tr>
            <?php } ?>
                <tr class="table-danger">
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                    <td class="font-weight-bold text-right" > &nbsp; </td>
                </tr>
            </tbody>
        </table>
    </div>
</fieldset>
<?php
$s_Content1 = ob_get_contents();
ob_end_clean();
?>

<fieldset class="">
    <legend class="w-auto">Resumen</legend>
    <div class="table-responsive">
        <table class="table  table-bordered table-hover">
            <thead class="table-primary">
            <tr>
                <th scope="col" style="text-align: center; vertical-align: top;">Total con IGV: </th>
                <td class="text-nowrap" style="text-align: center; background-color: white;"> <?=number_format( $a_Data['MontoTotal'], 2 )?> </td>
                <th scope="col" style="text-align: center; vertical-align: top;">Total sin IGV: </th>
                <td class="text-nowrap" style="text-align: center; background-color: white;"> <?=number_format( $a_Data['MontoAfecto'], 2 )?> </td>
                <th scope="col" style="text-align: center; vertical-align: top;">Margen: </th>
                <td class="text-nowrap" style="text-align: center; background-color: white;" id="content_margen"> <?=number_format( $f_SumaTotalMargen, 2 )?></td> <!--[<?=number_format( $f_SumaCostoAlmacenTotal, 2 )?>]-->
                <th scope="col" style="text-align: center; vertical-align: top;">Margen %: </th>
                <td class="text-nowrap" style="text-align: center; background-color: white;" id="content_margen"><?=number_format( round( $f_SumaTotalMargen / $a_Data['MontoAfecto'] * 100 , 2 ), 2 )?></td>
            </tr>
            </thead>
        </table>
    </div>
</fieldset>

<?php echo $s_Content1 ?>

<?php if( !$Excel ){ ?>
<script>
//$( "#content_margen" ).html( "<?=$f_SumaTotalMargen?>" );
</script>
<?php } ?>

