<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<style type="text/css">
    .table td, .table th
    {
        /*padding: 8px;*/
        font-size: 13px;
    }
    th { white-space: nowrap; }
    a:hover {
        color: #0056b3;
        text-decoration: underline;
    }

    a {
        color: #007bff;
        text-decoration: none;
        background-color: transparent;
        -webkit-text-decoration-skip: objects;
    }
</style>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">Periodo</h4>
        </div>
        <div class="form-row mx-1">

        </div>
    </div>
</div>

<div class="dropdown-divider"></div>

<script>
    buscarPeriodo = function()
    {
        $( "#TipoProc" ).val( "FIND" );
        $( "#form1" ).submit();
    }

    abrirPeriodo = function( mes )
    {
        $( "#TipoProc" ).val( "CAMBIAR_ESTADO" );
        $( "#Parametro1" ).val( mes );
        $( "#Parametro2" ).val( "1" );
        $( "#form1" ).submit();
    }

    cerrarPeriodo = function( mes )
    {
        $( "#TipoProc" ).val( "CAMBIAR_ESTADO" );
        $( "#Parametro1" ).val( mes );
        $( "#Parametro2" ).val( "0" );
        $( "#form1" ).submit();
    }
</script>

<div class="card" id="content_datos_cliente">
    <h5 class="card-header">Datos de Cliente</h5>
    <div class="card-body" style="padding: 10px;">
        <form class="" name="form1" id="form1" method="POST" action=""  onsubmit="">
            <input type="hidden" name="Control" id="Control" value="1">
            <input type="hidden" name="TipoProc" id="TipoProc" value="FIND">
            <input type="hidden" name="Parametro1" id="Parametro1" value="">
            <input type="hidden" name="Parametro2" id="Parametro2" value="">

            <div class="form-row mx-0">
                <div class="col-md-10 mb-1">
                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <label for="Ejercicio" class="col-form-label">Ejercicio:</label>
                            <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="Ejercicio" id="Ejercicio" onchange="">
                               <?php
                                $anio = date('Y')+1;
                                for($i=2021;$i<$anio;$i++){
                                	?>
                                	<option value="<?php echo $i;?>" <?php if( $Ejercicio==$i ){ echo "SELECTED"; } ?> ><?php echo $i;?></option>
                                	<?php
                                }
                               ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-1">
                        </div>
                        <div class="col-md-4 mb-1">
                        </div>
                    </div>
                </div>
                <div class="col-md-2 mb-1">
                    <button type="submit" class="btn btn-primary btn-block">BUSCAR</button>
                </div>

            </div>
        </form>
    </div>
</div>

<div id="content_alert" style=""></div>

<div class="dropdown-divider"></div>

<table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
    <thead class="">
    <tr class="table-primary">
        <th style="text-align: center;"><b>Nro</b></th>
        <th style="text-align: center;"><b>Estado</b></th>
        <th style="text-align: center;"><b>Periodo</b></th>
        <th style="text-align: center;"><b>Nombre</b></th>
        <th style="text-align: center;"><b>Fecha Ini</b></th>
        <th style="text-align: center;"><b>Fecha Fin</b></th>
        <th style="text-align: center;"><b>Opciones</b></th>
    </tr>
    </thead>

    <tbody id="">
    <?php foreach ( $a_DataPeriodo as $s_Cod => $a_Data ){ ?>
        <?php
        $b_Control = true;
        if( $a_Data['Estado'] == "Abierto" )
        {
            $b_Control = false;
        }
        ?>
        <tr>
            <td align="center"><?=$s_Cod?></td>
            <td align="center"><?=$a_Data['Estado']?></td>
            <td align="center"><?=$a_Data['Periodo']?></td>
            <td align="center"><?=$a_Data['Nombre']?></td>
            <td align="center"><?=$a_Data['FechaIni']?></td>
            <td align="center"><?=$a_Data['FechaFin']?></td>
            <td align="center">
                <?php if( $b_Control ){ ?>
                    <input type="button" onclick="abrirPeriodo('<?=$s_Cod?>');" value="ABRIR" id="" class="button">
                <?php }else{ ?>
                    <input type="button" onclick="cerrarPeriodo('<?=$s_Cod?>');" value="CERRAR" id="" class="button">
                <?php } ?>
            </td>
        </tr>
    <?php } ?>
    </tbody>

</table>

<br>
<br>
<br>