<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<style type="text/css">
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
.table td, .table th 
{
    padding: 8px;
    font-size: 13px;
    vertical-align: middle;
}
th { white-space: nowrap; }
</style>

<style>
.ui-datepicker {
    height: 160px;
    width: auto;
    top: 0 !important;
}
.ui-datepicker td span, .ui-datepicker td a {
    text-align: center;
    padding: 0;
}
.ui-datepicker table {
     font-size: 10px;
}
.ui-datepicker th {
    padding: 0;
}
</style>

<div id="content_alert" style=""></div>

<form name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="control" id="control" value="1" >
    <input type="hidden" name="tipoproc" id="tipoproc" value="list" >
    <input type="hidden" name="iddocrecibo" id="iddocrecibo" value="<?=$o_FCO_DocReciboBN->getIdDocRecibo()?>" >
    <input type="hidden" name="idaplicacion" id="idaplicacion" value="" >

    <div class="card">
        <h5 class="card-header">Cobranza Nro : <?=$o_FCO_DocReciboBN->getIdDocRecibo()?></h5>
        <div class="card-body" style="padding: 2px;">

            <div class="table-responsive" id="content_form">
                <table class="table table-borderless" style="margin-bottom: 0px; line-height: 0.5; padding: .50rem; ">
                    <tbody>
                        <tr>
                            <th class="text-nowrap" scope="row"><?=$o_FCO_DocReciboBN->getTipoDocCliente()?>:</th>
                            <td class="text-nowrap" style="color: #fc6d00;"><?=$o_FCO_DocReciboBN->getNumTipoDocCliente()?></td>
                            <th class="text-nowrap" scope="row">Cliente:</th>
                            <td class="text-nowrap" style="font-weight: bold; color: #fc6d00; font-size: 16px;" colspan="3"><?=$o_FCO_DocReciboBN->getNombreCliente()?></td>
                            <th class="text-nowrap" scope="row">Estado:</th>
                            <td class="text-nowrap" style="font-weight: bold; color: #fc6d00; font-size: 16px;" colspan="3"><?=$o_FCO_DocReciboBN->getEstadoDesc()?></td>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Medio de Pago:</th>
                            <td class="text-nowrap" style="color: #fc6d00;"><?=$o_FCO_DocReciboBN->getObjectTipoPago()->getNombre()?></td>
                            <th class="text-nowrap" scope="row">Numero de Operaci&oacute;n:</th>
                            <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_FCO_DocReciboBN->getReciboNumero()?></td>
                            <th class="text-nowrap" scope="row">Fecha:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getReciboFecha()?></td>
                            <th class="text-nowrap" scope="row">Fecha Vencimiento:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getFechaVencimiento()?></td>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Moneda:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getMonedaDes()?></td>
                            <th class="text-nowrap" scope="row">Tipo Cambio:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getTipoCambio()?></td>
                            <th class="text-nowrap" scope="row">Importe:</th>
                            <td class="text-nowrap" ><?=number_format( $o_FCO_DocReciboBN->getMonto(), 2 )?></td>
                            <th class="text-nowrap" scope="row">Saldo:</th>
                            <td class="text-nowrap" ><?=number_format( $o_FCO_DocReciboBN->getSaldo(), 2 )?></td>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Banco:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getObjectBanco()->getDescripcionLocal()?></td>
                            <th class="text-nowrap" scope="row">Cuenta Bancaria:</th>
                            <td class="text-nowrap" ><?=$o_FCO_DocReciboBN->getObjectCuentaBancaria()->getNumeroCuenta()?></td>
                            <?php $b_CtrlMN = false ?>
                            <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <?php $b_CtrlMN = true ?>
                            <th class="text-nowrap" scope="row">Importe MN</th>
                            <td class="text-nowrap" ><?=number_format( $o_FCO_DocReciboBN->getMontoMN(), 2 )?></td>
                            <th class="text-nowrap" scope="row">Saldo MN:</th>
                            <td class="text-nowrap" ><?=number_format( $o_FCO_DocReciboBN->getSaldoMN(), 2 )?></td>
                            <?php } ?>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>

    </div>
    
    <div class="dropdown-divider"></div>
    
    <div class="card" id="content_comprobantes">
        <h5 class="card-header" style="display: inline-flex;">Comprobantes Aplicados</h5>
        <div class="card-body" style="padding: 10px;">
            <div class="form-row mx-0" id="content_list_comprobantes">
            
                <div class="table-responsive">
                    <table class="table table-sm table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="5%" style="text-align: center;" scope="col">Tipo</th>
                                <th width="10%" style="text-align: center;" scope="col">Nro Documento</th>
                                <th width="5%" style="text-align: center;" scope="col">Fecha Doc</th>
                                <th width="5%" style="text-align: center;" scope="col">Fecha Vence</th>
                                <th width="5%" style="text-align: center;" scope="col">Moneda Doc</th>
                                <th width="10%" style="text-align: center;" scope="col">Monto Total</th>
                                <th width="10%" style="text-align: center;" scope="col">Saldo Doc</th>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <th width="5%" style="text-align: center;" scope="col">Moneda Cobrado</th>
                                <?php } ?>
                                
                                <th width="10%" style="text-align: center;" scope="col">Monto Cobrado</th>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <th width="10%" style="text-align: center;" scope="col">Monto MN Cobrado</th>
                                <?php } ?>
                                
                                <th width="5%" style="text-align: center;" scope="col">Fecha Cobrado</th>
                            </tr>
                        </thead>
                        <tbody id="">
                        <?php 
                        $f_SumaTotalDoc   = 0;
                        $f_SumaTotalCob   = 0;
                        $f_SumaTotalCobMN = 0;
                        ?>
                        <?php foreach ( $o_FCO_DocReciboBN->getArrayAplicaciones() as $o_FCO_AplicacionBN ){ ?>
                            <tr id="">
                                <td align="center"><?=$o_FCO_AplicacionBN->getCodDocRef()?></td>
                                <td align="center" nowrap="nowrap"><?=$o_FCO_AplicacionBN->getSerieNumeroDocRef()?></td>
                                <td align="center" nowrap="nowrap"><?=substr( $o_FCO_AplicacionBN->getFechaDocRef(), 0, 10 )?></td>
                                <td align="center" nowrap="nowrap"><?=substr( $o_FCO_AplicacionBN->getFechaDocVenRef(), 0, 10 )?></td>
                                <td align="center"><?=$o_FCO_AplicacionBN->getObjectMonedaDocRef()->getDescripcion()?></td>
                                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getMontoTotalDocRef(), 2 )?></td>
                                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getSaldoDocRef(), 2 )?></td>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <td align="center"><?=$o_FCO_AplicacionBN->getMonedaDes()?></td>
                                <?php } ?>
                                
                                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicado(), 2 )?></td>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicacionMN(), 2 )?></td>
                                <?php } ?>
                                
                                <td align="center" nowrap="nowrap"><?=substr( $o_FCO_AplicacionBN->getFechaAplicacion(), 0, 10 )?></td>
                            </tr>
                            <?php 
                            if( $o_FCO_AplicacionBN->getMostrar() == "Y" )
                            {
                                $f_SumaTotalDoc   = $f_SumaTotalDoc + $o_FCO_AplicacionBN->getMontoTotalDocRef();
                                $f_SumaTotalCob   = $f_SumaTotalCob + $o_FCO_AplicacionBN->getMontoAplicado();
                                $f_SumaTotalCobMN = $f_SumaTotalCobMN + $o_FCO_AplicacionBN->getMontoAplicacionMN();
                            }
                            ?>
                        <?php } ?>
                        </tbody>
                        <tbody id="">
                            <tr>
                                <td align="right" colspan="5">TOTALES</td>
                                <td align="right"><?=number_format( $f_SumaTotalDoc, 2 )?></td>
                                <td align="right">&nbsp;</td>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <td align="right">&nbsp;</td>
                                <?php } ?>
                                
                                <td align="right"><?=number_format( $f_SumaTotalCob, 2 )?></td>
                                
                                <?php if( $o_FCO_DocReciboBN->getIdMoneda() == "EX" ){ ?>
                                <td align="right"><?=number_format( $f_SumaTotalCobMN, 2 )?></td>
                                <?php } ?>
                                
                                <td align="right">&nbsp;</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
            </div>
        </div>
    </div>
    
    <div class="dropdown-divider"></div>
    
    <div class="form-row mx-0" style="" id="content_buttons">
        <div class="col-md-4 mb-1">
            <button type="button" class="btn btn-danger btn-sm btn-block" onclick="parent.closeWindow()">CERRAR</button>
        </div>
        <?php if( $o_FCO_DocReciboBN->getEstado() == FCO_DocReciboBN::ESTADO_ACTIVO ){ ?>
        <div class="col-md-4 mb-1">
            <button type="button" class="btn btn-primary btn-sm btn-block" onclick="anularDocumentoRecibo();">ANULAR</button>
        </div>
        <div class="col-md-4 mb-1">
            <button type="button" class="btn btn-primary btn-sm btn-block" onclick="verPDF();">VER PDF</button>
        </div>
        <?php } ?>
    </div>

</form>

<script type="text/javascript">
anularDocumentoRecibo = function()
{
    x = confirm( "Esta seguro de anularo el Documento?" );
    if( x )
    {
    	blockContent( 'form1' );
    	var serialice = "TipoProc=AnularRecibo&IdDocRecibo=" + $( "#iddocrecibo" ).val() ;
    	executeAjaxJson
        ( 
            "<?php echo buildUrl( 'caja/requestCaja', "" ) ?>", 
            serialice,
            function( o_json )
            {
                unBlockContent( 'form1' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }

                showAlertBootStrap( 'content_alert', 'alert-success', "Se anulo satisfactoriamente, junto a sus aplicaciones." );
                
                setTimeout
                (
                    function()
                    {
                    	//location.reload();
                    },
                    1500
                );
            } 
        );
    }
}

verPDF = function()
{
    window.open('<?=buildUrl( 'caja/cobranzaPDF', "IdDocRecibo=".$o_FCO_DocReciboBN->getIdDocRecibo() )?>', '_blank', '');
}
</script>