<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
        <?php if( $s_TipoProc != "shw" ){ ?>
        <div class="form-row mx-1">
            <input type="button" class="btn btn-primary" value="REGRESAR" onclick="location.href='<?=buildUrl('orden/list' )?>';" >
        </div>
        <?php } ?>
    </div>
</div>

<script type="text/javascript">
completarOrdenPrd = function()
{
    x = confirm( "Esta seguro de Completar la Orden?" );
    if( x )
    {
    	blockContent( "content_datos_cliente" );
    	var str_serialize = "TipoProc=CerrarOrdenPrd&IdOrdenCab=" + $( "#IdOrdenCab" ).val();
    	executeAjaxJson
        ( 
            "<?php echo buildUrl( 'orden/requestPrdOrden' ) ?>", 
            str_serialize,
            function( o_json )
            {
            	unBlockContent( "content_datos_cliente" );
                if( o_json.error )
                {
                	unBlockContent( 'content_datos_cliente' );
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                window.open( '<?=buildUrl( 'orden/printPDF', 'IdOrdenCab='.$s_IdOrdenCab )?>', '_BLANK' );
                location.reload();
            } 
        );
    }
}
reservarOrdenPrd = function()
{
    x = confirm( "Esta seguro de cambiar el estado de la Orden?" );
    if( x )
    {
        blockContent( "content_datos_cliente" );
        var str_serialize = "TipoProc=ReservarOrdenPrd&IdOrdenCab=" + $( "#IdOrdenCab" ).val();
        executeAjaxJson
        (
            "<?php echo buildUrl( 'orden/requestPrdOrden' ) ?>",
            str_serialize,
            function( o_json )
            {
                unBlockContent( "content_datos_cliente" );
                if( o_json.error )
                {
                    unBlockContent( 'content_datos_cliente' );
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                location.reload();
            }
        );
    }
}
anularOrdenPrd = function()
{
	x = confirm( "Esta seguro de Anular la Orden?" );
    if( x )
    {
    	blockContent( "content_datos_cliente" );
    	var str_serialize = "TipoProc=AnularOrdenPrd&IdOrdenCab=" + $( "#IdOrdenCab" ).val();
    	executeAjaxJson
        ( 
            "<?php echo buildUrl( 'orden/requestPrdOrden' ) ?>", 
            str_serialize,
            function( o_json )
            {
            	unBlockContent( "content_datos_cliente" );
                if( o_json.error )
                {
                	unBlockContent( 'content_datos_cliente' );
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                location.reload();
            } 
        );
    }
}
crearOrdenPrd = function()
{
	x = confirm( "Esta seguro de crear la Orden?" );
    if( x )
    {
        $( "#form1" ).submit();
    }
}
pdfOrdenPrd = function()
{
	window.open( '<?=buildUrl( 'orden/printPDF', 'IdOrdenCab='.$s_IdOrdenCab )?>', '_BLANK' );
}
excelOrdenPrd = function()
{
    window.open( '<?=buildUrl( 'orden/printExcel', 'IdOrdenCab='.$s_IdOrdenCab )?>', '_BLANK' );
}
</script>

<?php
$b_CtrlEdicion = true;
if( $s_Estado == PRD_OrdenCabBN::ESTADO_ANULADO || $s_Estado == PRD_OrdenCabBN::ESTADO_COMPLETADO )
{
    $b_CtrlEdicion = false;
}
?>

<form name="form1" id="form1" method="POST" action="" onsubmit=";">
    <input type="hidden" name="Control" id="Control" value="1">
    <input type="hidden" name="IdOrdenCab" id="IdOrdenCab" value="<?=$s_IdOrdenCab?>">
    <input type="hidden" name="TipoProc" id="TipoProc" value="<?=$s_TipoProc?>">
    
    <div class="card" id="content_datos_cliente">
        <h5 class="card-header">Datos de Cabecera</h5>
        <div class="card-body" style="padding: 10px;">
            <div class="form-row mx-0">
                <div class="col-md-10 mb-1">
                    <div class="form-row mx-0">
                        <div class="col-md-3 mb-1">
                            <label class="col-form-label" for="IdOrdenCab">Nro Orden:</label>
                            <input type="text" id="IdOrdenCab" name="IdOrdenCab" class="form-control text-center" value="<?=$s_IdOrdenCab?>" readonly="readonly">
                        </div>
                        <div class="col-md-3 mb-1">
                            <label class="col-form-label" for="cboTipoOrden">Tipo Orden:</label>
                            <input type="hidden" name="TipoOrden" id="TipoOrden" value="<?=$s_TipoOrden?>">
                            <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="cboTipoOrden" id="cboTipoOrden" disabled="disabled" >
                                <?php foreach( PRD_OrdenCabBN::getArrayTipoOrden() as $s_Key => $s_Data ){ ?>
                                    <option value="<?=$s_Key?>" <?php if( $s_Key == $s_TipoOrden ){ echo "SELECTED"; } ?> > <?=$s_Data?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-1">
                            <label class="col-form-label" for="FechaOrden">Fecha Orden:</label>
                            <input type="text" class="form-control text-center" id="FechaOrden" name="FechaOrden" readonly="readonly" value="<?=date( "Y-m-d" )?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-1">
                            <label for="IdDocRef" class="col-form-label">Cotizaci&oacute;n:</label>
                            <div class="input-group mb-0">
                                <input type="hidden" id="ProFinalId" name="ProFinalId" class="form-control" value="<?=$s_ProFinalId?>" >
                                <input type="hidden" id="IdDocRef" name="IdDocRef" class="form-control" value="<?=$s_IdDocRef?>" >
                                <input type="text" id="DocNumRef" name="DocNumRef" class="form-control text-center" value="<?=$s_DocNumRef?>" readonly="readonly">
                                <?php if( !$s_IdOrdenCab ){ ?>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" id="btn_fnd_orden" onclick="" type="button">Buscar</button>
                                    <script>
                                    $( "#btn_fnd_orden" )
                                    .click
                                    (
                                        function()
                                        {
                                            //var frameSrc = "<?=buildUrlComplet( 'vta.php/pro/listCotizacion', '' )?>";
                                        	var frameSrc = "<?=buildUrl( 'orden/listCotizacion', 'Tipo=OrdenPrd' )?>";
                                            $( "#exampleModalLongTitle" ).html( "Buscar Cotizaci&oacute;n" );
                                            $( '#iframe_id' ).attr( "src", frameSrc );
                                            $( '#exampleModalCenter' ).modal( { show:true } );
                                        }
                                    )
                                    asignarCotizacion = function( ProFinalId, OrdenId, CodCotizacion, AlmacenOrigen )
                                    {
                                        $( "#cboTipoOrden" ).val( "PRDCOT" );
                                        $( "#TipoOrden" ).val( "PRDCOT" );
                                        $( "#ProFinalId" ).val( ProFinalId );
                                        $( "#IdDocRef" ).val( OrdenId );
                                        $( "#DocNumRef" ).val( CodCotizacion );
                                        $( "#cboAlmacenOrigen" ).val( AlmacenOrigen );
                                        ocultarModal();
                                    }
                                    </script>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-row mx-0">
                        <div class="col-md-3 mb-1">
                            <label for="Comentario" class="col-form-label">Comentario:</label>
                            <textarea class="form-control" id="Comentario" name="Comentario" rows="1" <?php if( !$b_CtrlEdicion ){ ?> readonly="readonly" <?php } ?> ><?=$s_Comentario?></textarea>
                        </div>
                        <div class="col-md-3 mb-1">
                            <label class="col-form-label" for="">Estado:</label>
                            <input type="text" class="form-control text-center" id="" name="" readonly="readonly" value="<?=$s_EstadoDesc?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-1">
                            <label class="col-form-label" for="cboAlmacenOrigen">Almacen Origen:</label>
                            <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="cboAlmacenOrigen" id="cboAlmacenOrigen" <?php if( $s_AlamcenOri ){ echo "disabled"; } ?> >
                                <!--<option value=""  > - Seleccione - </option>-->
                                <?php foreach ( $a_ALM_AlmacenMast as $o_ALM_AlmacenMastBN ){ ?>
                                <option value="<?=$o_ALM_AlmacenMastBN->getIdAlmacen()?>" <?php if( $s_AlamcenOri == $o_ALM_AlmacenMastBN->getIdAlmacen() ){ echo "SELECTED"; } ?> > <?=$o_ALM_AlmacenMastBN->getDescripcionLocal()?> </option>
                                <?php } ?>
                            </select>
                        </div>
                         
                        <div class="col-md-3 mb-1 " aria-disabled="true">
                            <!-- 
                            <label class="col-form-label" for="NombreProyecto">Proyecto:</label>
                            <div class="input-group mb-0 " >
                                <input type="hidden" name="IdProyecto" id="IdProyecto" value="<?=$s_IdProyecto?>">
                                <input type="text" id="NombreProyecto" name="NombreProyecto" class="form-control" value="<?=$s_NombreProyecto?>" onfocus="this.select();" <?php if( !$b_CtrlEdicion ){ ?> readonly="readonly" <?php } ?> >
                                <?php if( $b_CtrlEdicion ){ ?>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" id="btnProyectoBus" type="button">Buscar</button>
                                    <script type="text/javascript">
                                    $( "#btnProyectoBus" )
                                    .click
                                    (
                                        function()
                                        {
                                            var frameSrc = "<?=buildUrlComplet( 'vta.php/cot/listProyectos', 'IdPersona=' )?>";
                                            $( "#exampleModalLongTitle" ).html( "Buscar Proyecto" );
                                            $( '#iframe_id' ).attr( "src", frameSrc );
                                            $( '#exampleModalCenter' ).modal( { show:true } );
                                        }
                                    );
                                    asignarCotizacion = function( IdProyecto, Nombre )
                                    {
                                        $( "#IdProyecto" ).val( IdProyecto );
                                        $( "#NombreProyecto" ).val( Nombre );
                                        ocultarModal();
                                    }
                                    actualizarProyecto = function( IdProyecto, Nombre )
                                    {
                                        $( "#IdProyecto" ).val( IdProyecto );
                                        $( "#NombreProyecto" ).val( Nombre );
                                        ocultarModal();
                                    }
                                    </script>
                                </div>
                                <?php } ?>
                            </div>
                             -->
                        </div>
                        
                    </div>
                </div>
                <div class="col-md-2 mb-1">
                    <?php if( $s_Estado == "" ){ ?>
                    <button type="button" class="btn btn-primary btn-block" onclick="crearOrdenPrd();">CREAR ORDEN</button>
                    <?php } ?>
                    <?php if( $s_Estado == PRD_OrdenCabBN::ESTADO_PENDIENTE ){ ?>
                        <button type="submit" class="btn btn-primary btn-block" onclick="">ACTUALIZAR</button>
                        <?php if( $s_TipoOrden == PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL ){ ?>
                        <button type="button" class="btn btn-primary btn-block" onclick="reservarOrdenPrd();">RESERVAR</button>
                        <?php } ?>
                        <button type="button" class="btn btn-primary btn-block" onclick="anularOrdenPrd();">ANULAR</button>
                    <?php } ?>
                    <?php if( $s_Estado == PRD_OrdenCabBN::ESTADO_RESERVADO ){ ?>
                        <button type="submit" class="btn btn-primary btn-block" onclick="">ACTUALIZAR</button>
                        <button type="button" class="btn btn-primary btn-block" onclick="completarOrdenPrd();">COMPLETAR</button>
                    <?php } ?>
                    <?php if( $s_IdOrdenCab ){ ?>
                        <button type="button" class="btn btn-primary btn-block" onclick="pdfOrdenPrd();">VER PDF</button>
                    <?php } ?>
                    <?php if( $s_Estado == PRD_OrdenCabBN::ESTADO_COMPLETADO ){ ?>
                        <button type="button" class="btn btn-primary btn-block" onclick="excelOrdenPrd();">EXCEL</button>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</form>
    
<div class="dropdown-divider"></div>

<div id="content_alert" style=""></div>

<?php if( $s_IdOrdenCab ){ ?>
<div class="table-responsive">
    <nav>
        <div class="nav nav-tabs" id="myTab" role="tablist">
            <a class="nav-item nav-link active" id="nav-general-tab" data-toggle="tab" href="#nav-general" role="tab" aria-controls="nav-general" aria-selected="true">General</a>
            <a class="nav-item nav-link"        id="nav-obra-tab" data-toggle="tab" href="#nav-obra" role="tab" aria-controls="nav-obra" aria-selected="false">Mano de Obra</a>
            <a class="nav-item nav-link"        id="nav-equipo-tab" data-toggle="tab" href="#nav-equipo" role="tab" aria-controls="nav-equipo" aria-selected="false">Equipo y Herramienta</a>
            <a class="nav-item nav-link"        id="nav-servicio-tab" data-toggle="tab" href="#nav-servicio" role="tab" aria-controls="nav-servicio" aria-selected="false">Servicio Externo</a>
        </div>
    </nav>
</div>
<div class="tab-content" id="nav-tabContent">
    <div class="tab-pane fade show active" id="nav-general" role="tabpanel" aria-labelledby="nav-general-tab">
        <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125);">
            <iframe width="100%" frameborder="0" align="middle" id="iframe_general"  class="embed-responsive-item" src="" height="620" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125);"></iframe>
        </div>
    </div>
    <div class="tab-pane fade" id="nav-obra" role="tabpanel" aria-labelledby="nav-obra-tab">
        <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125);">
            <iframe width="100%" frameborder="0" align="middle" id="iframe_obra"  class="embed-responsive-item" src="" height="620" ></iframe>
        </div>
    </div>
    <div class="tab-pane fade" id="nav-equipo" role="tabpanel" aria-labelledby="nav-equipo-tab">
        <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125);">
            <iframe width="100%" frameborder="0" align="middle" id="iframe_equipo"  class="embed-responsive-item" src="" height="620" ></iframe>
        </div>
    </div>
    <div class="tab-pane fade" id="nav-servicio" role="tabpanel" aria-labelledby="nav-servicio-tab">
        <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125);">
            <iframe width="100%" frameborder="0" align="middle" id="iframe_servicio"  class="embed-responsive-item" src="" height="620" ></iframe>
        </div>
    </div>
</div>
<?php } ?>
<script type="text/javascript">
$( '#myTab a' ).on
(
    'click', function ( e ) 
    {
        pr( $( e.currentTarget ).attr( "aria-controls" ) );
        
        var id_content = $( e.currentTarget ).attr( "aria-controls" );

        if( id_content == "nav-general" )
        {
            $( '#iframe_general' ).attr( "src", "<?=buildUrl( 'orden/ordendet', "ord_id=$s_IdOrdenCab&tipo=general" ) ?>" );
        }
        if( id_content == "nav-obra" )
        {
            $( '#iframe_obra' ).attr( "src", "<?=buildUrl( 'orden/ordendet', "ord_id=$s_IdOrdenCab&tipo=mano" ) ?>" );
        }
        if( id_content == "nav-equipo" )
        {
            $( '#iframe_equipo' ).attr( "src", "<?=buildUrl( 'orden/ordendet', "ord_id=$s_IdOrdenCab&tipo=equipo" ) ?>" );
        }
        if( id_content == "nav-servicio" )
        {
            $( '#iframe_servicio' ).attr( "src", "<?=buildUrl( 'orden/ordendet', "ord_id=$s_IdOrdenCab&tipo=servicio" ) ?>" );
        }

        e.preventDefault()
        $( this ).tab( 'show' );
    }
);
//tab por defecto
$( '#iframe_general' ).attr( "src", "<?=buildUrl( 'orden/ordendet', "ord_id=$s_IdOrdenCab&tipo=general" ) ?>" );
</script>


<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
.modal
{
 padding: 0 !important;
}
.modal-dialog {
  max-width: 95% !important;
  height: 90%;
/*  padding: 0;
  margin: 0;*/
}

.modal-content {
  /*border-radius: 0 !important;*/
  height: 70%;
}
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal - NUEVO CLIENTE -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">---</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="zoom:0.60;" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
<?php if( $s_Mensaje ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', '<?=str_replace( "'", "", $s_Mensaje )?>' );
<?php } ?>
</script>

<script type="text/javascript">
abrirPopupRecibo = function()
{
	var IdPersona = $( "#ClienteNumero" ).val();
    var frameSrc = "<?=buildUrl( 'caja/addeditRecibo', 'TipoProc=nvo' )?>/IdPersona/" + IdPersona ;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( "#exampleModalLongTitle" ).html( "Nuevo Recibo" );
    $( '#exampleModalCenter' ).modal( { show:true } );    
}
asignarValores = function()
{
	
    ocultarModal();
}
ocultarModal = function()
{
    $( '#exampleModalCenter' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

