<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class ordenActions extends wtActions
{
    public function executePrintPDF()
    {
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
        
        $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
        $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenCab );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_PRD_OrdenCabBN->getIdCompania() );
        
        $a_Data   = array
        (
                "o_GSS_CompaniaBN" => $o_GSS_CompaniaBN,
                "o_PRD_OrdenCabBN" => $o_PRD_OrdenCabBN
        );

        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();

        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );

        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }
    
    public function executePrintExcel()
    {
        $this->s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
        
        header( 'Content-Type: application/vnd.ms-excel' );
        header( 'Content-Disposition: attachment;filename="Orden_Produccion_'.str_pad( $this->s_IdOrdenCab, 10, "0", STR_PAD_LEFT ).'.xls"' );
        header( 'Cache-Control: max-age=0' );
        
        $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
        $this->o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $this->s_IdOrdenCab );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->o_PRD_OrdenCabBN->getIdCompania() );
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGrid()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new PRD_OrdenCabFN() );
        
        //$o_GridAction->addAssignFilter( "TipoDocCliente" );
        //$o_GridAction->addConditionFilter( "NumTipoDocCliente", FCO_DocReciboFN::NumTipoDocCliente,  "LIKE", "%%s%" );
        //$o_GridAction->addAssignFilter( "IdTipoPago" );
        //$o_GridAction->addConditionFilter( "ReciboNumero", FCO_DocReciboFN::ReciboNumero,  "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "FechaDocumento1", FCO_DocReciboFN::ReciboFecha,  ">=", '00:00:00' );
        //$o_GridAction->addConditionFilter( "FechaDocumento2", FCO_DocReciboFN::ReciboFecha,  "<=", '23:59:59' );        
        //$o_GridAction->addOrder( "Estado", FCO_CierreFN::Estado );
        
        $o_GridAction->addOrderDefault( PRD_OrdenCabFN::IdOrdenCab, true );
        
        $o_GridAction->addRowsToShow( "IdOrdenCab", "FechaOrden", "ProyectoDesc", "DocNumRef", "EstadoDesc", "TipoOrdenDesc", "Estado" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE; 
    }
    
    public function executeListPrd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGridProduccion()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new PRD_OrdenCabFN() );
        
        //$o_GridAction->addAssignFilter( "TipoDocCliente" );
        //$o_GridAction->addConditionFilter( "NumTipoDocCliente", FCO_DocReciboFN::NumTipoDocCliente,  "LIKE", "%%s%" );
        //$o_GridAction->addAssignFilter( "IdTipoPago" );
        //$o_GridAction->addConditionFilter( "ReciboNumero", FCO_DocReciboFN::ReciboNumero,  "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "FechaDocumento1", FCO_DocReciboFN::ReciboFecha,  ">=", '00:00:00' );
        //$o_GridAction->addConditionFilter( "FechaDocumento2", FCO_DocReciboFN::ReciboFecha,  "<=", '23:59:59' );
        //$o_GridAction->addOrder( "Estado", FCO_CierreFN::Estado );
        $o_GridAction->addMethodDefault( PRD_OrdenCabFN::Estado, array( 'Condition'=>'IN', 'Value'=>"( 'P', 'R' )" ) );
        
        $o_GridAction->addOrderDefault( PRD_OrdenCabFN::IdOrdenCab, true );
        
        $o_GridAction->addRowsToShow( "IdOrdenCab", "FechaOrden", "ProyectoDesc", "DocNumRef", "EstadoDesc", "TipoOrdenDesc" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE; 
    }
    

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_Titulo     = "Orden Produccion - Registro";
        $this->s_Mensaje    = "";
        $this->s_TipoProc   = $this->getRequestParameter( 'TipoProc' );
        $this->s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
        
        $this->s_TipoOrden      = is_null( $this->getRequestParameter( 'TipoOrden' ) ) ? PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL : $this->getRequestParameter( 'TipoOrden' );
        $this->s_FechaOrden     = $this->getRequestParameter( 'FechaOrden' );
        $this->s_ProFinalId     = $this->getRequestParameter( 'ProFinalId' );
        $this->s_IdDocRef       = $this->getRequestParameter( 'IdDocRef' );
        $this->s_DocNumRef      = $this->getRequestParameter( 'DocNumRef' );
        $this->s_Comentario     = $this->getRequestParameter( 'Comentario' );
        $this->s_Estado         = "";
        $this->s_EstadoDesc     = "";
        $this->s_AlamcenOri     = $this->getRequestParameter( 'cboAlmacenOrigen' );
        $this->s_IdProyecto     = $this->getRequestParameter( 'IdProyecto' );
        $this->s_NombreProyecto = $this->getRequestParameter( 'NombreProyecto' );
        
        if( $this->getRequestParameter( 'Control' ) ) //submit
        {
            try 
            {
                if( $this->s_TipoProc == "nvo" )
                {
                    if( $this->s_TipoOrden == PRD_OrdenCabBN::TIPO_ORDEN_PROD_COTI )
                    {
                        //ahora buscamos la cotizacion si se encuentra seleccionado:
                        $o_VTA_OrdenFN = new VTA_OrdenFN();
                        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_IdDocRef );
                        if( $o_VTA_OrdenBN )
                        {
                            $s_AlmacenDespacho = $o_VTA_OrdenBN->getAlmacenDespacho();
                            $s_IdProyecto = $o_VTA_OrdenBN->getIdProyecto();
                            
                            $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
                            $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $s_IdProyecto );
                            $s_NombreProyecto = $o_VTA_PrsProyectosBN->getNombreProyecto();
                        }
                        
                        $i_IdOrdenCab = PRD_OrdenCabDP::recuperarId();
                        
                        $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                        $o_PRD_OrdenCabDP->setIdOrdenCab( $i_IdOrdenCab );
                        $o_PRD_OrdenCabDP->setIdCompania( myUser::getUser()->getIdCompania() );
                        $o_PRD_OrdenCabDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_PRD_OrdenCabDP->setFechaOrden( date( "Y-m-d" ) );
                        $o_PRD_OrdenCabDP->setTipoOrden( $this->s_TipoOrden );
                        $o_PRD_OrdenCabDP->setIdAlmacen( "A1303" ); //almacen de produccion
                        $o_PRD_OrdenCabDP->setIdProyecto( $s_IdProyecto );
                        $o_PRD_OrdenCabDP->setProyectoDesc( $s_NombreProyecto );
                        $o_PRD_OrdenCabDP->setProFinalId( ( int ) $this->s_ProFinalId );
                        $o_PRD_OrdenCabDP->setIdDocRef( ( int ) $this->s_IdDocRef ); //id cotizacion
                        $o_PRD_OrdenCabDP->setDocNumRef( $this->s_DocNumRef ); //numero cotizacion
                        $o_PRD_OrdenCabDP->setIdAlmacenRef( $s_AlmacenDespacho ); //almacen de destino
                        $o_PRD_OrdenCabDP->setComentario( $this->s_Comentario );
                        $o_PRD_OrdenCabDP->setEstado( "P" ); //P endiente  |  C ompletado  |  A nulado
                        $o_PRD_OrdenCabDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->save();
                        
                        //pr( $o_PRD_OrdenCabDP );
                        
                        $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
                        $o_VTA_ProductoFinalFN->setProFinalId( $this->s_ProFinalId );
                        $o_VTA_ProductoFinalFN->setOrdenId( $this->s_IdDocRef );
                        $a_VTA_ProductoFinal = $o_VTA_ProductoFinalFN->select();
                        //se registra el producto final
                        foreach ( $a_VTA_ProductoFinal as $o_VTA_ProductoFinalBN )
                        {
                            $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
                            $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                            $o_PRD_OrdenDetDP->setIdOrdenCab( $i_IdOrdenCab );
                            $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                            $o_PRD_OrdenDetDP->setIdItem( $o_VTA_ProductoFinalBN->getIdItem() );
                            $o_PRD_OrdenDetDP->setItemTipo( "PF" );
                            $o_PRD_OrdenDetDP->setDescripcionItem( $o_VTA_ProductoFinalBN->getDetalleDescripcion() );
                            $o_PRD_OrdenDetDP->setIdUnidad( 58 );
                            $o_PRD_OrdenDetDP->setCantidadPedida( $o_VTA_ProductoFinalBN->getCantidad() );
                            $o_PRD_OrdenDetDP->setCantidadRecibida( 0 );
                            $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_PRD_OrdenDetDP->save();
                            //pr( $o_PRD_OrdenDetDP );
                        }
                        
                        $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                        $o_VTA_ProductoFinalDetFN->setProFinalId( $this->s_ProFinalId );
                        $o_VTA_ProductoFinalDetFN->setOrdenId( $this->s_IdDocRef );
                        $a_VTA_ProductoFinalDet = $o_VTA_ProductoFinalDetFN->select();
                        //se registra los materiales
                        foreach ( $a_VTA_ProductoFinalDet as $o_VTA_ProductoFinalDetBN )
                        {
                            //pr( $o_VTA_ProductoFinalDetBN );
                            $f_UltimoCosto = ALM_KardexFN::buscarUltimoCosto( myUser::getUser()->getIdCompania(), $o_VTA_ProductoFinalDetBN->getIdAlmacen(), $o_VTA_ProductoFinalDetBN->getIdItem() );
                            if( !$f_UltimoCosto )
                            {
                                throw new Exception( "No se encontro Costo para el Producto [{$o_VTA_ProductoFinalDetBN->getIdItem()}]" );
                            }
                            //pr( $f_UltimoCosto );
                            $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
                            $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                            $o_PRD_OrdenDetDP->setIdOrdenCab( $i_IdOrdenCab );
                            $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                            $o_PRD_OrdenDetDP->setIdItem( $o_VTA_ProductoFinalDetBN->getIdItem() );
                            $o_PRD_OrdenDetDP->setItemTipo( "PR" );
                            $o_PRD_OrdenDetDP->setDescripcionItem( $o_VTA_ProductoFinalDetBN->getDetalleDescripcion() );
                            $o_PRD_OrdenDetDP->setIdUnidad( 58 );
                            $o_PRD_OrdenDetDP->setCantidadPedida( $o_VTA_ProductoFinalDetBN->getCantidad() );
                            $o_PRD_OrdenDetDP->setCantidadRecibida( 0 );
                            $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_UltimoCosto );
                            $o_PRD_OrdenDetDP->setPrecioCostoTotal( round( $o_VTA_ProductoFinalDetBN->getCantidad() * $f_UltimoCosto, 2 ) );
                            $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_PRD_OrdenDetDP->save();
                            //pr( $o_PRD_OrdenDetDP );
                        }
                        
                        //ahora se actualiza el producto final, por ya tiene orden de produccion
                        $o_VTA_ProductoFinalDP = new VTA_ProductoFinalDP();
                        $o_VTA_ProductoFinalDP->setProFinalId( ( int ) $this->s_ProFinalId );
                        $o_VTA_ProductoFinalDP->setIdOrdenPrdCab( $i_IdOrdenCab );
                        $o_VTA_ProductoFinalDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_ProductoFinalDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_ProductoFinalDP->update();
                    }
                    
                    if( $this->s_TipoOrden == PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL )
                    {
                        $i_IdOrdenCab = PRD_OrdenCabDP::recuperarId();
                        
                        $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                        $o_PRD_OrdenCabDP->setIdOrdenCab( $i_IdOrdenCab );
                        $o_PRD_OrdenCabDP->setIdCompania( myUser::getUser()->getIdCompania() );
                        $o_PRD_OrdenCabDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_PRD_OrdenCabDP->setFechaOrden( date( "Y-m-d" ) );
                        $o_PRD_OrdenCabDP->setTipoOrden( $this->s_TipoOrden );
                        $o_PRD_OrdenCabDP->setIdAlmacen( $this->s_AlamcenOri ); //se tiene que elegir, pero por defecto ahora es el almacen de origen | 2021-11-11
                        if( trim( $this->s_NombreProyecto ) != "" )
                        {
                            $o_PRD_OrdenCabDP->setIdProyecto( ( int ) $this->s_IdProyecto );
                            $o_PRD_OrdenCabDP->setProyectoDesc( trim( $this->s_NombreProyecto ) );
                        }
                        else
                        {
                            //$o_PRD_OrdenCabDP->setIdProyecto( "" );
                            //$o_PRD_OrdenCabDP->setProyectoDesc( "" );
                        }
                        //$o_PRD_OrdenCabDP->setProFinalId( ( int ) $this->s_ProFinalId );
                        //$o_PRD_OrdenCabDP->setIdDocRef( ( int ) $this->s_IdDocRef ); //id cotizacion
                        //$o_PRD_OrdenCabDP->setDocNumRef(  ); //numero cotizacion
                        $o_PRD_OrdenCabDP->setIdAlmacenRef( $this->s_AlamcenOri ); //almacen de destino
                        $o_PRD_OrdenCabDP->setComentario( $this->s_Comentario );
                        $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_PENDIENTE ); //P endiente  |  C ompletado  |  A nulado
                        $o_PRD_OrdenCabDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->save();
                    }
                    
                    //redirect
                    $s_Dir = Constantes::ROOT_DIR_APP;
                    header( "Location:".$s_Dir."prd.php/orden/addedit/TipoProc/upd/IdOrdenCab/".$i_IdOrdenCab );
                }
                if( $this->s_TipoProc == "upd" )
                {
                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $this->s_IdOrdenCab );
                    if( trim( $this->s_NombreProyecto ) != "" )
                    {
                        $o_PRD_OrdenCabDP->setIdProyecto( ( int ) $this->s_IdProyecto );
                        $o_PRD_OrdenCabDP->setProyectoDesc( trim( $this->s_NombreProyecto ) );
                    }
                    else
                    {
                        $o_PRD_OrdenCabDP->setIdProyecto( "null" );
                        $o_PRD_OrdenCabDP->setProyectoDesc( "" );
                    }
                    if( $this->s_AlamcenOri )
                    {
                        $o_PRD_OrdenCabDP->setIdAlmacenRef( $this->s_AlamcenOri );
                    }
                    $o_PRD_OrdenCabDP->setComentario( $this->s_Comentario );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();
                }
            }
            catch ( Exception $e )
            {
                $this->s_Mensaje = $e->getMessage();
            }
        }
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        if( $this->s_TipoProc == "upd" || $this->s_TipoProc == "shw" )
        {
            $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
            $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $this->s_IdOrdenCab );
            
            $this->s_TipoOrden      = $o_PRD_OrdenCabBN->getTipoOrden();
            $this->s_FechaOrden     = $o_PRD_OrdenCabBN->getFechaOrden();
            $this->s_IdDocRef       = $o_PRD_OrdenCabBN->getIdDocRef();
            $this->s_DocNumRef      = $o_PRD_OrdenCabBN->getDocNumRef();
            $this->s_Comentario     = $o_PRD_OrdenCabBN->getComentario();
            $this->s_EstadoDesc     = $o_PRD_OrdenCabBN->getEstadoDesc();
            $this->s_Estado         = $o_PRD_OrdenCabBN->getEstado();
            $this->s_AlamcenOri     = $o_PRD_OrdenCabBN->getIdAlmacenRef();
            $this->s_IdProyecto     = $o_PRD_OrdenCabBN->getIdProyecto();
            $this->s_NombreProyecto = $o_PRD_OrdenCabBN->getProyectoDesc();
        }
        
    }
        
    public function executeListCotizacion()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGridCotizacion()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_ProductoFinalFN() );
        
        if( $this->getRequestParameter( 'OrdenNum' ) )
        {
            $o_GridAction->addMethodDefault( "( SELECT OrdenNum FROM VTA_Orden WHERE OrdenId=VTA_ProductoFinal.OrdenId )", array( 'Condition'=>'LIKE', 'Value'=>"'%".$this->getRequestParameter( 'OrdenNum' )."%'" ) );
        }
        if( $this->getRequestParameter( 'ClienteNombre' ) )
        {
            $o_GridAction->addMethodDefault( "( SELECT ClienteNombre FROM VTA_Orden WHERE OrdenId=VTA_ProductoFinal.OrdenId )", array( 'Condition'=>'LIKE', 'Value'=>"'%".$this->getRequestParameter( 'ClienteNombre' )."%'" ) );
        }
        if( $this->getRequestParameter( 'ClienteDocNum' ) )
        {
            $o_GridAction->addMethodDefault( "( SELECT ClienteDocNum FROM VTA_Orden WHERE OrdenId=VTA_ProductoFinal.OrdenId )", array( 'Condition'=>'LIKE', 'Value'=>"'%".$this->getRequestParameter( 'ClienteDocNum' )."%'" ) );
        }
        
        $o_GridAction->addMethodDefault( VTA_ProductoFinalFN::OrdenId, array( 'Condition'=>'IN', 'Value'=>"( SELECT OrdenId FROM VTA_Orden WHERE OrdenEstado='C' AND OrdenTipoComercialId=1 AND OrdenTipoClasificacionId=2 )" ), false );
        //$o_GridAction->addMethodDefault( VTA_ProductoFinalFN::OrdenId, array( 'Condition'=>'IN', 'Value'=>"( SELECT OrdenId FROM VTA_Orden WHERE OrdenEstado='C' )" ), false );
        $o_GridAction->addMethodDefault( VTA_ProductoFinalFN::IdOrdenPrdCab, array( 'Condition'=>'IS', 'Value'=>"NULL" ) );
        
        $o_GridAction->addRowsToShow( "ProFinalId", "OrdenId", "OrdenNum", "OrdenFecha", "ClienteNombre", "ClienteDocCod", "ClienteDocNum", "OrdenEstadoDesc", "DescripcionItemPerso", "IdAlmacen" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
}