<?php
class RequestPrdOrdenAction extends wtActions 
{
    public function execute()
    {
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        if( !$this->getRequestParameter( 'TipoProc' ) )
        {
            $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        }
        $a_Result   = array( "Result" => false, "error" => false );

        $con = null;
        try
        {
            switch ( $s_TipoProc )
            {
                case "actualizarCantPf":

                    $i_IdOrdenCab   = intval( $this->getRequestParameter( 'IdOrdenCab' ) );
                    $i_IdOrdenDet   = intval( $this->getRequestParameter( 'IdDet' ) );
                    $f_Cantidad     = floatval( $this->getRequestParameter( 'Cantidad' ) );

                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $i_IdOrdenCab );
                    $o_PRD_OrdenDetFN->addCondition( PRD_OrdenDetFN::ItemTipo, "IN", "('PR','PM','PE','PS')", false );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $f_SumaTotal = 0;
                    foreach ( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        $f_SumaTotal = $f_SumaTotal + $o_PRD_OrdenDetBN->getPrecioCostoTotal();
                    }

                    $f_CostoUnitario = round( $f_SumaTotal / $f_Cantidad, 2 );

                    $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                    $o_PRD_OrdenDetDP->setIdOrdenCab( $i_IdOrdenCab );
                    $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                    $o_PRD_OrdenDetDP->setCantidadPedida( $f_Cantidad );
                    $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_CostoUnitario );
                    $o_PRD_OrdenDetDP->setPrecioCostoTotal( $f_SumaTotal );
                    $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenDetDP->update();

                break;
                case "nvodet":
                case "agregarDetPrd":
                    
                    if( $this->getRequestParameter( 'i_Id' ) )
                    {
                        $s_IdOrdenCab  = $this->getRequestParameter( 'i_Id' );
                        $s_ItemTipoPrd = $this->getRequestParameter( 'id_adicional' );
                        $s_IdItem      = $this->getRequestParameter( 'IdItem' );
                        $f_Cantidad    = floatval( $this->getRequestParameter( 'CantidadxCaja' ) );
                        if( !$f_Cantidad )
                        {
                            $f_Cantidad    = 1;
                        }
                    }
                    else
                    {
                        $s_IdOrdenCab  = $this->getRequestParameter( 'IdOrdenCab' );
                        $s_ItemTipoPrd = $this->getRequestParameter( 'ItemTipoPrd' );
                        $s_IdItem      = $this->getRequestParameter( 'IdItem' );
                        $f_Cantidad    = 1;
                    }
                    
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
                    
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenCab );
                    
                    //se hace una validacion de q el almacen de origen tiene q estar seleccionado.
                    if( !$o_PRD_OrdenCabBN->getIdAlmacenRef() )
                    {
                        throw new Exception( "Tiene que seleccionar el Almacen de Origen." );
                    }
                    
                    //ahora otra validacion, de q solo debe de haber un producto final
                    if( $s_ItemTipoPrd == "PF" )
                    {
                        $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                        $o_PRD_OrdenDetFN->setItemTipo( "PF" );
                        $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                        $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                        if( count( $a_PRD_OrdenDet ) >= 1 )
                        {
                            throw new Exception( "Solo se permite un Producto Final." );
                        }
                    }
                    
                    $f_UltimoCosto = 0;
                    if( $s_ItemTipoPrd != "PF" )
                    {
                        //$f_UltimoCosto = ALM_KardexFN::buscarUltimoCosto( myUser::getUser()->getIdCompania(), $o_PRD_OrdenCabBN->getIdAlmacenRef(), $s_IdItem );

                        $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, 1 );
                        if( !$o_MST_ListaPrecioDetalleBN )
                        {
                            throw new Exception( "El Item [".$s_IdItem."] no tiene Costo asignado." );
                        }
                        $f_UltimoCosto          = $o_MST_ListaPrecioDetalleBN->getPrecioCosto(); //costo asignado en el listado de precios
                        $f_PrecioUnitarioIncIGV = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();
                    }
                    
                    //se hace una validacion, si existe el producto, se actualiza la cantidad
                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                    $o_PRD_OrdenDetFN->setItemTipo( $s_ItemTipoPrd );
                    $o_PRD_OrdenDetFN->setIdItem( $s_IdItem );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $b_ControlNvo = true;
                    if( $a_PRD_OrdenDet )
                    {
                        $o_PRD_OrdenDetBN = $a_PRD_OrdenDet[0];
                        $i_IdOrdenDet = $o_PRD_OrdenDetBN->getIdOrdenDet();
                        if( !$this->getRequestParameter( 'i_Id' ) )
                        {
                            $f_Cantidad   = $f_Cantidad + $o_PRD_OrdenDetBN->getCantidadPedida();
                        }
                        $b_ControlNvo = false;
                    }
                    else
                    {
                        $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
                    }
                    //////////////////////////////////////////////////////////////////////////
                    $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                    $o_PRD_OrdenDetDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                    $o_PRD_OrdenDetDP->setIdItem( $s_IdItem );
                    $o_PRD_OrdenDetDP->setItemTipo( $s_ItemTipoPrd );
                    $o_PRD_OrdenDetDP->setDescripcionItem( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                    $o_PRD_OrdenDetDP->setIdUnidad( ( int ) $o_ALM_ItemMastBN->getUnidadCompra() );
                    $o_PRD_OrdenDetDP->setCantidadPedida( $f_Cantidad );
                    $o_PRD_OrdenDetDP->setCantidadRecibida( 0 );
                    $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_UltimoCosto );
                    $o_PRD_OrdenDetDP->setPrecioCostoTotal( round( $f_Cantidad * $f_UltimoCosto, 2 ) );
                    if( $b_ControlNvo )
                    {
                        $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenDetDP->save();
                    }
                    else
                    {
                        $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenDetDP->update();
                    }
                    
                break;
                case "EliminarDet":
                    
                    $i_IdOrdenDet = intval( $this->getRequestParameter( 'IdOrdenDet' ) );
                    $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                    $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                    $o_PRD_OrdenDetDP->delete();
                    
                break;
                case "CerrarOrdenPrd":
                    
                    $con = Conexion::getConexion();
                    $con->begin();
                    
                    myUser::getUser()->validar_session();
                    
                    $s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
                    
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenCab );
                    if( $o_PRD_OrdenCabBN->getEstado() == PRD_OrdenCabBN::ESTADO_PENDIENTE || $o_PRD_OrdenCabBN->getEstado() == PRD_OrdenCabBN::ESTADO_ANULADO || $o_PRD_OrdenCabBN->getEstado() == PRD_OrdenCabBN::ESTADO_COMPLETADO )
                    {
                        throw new Exception( "El siguiente procedimiento es imposible de realizar, validar el estado de la Orden." );
                    }
                    
                    $s_IdAlmacenDespacho = $o_PRD_OrdenCabBN->getIdAlmacenRef();

                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setItemTipo( "PR" );
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    foreach( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        if( $o_PRD_OrdenCabBN->getTipoOrden() == PRD_OrdenCabBN::TIPO_ORDEN_PROD_COTI )
                        {
                            if( $o_PRD_OrdenDetBN->getCantidadPedida() > $o_PRD_OrdenDetBN->getCantidadRecibida() )
                            {
                                throw new Exception( "El Producto [{$o_PRD_OrdenDetBN->getIdItem()}] no tiene la cantidad suficiente para realizar el procedimiento." );
                            }
                        }
                    }

                    $s_DescripcionTrx = "ORDEN POR COTIZACION";
                    $s_AlmacenSalida = "A1303"; //por defecto es PRODUCCION A1303
                    if( $o_PRD_OrdenCabBN->getTipoOrden() == PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL )
                    {
                        $s_AlmacenSalida = $o_PRD_OrdenCabBN->getIdAlmacen();
                        $s_DescripcionTrx = "ORDEN POR PRODUCCION";
                    }

                    //pr( $a_PRD_OrdenDet ); exit;
                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_COMPLETADO );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();
                    
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //AQUI SE REALIZA LA SALIDA
                    $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                    $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( "NS" );
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccion( "RTO" ); //RETIRO
                    //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( "A1303" ); //alquiler
                    $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $s_AlmacenSalida ); //almacen produccion
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                    $o_ALM_TransaccionCabeceraBN->setDescripcion( $s_DescripcionTrx );
                    $o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d H:i:s" ) );
                    $o_ALM_TransaccionCabeceraBN->setTipodeCambio( GSS_TipoCambioFN::getStaticTipoCambioCobranza() );
                    $o_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
                    $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( "PR" ); //ORDEN DE PRODUCCION -> VTA_TipoDocumento
                    $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $s_IdOrdenCab );
                    $o_ALM_TransaccionCabeceraBN->setIdProyecto( $o_PRD_OrdenCabBN->getIdProyecto() );
                    //$o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
                    $o_ALM_TransaccionCabeceraBN->setCodigoCliente( myUser::getUser()->getObjectCompania()->getIdUsuarioAdmin() ); //ID DE LA EMPRESA POR DEFECTO
                    
                    $o_utilGenerateId = new utilGenerateId();
                    $o_utilGenerateId->setIdCompania( -1 );
                    $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                    $o_utilGenerateId->setSerie( "TIPO" );
                    $i_IdCrtl = $o_utilGenerateId->generateId();
                    
                    $s_Tipo   = "CT";
                    $s_Serie  = "0001";
                    $s_Numero = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );
                    
                    $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $s_Tipo ); //$o_VTA_DocumentoBN->getIdTipoDocumento()
                    $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_Serie ); //$o_VTA_DocumentoBN->getDocumentoSerie()
                    $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_Numero ); //$o_VTA_DocumentoBN->getDocumentoNumero()
                    
                    $a_MovientoDetalle = array();
                    foreach( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                        $o_ALM_TransaccionDetalleBN->setIdItem( $o_PRD_OrdenDetBN->getIdItem() );
                        $o_ALM_TransaccionDetalleBN->setCantidad( $o_PRD_OrdenDetBN->getCantidadPedida() );
                        $o_ALM_TransaccionDetalleBN->setUnidadCodigo( ( string ) $o_PRD_OrdenDetBN->getIdUnidad() );
                        //$o_ALM_TransaccionDetalleBN->setPrecioUnitario( $o_PRD_OrdenDetBN->getPrecioCostoUnit() );
                        $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                    }
                    $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

                    $o_MovimientoBL = new MovimientoBL();
                    $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

                    //pr( $o_ALM_TransaccionCabeceraBN );
                    //pr( "-------------------------" );

                    $a_ALM_Kardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();
                    $o_ALM_TransaccionDetalleBN = $a_ALM_Kardex[0]->getObjetoDetalleTransaccion();

                    $s_LoteSelect = $o_ALM_TransaccionDetalleBN->getLote();
                    $s_FechaVenci = substr( $o_ALM_TransaccionDetalleBN->getFechaVencimiento(), 0, 10 );

                    $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                    $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                    $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();
                    
                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenCabDP->setIdTipoDocumentoSal( $s_IdTipoDocumento );
                    $o_PRD_OrdenCabDP->setIdNumeroDocumentoSal( $s_IdNumeroDocumento );
                    $o_PRD_OrdenCabDP->setIdTransaccionSal( $s_IdTransaccion );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //AHORA SE HACE EL INGRESO DEL PRODUCTO FINAL
                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                    $o_PRD_OrdenDetFN->setItemTipo( "PF" );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $f_CantidadPF    = $a_PRD_OrdenDet[0]->getCantidadPedida();
                    $i_IdProdFinalId = $a_PRD_OrdenDet[0]->getIdOrdenDet();
                    
                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                    $o_PRD_OrdenDetFN->addCondition( PRD_OrdenDetFN::ItemTipo, "IN", "('PR','PM','PE','PS')", false );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $this->f_SumaTotal = 0;
                    foreach ( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        $this->f_SumaTotal = $this->f_SumaTotal + $o_PRD_OrdenDetBN->getPrecioCostoTotal();
                    }
                    //se recupera el costo unitario para el producto final
                    $f_CostoUnitarioPF = round( $this->f_SumaTotal / $f_CantidadPF, 2 );
                    
                    //se actualiza el costo unitario
                    $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                    $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdProdFinalId );
                    $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_CostoUnitarioPF );
                    $o_PRD_OrdenDetDP->setPrecioCostoTotal( $this->f_SumaTotal );
                    $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenDetDP->update();
                    ///////////////////////////////////////////////////////////////////////////////

                    $s_AlmacenIngreso = "A1303"; //por defecto es PRODUCCION A1303
                    if( $o_PRD_OrdenCabBN->getTipoOrden() == PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL )
                    {
                        $s_AlmacenIngreso = $o_PRD_OrdenCabBN->getIdAlmacen();
                    }

                    $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                    $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( "NI" );
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccion( "DRE" ); //DEVOLUCIÓN RECIBIDA  //PREVIA COORDINACION CON EL CONTADOR DE LA EMPRESA
                    //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( "A1303" ); //alquiler
                    $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $s_AlmacenIngreso );
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                    $o_ALM_TransaccionCabeceraBN->setDescripcion( $s_DescripcionTrx );
                    $o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d H:i:s" ) );
                    $o_ALM_TransaccionCabeceraBN->setTipodeCambio( GSS_TipoCambioFN::getStaticTipoCambioCobranza() );
                    $o_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
                    $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( "PR" ); //ORDEN DE PRODUCCION -> VTA_TipoDocumento
                    $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $s_IdOrdenCab );
                    $o_ALM_TransaccionCabeceraBN->setIdProyecto( $o_PRD_OrdenCabBN->getIdProyecto() );
                    //$o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
                    $o_ALM_TransaccionCabeceraBN->setCodigoCliente( myUser::getUser()->getObjectCompania()->getIdUsuarioAdmin() ); //ID DE LA EMPRESA POR DEFECTO
                    
                    $o_utilGenerateId = new utilGenerateId();
                    $o_utilGenerateId->setIdCompania( -1 );
                    $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                    $o_utilGenerateId->setSerie( "TIPO" );
                    $i_IdCrtl = $o_utilGenerateId->generateId();
                    
                    $s_Tipo = "CT";
                    $s_Serie = "0001";
                    $s_Numero = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );
                    
                    $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $s_Tipo ); //$o_VTA_DocumentoBN->getIdTipoDocumento()
                    $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_Serie ); //$o_VTA_DocumentoBN->getDocumentoSerie()
                    $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_Numero ); //$o_VTA_DocumentoBN->getDocumentoNumero()
                    
                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setItemTipo( "PF" );
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenCab );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $a_MovientoDetalle = array();
                    foreach( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        $s_IdItem     = $o_PRD_OrdenDetBN->getIdItem();
                        $i_IdOrdenDet = $o_PRD_OrdenDetBN->getIdOrdenDet();
                        $f_CantidadPF = $o_PRD_OrdenDetBN->getCantidadPedida();
                        $i_IdUnidadPF = $o_PRD_OrdenDetBN->getIdUnidad();

                        $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                        $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                        $o_ALM_TransaccionDetalleBN->setCantidad( $f_CantidadPF );
                        $o_ALM_TransaccionDetalleBN->setUnidadCodigo( ( string ) $i_IdUnidadPF );
                        $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_CostoUnitarioPF );
                        $o_ALM_TransaccionDetalleBN->setLote( $s_LoteSelect );
                        $o_ALM_TransaccionDetalleBN->setFechaVencimiento( $s_FechaVenci );
                        $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                    }
                    $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );
                    
                    $o_MovimientoBL = new MovimientoBL();
                    $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

                    //pr( $o_ALM_TransaccionCabeceraBN ); exit;

                    $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                    $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                    $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();
                    
                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenCabDP->setIdTipoDocumentoIng( $s_IdTipoDocumento );
                    $o_PRD_OrdenCabDP->setIdNumeroDocumentoIng( $s_IdNumeroDocumento );
                    $o_PRD_OrdenCabDP->setIdTransaccionIng( $s_IdTransaccion );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();
                    
                    $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                    $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                    $o_PRD_OrdenDetDP->setCantidadRecibida( $f_CantidadPF );
                    $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenDetDP->update();
                    
                    //ahora se activa el producto final
                    if( $o_PRD_OrdenCabBN->getTipoOrden() == PRD_OrdenCabBN::TIPO_ORDEN_PROD_COTI )
                    {
                        $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                        $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                        $o_ALM_ItemMastDP->setEstado( ALM_ItemMastBN::ESTADO_ACTIVO );
                        $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_ALM_ItemMastDP->update();
                    }
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    if( $o_PRD_OrdenCabBN->getTipoOrden() == PRD_OrdenCabBN::TIPO_ORDEN_PROD_COTI ) //se agrego 2021-11-12
                    {
                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //AHORA SE REALIZA LA TRANSFERENCIA DE PRODUCCION A ALMACEN DE ORIGEN PARA EL PRODUCTO FINAL - 2021-06-06
                        //aqui se realiza transferencias
                        $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                        $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( "NT" );
                        $o_ALM_TransaccionCabeceraBN->setIdTransaccion( "TRA" );                  //transferencia
                        $o_ALM_TransaccionCabeceraBN->setIdAlmacen( "A1303" );                    //almacen produccion
                        $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $s_IdAlmacenDespacho ); //almacen de despacho de la cotizacion
                        $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA );
                        $o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d H:i:s" ) );
                        $o_ALM_TransaccionCabeceraBN->setTipodeCambio( GSS_TipoCambioFN::getStaticTipoCambioCobranza() );
                        $o_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( "PR" );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $s_IdOrdenCab );
                        $o_ALM_TransaccionCabeceraBN->setIdProyecto( $o_PRD_OrdenCabBN->getIdProyecto() );
                        //$o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
                        $o_ALM_TransaccionCabeceraBN->setCodigoCliente( GSS_ParametroMastFN::getValorParam( "AL", "PR_ID_COMPANIA" ) );

                        $o_utilGenerateId = new utilGenerateId();
                        $o_utilGenerateId->setIdCompania( -1 );
                        $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                        $o_utilGenerateId->setSerie( "TIPO" );
                        $i_IdCrtl = $o_utilGenerateId->generateId();

                        $s_Tipo   = "CT";
                        $s_Serie  = "0001";
                        $s_Numero = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );

                        $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $s_Tipo );     //$o_VTA_DocumentoBN->getIdTipoDocumento()
                        $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_Serie );   //$o_VTA_DocumentoBN->getDocumentoSerie()
                        $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_Numero ); //$o_VTA_DocumentoBN->getDocumentoNumero()

                        $a_MovientoDetalle          = array();
                        $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                        $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                        $o_ALM_TransaccionDetalleBN->setCantidad( $f_CantidadPF );
                        $o_ALM_TransaccionDetalleBN->setUnidadCodigo( ( string ) $i_IdUnidadPF );
                        $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_CostoUnitarioPF );
                        $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

                        $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

                        $o_MovimientoBL = new MovimientoBL();
                        $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

                        $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                        $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                        $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();

                        $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                        $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                        $o_PRD_OrdenCabDP->setIdTipoDocumentoTrf( $s_IdTipoDocumento );
                        $o_PRD_OrdenCabDP->setIdNumeroDocumentoTrf( $s_IdNumeroDocumento );
                        $o_PRD_OrdenCabDP->setIdTransaccionTrf( $s_IdTransaccion );
                        $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->update();
                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    }

                    $con->commit();
                    
                break;
                case "ReservarOrdenPrd":

                    $con = Conexion::getConexion();
                    $con->begin();

                    myUser::getUser()->validar_session();

                    $s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );

                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenCab );

                    if( $o_PRD_OrdenCabBN->getEstado() != PRD_OrdenCabBN::ESTADO_PENDIENTE )
                    {
                        throw new Exception( "La Orden tiene un estado diferente." );
                    }

                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_RESERVADO );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();

                    $con->commit();

                break;
                case "AnularOrdenPrd":

                    $con = Conexion::getConexion();
                    $con->begin();
                    
                    myUser::getUser()->validar_session();
                    
                    $s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
                    
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenCab );
                    
                    if( $o_PRD_OrdenCabBN->getEstado() != PRD_OrdenCabBN::ESTADO_PENDIENTE )
                    {
                        throw new Exception( "La Orden tiene un estado diferente." );
                    }
                    
                    $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                    $o_PRD_OrdenCabDP->setIdOrdenCab( ( int ) $s_IdOrdenCab );
                    $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_ANULADO );
                    $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRD_OrdenCabDP->update();
                    
                    //ahora se actualiza el producto final, por ya tiene orden de produccion
                    if( $o_PRD_OrdenCabBN->getProFinalId() )
                    {
                        $o_VTA_ProductoFinalDP = new VTA_ProductoFinalDP();
                        $o_VTA_ProductoFinalDP->setDebug( true );
                        $o_VTA_ProductoFinalDP->setProFinalId( $o_PRD_OrdenCabBN->getProFinalId() );
                        $o_VTA_ProductoFinalDP->setIdOrdenPrdCab( "null" );
                        $o_VTA_ProductoFinalDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_ProductoFinalDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_ProductoFinalDP->update();
                    }

                    $con->commit();
                    
                break;
                default:
                    throw new Exception( "No se encontro parametro." );
                breaK;
            }
        }
        catch ( Exception $o_Exception )
        {
            if( $con )
            {
                $con->rollback();
            }
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
}