<?php
class GenerarCorteAction extends wtActions
{
    public function execute()
    {
        $s_IdProyecto     = $this->getRequestParameter( 'IdProyecto' );
        $s_FechaCorte     = $this->getRequestParameter( 'Fecha' );

        $a_Respuesta = array( "error" => false );

        if( $s_IdProyecto && trim( $s_FechaCorte ) != "" )
        {
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                $b_ControlRegistro = false;
                $a_DataRs = array();
                $a_Result = array();

                $a_DevolucionDetCorteUPD = array();
                $a_DevolucionCabeceraUPD = array();

                $s_IdProyecto = intval( $s_IdProyecto );
                $s_Sql = "SELECT * FROM SR_CotizacionDevolucionCab WHERE IdProyecto={$s_IdProyecto} ";
                $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                if( $o_ResultSet->getRecordCount() > 0 )
                {
                    while ( $o_ResultSet->next() )
                    {
                        $a_SQLRow = $o_ResultSet->getRow();
    
                        $i_CotiDevolucionId = intval( $a_SQLRow['CotiDevolucionId'] );
    
                        $s_IdItem = $a_SQLRow['IdItem'];
    
                        $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );
    
                        //se recupera el precio por alquiler
                        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                        $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 2 ); //ALQUILER
                        $o_MST_ListaPrecioDetalleFN->setIdRango( $o_ALM_ItemMastBN->getIdRangoAlquiler() ); //RANGO ALQUILER
                        $o_MST_ListaPrecioDetalleFN->setIdItem( $s_IdItem );
                        $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
                        foreach ( $a_MST_ListaPrecioDetalle as $o_TMP_MST_ListaPrecioDetalleBN )
                        {
                            $f_PrecioSinIGV = $o_TMP_MST_ListaPrecioDetalleBN->getPrecioVenta();
                            $f_PrecioSinIGV = round( $f_PrecioSinIGV / 30, 2 );
                        }

                        //INFORMACION PARA SALDO INICIAL
                        //f.PrecioUnitarioAlq
                        $o_SR_DevolucionDetCorteFN = new SR_DevolucionDetCorteFN();
                        $o_SR_DevolucionDetCorteFN->setIdProyecto( $s_IdProyecto );
                        $o_SR_DevolucionDetCorteFN->setEstado( "P" );
                        $i_Num = $o_SR_DevolucionDetCorteFN->selectNumRows();
                        if( $i_Num )
                        {
                            $o_SR_DevolucionDetCorteFN = new SR_DevolucionDetCorteFN();
                            $o_SR_DevolucionDetCorteFN->setIdProyecto( $s_IdProyecto );
                            $o_SR_DevolucionDetCorteFN->setIdItem( $s_IdItem );
                            $o_SR_DevolucionDetCorteFN->setEstado( "P" );
                            $a_SR_DevolucionDetCorte = $o_SR_DevolucionDetCorteFN->select();
                            
                            foreach ( $a_SR_DevolucionDetCorte as $i_Key => $o_SR_DevolucionDetCorteBN )
                            {
                                $i_DevolDetCorteId = $o_SR_DevolucionDetCorteBN->getDevolDetCorteId();
                                $s_IdItem = $o_SR_DevolucionDetCorteBN->getIdItem();

                                $a_DataFinal[ 'DevolDetCorteId' ]      = $i_DevolDetCorteId;
                                $a_DataFinal[ 'FechaInicioAlq' ]       = $o_SR_DevolucionDetCorteBN->getFechaIni();
                                $a_DataFinal[ 'FechaFinAlq' ]          = $o_SR_DevolucionDetCorteBN->getFechaFin();
                                $a_DataFinal[ 'Tipo' ]                 = $o_SR_DevolucionDetCorteBN->getTipo();
                                $a_DataFinal[ 'Documento' ]            = "";
                                $a_DataFinal[ 'IdItem' ]               = $s_IdItem;
                                $a_DataFinal[ 'Descripcion' ]          = $o_SR_DevolucionDetCorteBN->getDescripcionItem();
                                $a_DataFinal[ 'PrecioUnitarioAlq' ]    = $o_SR_DevolucionDetCorteBN->getPrecioUnitario();
                                $a_DataFinal[ 'Cantidad' ]             = $o_SR_DevolucionDetCorteBN->getCantidad();
                                $a_DataFinal[ 'EstadoDevolucionId' ]   = "";
                                $a_DataFinal[ 'ComentarioDevolucion' ] = "";

                                $i_Dias    = UtilDate::diferenciaEntreFecha( $s_FechaCorte, $a_DataFinal[ 'FechaFinAlq' ] );
                                $b_Control = UtilDate::validarFecha1Mayor( $s_FechaCorte, $a_DataFinal[ 'FechaFinAlq' ] );
                                if ( !$b_Control )
                                {
                                    $i_Dias = 0;
                                }
                                $a_DataFinal['Dias']       = $i_Dias;
                                $a_DataFinal['EstadoDesc'] = "";
                                
                                $f_Total = $a_DataFinal['Cantidad'] * $i_Dias * $a_DataFinal['PrecioUnitarioAlq'];
                                $a_DataFinal['MontoTotal'] = $f_Total;
                                
                                $a_DataRs[$s_IdItem][] = $a_DataFinal;
                                
                                //ahora se actualiza el estado
                                $a_DevolucionDetCorteUPD[$s_IdItem][] = array( "DevolDetCorteId" => $i_DevolDetCorteId, "Dias" => $i_Dias, "MontoTotal" => $f_Total );
                                /*
                                $o_SR_DevolucionDetCorteDP = new SR_DevolucionDetCorteDP();
                                $o_SR_DevolucionDetCorteDP->setDevolDetCorteId( $i_DevolDetCorteId );
                                $o_SR_DevolucionDetCorteDP->setFechaCorte( $s_FechaCorte );
                                $o_SR_DevolucionDetCorteDP->setDias( $i_Dias );
                                $o_SR_DevolucionDetCorteDP->setMontoTotal( $f_Total );
                                $o_SR_DevolucionDetCorteDP->setEstado( "C" );
                                $o_SR_DevolucionDetCorteDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_SR_DevolucionDetCorteDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_SR_DevolucionDetCorteDP->update();
                                */
                            }
                        }

                        //INFORMACION PARA DESPACHO
                        $s_Sql = "SELECT
                                      g.FechaInicioAlq, g.FechaFinAlq, 'DESPACHO' Tipo, CONCAT(g.GuiaSerie, '-', g.GuiaNumero) Documento, d.IdItem, d.Descripcion, 0 PrecioUnitarioAlq, d.Cantidad, '' EstadoDevolucionId, '' ComentarioDevolucion
                                    FROM SR_GuiaRemisionH g
                                      LEFT JOIN SR_GuiaRemisionDet d ON g.GuiaRemisionId=d.GuiaRemisionId
                                        LEFT JOIN VTA_ProductoFinalDet f ON f.ProFinalDetId=d.ProFinalDetId
                                    WHERE g.IdProyecto={$s_IdProyecto} AND d.IdItem='$s_IdItem'
                                            AND CONCAT(g.GuiaSerie, '-', g.GuiaNumero) NOT IN ( SELECT Documento FROM SR_DevolucionDetCorte WHERE 1=1 AND IdProyecto=7 AND Tipo='DESPACHO' AND IdItem=d.IdItem ) ";
                        $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                        while ( $o_ResultSet2->next() )
                        {
                            $a_SQLRow2 = $o_ResultSet2->getRow();

                            $a_SQLRow2['PrecioUnitarioAlq'] = $f_PrecioSinIGV;
                            $a_SQLRow2['EstadoDesc']        = "";

                            $i_Dias    = UtilDate::diferenciaEntreFecha( $s_FechaCorte, $a_SQLRow2['FechaFinAlq'] );
                            $b_Control = UtilDate::validarFecha1Mayor( $s_FechaCorte, $a_SQLRow2['FechaFinAlq'] );
                            if ( !$b_Control )
                            {
                                $i_Dias = 0;
                            }
                            $a_SQLRow2['Dias'] = $i_Dias;

                            $f_Total = round( $a_SQLRow2['Cantidad'] * $i_Dias * $a_SQLRow2['PrecioUnitarioAlq'], 2 );
                            $a_SQLRow2['MontoTotal'] = $f_Total;

                            $a_SQLRow2['DevolDetCorteId'] = null;

                            $a_DataRs[$s_IdItem][] = $a_SQLRow2;
                        }
    
                        //INFORMACION PARA DEVOLUCION
                        $s_Sql = "SELECT c.FechaDevolucion FechaInicioAlq, 'DEVOLUCION' Tipo, LPAD( c.DevolucionCabId, 10, '0' ) Documento, d.IdItem, d.ItemDescripcion Descripcion, ( d.CantidadDevolucion * -1 ) Cantidad, 
                                         d.EstadoDevolucionId, d.ComentarioDevolucion, c.DevolucionCabId
                                    FROM SR_DevolucionCabecera c
                                      LEFT JOIN SR_DevolucionDetalle d ON d.DevolucionCabId=c.DevolucionCabId
                                    WHERE 1=1
                                      AND c.IdProyecto={$s_IdProyecto} AND d.IdItem='$s_IdItem' AND c.EstadoCorte='P' ;";
                        $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                        while ( $o_ResultSet2->next() )
                        {
                            $a_SQLRow2 = $o_ResultSet2->getRow();

                            $a_SQLRow2['FechaFinAlq']       = $a_SQLRow2['FechaInicioAlq'];
                            $a_SQLRow2['PrecioUnitarioAlq'] = $f_PrecioSinIGV;
    
                            $o_SR_EstadoDevolucionFN  = new SR_EstadoDevolucionFN();
                            $o_SR_EstadoDevolucionBN  = $o_SR_EstadoDevolucionFN->selectByPK( $a_SQLRow2['EstadoDevolucionId'] );
                            $a_SQLRow2['EstadoDesc']  = strtoupper( $o_SR_EstadoDevolucionBN->getDescripcion() );
                            $a_SQLRow2['FechaFinAlq'] = UtilDate::sumarDias( $a_SQLRow2['FechaFinAlq'], 1 );
    
                            $i_Dias    = UtilDate::diferenciaEntreFecha( $s_FechaCorte, $a_SQLRow2['FechaFinAlq'] );
                            $b_Control = UtilDate::validarFecha1Mayor( $s_FechaCorte, $a_SQLRow2['FechaFinAlq'] );
                            if ( !$b_Control )
                            {
                                $i_Dias = 0;
                            }
                            $a_SQLRow2['Dias'] = $i_Dias;
    
                            $f_Total                 = $a_SQLRow2['Cantidad'] * $i_Dias * $a_SQLRow2['PrecioUnitarioAlq'];
                            $a_SQLRow2['MontoTotal'] = $f_Total;

                            $a_SQLRow2['DevolDetCorteId'] = null;
    
                            $a_DataRs[$s_IdItem][] = $a_SQLRow2;
                            
                            //AHORA SE ACTUALIZA AQUI EL ESTADO DE CORTE
                            $i_DevolucionCabId = intval( $a_SQLRow2['DevolucionCabId'] );

                            $a_DevolucionCabeceraUPD[$s_IdItem][] = $i_DevolucionCabId;
                            /*
                            $o_SR_DevolucionCabeceraDP = new SR_DevolucionCabeceraDP();
                            $o_SR_DevolucionCabeceraDP->setDevolucionCabId( $i_DevolucionCabId );
                            $o_SR_DevolucionCabeceraDP->setEstadoCorte( "C" );
                            $o_SR_DevolucionCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_DevolucionCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_DevolucionCabeceraDP->update();
                            */
                        }
                    }
                    
                    $b_ControlRegistro = true;
                }

                //pr( $a_DevolucionDetCorteUPD ); exit;
                foreach( $a_DevolucionDetCorteUPD as $a_Data1 )
                {
                    foreach( $a_Data1 as $i_Key => $a_Data2 )
                    {
                        $o_SR_DevolucionDetCorteDP = new SR_DevolucionDetCorteDP();
                        $o_SR_DevolucionDetCorteDP->setDevolDetCorteId( $a_Data2[ 'DevolDetCorteId' ] );
                        $o_SR_DevolucionDetCorteDP->setFechaCorte( $s_FechaCorte );
                        $o_SR_DevolucionDetCorteDP->setDias( $a_Data2[ 'Dias' ] );
                        $o_SR_DevolucionDetCorteDP->setMontoTotal( $a_Data2[ 'MontoTotal' ] );
                        $o_SR_DevolucionDetCorteDP->setEstado( "C" );
                        $o_SR_DevolucionDetCorteDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SR_DevolucionDetCorteDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_DevolucionDetCorteDP->update();
                    }
                }

                //pr( $a_DevolucionCabeceraUPD ); exit;
                foreach( $a_DevolucionCabeceraUPD as $s_IdItem => $a_Data1 )
                {
                    //pr( "$s_IdItem:" );
                    foreach( $a_Data1 as $i_Key => $i_DevolucionCabId )
                    {
                        $o_SR_DevolucionCabeceraDP = new SR_DevolucionCabeceraDP();
                        $o_SR_DevolucionCabeceraDP->setDevolucionCabId( $i_DevolucionCabId );
                        $o_SR_DevolucionCabeceraDP->setEstadoCorte( "C" );
                        $o_SR_DevolucionCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_DevolucionCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SR_DevolucionCabeceraDP->update();
                    }
                }
                
                $s_Sql = "select coalesce(MAX(GrupoId),1) GrupoId from SR_DevolucionDetCorte WHERE IdProyecto=$s_IdProyecto;";
                $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                $o_ResultSet2->next();
                $i_GrupoId = $o_ResultSet2->getInt( 'GrupoId' );
                $s_Grupo1 = "GR_".date( "Ymd" )."_$i_GrupoId";

                if( $b_ControlRegistro )
                {
                    foreach ( $a_DataRs as $s_IdItem => $a_Data1 )
                    {
                        foreach ( $a_Data1 as $i_Key => $a_Data )
                        {
                            if( is_null( $a_Data['DevolDetCorteId'] ) )
                            {
                                $i_Id = SR_DevolucionDetCorteDP::recuperarId();
        
                                $o_SR_DevolucionDetCorteDP = new SR_DevolucionDetCorteDP();
                                $o_SR_DevolucionDetCorteDP->setDevolDetCorteId( $i_Id );
                                $o_SR_DevolucionDetCorteDP->setIdCompania( myUser::getUser()->getIdCompania() );
                                $o_SR_DevolucionDetCorteDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                                $o_SR_DevolucionDetCorteDP->setIdProyecto( $s_IdProyecto );
                                $o_SR_DevolucionDetCorteDP->setEstadoDevolucionId( $a_Data['EstadoDevolucionId'] );
                                $o_SR_DevolucionDetCorteDP->setGrupoId( $s_Grupo1 );
                                $o_SR_DevolucionDetCorteDP->setFechaIni( $a_Data['FechaInicioAlq'] );
                                $o_SR_DevolucionDetCorteDP->setTipo( $a_Data['Tipo'] );
                                $o_SR_DevolucionDetCorteDP->setEstadoDesc( $a_Data['EstadoDesc'] );
                                $o_SR_DevolucionDetCorteDP->setComentario( $a_Data['ComentarioDevolucion'] );
                                $o_SR_DevolucionDetCorteDP->setDocumento( $a_Data['Documento'] );
                                $o_SR_DevolucionDetCorteDP->setIdItem( $a_Data['IdItem'] );
                                $o_SR_DevolucionDetCorteDP->setDescripcionItem( $a_Data['Descripcion'] );
                                $o_SR_DevolucionDetCorteDP->setCantidad( floatval( $a_Data['Cantidad'] ) );
                                $o_SR_DevolucionDetCorteDP->setFechaFin( $a_Data['FechaFinAlq'] );
                                $o_SR_DevolucionDetCorteDP->setFechaCorte( $s_FechaCorte );
                                $o_SR_DevolucionDetCorteDP->setDias( $a_Data['Dias'] );
                                $o_SR_DevolucionDetCorteDP->setPrecioUnitario( $a_Data['PrecioUnitarioAlq'] );
                                $o_SR_DevolucionDetCorteDP->setMontoTotal( $a_Data['MontoTotal'] );
                                $o_SR_DevolucionDetCorteDP->setEstado( "C" );  //C OMPLETADO | P ENDIENTE
                                $o_SR_DevolucionDetCorteDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_SR_DevolucionDetCorteDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_SR_DevolucionDetCorteDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_SR_DevolucionDetCorteDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_SR_DevolucionDetCorteDP->save();
                            }
    
                            if( isset( $a_Result[$s_IdItem]['SumaCatidad'] ) )
                            {
                                $a_Result[$s_IdItem]['SumaCatidad'] = $a_Result[$s_IdItem]['SumaCatidad'] + floatval( $a_Data['Cantidad'] );
                                $a_Result[$s_IdItem]['SumaTotal'] = $a_Result[$s_IdItem]['SumaTotal'] + ( $a_Data['MontoTotal'] );
                            }
                            else
                            {
                                $a_Result[$s_IdItem]['SumaCatidad'] = floatval( $a_Data['Cantidad'] );
                                $a_Result[$s_IdItem]['SumaTotal'] = ( $a_Data['MontoTotal'] );
                            }
    
                            $a_Result[$s_IdItem]['PrecioUnitarioAlq']   = $a_Data['PrecioUnitarioAlq'];
                            $a_Result[$s_IdItem]['Descripcion']         = $a_Data['Descripcion'];
                            $a_Result[$s_IdItem]['IdItem']              = $a_Data['IdItem'];
                        }
                    }
                }

                //pr( $a_Result );

                $f_SubTotal = 0;

                $i_GrupoId = $i_GrupoId + 1;
                $s_Grupo2 = "GR_".date( "Ymd" )."_$i_GrupoId";
                foreach ( $a_Result as $s_IdItem => $a_Data )
                {
                    $s_Fecha      = UtilDate::sumarDias( $s_FechaCorte, 1 );
                    $s_FechaDesde = UtilDate::sumarDias( $s_FechaCorte, 1 );

                    $i_Id = SR_DevolucionDetCorteDP::recuperarId();

                    $o_SR_DevolucionDetCorteDP = new SR_DevolucionDetCorteDP();
                    $o_SR_DevolucionDetCorteDP->setDevolDetCorteId( $i_Id );
                    $o_SR_DevolucionDetCorteDP->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_SR_DevolucionDetCorteDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_SR_DevolucionDetCorteDP->setIdProyecto( $s_IdProyecto );
                    $o_SR_DevolucionDetCorteDP->setEstadoDevolucionId( "" );
                    $o_SR_DevolucionDetCorteDP->setGrupoId( $s_Grupo2 );
                    $o_SR_DevolucionDetCorteDP->setFechaIni( $s_Fecha );
                    $o_SR_DevolucionDetCorteDP->setTipo( "SALDO_INICIAL" );
                    $o_SR_DevolucionDetCorteDP->setEstadoDesc( "" );
                    $o_SR_DevolucionDetCorteDP->setComentario( "" );
                    $o_SR_DevolucionDetCorteDP->setDocumento( "" );
                    $o_SR_DevolucionDetCorteDP->setIdItem( $a_Data['IdItem'] );
                    $o_SR_DevolucionDetCorteDP->setDescripcionItem( $a_Data['Descripcion'] );
                    $o_SR_DevolucionDetCorteDP->setCantidad( ( $a_Data['SumaCatidad'] ) );
                    $o_SR_DevolucionDetCorteDP->setFechaFin( $s_FechaDesde );
                    //$o_SR_DevolucionDetCorteDP->setFechaCorte( $s_FechaCorte );
                    //$o_SR_DevolucionDetCorteDP->setDias( "" );
                    $o_SR_DevolucionDetCorteDP->setPrecioUnitario( $a_Data['PrecioUnitarioAlq'] );
                    //$o_SR_DevolucionDetCorteDP->setMontoTotal( $a_Data['SumaTotal'] );
                    $o_SR_DevolucionDetCorteDP->setEstado( "P" );  //C OMPLETADO | P ENDIENTE
                    $o_SR_DevolucionDetCorteDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_DevolucionDetCorteDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_SR_DevolucionDetCorteDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_DevolucionDetCorteDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_DevolucionDetCorteDP->save();

                    $f_SubTotal = $f_SubTotal + $a_Data['SumaTotal'];
                }

                //AHORA SE REGISTRA EL LA FACTURACION PENDIENTE PARA ESTE CORTE
                $o_SR_EstadoDevolucionFN = new SR_EstadoDevolucionFN();
                $o_SR_EstadoDevolucionBN = $o_SR_EstadoDevolucionFN->selectByPK( "CO" );
                $s_IdItemServ = $o_SR_EstadoDevolucionBN->getIdItemServicio();
                $o_ALM_ItemMastBN = $o_SR_EstadoDevolucionBN->getObjectItem();

                if( $o_ALM_ItemMastBN )
                {
                    $f_MontoIGV   = round( $f_SubTotal * 0.18, 2 );
                    $f_MontoTotal = $f_SubTotal + $f_MontoIGV;

                    $i_Id                         = SR_DevolucionFacturacionDP::recuperarId();
                    $o_SR_DevolucionFacturacionDP = new SR_DevolucionFacturacionDP();
                    $o_SR_DevolucionFacturacionDP->setDevolFactId( $i_Id );
                    $o_SR_DevolucionFacturacionDP->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_SR_DevolucionFacturacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_SR_DevolucionFacturacionDP->setIdProyecto( $s_IdProyecto );
                    $o_SR_DevolucionFacturacionDP->setGrupoId( $s_Grupo1 );
                    $o_SR_DevolucionFacturacionDP->setTipoEstado( $o_SR_EstadoDevolucionBN->getEstadoDevolucionId() );
                    $o_SR_DevolucionFacturacionDP->setEstadoDesc( $o_SR_EstadoDevolucionBN->getDescripcion() );
                    $o_SR_DevolucionFacturacionDP->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
                    $o_SR_DevolucionFacturacionDP->setDescripcionItem( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                    $o_SR_DevolucionFacturacionDP->setFechaCorte( $s_FechaCorte );
                    $o_SR_DevolucionFacturacionDP->setSubTotal( $f_SubTotal );
                    $o_SR_DevolucionFacturacionDP->setMontoIGV( $f_MontoIGV );
                    $o_SR_DevolucionFacturacionDP->setMontoTotal( $f_MontoTotal );
                    $o_SR_DevolucionFacturacionDP->setEstado( "P" );
                    $o_SR_DevolucionFacturacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_DevolucionFacturacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_SR_DevolucionFacturacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_DevolucionFacturacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_DevolucionFacturacionDP->save();
                }
                else
                {
                    throw new Exception( "No se encontro el Item de Servicio" );
                }

                //exit;

                $con->commit();
            }
            catch ( Exception $e )
            {
                //pr( $e );
                $con->rollback();
                $a_Respuesta['error'] = true;
                $a_Respuesta['mensaje_error'] = $e->getMessage();
            }
        }

        echo json_encode( $a_Respuesta );

        exit;
    }
}

