<?php
class prodrefActions extends wtActions
{
    public function executeIndex()
    {
    }

    public function executeRequestProdRef()
    {
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $a_Response = array( "Result" => false, "error" => false );

        try
        {
            switch ( $s_TipoProc )
            {
                case "eliminar_registro_color":

                    $s_IdReferencia = $this->getRequestParameter( 'IdReferencia' );
                    $s_IdColor      = $this->getRequestParameter( 'IdColor' );

                    //VALIDACION
                    $o_MST_RelacionReferenciaProductoFN = new MST_RelacionReferenciaProductoFN();
                    $o_MST_RelacionReferenciaProductoFN->setIdReferencia( $s_IdReferencia );
                    $o_MST_RelacionReferenciaProductoFN->setIdColor( $s_IdColor );
                    $a_MST_RelacionReferenciaProducto = $o_MST_RelacionReferenciaProductoFN->select();
                    if( $a_MST_RelacionReferenciaProducto )
                    {
                        throw new Exception( "No se puede eliminar el registro, tiene codigo de producto relacionado." );
                    }

                    MST_ReferenciaProductoColorDP::eliminarPorReferencia( $s_IdReferencia, $s_IdColor );
                    MST_ReferenciaProductoCatTallaDP::eliminarPorReferenciaColor( $s_IdReferencia,  $s_IdColor );

                break;
                case "eliminar_registro_categoria":

                    $s_IdReferencia = $this->getRequestParameter( 'IdReferencia' );
                    $s_IdColor      = $this->getRequestParameter( 'IdColor' );
                    $s_IdCategoria  = $this->getRequestParameter( 'IdCategoria' );

                    //VALIDACION
                    $o_MST_RelacionReferenciaProductoFN = new MST_RelacionReferenciaProductoFN();
                    $o_MST_RelacionReferenciaProductoFN->setIdReferencia( $s_IdReferencia );
                    $o_MST_RelacionReferenciaProductoFN->setIdColor( $s_IdColor );
                    $o_MST_RelacionReferenciaProductoFN->setIdCatTalla( $s_IdCategoria );
                    $a_MST_RelacionReferenciaProducto = $o_MST_RelacionReferenciaProductoFN->select();
                    if( $a_MST_RelacionReferenciaProducto )
                    {
                        throw new Exception( "No se puede eliminar el registro, tiene codigo de producto relacionado." );
                    }

                    MST_ReferenciaProductoCatTallaDP::eliminarPorReferenciaColorCat( $s_IdReferencia,  $s_IdColor, $s_IdCategoria );

                break;

                case "get_stock_disponible":

                    $s_IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
                    $s_IdItem    = $this->getRequestParameter( 'IdItem' );

                    $s_StockDisponible = ALM_ItemAlmacenStockFN::getStockDisponibleTotal( $s_IdItem, $s_IdAlmacen );
                    $a_Response['StockDisponible'] = $s_StockDisponible;

                break;

                case "set_stock_inventario":

                    $s_IdRefe    = $this->getRequestParameter( 'IdReferencia' );
                    $s_IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
                    $s_IdItem    = $this->getRequestParameter( 'IdItem' );
                    $s_Cantidad  = $this->getRequestParameter( 'Cantidad' );

                    if( !$s_IdAlmacen )
                    {
                        throw new Exception( "Tiene que seleccionar un almacen." );
                    }

                    $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
                    $o_MST_ReferenciaProductoBN = $o_MST_ReferenciaProductoFN->selectByPK( $s_IdRefe );

                    $IdTransaccion          = "CPN";
                    $IdTransaccionOperacion = "I";
                    $FechaDocumento         = date( "Y-m-d H:i:s" );
                    $TipodeCambio           = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                    $s_MonedaCod            = "LO";
                    $Descripcion            = "";
                    $ReferenciaTipoDocumento = "CT";
                    $ReferenciaNumeroDocumento = ( string ) $o_MST_ReferenciaProductoBN->getIdReferencia();
                    $IdTipoDocumento        = "NI";
                    $Comentario             = "";
                    $f_PrecioUnitario       = 0.04;

                    //datos para la cabecera
                    $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
                    //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
                    $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $s_IdAlmacen );
                    $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
                    $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
                    $o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
                    $o_ALM_TransaccionCabeceraBN->setMonedaCod( $s_MonedaCod );
                    $o_ALM_TransaccionCabeceraBN->setDescripcion( $Descripcion );

                    $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
                    $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );

                    $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
                    $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
                    $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( ( string ) $o_MST_ReferenciaProductoBN->getIdProveedor() );

                    if( $ReferenciaTipoDocumento == "CT" )
                    {
                        $o_utilGenerateId = new utilGenerateId();
                        $o_utilGenerateId->setIdCompania( -1 );
                        $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                        $o_utilGenerateId->setSerie( "TIPO" );
                        $i_IdCrtl = $o_utilGenerateId->generateId();

                        $ReferenciaTipoDocumento   = "CT";
                        $ReferenciaSerieDocumento  = "0001";
                        $ReferenciaNumeroDocumento = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );

                        $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $ReferenciaTipoDocumento );
                        $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $ReferenciaSerieDocumento );
                        $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $ReferenciaNumeroDocumento );
                    }

                    //datos para los detalles
                    $a_MovientoDetalle = array();
                    $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                    $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                    $o_ALM_TransaccionDetalleBN->setCantidad( floatval( $s_Cantidad ) );
                    $o_ALM_TransaccionDetalleBN->setUnidadCodigo( "58" );
                    $f_PrecioUnitarioSibIGV = round( $f_PrecioUnitario / 1.18, 2 );
                    $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrecioUnitarioSibIGV );
                    $o_ALM_TransaccionDetalleBN->setMontoTotal( $f_PrecioUnitario );
                    $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

                    $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

                    $o_MovimientoBL = new MovimientoBL();
                    $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

                    $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();
                    $a_Response['IdMovimientoInv'] = $i_Id;

                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Response['error']         = true;
            $a_Response['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Response );
        return ViewResponse::NONE;
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Referencia Producto";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        //$o_MST_CategoriaTallaFN->setIdProveedor( $this->IdProveedor );
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );

        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_ReferenciaProductoFN() );

        $o_GridAction->addAssignFilter( "IdReferencia" );
        $o_GridAction->addAssignFilter( "IdProveedor" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addConditionFilter( "Descripcion", MST_ReferenciaProductoFN::Descripcion, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "IdCatTalla", "IdReferencia", "IN", "(SELECT IdReferencia from MST_ReferenciaProductoCatTalla where IdCatTalla=".$this->getRequestParameter( 'IdCatTalla' )." group by IdReferencia)" );

        $o_GridAction->addOrderDefault( MST_ReferenciaProductoFN::IdReferencia, true );

        $o_GridAction->addRowsToShow( "IdReferencia", "ProveedorDesc", "Descripcion", "Estado", "EstadoDesc", "Codigo" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAdd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Nueva Referencia";
        $this->s_TipoProc = "nvo";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
    }

    public function executeAniadirNuevoColor()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo       = "Seleccionar Color y Talla";
        $this->s_DisabledFiel = "";
        $this->idReferencia   = $this->getRequestParameter( "idReferencia" );
        $this->s_CodigoColor  = $this->getRequestParameter( "CodigoColor" );
        $this->s_CatTalla     = $this->getRequestParameter( "CatTalla" );

        if( $this->getRequestParameter( "control" ) )
        {
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                $a_IdColor    = $this->getRequestParameter( 'idColor' );

                $i_Id = $this->idReferencia;

                if( $a_IdColor )
                {
                    foreach ( $a_IdColor as $s_IdColor )
                    {
                        $uploadFileDir = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."referencia/";
                        $newFileName  = "img_no_disponible.jpg";
                        $dest_path    = $uploadFileDir.$newFileName;
                        $s_DestinoUrl = Constantes::ROOT_DIR_IMG."referencia/".$newFileName;

                        $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                        $o_MST_ReferenciaProductoColorBN = $o_MST_ReferenciaProductoColorFN->selectByPK( $this->idReferencia, $s_IdColor );
                        if( !$o_MST_ReferenciaProductoColorBN )
                        {
                            $o_MST_ReferenciaProductoColorDP = new MST_ReferenciaProductoColorDP();
                            $o_MST_ReferenciaProductoColorDP->setIdReferencia( intval( $this->idReferencia ) );
                            $o_MST_ReferenciaProductoColorDP->setIdColor( intval( $s_IdColor ) );
                            $o_MST_ReferenciaProductoColorDP->setImagenFlag( 0 );
                            $o_MST_ReferenciaProductoColorDP->setImagenReferenciaNombre( $newFileName );
                            $o_MST_ReferenciaProductoColorDP->setImagenReferenciaWeb( $s_DestinoUrl );
                            $o_MST_ReferenciaProductoColorDP->setImagenReferenciaFisico( $dest_path );
                            $o_MST_ReferenciaProductoColorDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_MST_ReferenciaProductoColorDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_MST_ReferenciaProductoColorDP->save();
                        }
                    }

                    $a_IdCatTalla    = $this->getRequestParameter( 'idCatTalla' );
                    if( $a_IdCatTalla )
                    {
                        //MST_ReferenciaProductoCatTallaDP::eliminarPorReferencia( $this->idReferencia );
                        foreach ( $a_IdCatTalla as $s_IdColorSel => $a_Valores )
                        {
                            foreach ( $a_Valores as $s_IdTallaSel => $s_Valor )
                            {
                                $o_MST_ReferenciaProductoCatTallaDP = new MST_ReferenciaProductoCatTallaDP();
                                $o_MST_ReferenciaProductoCatTallaDP->setIdReferencia( intval( $this->idReferencia ) );
                                $o_MST_ReferenciaProductoCatTallaDP->setIdColor( intval( $s_IdColorSel ) );
                                $o_MST_ReferenciaProductoCatTallaDP->setIdCatTalla( intval( $s_IdTallaSel ) );
                                $o_MST_ReferenciaProductoCatTallaDP->setAplicado( 0 );
                                $o_MST_ReferenciaProductoCatTallaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_MST_ReferenciaProductoCatTallaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ReferenciaProductoCatTallaDP->save();
                            }
                        }
                    }
                }
                else
                {
                    //MST_ReferenciaProductoColorDP::eliminarPorReferencia( $this->idReferencia );
                    //MST_ReferenciaProductoCatTallaDP::eliminarPorReferencia( $this->idReferencia );
                }

                ParameterWR::getInstance()->setVar( "tipoProc", "nvo" );
                ParameterWR::getInstance()->setVar( "id", $this->idReferencia );
                ob_start();
                $this->executeSaveAddEditProd();
                $s_JsonResult = ob_get_contents();
                ob_end_clean();

                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                $con->rollback();
            }
        }

        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoBN = $o_MST_ReferenciaProductoFN->selectByPK( $this->idReferencia );
        $i_IdProveedor = $o_MST_ReferenciaProductoBN->getIdProveedor();
        
        $o_FND_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        $o_FND_MST_CategoriaTallaFN->setIdProveedor( $i_IdProveedor );
        $o_FND_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_FndCatTalla = $o_FND_MST_CategoriaTallaFN->select();

        $o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorFN->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        if( $this->getRequestParameter( "CodigoColor" ) )
        {
            $o_MST_ColorFN->addCondition( MST_ColorFN::Codigo, "LIKE", "'".$this->getRequestParameter( "CodigoColor" )."%'", false );
        }
        $o_MST_ColorFN->setEstado( MST_ColorBN::ESTADO_ACTIVO );
        $this->a_MST_Color = $o_MST_ColorFN->select();

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        $o_MST_CategoriaTallaFN->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        if( $this->getRequestParameter( "CatTalla" ) )
        {
            $o_MST_CategoriaTallaFN->addCondition( MST_CategoriaTallaFN::IdCatTalla, "=", $this->getRequestParameter( "CatTalla" ) );
        }
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();
    }

    public function executeAddeditColor()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo       = "Seleccionar Color y Categoria";
        $this->s_DisabledFiel = "";
        $this->idReferencia   = $this->getRequestParameter( "idReferencia" );
        $this->b_CtrlPopup    = false;

        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoBN = $o_MST_ReferenciaProductoFN->selectByPK( $this->idReferencia );
        $i_IdProveedor = $o_MST_ReferenciaProductoBN->getIdProveedor();

        if( $this->getRequestParameter( "control" ) )
        {
            $s_CodigoColor = $this->getRequestParameter( "CodigoColor" );
            $s_DscprColor  = $this->getRequestParameter( "DescripcionColor" );
            $s_EstadoColor = "A";
            $s_IdCatTalla  = $this->getRequestParameter( "idCatTalla" );

            $i_Id = $this->idReferencia;

            //ahora registramos el color
            $o_DefaultDP = new MST_ColorDP();
            $o_DefaultDP->setIdProveedor( $i_IdProveedor );
            $o_DefaultDP->setCodigo( $s_CodigoColor );
            $o_DefaultDP->setDescripcion( $s_DscprColor );
            $o_DefaultDP->setEstado( $s_EstadoColor );
            $i_IdColor = MST_ColorDP::recuperarId();
            $o_DefaultDP->setIdColor( $i_IdColor );
            $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_DefaultDP->save();
            $a_IdColor[] = $i_IdColor;

            if( $a_IdColor )
            {
                //primero buscamos lo q tiene registrado
                $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                $o_MST_ReferenciaProductoColorFN->setIdReferencia( $this->idReferencia );
                $a_MST_ReferenciaProductoColor = $o_MST_ReferenciaProductoColorFN->select();
                foreach ( $a_MST_ReferenciaProductoColor as $o_MST_ReferenciaProductoColorBN )
                {
                    $b_CrtoEliminar = true;
                    foreach ( $a_IdColor as $s_IdColor )
                    {
                        if( $o_MST_ReferenciaProductoColorBN->getIdColor() == $s_IdColor )
                        {
                            $b_CrtoEliminar = false;
                            break;
                        }
                    }
                    if( $b_CrtoEliminar )
                    {
                        if( $o_MST_ReferenciaProductoColorBN->getImagenFlag() )
                        {
                            unlink( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaFisico() );
                        }
                        //MST_ReferenciaProductoColorDP::eliminarPorReferencia( $this->idReferencia, $o_MST_ReferenciaProductoColorBN->getIdColor() );
                    }
                }

                foreach ( $a_IdColor as $s_IdColor )
                {
                    $uploadFileDir = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."referencia/";
                    $newFileName  = "img_no_disponible.jpg";
                    $dest_path    = $uploadFileDir.$newFileName;
                    $s_DestinoUrl = Constantes::ROOT_DIR_IMG."referencia/".$newFileName;

                    $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                    $o_MST_ReferenciaProductoColorBN = $o_MST_ReferenciaProductoColorFN->selectByPK( $this->idReferencia, $s_IdColor );
                    if( !$o_MST_ReferenciaProductoColorBN )
                    {
                        $o_MST_ReferenciaProductoColorDP = new MST_ReferenciaProductoColorDP();
                        $o_MST_ReferenciaProductoColorDP->setIdReferencia( intval( $this->idReferencia ) );
                        $o_MST_ReferenciaProductoColorDP->setIdColor( intval( $s_IdColor ) );
                        $o_MST_ReferenciaProductoColorDP->setImagenFlag( 0 );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaNombre( $newFileName );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaWeb( $s_DestinoUrl );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaFisico( $dest_path );
                        $o_MST_ReferenciaProductoColorDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_MST_ReferenciaProductoColorDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_MST_ReferenciaProductoColorDP->save();
                    }
                }

                $s_IdColorSel = $i_IdColor;
                $a_IdCatTalla = $this->getRequestParameter( 'idCatTalla' );
                if( $a_IdCatTalla )
                {
                    //MST_ReferenciaProductoCatTallaDP::eliminarPorReferencia( $this->idReferencia );
                    foreach ( $a_IdCatTalla as $s_IdTallaSel )
                    {
                        $o_MST_ReferenciaProductoCatTallaDP = new MST_ReferenciaProductoCatTallaDP();
                        $o_MST_ReferenciaProductoCatTallaDP->setIdReferencia( intval( $this->idReferencia ) );
                        $o_MST_ReferenciaProductoCatTallaDP->setIdColor( intval( $s_IdColorSel ) );
                        $o_MST_ReferenciaProductoCatTallaDP->setIdCatTalla( intval( $s_IdTallaSel ) );
                        $o_MST_ReferenciaProductoCatTallaDP->setAplicado( 0 );
                        $o_MST_ReferenciaProductoCatTallaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_MST_ReferenciaProductoCatTallaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_MST_ReferenciaProductoCatTallaDP->save();
                    }
                }
            }
            else
            {
                MST_ReferenciaProductoColorDP::eliminarPorReferencia( $this->idReferencia );
                MST_ReferenciaProductoCatTallaDP::eliminarPorReferencia( $this->idReferencia );
            }
            $this->b_CtrlPopup = true;
        }

        /*$o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorFN->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        if( $this->getRequestParameter( "CodigoColor" ) )
        {
            $o_MST_ColorFN->addCondition( MST_ColorFN::Codigo, "LIKE", "'".$this->getRequestParameter( "CodigoColor" )."%'", false );
        }
        $o_MST_ColorFN->setEstado( MST_ColorBN::ESTADO_ACTIVO );
        $this->a_MST_Color = $o_MST_ColorFN->select();*/

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        //$o_MST_CategoriaTallaFN->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();
    }

    public function executeAddeditCatTall()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo       = "Seleccionar Categoria";
        $this->s_DisabledFiel = "";
        $this->idReferencia   = $this->getRequestParameter( "idReferencia" );

        if( $this->getRequestParameter( "control" ) )
        {
            $a_IdCatTalla    = $this->getRequestParameter( 'idCatTalla' );
            if( $a_IdCatTalla )
            {
                MST_ReferenciaProductoCatTallaDP::eliminarPorReferencia( $this->idReferencia );
                foreach ( $a_IdCatTalla as $s_IdCatTalla )
                {
                    $o_MST_ReferenciaProductoCatTallaDP = new MST_ReferenciaProductoCatTallaDP();
                    $o_MST_ReferenciaProductoCatTallaDP->setIdReferencia( intval( $this->idReferencia ) );
                    $o_MST_ReferenciaProductoCatTallaDP->setIdCatTalla( intval( $s_IdCatTalla ) );
                    $o_MST_ReferenciaProductoCatTallaDP->save();
                }
            }
        }

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        $o_MST_CategoriaTallaFN->setEstado( "A" );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();
        foreach ( $this->a_MST_CategoriaTalla as $o_MST_CategoriaTallaBN )
        {
            $o_MST_ReferenciaProductoCatTallaFN = new MST_ReferenciaProductoCatTallaFN();
            $o_MST_ReferenciaProductoCatTallaBN = $o_MST_ReferenciaProductoCatTallaFN->selectByPK( $this->idReferencia, $o_MST_CategoriaTallaBN->getIdCatTalla() );
            if( $o_MST_ReferenciaProductoCatTallaBN )
            {
                $o_MST_CategoriaTallaBN->setIsChecked( true );
            }
        }
    }

    public function executeEdit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo = "Editar Referencia";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = "upd";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_DefaultFN = new MST_ReferenciaProductoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_ReferenciaProductoBN();
        }

        $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
        $o_MST_ReferenciaProductoColorFN->setIdReferencia( $this->i_Id );
        $this->a_MST_ReferenciaProductoColor = $o_MST_ReferenciaProductoColorFN->select();

        $this->o_MST_RelacionReferenciaProductoBN = array();
        if( $this->o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_COMPLETO )
        {
            $o_MST_RelacionReferenciaProductoFN = new MST_RelacionReferenciaProductoFN();
            $o_MST_RelacionReferenciaProductoFN->setIdReferencia( $this->i_Id );
            $this->a_MST_RelacionReferenciaProducto = $o_MST_RelacionReferenciaProductoFN->select();
        }
    }

    public function executeGuardarImagen()
    {
        $i_Id      = ( int ) $this->getRequestParameter( 'id' );
        $i_IdColor = ( int ) $this->getRequestParameter( 'idColor' );

        $uploadFileDir = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."referencia/";

        if( $i_Id )
        {
            if( $this->getRequestParameter( 'tipoProcImg' ) == "file_to_upload" )
            {
                $phpFileUploadErrors = array
                (
                    0 => 'There is no error, the file uploaded with success',
                    1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                    2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                    3 => 'El fichero fue sólo parcialmente subido.',
                    4 => 'No se subió ningún fichero.',
                    6 => 'Falta la carpeta temporal.',
                    7 => 'No se pudo escribir el fichero en el disco.',
                    8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                );

                if ( isset( $_FILES['file_upload'] ) )
                {
                    if ( $_FILES['file_upload']['error'] )
                    {
                        pr( $phpFileUploadErrors[ $_FILES['file_upload']['error'] ] );
                        exit;
                    }

                    $fileTmpPath   = $_FILES['file_upload']['tmp_name'];
                    $fileName      = $_FILES['file_upload']['name'];
                    $fileSize      = $_FILES['file_upload']['size'];
                    $fileType      = $_FILES['file_upload']['type'];
                    $fileNameCmps  = explode( ".", $fileName );
                    $fileExtension = strtolower( end( $fileNameCmps ) );

                    $newFileName  = "Referencia_".$i_Id."_".$i_IdColor.".".$fileExtension;
                    $dest_path    = $uploadFileDir.$newFileName;
                    $s_DestinoUrl = Constantes::ROOT_DIR_IMG."referencia/".$newFileName;

                    //if( move_uploaded_file( $fileTmpPath, $dest_path ) )
                    if ( copy( $fileTmpPath, $dest_path ) )
                    {
                        //aqui se atualiza la url de la imagen
                        $o_MST_ReferenciaProductoColorDP = new MST_ReferenciaProductoColorDP();
                        $o_MST_ReferenciaProductoColorDP->setIdReferencia( $i_Id );
                        $o_MST_ReferenciaProductoColorDP->setIdColor( $i_IdColor );
                        $o_MST_ReferenciaProductoColorDP->setImagenFlag( 1 );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaNombre( $newFileName );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaWeb( $s_DestinoUrl );
                        $o_MST_ReferenciaProductoColorDP->setImagenReferenciaFisico( $dest_path );
                        $o_MST_ReferenciaProductoColorDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_MST_ReferenciaProductoColorDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_MST_ReferenciaProductoColorDP->update();

                        //ahora se actualiza los productos relacionados
                        $o_MST_RelacionReferenciaProductoFN = new MST_RelacionReferenciaProductoFN();
                        $o_MST_RelacionReferenciaProductoFN->setIdReferencia( $i_Id );
                        $o_MST_RelacionReferenciaProductoFN->setIdColor( $i_IdColor );
                        $a_MST_RelacionReferenciaProducto = $o_MST_RelacionReferenciaProductoFN->select();
                        foreach ( $a_MST_RelacionReferenciaProducto as $o_MST_RelacionReferenciaProductoBN )
                        {
                            $s_IdItem = $o_MST_RelacionReferenciaProductoBN->getIdItem();

                            $uploadFileDir    = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."productos/";

                            $fileNameCmps  = explode( ".", $newFileName );
                            $fileExtension = strtolower( end( $fileNameCmps ) );

                            $s_ImagenTmp = $dest_path;
                            $newFileName   = $s_IdItem.".".$fileExtension;
                            $s_DestinoUrl = Constantes::ROOT_DIR_IMG."productos/".$newFileName;
                            $dest_path     = $uploadFileDir . $newFileName;
                            if ( copy( $s_ImagenTmp, $dest_path ) )
                            {
                                //$message ='File is successfully uploaded.';
                                //aqui se atualiza la url de la imagen
                                $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                                $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                                $o_ALM_ItemMastDP->setNombreArchivo( $newFileName );
                                $o_ALM_ItemMastDP->setUbicacionURL( $s_DestinoUrl );
                                $o_ALM_ItemMastDP->setUbicacionFisica( $dest_path );
                                $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_ALM_ItemMastDP->update();
                            }
                        }
                    }
                    else
                    {
                    }
                }
            }
            elseif ( $this->getRequestParameter( 'tipoProcImg' ) == "file_to_upload_del" )
            {
                $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                $o_MST_ReferenciaProductoColorBN = $o_MST_ReferenciaProductoColorFN->selectByPK( $i_Id, $i_IdColor );
                if( $o_MST_ReferenciaProductoColorBN )
                {
                    if( $o_MST_ReferenciaProductoColorBN->getImagenFlag() )
                    {
                        unlink( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaFisico() );
                    }
                }

                $uploadFileDir = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."referencia/";
                $newFileName  = "img_no_disponible.jpg";
                $dest_path    = $uploadFileDir.$newFileName;
                $s_DestinoUrl = Constantes::ROOT_DIR_IMG."referencia/".$newFileName;

                $o_MST_ReferenciaProductoColorDP = new MST_ReferenciaProductoColorDP();
                $o_MST_ReferenciaProductoColorDP->setIdReferencia( $i_Id );
                $o_MST_ReferenciaProductoColorDP->setIdColor( $i_IdColor );
                $o_MST_ReferenciaProductoColorDP->setImagenFlag( 0 );
                $o_MST_ReferenciaProductoColorDP->setImagenReferenciaNombre( $newFileName );
                $o_MST_ReferenciaProductoColorDP->setImagenReferenciaWeb( $s_DestinoUrl );
                $o_MST_ReferenciaProductoColorDP->setImagenReferenciaFisico( $dest_path );
                $o_MST_ReferenciaProductoColorDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MST_ReferenciaProductoColorDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_MST_ReferenciaProductoColorDP->update();
            }
        }

        //redirect
        $s_Dir = Constantes::ROOT_DIR_APP;
        header( "Location:".$s_Dir."mst.php/prodref/edit/id/".$i_Id );
    }

    public function executeSaveAddEdit()
    {
        $s_TipoProc    = $this->getRequestParameter( 'tipoProc' );

        $i_IdProveedor = intval( $this->getRequestParameter( 'IdProveedor' ) );
        $s_Descripcion = $this->getRequestParameter( 'Descripcion' );
        //$s_Estado      = $this->getRequestParameter( 'Estado' );

        $i_IdCompania  = intval( myUser::getUser()->getIdCompania() );
        $i_IdSucursal  = intval( myUser::getUser()->getIdSucursal() );

        try
        {
            if( !$i_IdProveedor )
            {
                throw new Exception( "Debe de seleccionar un Proveedor." );
            }
            if( !$s_Descripcion )
            {
                throw new Exception( "Debe de ingresar una descripcion." );
            }

            $o_DefaultDP = new MST_ReferenciaProductoDP();
            $o_DefaultDP->setIdProveedor( $i_IdProveedor );
            $o_DefaultDP->setDescripcion( $s_Descripcion );
            //$o_DefaultDP->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //validacion por la descripcion que no sea igual
                $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
                $o_MST_ReferenciaProductoFN->setDescripcion( $s_Descripcion );
                $o_MST_ReferenciaProductoFN->addCondition( MST_ReferenciaProductoFN::Estado, "<>", MST_ReferenciaProductoBN::ESTADO_ANULADO );
                $a_MST_ReferenciaProducto = $o_MST_ReferenciaProductoFN->select();
                if( $a_MST_ReferenciaProducto )
                {
                    throw new Exception( "Actualmente existe una referencia con el numero seleccionado." );
                }

                //NUEVO
                $i_Id = MST_ReferenciaProductoDP::recuperarId();
                $o_DefaultDP->setIdReferencia( $i_Id );
                $o_DefaultDP->setEstado( MST_ReferenciaProductoBN::ESTADO_PENDIENTE );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = intval( $this->getRequestParameter( 'id' ) );
                $o_DefaultDP->setIdReferencia( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->update();
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeSaveAddEditProd()
    {
        $s_TipoProc = $this->getRequestParameter( 'tipoProc' );
        $s_Id       = $this->getRequestParameter( 'id' );

        $i_IdCompania  = intval( myUser::getUser()->getIdCompania() );
        $i_IdSucursal  = intval( myUser::getUser()->getIdSucursal() );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
            $o_MST_ReferenciaProductoBN = $o_MST_ReferenciaProductoFN->selectByPK( $s_Id );
            $s_RefeDescripcion = $o_MST_ReferenciaProductoBN->getDescripcion();
            $i_RefeIdProveedor = $o_MST_ReferenciaProductoBN->getIdProveedor();
            $i_IdReferencia    = $o_MST_ReferenciaProductoBN->getIdReferencia();

            if( !$i_RefeIdProveedor )
            {
                throw new Exception( "Debe de seleccionar un Proveedor." );
            }
            if( !$s_RefeDescripcion )
            {
                throw new Exception( "Debe de ingresar una descripcion." );
            }

            $o_MST_ReferenciaProductoCatTallaFN = new MST_ReferenciaProductoCatTallaFN();
            $o_MST_ReferenciaProductoCatTallaFN->setIdReferencia( $s_Id );
            $a_MST_ReferenciaProductoCatTalla = $o_MST_ReferenciaProductoCatTallaFN->select();
            if( !$a_MST_ReferenciaProductoCatTalla )
            {
                throw new Exception( "No se encontro relacion con Categoria." );
            }
            foreach ( $a_MST_ReferenciaProductoCatTalla as $o_MST_ReferenciaProductoCatTallaBN )
            {
                if( $o_MST_ReferenciaProductoCatTallaBN->getAplicado() )
                {
                    continue;
                }

                $i_IdColor      = $o_MST_ReferenciaProductoCatTallaBN->getIdColor();
                $i_IdCatTalla   = $o_MST_ReferenciaProductoCatTallaBN->getIdCatTalla();

                //se recupera la relacion entre el color para copiar la imagen
                $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                $o_MST_ReferenciaProductoColorBN = $o_MST_ReferenciaProductoColorFN->selectByPK( $i_IdReferencia, $i_IdColor );

                $o_MST_ColorFN  = new MST_ColorFN();
                $o_MST_ColorBN  = $o_MST_ColorFN->selectByPK( $i_IdColor );
                //$s_CodigoCodigo = $o_MST_ColorBN->getCodigo();
                $s_CodigoCodigo = $o_MST_ColorBN->getDescripcion();

                $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
                $o_MST_CategoriaTallaBN = $o_MST_CategoriaTallaFN->selectByPK( $i_IdCatTalla );
                $s_CatTallaDescripcion = $o_MST_CategoriaTallaBN->getDescripcion();


                $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
                $o_MST_CategoriaTallaRelacionFN->setIdCatTalla( $i_IdCatTalla );
                $a_MST_CategoriaTallaRelacion = $o_MST_CategoriaTallaRelacionFN->select();
                if( !$a_MST_CategoriaTallaRelacion )
                {
                    throw new Exception( "No se encontro relacion con Talla." );
                }
                foreach ( $a_MST_CategoriaTallaRelacion as $o_MST_CategoriaTallaRelacionBN )
                {
                    $o_MST_TallaBN = $o_MST_CategoriaTallaRelacionBN->getObjectTalla();
                    $i_IdTalla = $o_MST_TallaBN->getIdTalla();
                    $s_TallaDescripcion = $o_MST_TallaBN->getDescripcion();

                    //ahora se crea el producto
                    $s_ProductoDescripcion = $s_RefeDescripcion."-".$s_CodigoCodigo."-".$s_TallaDescripcion."-".$s_CatTallaDescripcion;

                    //SE RECUPERA CORRELATIVO ITEM
                    $s_IdItem        = ALM_ItemMastFN::recuperarId();
                    $i_CodigoInterno = ALM_ItemMastDP::recuperarCodigoInterno();

                    $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                    $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                    $o_ALM_ItemMastDP->setIdMarca( "44" );
                    $o_ALM_ItemMastDP->setIdItemTipo( "01" );
                    $o_ALM_ItemMastDP->setDescripcionCompleta( $s_ProductoDescripcion );
                    $o_ALM_ItemMastDP->setCodigoInterno( ( string ) $i_CodigoInterno );
                    $o_ALM_ItemMastDP->setIdItemFiscal( 0 );
                    $o_ALM_ItemMastDP->setUnidadCompra( "58" );
                    $o_ALM_ItemMastDP->setUnidadVenta( "58" );
                    $o_ALM_ItemMastDP->setManejoxLoteFlag( "N" );
                    $o_ALM_ItemMastDP->setManejoxSerieFlag( "N" );
                    $o_ALM_ItemMastDP->setNoAfectoImpuestoVentasFlag( "N" );
                    $o_ALM_ItemMastDP->setStockMinimo( 0 );
                    $o_ALM_ItemMastDP->setStockMaximo( 0 );
                    $o_ALM_ItemMastDP->setEstado( "A" );
                    $o_ALM_ItemMastDP->setIdLinea( 1 );
                    $o_ALM_ItemMastDP->setIdFamilia( 18 );
                    $o_ALM_ItemMastDP->setIdSubFamilia( 0 );
                    $o_ALM_ItemMastDP->setIdProcedencia( "LOC" );
                    $o_ALM_ItemMastDP->setTipoGarantiaId( "18" );
                    $o_ALM_ItemMastDP->setIdTipoOperatividad( "NVO" );
                    $o_ALM_ItemMastDP->setPesoGramos( 0 );
                    $o_ALM_ItemMastDP->setAfectoPercepcionIGVFlag( "N" );
                    $o_ALM_ItemMastDP->setIdPersona( $i_RefeIdProveedor );
                    $o_ALM_ItemMastDP->setCantidadUnidad( 0 );
                    $o_ALM_ItemMastDP->setCantidadUnidadCompra( 0 );
                    $o_ALM_ItemMastDP->setEsInventariableFlag( "S" );
                    $o_ALM_ItemMastDP->setFusionarLoteFlag( "N" );
                    $o_ALM_ItemMastDP->setUsarDisponibleStock( "S" );
                    $o_ALM_ItemMastDP->setUsarResevableStock( "S" );
                    $o_ALM_ItemMastDP->setEsParaVenta( "SI" );
                    $o_ALM_ItemMastDP->setIdRangoVenta( 1 );
                    $o_ALM_ItemMastDP->setEsParaAlquiler( "NO" );
                    $o_ALM_ItemMastDP->setIdRangoAlquiler( 0 );
                    $o_ALM_ItemMastDP->setUsuarioCreacion( "wtaype" );
                    $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_ItemMastDP->save();

                    $i_IdRela = MST_RelacionReferenciaProductoDP::recuperarId();
                    $o_MST_RelacionReferenciaProductoDP = new MST_RelacionReferenciaProductoDP();
                    $o_MST_RelacionReferenciaProductoDP->setIdReleacion( $i_IdRela );
                    $o_MST_RelacionReferenciaProductoDP->setIdReferencia( $i_IdReferencia );
                    $o_MST_RelacionReferenciaProductoDP->setIdProveedor( $i_RefeIdProveedor );
                    $o_MST_RelacionReferenciaProductoDP->setIdColor( $i_IdColor );
                    $o_MST_RelacionReferenciaProductoDP->setIdCatTalla( $i_IdCatTalla );
                    $o_MST_RelacionReferenciaProductoDP->setIdTalla( $i_IdTalla );
                    $o_MST_RelacionReferenciaProductoDP->setIdItem( $s_IdItem );
                    $o_MST_RelacionReferenciaProductoDP->save();

                    if( $o_MST_ReferenciaProductoColorBN->getImagenFlag() )
                    {
                        $uploadFileDir    = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."productos/";

                        $fileNameCmps  = explode( ".", $o_MST_ReferenciaProductoColorBN->getImagenReferenciaNombre() );
                        $fileExtension = strtolower( end( $fileNameCmps ) );

                        $s_ImagenTmp = $o_MST_ReferenciaProductoColorBN->getImagenReferenciaFisico();
                        $newFileName   = $s_IdItem.".".$fileExtension;
                        $s_DestinoUrl = Constantes::ROOT_DIR_IMG."productos/".$newFileName;
                        $dest_path     = $uploadFileDir . $newFileName;
                        if ( copy( $s_ImagenTmp, $dest_path ) )
                        {
                            //$message ='File is successfully uploaded.';
                            //aqui se atualiza la url de la imagen
                            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                            $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                            $o_ALM_ItemMastDP->setNombreArchivo( $newFileName );
                            $o_ALM_ItemMastDP->setUbicacionURL( $s_DestinoUrl );
                            $o_ALM_ItemMastDP->setUbicacionFisica( $dest_path );
                            $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_ALM_ItemMastDP->update();
                        }
                    }
                    else
                    {
                        //no tiene imagen asociado
                    }
                }

                $o_MST_ReferenciaProductoCatTallaDP = new MST_ReferenciaProductoCatTallaDP();
                $o_MST_ReferenciaProductoCatTallaDP->setIdReferencia( $i_IdReferencia );
                $o_MST_ReferenciaProductoCatTallaDP->setIdColor( $i_IdColor );
                $o_MST_ReferenciaProductoCatTallaDP->setIdCatTalla( $i_IdCatTalla );
                $o_MST_ReferenciaProductoCatTallaDP->setAplicado( 1 );
                $o_MST_ReferenciaProductoCatTallaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MST_ReferenciaProductoCatTallaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ReferenciaProductoCatTallaDP->update();
            }

            $o_MST_ReferenciaProductoDP = new MST_ReferenciaProductoDP();
            $o_MST_ReferenciaProductoDP->setIdReferencia( $i_IdReferencia );
            $o_MST_ReferenciaProductoDP->setEstado( MST_ReferenciaProductoBN::ESTADO_COMPLETO );
            $o_MST_ReferenciaProductoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_MST_ReferenciaProductoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_MST_ReferenciaProductoDP->update();

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_IdRela;

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }


    public function executeView()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Mostrar Referencia";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipoProc' );

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_DefaultFN = new MST_ReferenciaProductoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_ReferenciaProductoBN();
        }

        $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
        $o_MST_ReferenciaProductoColorFN->setIdReferencia( $this->i_Id );
        $this->a_MST_ReferenciaProductoColor = $o_MST_ReferenciaProductoColorFN->select();

        $this->o_MST_RelacionReferenciaProductoBN = array();
        if( $this->o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_COMPLETO )
        {
            $o_MST_RelacionReferenciaProductoFN = new MST_RelacionReferenciaProductoFN();
            $o_MST_RelacionReferenciaProductoFN->setIdReferencia( $this->i_Id );
            $this->a_MST_RelacionReferenciaProducto = $o_MST_RelacionReferenciaProductoFN->select();
        }
    }
}